/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.nativeexecution.ExternalTerminalAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.support.TerminalProfile;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ExternalTerminal {
    private static final ConcurrentHashMap<TermEnvPair, String> execCache = new ConcurrentHashMap();
    private final TerminalProfile profile;
    private String title = null;
    private String workdir = null;
    private static final boolean CLOSE_TERMINAL = Boolean.getBoolean("org.netbeans.modules.nativeexecution.api.util.CloseTerminal");
    private String prompt = CLOSE_TERMINAL ? "NO" : ExternalTerminal.loc("Terminal.DefaultPrompt.text", new String[0]);

    ExternalTerminal(TerminalProfile info) throws IllegalArgumentException {
        this.profile = info;
    }

    private ExternalTerminal(ExternalTerminal terminal) {
        this.profile = terminal.profile;
        this.title = terminal.title;
        this.workdir = terminal.workdir;
        this.prompt = terminal.prompt;
    }

    public boolean isAvailable(ExecutionEnvironment executionEnvironment) {
        return this.getExecutable(executionEnvironment) != null;
    }

    public String getID() {
        return this.profile.getID();
    }

    public ExternalTerminal setPrompt(String prompt) {
        ExternalTerminal result = new ExternalTerminal(this);
        result.prompt = prompt;
        return result;
    }

    public ExternalTerminal setTitle(String title) {
        ExternalTerminal result = new ExternalTerminal(this);
        result.title = title;
        return result;
    }

    public ExternalTerminal setWorkdir(String workdir) {
        ExternalTerminal result = new ExternalTerminal(this);
        result.workdir = workdir;
        return result;
    }

    private String getExecutable(ExecutionEnvironment execEnv) {
        String execPath;
        TermEnvPair key = new TermEnvPair(execEnv, this.profile.getCommand());
        String exec = execCache.get(key);
        if (exec == null && (exec = execEnv.isLocal() && Utilities.isWindows() ? this.profile.getCommand() : HostInfoUtils.searchFile(execEnv, this.profile.getSearchPaths(), this.profile.getCommand(), true)) != null && (execPath = execCache.putIfAbsent(key, exec)) != null) {
            exec = execPath;
        }
        return exec;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(ExternalTerminal.class, (String)key, (Object[])params);
    }

    static {
        ExternalTerminalAccessor.setDefault(new ExternalTerminalAccessorImpl());
    }

    static final class TermEnvPair {
        public final ExecutionEnvironment env;
        public final String termexec;

        public TermEnvPair(ExecutionEnvironment env, String termexec) {
            this.env = env;
            this.termexec = termexec;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TermEnvPair)) {
                throw new IllegalArgumentException();
            }
            TermEnvPair that = (TermEnvPair)obj;
            return this.env.equals(that.env) && this.termexec.equals(that.termexec);
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.env != null ? this.env.hashCode() : 0);
            hash = 79 * hash + (this.termexec != null ? this.termexec.hashCode() : 0);
            return hash;
        }
    }

    private static class ExternalTerminalAccessorImpl
    extends ExternalTerminalAccessor {
        private static final String ARG_TITLE = "$title";
        private static final String ARG_WORKDIR = "$workdir";

        private ExternalTerminalAccessorImpl() {
        }

        @Override
        public TerminalProfile getTerminalProfile(ExternalTerminal terminal) {
            return terminal.profile;
        }

        @Override
        public List<String> wrapCommand(ExecutionEnvironment execEnv, ExternalTerminal terminal, List<String> args) {
            String exec = terminal.getExecutable(execEnv);
            if (exec == null) {
                return args;
            }
            ArrayList<String> result = new ArrayList<String>();
            result.add(exec);
            for (String arg : terminal.profile.getArguments()) {
                if ("$@".equals(arg)) {
                    result.addAll(args);
                    continue;
                }
                if ("$shell".equals(arg)) {
                    try {
                        HostInfo hostInfo = HostInfoUtils.getHostInfo(execEnv);
                        result.add(hostInfo.getShell());
                        continue;
                    }
                    catch (IOException ex) {
                    }
                    catch (ConnectionManager.CancellationException ex) {
                        // empty catch block
                    }
                }
                if (arg.contains(ARG_TITLE)) {
                    arg = arg.replace(ARG_TITLE, terminal.title);
                }
                if (arg.contains(ARG_WORKDIR)) {
                    arg = arg.replace(ARG_WORKDIR, terminal.workdir);
                }
                result.add(arg);
            }
            return result;
        }

        @Override
        public String getPrompt(ExternalTerminal terminal) {
            return terminal.prompt;
        }

        @Override
        public String getTitle(ExternalTerminal terminal) {
            return terminal.title;
        }

        @Override
        public String getExecutable(ExternalTerminal terminal, ExecutionEnvironment execEnv) {
            return terminal.getExecutable(execEnv);
        }
    }
}

