/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class MiscUtils {
    private static boolean wasShown = false;

    public static boolean isJSCHTooLongException(Exception ex) {
        String message = "Received message is too long: ";
        boolean jschEx = ex instanceof JSchException || ex.getCause() instanceof JSchException;
        boolean longMessage = ex.getMessage().contains("Received message is too long: ") || ex.getCause() != null && ex.getCause().getMessage().contains("Received message is too long: ");
        return jschEx && longMessage;
    }

    public static void showJSCHTooLongNotification(String envName) {
        String title = NbBundle.getMessage(MiscUtils.class, (String)"JSCHReceivedMessageIsTooLong.error.title", (Object)envName);
        String shortText = NbBundle.getMessage(MiscUtils.class, (String)"JSCHReceivedMessageIsTooLong.error.shorttext");
        String details = NbBundle.getMessage(MiscUtils.class, (String)"JSCHReceivedMessageIsTooLong.error.text");
        MiscUtils.showNotification(title, shortText, details);
    }

    public static void showNotification(String title, String shortText, String longText) {
        if (wasShown) {
            return;
        }
        wasShown = true;
        ImageIcon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/nativeexecution/support/error.png", (boolean)false);
        longText = "<html>" + longText + "</html>";
        NotificationDisplayer.getDefault().notify(title, (Icon)icon, (JComponent)new JLabel(shortText), (JComponent)new JLabel(longText), NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.ERROR);
    }

    public static JComponent getNotificationLabel(String text) {
        return new JLabel(text);
    }

    public static boolean mightBrokeSftpChannel(SftpException e) {
        return e.id != 2 && e.id != 3;
    }
}

