/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.gulp.ui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.gulp.GulpBuildTool;
import org.netbeans.modules.javascript.gulp.exec.GulpExecutable;
import org.netbeans.modules.javascript.gulp.file.GulpTasks;
import org.netbeans.modules.javascript.gulp.ui.actions.Bundle;
import org.netbeans.modules.javascript.gulp.util.GulpUtils;
import org.netbeans.modules.web.clientproject.api.build.BuildTools;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;

public final class RunGulpTaskAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Popup {
    static final Logger LOGGER = Logger.getLogger(RunGulpTaskAction.class.getName());
    private final Project project;

    public RunGulpTaskAction() {
        this((Project)null);
    }

    public RunGulpTaskAction(Project project) {
        this.project = project;
        this.setEnabled(project != null);
        this.putValue("hideWhenDisabled", true);
        this.putValue("Name", null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup context) {
        DataObject dataObject;
        Project contextProject = (Project)context.lookup(Project.class);
        if (contextProject != null) {
            return this.createAction(contextProject);
        }
        FileObject file = (FileObject)context.lookup(FileObject.class);
        if (file == null && (dataObject = (DataObject)context.lookup(DataObject.class)) != null) {
            file = dataObject.getPrimaryFile();
        }
        if (file == null) {
            return this;
        }
        contextProject = FileOwnerQuery.getOwner((FileObject)file);
        if (contextProject == null) {
            return null;
        }
        if (!contextProject.getProjectDirectory().equals(file.getParent())) {
            return this;
        }
        return this.createAction(contextProject);
    }

    private Action createAction(Project contextProject) {
        assert (contextProject != null);
        GulpBuildTool gulpBuildTool = GulpBuildTool.inProject(contextProject);
        if (gulpBuildTool == null) {
            return this;
        }
        if (!gulpBuildTool.getGulpfile().exists()) {
            return this;
        }
        return new RunGulpTaskAction(contextProject);
    }

    public JMenuItem getPopupPresenter() {
        if (this.project == null) {
            return new Actions.MenuItem((Action)this, false);
        }
        return BuildTools.getDefault().createTasksMenu((BuildTools.TasksMenuSupport)new TasksMenuSupportImpl(this.project));
    }

    private static final class TasksFuture
    implements Future<List<String>> {
        private final GulpTasks gulpTasks;

        public TasksFuture(GulpTasks gulpTasks) {
            assert (gulpTasks != null);
            this.gulpTasks = gulpTasks;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.gulpTasks.getTasks() != null;
        }

        @Override
        public List<String> get() throws InterruptedException, ExecutionException {
            try {
                return this.gulpTasks.loadTasks(null, null);
            }
            catch (TimeoutException ex) {
                assert (false);
                return null;
            }
        }

        @Override
        public List<String> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.gulpTasks.loadTasks(timeout, unit);
        }
    }

    private static final class TasksMenuSupportImpl
    implements BuildTools.TasksMenuSupport {
        private final Project project;
        private final GulpTasks gulpTasks;

        public TasksMenuSupportImpl(Project project) {
            assert (project != null);
            this.project = project;
            this.gulpTasks = GulpBuildTool.forProject(project).getGulpTasks();
        }

        public Project getProject() {
            return this.project;
        }

        public String getIdentifier() {
            return "Gulp";
        }

        public String getTitle(BuildTools.TasksMenuSupport.Title title) {
            switch (title) {
                case MENU: {
                    return Bundle.RunGulpTaskAction_name();
                }
                case LOADING_TASKS: {
                    return Bundle.TasksMenuSupportImpl_tasks_loading();
                }
                case RELOAD_TASKS: {
                    return Bundle.TasksMenuSupportImpl_tasks_reload();
                }
                case CONFIGURE_TOOL: {
                    return Bundle.TasksMenuSupportImpl_gulp_configure();
                }
                case RUN_ADVANCED: {
                    return Bundle.TasksMenuSupportImpl_tasks_run_advanced();
                }
                case TASKS_LABEL: {
                    return Bundle.TasksMenuSupportImpl_tasks_label();
                }
                case BUILD_TOOL_EXEC: {
                    return GulpExecutable.GULP_NAME;
                }
            }
            assert (false) : "Unknown title: " + title;
            return null;
        }

        public String getDefaultTaskName() {
            return "default";
        }

        public Future<List<String>> getTasks() {
            return new TasksFuture(this.gulpTasks);
        }

        public void runTask(String ... args) {
            assert (!EventQueue.isDispatchThread());
            GulpExecutable gulp = GulpExecutable.getDefault(this.project, true);
            if (gulp != null) {
                GulpUtils.logUsageGulpBuild();
                gulp.run(args);
            }
        }

        public void reloadTasks() {
            assert (!EventQueue.isDispatchThread());
            this.gulpTasks.reset();
            try {
                this.gulpTasks.loadTasks(null, null);
            }
            catch (ExecutionException | TimeoutException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }

        public void configure() {
            OptionsDisplayer.getDefault().open("Html5/Gulp");
        }
    }
}

