/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.spi.project.NativeFileSearchProvider;
import org.netbeans.modules.cnd.spi.project.NativeProjectExecutionProvider;
import org.openide.util.lookup.Lookups;

public final class NativeProjectSupport {
    private NativeProjectSupport() {
    }

    public static NativeExitStatus execute(NativeProject project, String executable, String[] env, String ... args) throws IOException {
        for (NativeProjectExecutionProvider provider : Lookups.forPath((String)"CND/NativeProjectExecutionProvider").lookupAll(NativeProjectExecutionProvider.class)) {
            NativeExitStatus result = provider.execute(project, executable, env, args);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String getPlatformName(NativeProject project) {
        for (NativeProjectExecutionProvider provider : Lookups.forPath((String)"CND/NativeProjectExecutionProvider").lookupAll(NativeProjectExecutionProvider.class)) {
            String result = provider.getPlatformName(project);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static NativeFileSearch getNativeFileSearch(NativeProject project) {
        final ArrayList<NativeFileSearch> delegates = new ArrayList<NativeFileSearch>();
        for (NativeFileSearchProvider provider : Lookups.forPath((String)"CND/NativeFileSearchProvider").lookupAll(NativeFileSearchProvider.class)) {
            NativeFileSearch result = provider.getNativeFileSearch(project);
            if (result == null) continue;
            delegates.add(result);
        }
        return new NativeFileSearch(){

            @Override
            public Collection<CharSequence> searchFile(NativeProject project, String fileName) {
                LinkedHashSet<CharSequence> out = new LinkedHashSet<CharSequence>();
                for (NativeFileSearch searcher : delegates) {
                    out.addAll(searcher.searchFile(project, fileName));
                }
                return out;
            }
        };
    }

    public static final class NativeExitStatus {
        public final int exitCode;
        public final String error;
        public final String output;

        public NativeExitStatus(int exitCode, String output, String error) {
            this.exitCode = exitCode;
            this.error = error;
            this.output = output;
        }

        public boolean isOK() {
            return this.exitCode == 0;
        }
    }
}

