/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.project.support;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.source.spi.CndCookieProvider;
import org.openide.loaders.DataObject;
import org.openide.util.WeakSet;
import org.openide.util.lookup.InstanceContent;

public final class NativeFileItemSetProvider
extends CndCookieProvider {
    public void addLookup(DataObject dao, InstanceContent ic) {
        ic.add((Object)new NativeFileItemSetImpl());
    }

    private static final class NativeFileItemSetImpl
    implements NativeFileItemSet {
        private Object singleItemOrItems;

        private NativeFileItemSetImpl() {
        }

        @Override
        public synchronized Collection<NativeFileItem> getItems() {
            ArrayList<NativeFileItem> res;
            if (this.singleItemOrItems instanceof WeakReference) {
                WeakReference singleItem = (WeakReference)this.singleItemOrItems;
                res = new ArrayList<NativeFileItem>(1);
                NativeFileItem first = (NativeFileItem)singleItem.get();
                if (first != null) {
                    res.add(first);
                }
            } else if (this.singleItemOrItems instanceof WeakSet) {
                WeakSet items = (WeakSet)this.singleItemOrItems;
                res = new ArrayList(items.size());
                for (NativeFileItem item : items) {
                    if (item == null) continue;
                    res.add(item);
                }
            } else {
                res = new ArrayList(0);
            }
            return res;
        }

        @Override
        public synchronized void add(NativeFileItem item) {
            if (item == null) {
                return;
            }
            if (this.singleItemOrItems == null) {
                this.singleItemOrItems = new WeakReference<NativeFileItem>(item);
            } else if (this.singleItemOrItems instanceof WeakReference) {
                WeakReference singleItem = (WeakReference)this.singleItemOrItems;
                NativeFileItem first = (NativeFileItem)singleItem.get();
                if (first == null) {
                    this.singleItemOrItems = new WeakReference<NativeFileItem>(item);
                    return;
                }
                if (item.equals(first)) {
                    return;
                }
                WeakSet items = new WeakSet(2);
                items.add((Object)first);
                items.add((Object)item);
                this.singleItemOrItems = items;
            } else if (this.singleItemOrItems instanceof WeakSet) {
                WeakSet items = (WeakSet)this.singleItemOrItems;
                items.add((Object)item);
            }
        }

        @Override
        public synchronized void remove(NativeFileItem item) {
            if (item == null) {
                return;
            }
            if (this.singleItemOrItems instanceof WeakReference) {
                WeakReference singleItem = (WeakReference)this.singleItemOrItems;
                NativeFileItem first = (NativeFileItem)singleItem.get();
                if (item.equals(first)) {
                    this.singleItemOrItems = null;
                }
            } else if (this.singleItemOrItems instanceof WeakSet) {
                WeakSet items = (WeakSet)this.singleItemOrItems;
                items.remove((Object)item);
            }
        }

        @Override
        public synchronized boolean isEmpty() {
            if (this.singleItemOrItems instanceof WeakReference) {
                WeakReference singleItem = (WeakReference)this.singleItemOrItems;
                return singleItem.get() == null;
            }
            if (this.singleItemOrItems instanceof WeakSet) {
                WeakSet items = (WeakSet)this.singleItemOrItems;
                return items.isEmpty();
            }
            return true;
        }
    }
}

