/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer;

import java.awt.Color;
import org.netbeans.modules.profiler.snaptracer.ItemValueFormatter;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.ContinuousXYItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.DiscreteXYItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.IconItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.ValueItemDescriptor;

public abstract class ProbeItemDescriptor {
    public static final long MIN_VALUE_UNDEFINED = Long.MAX_VALUE;
    public static final long MAX_VALUE_UNDEFINED = Long.MIN_VALUE;
    public static final long VALUE_UNDEFINED = Long.MAX_VALUE;
    public static final Color DEFAULT_COLOR = new Color(0, 0, 0);
    public static final float DEFAULT_LINE_WIDTH = -1.0f;
    private final String name;
    private final String description;

    protected ProbeItemDescriptor(String name, String description) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (!(this instanceof ValueItemDescriptor)) {
            throw new UnsupportedOperationException("Custom descriptor not supported. Use the predefined descriptors.");
        }
        this.name = name;
        this.description = description;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public static ProbeItemDescriptor iconItem(String name, String description, ItemValueFormatter formatter) {
        return new IconItemDescriptor(name, description, formatter, DEFAULT_COLOR);
    }

    public static ProbeItemDescriptor continuousLineItem(String name, String description, ItemValueFormatter formatter) {
        return ProbeItemDescriptor.continuousItem(name, description, formatter, 1.0, 0L, Long.MIN_VALUE, -1.0f, DEFAULT_COLOR, null);
    }

    public static ProbeItemDescriptor continuousLineItem(String name, String description, ItemValueFormatter formatter, double dataFactor, long minValue, long maxValue) {
        return ProbeItemDescriptor.continuousItem(name, description, formatter, dataFactor, minValue, maxValue, -1.0f, DEFAULT_COLOR, null);
    }

    public static ProbeItemDescriptor continuousFillItem(String name, String description, ItemValueFormatter formatter) {
        return ProbeItemDescriptor.continuousItem(name, description, formatter, 1.0, 0L, Long.MIN_VALUE, -1.0f, null, DEFAULT_COLOR);
    }

    public static ProbeItemDescriptor continuousFillItem(String name, String description, ItemValueFormatter formatter, double dataFactor, long minValue, long maxValue) {
        return ProbeItemDescriptor.continuousItem(name, description, formatter, dataFactor, minValue, maxValue, -1.0f, null, DEFAULT_COLOR);
    }

    public static ProbeItemDescriptor continuousLineFillItem(String name, String description, ItemValueFormatter formatter) {
        return ProbeItemDescriptor.continuousItem(name, description, formatter, 1.0, 0L, Long.MIN_VALUE, -1.0f, DEFAULT_COLOR, DEFAULT_COLOR);
    }

    public static ProbeItemDescriptor continuousLineFillItem(String name, String description, ItemValueFormatter formatter, double dataFactor, long minValue, long maxValue) {
        return ProbeItemDescriptor.continuousItem(name, description, formatter, dataFactor, minValue, maxValue, -1.0f, DEFAULT_COLOR, DEFAULT_COLOR);
    }

    public static ProbeItemDescriptor continuousItem(String name, String description, ItemValueFormatter formatter, double dataFactor, long minValue, long maxValue, float lineWidth, Color lineColor, Color fillColor) {
        if (lineColor == null && fillColor == null) {
            throw new IllegalArgumentException("Either lineColor or fillColor must be defined");
        }
        return new ContinuousXYItemDescriptor(name, description, formatter, dataFactor, minValue, maxValue, lineWidth, lineColor, fillColor);
    }

    public static ProbeItemDescriptor discreteLineItem(String name, String description, ItemValueFormatter formatter) {
        return ProbeItemDescriptor.discreteOutlineItem(name, description, formatter, 1.0, 0L, Long.MIN_VALUE, -1.0f, DEFAULT_COLOR, null);
    }

    public static ProbeItemDescriptor discreteLineItem(String name, String description, ItemValueFormatter formatter, double dataFactor, long minValue, long maxValue) {
        return ProbeItemDescriptor.discreteOutlineItem(name, description, formatter, dataFactor, minValue, maxValue, -1.0f, DEFAULT_COLOR, null);
    }

    public static ProbeItemDescriptor discreteFillItem(String name, String description, ItemValueFormatter formatter) {
        return ProbeItemDescriptor.discreteOutlineItem(name, description, formatter, 1.0, 0L, Long.MIN_VALUE, -1.0f, null, DEFAULT_COLOR);
    }

    public static ProbeItemDescriptor discreteFillItem(String name, String description, ItemValueFormatter formatter, double dataFactor, long minValue, long maxValue) {
        return ProbeItemDescriptor.discreteOutlineItem(name, description, formatter, dataFactor, minValue, maxValue, -1.0f, null, DEFAULT_COLOR);
    }

    public static ProbeItemDescriptor discreteLineFillItem(String name, String description, ItemValueFormatter formatter) {
        return ProbeItemDescriptor.discreteOutlineItem(name, description, formatter, 1.0, 0L, Long.MIN_VALUE, -1.0f, DEFAULT_COLOR, DEFAULT_COLOR);
    }

    public static ProbeItemDescriptor discreteLineFillItem(String name, String description, ItemValueFormatter formatter, double dataFactor, long minValue, long maxValue) {
        return ProbeItemDescriptor.discreteOutlineItem(name, description, formatter, dataFactor, minValue, maxValue, -1.0f, DEFAULT_COLOR, DEFAULT_COLOR);
    }

    public static ProbeItemDescriptor discreteOutlineItem(String name, String description, ItemValueFormatter formatter, double dataFactor, long minValue, long maxValue, float lineWidth, Color lineColor, Color fillColor) {
        if (lineColor == null && fillColor == null) {
            throw new IllegalArgumentException("Either lineColor or fillColor must be defined");
        }
        return ProbeItemDescriptor.discreteItem(name, description, formatter, dataFactor, minValue, maxValue, lineWidth, lineColor, fillColor, 0, false, false, true);
    }

    public static ProbeItemDescriptor discreteToplineItem(String name, String description, ItemValueFormatter formatter, double dataFactor, long minValue, long maxValue, boolean filled, int width, boolean fixedWidth) {
        return ProbeItemDescriptor.discreteItem(name, description, formatter, dataFactor, minValue, maxValue, -1.0f, DEFAULT_COLOR, filled ? DEFAULT_COLOR : null, width, fixedWidth, true, false);
    }

    public static ProbeItemDescriptor discreteToplineItem(String name, String description, ItemValueFormatter formatter, double dataFactor, long minValue, long maxValue, float lineWidth, Color lineColor, Color fillColor, int width, boolean fixedWidth) {
        if (lineColor == null && fillColor == null) {
            throw new IllegalArgumentException("Either lineColor or fillColor must be defined");
        }
        return ProbeItemDescriptor.discreteItem(name, description, formatter, dataFactor, minValue, maxValue, lineWidth, lineColor, fillColor, width, fixedWidth, true, false);
    }

    public static ProbeItemDescriptor discreteBarItem(String name, String description, ItemValueFormatter formatter, double dataFactor, long minValue, long maxValue, boolean outlined, boolean filled, int width, boolean fixedWidth) {
        if (!outlined && !filled) {
            throw new IllegalArgumentException("Either outlined or filled must be set");
        }
        return ProbeItemDescriptor.discreteItem(name, description, formatter, dataFactor, minValue, maxValue, -1.0f, outlined ? DEFAULT_COLOR : null, filled ? DEFAULT_COLOR : null, width, fixedWidth, false, !filled);
    }

    public static ProbeItemDescriptor discreteBarItem(String name, String description, ItemValueFormatter formatter, double dataFactor, long minValue, long maxValue, float lineWidth, Color lineColor, Color fillColor, int width, boolean fixedWidth) {
        if (lineColor == null && fillColor == null) {
            throw new IllegalArgumentException("Either lineColor or fillColor must be defined");
        }
        return ProbeItemDescriptor.discreteItem(name, description, formatter, dataFactor, minValue, maxValue, lineWidth, lineColor, fillColor, width, fixedWidth, false, fillColor == null);
    }

    private static ProbeItemDescriptor discreteItem(String name, String description, ItemValueFormatter formatter, double dataFactor, long minValue, long maxValue, float lineWidth, Color lineColor, Color fillColor, int width, boolean fixedWidth, boolean topLineOnly, boolean outlineOnly) {
        return new DiscreteXYItemDescriptor(name, description, formatter, dataFactor, minValue, maxValue, lineWidth, lineColor, fillColor, width, fixedWidth, topLineOnly, outlineOnly);
    }
}

