/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.probes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.modules.profiler.snaptracer.TracerProbe;
import org.netbeans.modules.profiler.snaptracer.TracerProbeDescriptor;

public final class ProbePresenter
extends JLabel {
    private static final Color SELECTED_FILTER = new Color(0, 0, 200, 40);
    private static final float[] FRACTIONS = new float[]{0.0f, 0.49f, 0.51f, 1.0f};
    private static final Color[] COLORS = new Color[]{new Color(250, 251, 252, 120), new Color(237, 240, 242, 120), new Color(229, 233, 236, 125), new Color(215, 221, 226, 130)};
    private static final Color BACKGROUND = UIManager.getColor("Panel.background");
    private LinearGradientPaint gradientPaint;
    private static final boolean GRADIENT = !Utils.forceSpeed();
    private boolean isSelected = false;

    public ProbePresenter(TracerProbe p, TracerProbeDescriptor d) {
        super(d.getProbeName(), d.getProbeIcon(), 10);
        this.putClientProperty("ToolTipHelper", d.getProbeDescription());
        this.setIconTextGap(7);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
    }

    public void setSelected(boolean selected) {
        if (this.isSelected == selected) {
            return;
        }
        this.isSelected = selected;
        this.repaint();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        if (GRADIENT) {
            this.gradientPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, h - 1, FRACTIONS, COLORS);
        }
        super.reshape(x, y, w, h);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int y = this.getHeight() - 1;
        ((Graphics2D)g).setPaint(GRADIENT ? this.gradientPaint : BACKGROUND);
        g.fillRect(0, 0, this.getWidth(), y);
        if (this.isSelected) {
            g.setColor(SELECTED_FILTER);
            g.fillRect(0, 0, this.getWidth(), y);
        }
        super.paintComponent(g);
    }
}

