/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatus;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.commands.Bundle;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class StatusCommand
extends HgCommand<Map<File, FileInformation>> {
    private final File repository;
    private List<String> output;
    private String statusFlags;
    private String revisionFrom;
    private String revisionTo;
    private final List<File> files;
    private static final Logger LOG = Logger.getLogger(StatusCommand.class.getName());
    private static final String HG_STATUS_FLAG_INTERESTING_CMD = "-mardu";
    private static final String HG_STATUS_FLAG_COPIES = "C";
    private static final char HG_STATUS_CODE_MODIFIED = 'm';
    private static final char HG_STATUS_CODE_ADDED = 'a';
    private static final char HG_STATUS_CODE_REMOVED = 'r';
    private static final char HG_STATUS_CODE_CLEAN = 'c';
    private static final char HG_STATUS_CODE_DELETED = 'A';
    private static final char HG_STATUS_CODE_NOTTRACKED = '_';
    private static final char HG_STATUS_CODE_IGNORED = 'i';
    private static final char HG_STATUS_CODE_CONFLICT = 'u';
    private static final char HG_STATUS_CODE_ABORT = '\u00c3';
    private boolean detectCopies;
    private boolean detectConflicts;

    public StatusCommand(File repository, List<File> files) {
        Parameters.notNull((CharSequence)"repository", (Object)repository);
        Parameters.notNull((CharSequence)"files", files);
        this.repository = repository;
        this.files = files;
        this.statusFlags = HG_STATUS_FLAG_INTERESTING_CMD;
        this.detectConflicts = true;
    }

    public static StatusCommand create(File repository, List<File> files, boolean detectCopies) {
        return new StatusCommand(repository, files).setStatusFlags(HG_STATUS_FLAG_INTERESTING_CMD).setDetectCopies(detectCopies);
    }

    public StatusCommand setRevisionFrom(String revisionFrom) {
        this.revisionFrom = revisionFrom;
        return this;
    }

    public StatusCommand setRevisionTo(String revisionTo) {
        this.revisionTo = revisionTo;
        return this;
    }

    public StatusCommand setDetectCopies(boolean detectCopies) {
        this.detectCopies = detectCopies;
        return this;
    }

    public StatusCommand setDetectConflicts(boolean detectConflicts) {
        this.detectConflicts = detectConflicts;
        return this;
    }

    private StatusCommand setStatusFlags(String statusFlags) {
        this.statusFlags = statusFlags;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<File, FileInformation> call() throws HgException {
        Map<File, FileInformation> map;
        block4: {
            long startTime = 0L;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "getStatusWithFlags: starting for {0}", this.files);
                startTime = System.currentTimeMillis();
            }
            try {
                map = this.runInternal();
                if (!LOG.isLoggable(Level.FINER)) break block4;
            }
            catch (Throwable throwable) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "getStatusWithFlags for {0} lasted {1}", new Object[]{this.files, System.currentTimeMillis() - startTime});
                }
                throw throwable;
            }
            LOG.log(Level.FINER, "getStatusWithFlags for {0} lasted {1}", new Object[]{this.files, System.currentTimeMillis() - startTime});
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<File, FileInformation> runInternal() throws HgException {
        HgCommand.CommandParameters args = new HgCommand.CommandParameters("status");
        String flags = this.statusFlags;
        if (this.detectCopies) {
            flags = flags + HG_STATUS_FLAG_COPIES;
        }
        args.add(flags).addRepositoryLocation(this.repository.getAbsolutePath()).add("--cwd").add(this.repository.getAbsolutePath());
        List<String> command = args.toCommand();
        List<List<String>> attributeGroups = HgCommand.splitAttributes(this.repository, command, this.files, true);
        boolean workDirStatus = true;
        boolean skipMidChanges = false;
        if (this.revisionFrom != null) {
            command.add("--rev");
            if (this.revisionTo == null || HgLogMessage.HgRevision.CURRENT.getRevisionNumber().equals(this.revisionTo)) {
                skipMidChanges = !HgLogMessage.HgRevision.BASE.getRevisionNumber().equals(this.revisionFrom);
                command.add(this.revisionFrom);
            } else {
                skipMidChanges = true;
                command.add(this.revisionFrom + ":" + this.revisionTo);
                workDirStatus = false;
            }
        }
        ArrayList<String> commandOutput = new ArrayList<String>();
        ArrayList<String> changedPaths = skipMidChanges ? new ArrayList<String>() : null;
        for (List<String> attributes : attributeGroups) {
            if (changedPaths != null) {
                changedPaths.addAll(HgCommand.getListOfChangedFiles(this.repository, attributes, this.revisionFrom, this.revisionTo));
            }
            ArrayList<String> finalCommand = new ArrayList<String>(command);
            finalCommand.addAll(attributes);
            List<String> list = StatusCommand.exec(finalCommand);
            if (!list.isEmpty() && HgCommand.isErrorNoRepository(list.get(0))) {
                OutputLogger logger = OutputLogger.getLogger(this.repository);
                try {
                    StatusCommand.handleError(finalCommand, list, Bundle.MSG_NO_REPOSITORY_ERR(), logger);
                }
                finally {
                    logger.closeLog();
                }
            }
            if (this.detectConflicts && workDirStatus && HgUtils.hasResolveCommand(Mercurial.getInstance().getVersion())) {
                try {
                    List<String> unresolved = HgCommand.getUnresolvedFiles(this.repository, attributes);
                    list.addAll(unresolved);
                }
                catch (HgException ex) {
                    // empty catch block
                }
            }
            commandOutput.addAll(list);
        }
        Map<File, FileInformation> infos = StatusCommand.processStatusResult(commandOutput, this.repository, flags, changedPaths);
        if (LOG.isLoggable(Level.FINE)) {
            if (commandOutput.size() < 10) {
                LOG.log(Level.FINE, "getStatusWithFlags(): repository path: {0} status flags: {1} status list {2}", new Object[]{this.repository.getAbsolutePath(), flags, commandOutput});
            } else {
                LOG.log(Level.FINE, "getStatusWithFlags(): repository path: {0} status flags: {1} status list has {2} elements", new Object[]{this.repository.getAbsolutePath(), flags, commandOutput.size()});
            }
        }
        return infos;
    }

    private static Map<File, FileInformation> processStatusResult(List<String> commandOutput, File repository, String statusFlags, List<String> changedPaths) {
        HashMap<File, FileInformation> repositoryFiles = new HashMap<File, FileInformation>(commandOutput.size());
        File file = null;
        FileInformation prev_info = null;
        String repositoryPath = repository.getAbsolutePath();
        for (String statusLine : commandOutput) {
            if (statusLine.isEmpty()) continue;
            FileInformation info = StatusCommand.getFileInformationFromStatusLine(statusLine);
            LOG.log(Level.FINE, "getStatusWithFlags(): status line {0}  info {1}", new Object[]{statusLine, info});
            if (statusLine.length() > 0) {
                if (statusLine.charAt(0) == ' ') {
                    if (file != null) {
                        File original = StatusCommand.getFileFromStatusLine(statusLine, repository);
                        prev_info = new FileInformation(prev_info.getStatus(), new FileStatus(file, original), false);
                        LOG.log(Level.FINE, "getStatusWithFlags(): prev_info {0}  filePath {1}", new Object[]{prev_info, file});
                        continue;
                    }
                    LOG.log(Level.FINE, "getStatusWithFlags(): repository path: {0} status flags: {1} status line {2} filepath == nullfor prev_info ", new Object[]{repository.getAbsolutePath(), statusFlags, statusLine});
                    continue;
                }
                if (file != null) {
                    repositoryFiles.put(file, prev_info);
                }
            }
            if (info.getStatus() == 1 || info.getStatus() == 0) continue;
            if (changedPaths != null && (info.getStatus() & 0x10) != 0 && !changedPaths.contains(StatusCommand.getRelativePathFromStatusLine(statusLine, repositoryPath))) {
                file = null;
                continue;
            }
            file = StatusCommand.getFileFromStatusLine(statusLine, repository);
            if (StatusCommand.existsConflictFile(file.getAbsolutePath())) {
                info = new FileInformation(64, null, false);
                LOG.log(Level.FINE, "getStatusWithFlags(): CONFLICT repository path: {0} status flags: {1} status line {2} CONFLICT {3}", new Object[]{repository.getAbsolutePath(), statusFlags, statusLine, file + ".conflict~"});
            }
            prev_info = info;
        }
        if (prev_info != null) {
            repositoryFiles.put(file, prev_info);
        }
        return repositoryFiles;
    }

    private static File getFileFromStatusLine(String statusLine, File repository) {
        String repositoryPath = repository.getAbsolutePath();
        String path = StatusCommand.getRelativePathFromStatusLine(statusLine, repositoryPath);
        File file = Utilities.isWindows() && path.startsWith(repositoryPath) ? new File(path) : new File(repository, path);
        return file;
    }

    private static FileInformation getFileInformationFromStatusLine(String status) {
        FileInformation info = null;
        if (status == null || status.length() == 0) {
            return new FileInformation(8, null, false);
        }
        char c0 = status.charAt(0);
        char c1 = status.charAt(1);
        switch (c0 + c1) {
            case 109: {
                info = new FileInformation(16, null, false);
                break;
            }
            case 97: {
                info = new FileInformation(4096, null, false);
                break;
            }
            case 114: {
                info = new FileInformation(256, null, false);
                break;
            }
            case 99: {
                info = new FileInformation(8, null, false);
                break;
            }
            case 65: {
                info = new FileInformation(2048, null, false);
                break;
            }
            case 105: {
                info = new FileInformation(2, null, false);
                break;
            }
            case 95: {
                info = new FileInformation(4, null, false);
                break;
            }
            case 117: {
                info = new FileInformation(64, null, false);
                break;
            }
            case 195: {
                info = new FileInformation(1, null, false);
                break;
            }
            default: {
                info = new FileInformation(0, null, false);
            }
        }
        return info;
    }

    private static String getRelativePathFromStatusLine(String statusLine, String repositoryPath) {
        String path = statusLine.substring(2);
        if (Utilities.isWindows() && path.startsWith(repositoryPath)) {
            path = path.substring(repositoryPath.length() + 1);
        }
        return path;
    }

    public List<String> getOutput() {
        return this.output;
    }
}

