/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.queues;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.queues.FinishPatch;
import org.netbeans.modules.mercurial.ui.queues.QPatch;
import org.netbeans.modules.mercurial.ui.queues.QUtils;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.hooks.HgHookContext;
import org.netbeans.modules.versioning.hooks.HgQueueHook;
import org.netbeans.modules.versioning.hooks.HgQueueHookContext;
import org.netbeans.modules.versioning.hooks.VCSHooks;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class QFinishPatchesAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_QFinishPatches";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        final File[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        Utils.post((Runnable)new Runnable(){

            @Override
            public void run() {
                if (QUtils.isMQEnabledExtension(root)) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String patchName;
                            FinishPatch finishPatch = new FinishPatch(root);
                            if (finishPatch.showDialog() && (patchName = finishPatch.getSelectedPatch()) != null) {
                                QFinishPatchesAction.this.finishPatch(root, roots, patchName);
                            }
                        }
                    });
                }
            }
        });
    }

    public void finishPatch(final File root, final File[] roots, final String patchName) {
        new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void perform() {
                OutputLogger logger = this.getLogger();
                try {
                    logger.outputInRed(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_FINISH_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_FINISH_TITLE_SEP"));
                    List<QPatch> toFinish = this.getPatchesToFinish(patchName, root);
                    if (toFinish.isEmpty()) {
                        logger.output(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_FINISH_NOTHING_TO_FINISH"));
                        return;
                    }
                    Collection hooks = VCSHooks.getInstance().getHooks(HgQueueHook.class);
                    for (QPatch patch : toFinish) {
                        if (this.isCanceled()) {
                            return;
                        }
                        this.setDisplayName(patch.getId());
                        logger.output(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_FINISH_INFO_SEP", (Object)patch.getId(), (Object)root.getAbsolutePath()));
                        logger.output("");
                        HgQueueHookContext hooksCtx = new HgQueueHookContext(roots, null, patch.getId(), new HgHookContext.LogEntry[0]);
                        for (HgQueueHook hgHook : hooks) {
                            try {
                                hgHook.beforePatchFinish(hooksCtx);
                            }
                            catch (IOException ex) {}
                        }
                        HgLogMessage message = this.getRevision(patch.getId());
                        if (message == null) {
                            logger.outputInRed(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_FINISH_ERR_NOSUCHREVISION", (Object)patch.getId()));
                            break;
                        }
                        HgCommand.qFinishPatches(root, patch.getId(), logger);
                        HgModuleConfig.getDefault().setLastUsedQPatchMessage(patch.getId(), null);
                        message = this.getRevision(message.getRevisionNumber());
                        if (message == null) {
                            logger.outputInRed(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_FINISH_ERR_NOSUCHREVISION", (Object)patch.getId()));
                            break;
                        }
                        HgUtils.logHgLog(message, logger);
                        hooksCtx = new HgQueueHookContext(roots, null, patch.getId(), new HgHookContext.LogEntry[]{new HgHookContext.LogEntry(message.getMessage(), message.getAuthor(), message.getCSetShortID(), message.getDate())});
                        for (HgQueueHook hgHook : hooks) {
                            this.setDisplayName(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_QFinishPatchesAction.progress.hooks", (Object)patch.getId()));
                            hgHook.afterPatchFinish(hooksCtx);
                        }
                    }
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                finally {
                    logger.outputInRed(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_FINISH_DONE"));
                    logger.output("");
                }
            }

            private List<QPatch> getPatchesToFinish(String patchName2, File root2) throws HgException {
                QPatch[] patches = HgCommand.qListSeries(root2);
                LinkedList<QPatch> toFinish = new LinkedList<QPatch>();
                boolean containsTarget = false;
                for (QPatch patch : patches) {
                    if (!patch.isApplied()) break;
                    toFinish.add(patch);
                    if (!patchName2.contains(patch.getId())) continue;
                    containsTarget = true;
                    break;
                }
                return containsTarget ? toFinish : Collections.emptyList();
            }

            private HgLogMessage getRevision(String revisionId) {
                HgLogMessage[] messages = HgCommand.getLogMessagesNoFileInfo(root, null, revisionId, revisionId, true, -1, Collections.emptyList(), this.getLogger());
                return messages.length == 0 ? null : messages[0];
            }
        }.start(Mercurial.getInstance().getRequestProcessor(root), root, NbBundle.getMessage(QFinishPatchesAction.class, (String)"LBL_QFinishPatchAction.progress"));
    }
}

