/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.parser.html;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.AbstractSaxHtmlParser;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.DocumentProcessor;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HtmlParser
extends AbstractSaxHtmlParser {
    private List<DocumentProcessor> processors = new ArrayList<DocumentProcessor>();

    @Override
    protected void parse(InputSource input, DocumentBuilder builder, ContentHandler contentHandler) throws IOException, SAXException {
        Document document = Jsoup.parse((String)this.readContent(input));
        for (DocumentProcessor processor : this.processors) {
            processor.process(document);
        }
        Stack<NodeHandler> stack = new Stack<NodeHandler>();
        stack.push(new DocumentHandler(document));
        while (!stack.isEmpty()) {
            NodeHandler handler = (NodeHandler)stack.pop();
            handler.process(stack, contentHandler);
        }
    }

    public List<DocumentProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<DocumentProcessor> processors) {
        this.processors = processors;
    }

    private String readContent(InputSource input) throws IOException {
        Reader reader = input.getCharacterStream();
        try {
            if (reader == null) {
                InputStream bytes = input.getByteStream();
                if (bytes == null) {
                    String systemId = input.getSystemId();
                    if (systemId != null) {
                        bytes = new BufferedInputStream(new FileInputStream(systemId));
                    }
                    if (bytes == null) {
                        throw new IllegalArgumentException();
                    }
                }
                reader = new InputStreamReader(bytes, input.getEncoding() == null ? "utf-8" : input.getEncoding());
            }
            StringWriter writer = new StringWriter(2048);
            int i = reader.read();
            while (i != -1) {
                writer.write(i);
                i = reader.read();
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static class DocumentHandler
    extends NodeHandler {
        private final Document document;

        public DocumentHandler(Document doc) {
            this.document = doc;
        }

        @Override
        public void process(Stack<NodeHandler> stack, ContentHandler contentHandler) throws SAXException {
            contentHandler.startDocument();
            stack.push(new EndDocumentHandler());
            stack.push(new ElementHandler(this.document.body()));
        }
    }

    private static class ElementHandler
    extends NodeHandler {
        private final Element element;

        public ElementHandler(Element element) {
            this.element = element;
        }

        @Override
        public void process(Stack<NodeHandler> stack, ContentHandler contentHandler) throws SAXException {
            contentHandler.startElement(null, this.element.nodeName(), this.element.nodeName(), this.computeAttributes());
            stack.push(new EndElementHandler(this.element));
            List childNodes = this.element.childNodes();
            if (!childNodes.isEmpty()) {
                int x = childNodes.size() - 1;
                while (x >= 0) {
                    Node child = (Node)childNodes.get(x);
                    if (child instanceof Element) {
                        stack.push(new ElementHandler((Element)child));
                    } else if (child instanceof TextNode) {
                        stack.push(new TextHandler((TextNode)child));
                    }
                    --x;
                }
            }
        }

        private Attributes computeAttributes() {
            AttributesImpl attributes = new AttributesImpl();
            for (Attribute attr : this.element.attributes()) {
                attributes.addAttribute(null, attr.getKey(), null, null, attr.getValue());
            }
            return attributes;
        }
    }

    private static class EndDocumentHandler
    extends NodeHandler {
        @Override
        public void process(Stack<NodeHandler> stack, ContentHandler contentHandler) throws SAXException {
            contentHandler.endDocument();
        }
    }

    private static class EndElementHandler
    extends NodeHandler {
        private final Element element;

        public EndElementHandler(Element element) {
            this.element = element;
        }

        @Override
        public void process(Stack<NodeHandler> stack, ContentHandler contentHandler) throws SAXException {
            contentHandler.endElement(null, this.element.nodeName(), this.element.nodeName());
        }
    }

    private static abstract class NodeHandler {
        private NodeHandler() {
        }

        public abstract void process(Stack<NodeHandler> var1, ContentHandler var2) throws SAXException;
    }

    private static class TextHandler
    extends NodeHandler {
        private final TextNode node;

        public TextHandler(TextNode node) {
            this.node = node;
        }

        @Override
        public void process(Stack<NodeHandler> stack, ContentHandler contentHandler) throws SAXException {
            String text = this.isPreserveWhitespace() ? this.node.getWholeText() : this.node.text();
            contentHandler.characters(text.toCharArray(), 0, text.length());
        }

        private boolean isPreserveWhitespace() {
            Node parent = this.node.parent();
            while (parent != null) {
                if (parent.nodeName().equals("pre")) {
                    return true;
                }
                parent = parent.parent();
            }
            return false;
        }
    }
}

