/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util.anttask;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.DocBookDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.anttask.MarkupTask;
import org.eclipse.mylyn.wikitext.core.util.anttask.Messages;

public class MarkupToDocbookTask
extends MarkupTask {
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private String docbookFilenameFormat = "$1.xml";
    private String bookTitle;
    private boolean overwrite = true;
    protected File file;
    private String doctype;

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void execute() throws BuildException {
        if (this.file == null && this.filesets.isEmpty()) {
            throw new BuildException(Messages.getString("MarkupToDocbookTask.1"));
        }
        if (this.file != null && !this.filesets.isEmpty()) {
            throw new BuildException(Messages.getString("MarkupToDocbookTask.2"));
        }
        if (this.file != null) {
            if (!this.file.exists()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDocbookTask.3"), this.file));
            }
            if (!this.file.isFile()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDocbookTask.4"), this.file));
            }
            if (!this.file.canRead()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDocbookTask.5"), this.file));
            }
        }
        MarkupLanguage markupLanguage = this.createMarkupLanguage();
        for (FileSet fileset : this.filesets) {
            File filesetBaseDir = fileset.getDir(this.getProject());
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            if (files == null) continue;
            File baseDir = ds.getBasedir();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File inputFile = new File(baseDir, file);
                try {
                    this.processFile(markupLanguage, filesetBaseDir, inputFile);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDocbookTask.6"), inputFile, e.getMessage()), (Throwable)e);
                }
                ++n2;
            }
        }
        if (this.file != null) {
            try {
                this.processFile(markupLanguage, this.file.getParentFile(), this.file);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDocbookTask.7"), this.file, e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processFile(MarkupLanguage markupLanguage, File baseDir, File source) throws BuildException {
        File docbookOutputFile;
        this.log(MessageFormat.format(Messages.getString("MarkupToDocbookTask.8"), source), 3);
        String markupContent = null;
        String name = source.getName();
        if (name.lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (!(docbookOutputFile = new File(source.getParentFile(), this.docbookFilenameFormat.replace("$1", name))).exists() || this.overwrite || docbookOutputFile.lastModified() < source.lastModified()) {
            OutputStreamWriter writer;
            if (markupContent == null) {
                markupContent = this.readFully(source);
            }
            this.performValidation(source, markupContent);
            try {
                writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(docbookOutputFile)), "utf-8");
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDocbookTask.11"), docbookOutputFile, e.getMessage()), (Throwable)e);
            }
            try {
                DocBookDocumentBuilder builder = new DocBookDocumentBuilder(writer){

                    @Override
                    protected XmlStreamWriter createXmlStreamWriter(Writer out) {
                        return super.createFormattingXmlStreamWriter(out);
                    }
                };
                MarkupParser parser = new MarkupParser();
                parser.setMarkupLanguage(markupLanguage);
                parser.setBuilder(builder);
                builder.setBookTitle(this.bookTitle == null ? name : this.bookTitle);
                if (this.doctype != null) {
                    builder.setDoctype(this.doctype);
                }
                parser.parse(markupContent);
            }
            catch (Throwable throwable) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception e) {
                    throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDocbookTask.12"), docbookOutputFile, e.getMessage()), (Throwable)e);
                }
                throw throwable;
            }
            try {
                ((Writer)writer).close();
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDocbookTask.12"), docbookOutputFile, e.getMessage()), (Throwable)e);
            }
        }
    }

    public String getDocbookFilenameFormat() {
        return this.docbookFilenameFormat;
    }

    public void setDocbookFilenameFormat(String docbookFilenameFormat) {
        this.docbookFilenameFormat = docbookFilenameFormat;
    }

    public String getBookTitle() {
        return this.bookTitle;
    }

    public void setBookTitle(String bookTitle) {
        this.bookTitle = bookTitle;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

