/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;
import org.netbeans.installer.Installer;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StreamUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.XMLUtils;
import org.netbeans.installer.utils.exceptions.XMLException;
import org.netbeans.installer.utils.progress.Progress;

public final class EngineUtils {
    public static final String DEFAULT_ENGINE_JAR_NAME = "nbi-engine.jar";

    public static File cacheEngine(Progress progress) throws IOException {
        File cachedEngine = EngineUtils.getEngineLocation();
        if (!FileUtils.exists(cachedEngine)) {
            EngineUtils.cacheEngine(cachedEngine, progress);
        }
        return cachedEngine;
    }

    public static Class getEngineMainClass() {
        return Installer.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void cacheEngine(File dest, Progress progress) throws IOException {
        LogManager.logIndent("cache engine data locally to run uninstall in the future");
        String filePrefix = "file:";
        String httpPrefix = "http://";
        String jarSep = "!/";
        String installerResource = ResourceUtils.getResourceClassName(EngineUtils.getEngineMainClass());
        URL url = EngineUtils.getEngineMainClass().getClassLoader().getResource(installerResource);
        if (url == null) {
            throw new IOException("No main Installer class in the engine");
        }
        LogManager.log(4, "NBI Engine URL for Installer.Class = " + url);
        LogManager.log(4, "URL Path = " + url.getPath());
        boolean needCache = true;
        if ("jar".equals(url.getProtocol())) {
            LogManager.log("... running engine as a .jar file");
            String path = url.getPath();
            if (path.startsWith(filePrefix)) {
                LogManager.log("... classloader says that jar file is on the disk");
                if (path.indexOf(jarSep) == -1) throw new IOException("JAR path " + path + " doesn`t contaion jar-separator " + jarSep);
                String jarLocation = path.substring(filePrefix.length(), path.indexOf(jarSep + installerResource));
                jarLocation = URLDecoder.decode(jarLocation, "UTF-8");
                File jarfile = new File(jarLocation);
                LogManager.log("... checking if it runs from cached engine");
                if (jarfile.getAbsolutePath().equals(dest.getAbsolutePath())) {
                    needCache = false;
                }
                LogManager.log("... " + !needCache);
            } else if (path.startsWith(httpPrefix)) {
                LogManager.log("... classloader says that jar file is on remote server");
            }
        } else {
            LogManager.log("... running engine as a .class file");
        }
        if (needCache) {
            EngineUtils.cacheEngineJar(dest, progress);
        }
        LogManager.logUnindent("... finished caching engine data");
    }

    public static void checkEngine() {
        Class mainClass = EngineUtils.getEngineMainClass();
        String thisClassResource = ResourceUtils.getResourceClassName(mainClass);
        InputStream is = mainClass.getClassLoader().getResourceAsStream(thisClassResource);
        ClassLoader cl = mainClass.getClassLoader();
        boolean exclamationMarkInURL = false;
        if (cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            for (URL url : ucl.getURLs()) {
                exclamationMarkInURL = exclamationMarkInURL || url.getPath().contains("!");
            }
        }
        if (is == null) {
            if (exclamationMarkInURL) {
                String message = SystemUtils.getDefaultUserdirRoot().toString().contains("!") ? "Looks like the name of current user profile directory contains an exclamation mark (!):\n" + SystemUtils.getDefaultUserdirRoot() + "\n\n" + "It is not recommended to use such profile names due to JDK bugs:\n" + "http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4730642" + "\n" + "http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4523159" + "\n" + "\n" + "That bugs affects the installer work as well.\n" + "The workaround is to run installer with different temporary and working installer directory.\n" + "For example, try run installer with the following arguments:\n" + "--tempdir " + new File(System.getenv("SystemDrive"), "Temp") + " " + "--userdir " + new File(System.getenv("SystemDrive"), "NBI") + "\n" : "Cannot load the main class " + mainClass.getName() + " from the jar file due to JDK bugs:\n" + "http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4730642" + "\n" + "http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4523159" + "\n" + "\n" + "Use other directory for the jar file.\n";
                ErrorManager.notifyCritical(message);
            }
        } else {
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private static File getEngineLocation() {
        String propName = "nbi.product.local.engine.path";
        if (System.getProperty("nbi.product.local.engine.path") == null) {
            File cachedEngine = new File(Installer.getInstance().getLocalDirectory(), DEFAULT_ENGINE_JAR_NAME);
            System.setProperty("nbi.product.local.engine.path", cachedEngine.getAbsolutePath());
        }
        return new File(System.getProperty("nbi.product.local.engine.path"));
    }

    private static void cacheEngineJar(File dest, Progress progress) throws IOException {
        LogManager.log("... starting copying engine content to the new jar file");
        Object[] entries = StringUtils.splitByLines(StreamUtils.readStream(ResourceUtils.getResource("data/engine.list")));
        ZipOutputStream jos = null;
        HashSet<String> jarEntries = new HashSet<String>();
        try {
            Manifest mf = new Manifest();
            mf.getMainAttributes().put(Attributes.Name.MAIN_CLASS, EngineUtils.getEngineMainClass().getName());
            mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            mf.getMainAttributes().put(Attributes.Name.CLASS_PATH, "");
            dest.getParentFile().mkdirs();
            jos = new JarOutputStream((OutputStream)new FileOutputStream(dest), mf);
            LogManager.log("... total entries : " + entries.length);
            for (int i = 0; i < entries.length; ++i) {
                String dataDir;
                progress.setPercentage(i * 100 / entries.length);
                String name = entries[i];
                if (name.length() <= 0 || name.startsWith(dataDir = "data/") && !name.equals(dataDir) && !name.matches("^data/engine(_[a-zA-Z]+)*.properties$") && !name.equals("data/clioptions.list")) continue;
                EngineUtils.addJarEntry((JarOutputStream)jos, name, jarEntries);
                if (name.endsWith("/")) continue;
                StreamUtils.transferData(ResourceUtils.getResource(name), (OutputStream)jos);
            }
            LogManager.log("... adding content list and some other stuff");
            EngineUtils.addJarEntry((JarOutputStream)jos, "data/registry.xml", jarEntries);
            XMLUtils.saveXMLDocument(Registry.getInstance().getEmptyRegistryDocument(), jos);
            EngineUtils.addJarEntry((JarOutputStream)jos, "data/engine.list", jarEntries);
            jos.write(StringUtils.asString(entries, SystemUtils.getLineSeparator()).getBytes());
        }
        catch (XMLException e) {
            throw new IOException(e);
        }
        finally {
            if (jos != null) {
                try {
                    jos.close();
                }
                catch (IOException ex) {
                    LogManager.log(ex);
                }
            }
        }
        LogManager.log("Installer Engine has been cached to " + dest);
    }

    private static void addJarEntry(JarOutputStream jos, String name, Set<String> entries) throws IOException {
        int index = !name.endsWith("/") ? name.lastIndexOf("/") : name.substring(0, name.length() - 1).lastIndexOf("/");
        if (index != -1) {
            String parent = name.substring(0, index + 1);
            EngineUtils.addJarEntry(jos, parent, entries);
        }
        if (entries.add(name)) {
            jos.putNextEntry(new JarEntry(name));
        }
    }
}

