/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.execution;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Build;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.j2ee.OneTimeDeployment;
import org.netbeans.modules.maven.j2ee.execution.DeploymentLogger;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.modules.maven.spi.debug.MavenDebugger;
import org.netbeans.modules.web.browser.spi.URLDisplayerImplementation;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.OutputWriter;

public final class DeploymentHelper {
    private static final String MODULEURI = "netbeans.deploy.clientModuleUri";
    private static final String NB_COS = ".netbeans_automatic_build";
    private static final Logger LOGGER = Logger.getLogger(DeploymentHelper.class.getName());
    public static final String CLIENTURLPART = "netbeans.deploy.clientUrlPart";

    private DeploymentHelper() {
    }

    public static DeploymentResult perform(RunConfig config, final ExecutionContext executionContext) {
        final Project project = config.getProject();
        if (RunUtils.isCompileOnSaveEnabled((RunConfig)config)) {
            DeploymentHelper.touchCoSTimeStamp(config, System.currentTimeMillis());
        }
        String moduleUri = (String)config.getProperties().get(MODULEURI);
        String clientUrlPart = (String)config.getProperties().get(CLIENTURLPART);
        if (clientUrlPart == null) {
            clientUrlPart = "";
        }
        boolean redeploy = DeploymentHelper.isRedeploy(config);
        boolean debugmode = DeploymentHelper.isDebugMode(config);
        boolean profilemode = DeploymentHelper.isProfileMode(config);
        boolean showInBrowser = DeploymentHelper.showInBrowser(config);
        FileUtil.refreshFor((File[])new File[]{FileUtil.toFile((FileObject)project.getProjectDirectory())});
        OutputWriter err = executionContext.getInputOutput().getErr();
        OutputWriter out = executionContext.getInputOutput().getOut();
        final J2eeModuleProvider jmp = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (jmp == null) {
            err.println();
            err.println();
            err.println("NetBeans: Application Server deployment not available for Maven project '" + ProjectUtils.getInformation((Project)project).getDisplayName() + "'");
            return DeploymentResult.FAILED;
        }
        String serverInstanceID = null;
        OneTimeDeployment oneTimeDeployment = (OneTimeDeployment)project.getLookup().lookup(OneTimeDeployment.class);
        if (oneTimeDeployment != null) {
            serverInstanceID = oneTimeDeployment.getServerInstanceId();
        }
        Deployment.Mode mode = DeploymentHelper.getMode(config);
        serverInstanceID = jmp.getServerInstanceID();
        if ("DEV-NULL".equals(serverInstanceID) || serverInstanceID == null) {
            err.println("NetBeans: No suitable Deployment Server is defined for the project or globally.");
            return DeploymentResult.FAILED;
        }
        ServerInstance si = Deployment.getDefault().getServerInstance(serverInstanceID);
        try {
            out.println("NetBeans: Deploying on " + (si != null ? si.getDisplayName() : serverInstanceID));
        }
        catch (InstanceRemovedException ex) {
            out.println("NetBeans: Deploying on " + serverInstanceID);
        }
        try {
            String clientUrl;
            out.println("    profile mode: " + profilemode);
            out.println("    debug mode: " + debugmode);
            out.println("    force redeploy: " + redeploy);
            Callable<Void> debuggerHook = null;
            if (debugmode) {
                debuggerHook = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ServerDebugInfo sdi = jmp.getServerDebugInfo();
                        if (sdi != null) {
                            String h = sdi.getHost();
                            String transport = sdi.getTransport();
                            String address = transport.equals("dt_shmem") ? sdi.getShmemName() : Integer.toString(sdi.getPort());
                            MavenDebugger deb = (MavenDebugger)project.getLookup().lookup(MavenDebugger.class);
                            try {
                                deb.attachDebugger(executionContext.getInputOutput(), "Debug Deployed app", transport, h, address);
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.FINE, "Exception occured while trying to attach debugger", ex);
                            }
                        }
                        return null;
                    }
                };
            }
            if ((clientUrl = Deployment.getDefault().deploy(jmp, mode, moduleUri, clientUrlPart, redeploy, (Deployment.Logger)new DeploymentLogger(out), (Callable)debuggerHook)) != null && showInBrowser) {
                URL url = new URL(clientUrl);
                URLDisplayerImplementation urlDisplayer = (URLDisplayerImplementation)project.getLookup().lookup(URLDisplayerImplementation.class);
                if (urlDisplayer != null) {
                    URL appRoot = url;
                    if (clientUrlPart.length() > 0 && clientUrl.endsWith(clientUrlPart)) {
                        appRoot = new URL(clientUrl.substring(0, clientUrl.length() - clientUrlPart.length()));
                    }
                    urlDisplayer.showURL(appRoot, url, project.getProjectDirectory());
                } else {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                }
            }
        }
        catch (MalformedURLException | Deployment.DeploymentException ex) {
            LOGGER.log(Level.FINE, "Exception occured wile deploying to Application Server.", ex);
            return DeploymentResult.FAILED;
        }
        if (oneTimeDeployment != null) {
            oneTimeDeployment.reset();
            MavenProjectSupport.changeServer(project, false);
        }
        return DeploymentResult.SUCCESSFUL;
    }

    private static boolean isRedeploy(RunConfig config) {
        return DeploymentHelper.readBooleanValue(config, "netbeans.deploy.forceRedeploy", true);
    }

    public static Deployment.Mode getMode(RunConfig config) {
        if (DeploymentHelper.isDebugMode(config)) {
            return Deployment.Mode.DEBUG;
        }
        if (DeploymentHelper.isProfileMode(config)) {
            return Deployment.Mode.PROFILE;
        }
        return Deployment.Mode.RUN;
    }

    public static boolean isDebugMode(RunConfig config) {
        return DeploymentHelper.readBooleanValue(config, "netbeans.deploy.debugmode", false);
    }

    public static boolean isProfileMode(RunConfig config) {
        return DeploymentHelper.readBooleanValue(config, "netbeans.deploy.profilemode", false);
    }

    private static boolean showInBrowser(RunConfig config) {
        String browser;
        if (!DeploymentHelper.readBooleanValue(config, "netbeans.deploy.open.in.browser", true)) {
            return false;
        }
        FileObject projectDir = config.getProject().getProjectDirectory();
        if (projectDir != null && (browser = (String)projectDir.getAttribute("netbeans.deploy.showBrowser")) != null) {
            return Boolean.parseBoolean(browser);
        }
        return true;
    }

    private static boolean readBooleanValue(RunConfig config, String key, boolean defaultValue) {
        String value = (String)config.getProperties().get(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    private static boolean touchCoSTimeStamp(RunConfig rc, long stamp) {
        if (rc.getProject() == null) {
            return false;
        }
        Build build = rc.getMavenProject().getBuild();
        if (build == null || build.getOutputDirectory() == null) {
            return false;
        }
        File fl = new File(build.getOutputDirectory());
        if (!(fl = FileUtil.normalizeFile((File)fl)).exists()) {
            return false;
        }
        File check = new File(fl, NB_COS);
        if (!check.exists()) {
            try {
                return check.createNewFile();
            }
            catch (IOException ex) {
                return false;
            }
        }
        return check.setLastModified(stamp);
    }

    public static enum DeploymentResult {
        SUCCESSFUL,
        CANCELED,
        FAILED;

    }
}

