/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.api.debugger.DebuggerManager;

public final class Watch {
    public static final String PROP_EXPRESSION = "expression";
    public static final String PROP_VALUE = "value";
    public static final String PROP_ENABLED = "enabled";
    private String expression;
    private boolean enabled = true;
    private PropertyChangeSupport pcs;

    Watch(String expr) {
        this.expression = expr;
        this.pcs = new PropertyChangeSupport(this);
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        Watch watch = this;
        synchronized (watch) {
            if (enabled == this.enabled) {
                return;
            }
            this.enabled = enabled;
        }
        this.pcs.firePropertyChange(PROP_ENABLED, !enabled, enabled);
    }

    public synchronized String getExpression() {
        return this.expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpression(String expression) {
        String old;
        Watch watch = this;
        synchronized (watch) {
            old = this.expression;
            this.expression = expression;
        }
        this.pcs.firePropertyChange(PROP_EXPRESSION, old, expression);
    }

    public void remove() {
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        dm.removeWatch(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }
}

