/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitObjectType;
import org.netbeans.modules.git.remote.cli.GitTag;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.CreateTagCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class ListTagCommand
extends GitCommand {
    public static final boolean KIT = false;
    private Map<String, GitTag> allTags;
    private final ProgressMonitor monitor;
    private final boolean all;
    private final GitCommand.Revision revisionPlaseHolder;
    private final String onlyTagName;

    public ListTagCommand(JGitRepository repository, GitClassFactory gitFactory, boolean all, ProgressMonitor monitor, String tagName) {
        super(repository, gitFactory, monitor);
        this.all = all;
        this.monitor = monitor;
        this.revisionPlaseHolder = new GitCommand.Revision();
        this.onlyTagName = tagName;
    }

    public Map<String, GitTag> getTags() {
        return this.allTags;
    }

    @Override
    protected void prepare() throws GitException {
        this.setCommandsNumber(2);
        super.prepare();
        this.addArgument(0, "show-ref");
        this.addArgument(0, "--tags");
        this.addArgument(0, "-d");
        if (this.onlyTagName != null) {
            this.addArgument(0, this.onlyTagName);
        }
        this.addArgument(1, "show");
        this.addArgument(1, "--raw");
        this.addArgument(1, this.revisionPlaseHolder);
    }

    @Override
    protected void run() throws GitException {
        block8: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                this.allTags = new LinkedHashMap<String, GitTag>();
                final ArrayList list = new ArrayList();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        ListTagCommand.this.parseTagOutput(output, list);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        ListTagCommand.this.parseAddError(error);
                    }
                }.runCLI();
                if (list.size() == 1) {
                    for (final GitTag.TagContainer container : list) {
                        if (container.id == null) continue;
                        this.revisionPlaseHolder.setContent(container.id);
                        new GitCommand.Runner(canceled, 1){

                            @Override
                            public void outputParser(String output) throws GitException {
                                CreateTagCommand.parseShowDetails(output, container);
                            }

                            @Override
                            protected void errorParser(String error) throws GitException {
                                ListTagCommand.this.parseAddError(error);
                            }
                        }.runCLI();
                        this.allTags.put(container.name, this.getClassFactory().createTag(container));
                    }
                } else {
                    for (GitTag.TagContainer container : list) {
                        this.allTags.put(container.name, this.getClassFactory().createTag(container));
                    }
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block8;
                throw new GitException(t);
            }
        }
    }

    private void parseTagOutput(String output, List<GitTag.TagContainer> list) {
        for (String line : output.split("\n")) {
            GitTag.TagContainer container;
            boolean first;
            String ref;
            int i;
            if (line.isEmpty() || (i = line.indexOf(32)) <= 0) continue;
            String id = line.substring(0, i);
            String rest = line.substring(i + 1);
            if ((i = rest.indexOf(94)) < 0) {
                ref = rest;
                first = true;
            } else {
                ref = rest.substring(0, i);
                first = false;
            }
            i = ref.lastIndexOf(47);
            String tag = i > 0 ? ref.substring(i + 1) : ref;
            if (first) {
                container = new GitTag.TagContainer();
                list.add(container);
                container.name = tag;
                container.id = id;
                container.ref = ref;
                container.type = GitObjectType.UNKNOWN;
                continue;
            }
            if (list.size() <= 0) continue;
            container = list.get(list.size() - 1);
            assert (container.name.equals(tag));
            container.objectId = id;
            container.type = GitObjectType.COMMIT;
        }
    }

    private void parseAddError(String error) {
        this.processMessages(error);
    }
}

