/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.spi;

import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javacard.spi.FastProjectKindDetector;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public enum ProjectKind {
    WEB("org.netbeans.modules.javacard.webproject", "org/netbeans/modules/javacard/spi/resources/webproject.png"),
    EXTENDED_APPLET("org.netbeans.modules.javacard.eapproject", "org/netbeans/modules/javacard/spi/resources/eapproject.png"),
    CLASSIC_APPLET("org.netbeans.modules.javacard.capproject", "org/netbeans/modules/javacard/spi/resources/capproject.png"),
    EXTENSION_LIBRARY("org.netbeans.modules.javacard.extlibproject", "org/netbeans/modules/javacard/spi/resources/extlibproject.png"),
    CLASSIC_LIBRARY("org.netbeans.modules.javacard.clslibproject", "org/netbeans/modules/javacard/spi/resources/clslibproject.png");

    public static final String FO_ATTR_PROJECT_TYPE = "projectType";
    private final String id;
    private final String iconPath;

    private ProjectKind(String id, String iconPath) {
        this.id = id;
        this.iconPath = iconPath;
    }

    public Image icon() {
        return ImageUtilities.loadImage((String)this.iconPath);
    }

    public String iconPath() {
        return this.iconPath;
    }

    public String toString() {
        return this.id;
    }

    public boolean isClassic() {
        return this == CLASSIC_APPLET || this == CLASSIC_LIBRARY;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ProjectKind.class, (String)this.name());
    }

    public String prototypeProjectName() {
        switch (this) {
            case WEB: {
                return "WebApplication";
            }
            case EXTENDED_APPLET: {
                return "ExtendedApplet";
            }
            case CLASSIC_APPLET: {
                return "ClassicApplet";
            }
            case EXTENSION_LIBRARY: {
                return "ExtensionLibrary";
            }
            case CLASSIC_LIBRARY: {
                return "ClassicLibrary";
            }
        }
        throw new AssertionError();
    }

    public boolean isApplication() {
        switch (this) {
            case WEB: 
            case EXTENDED_APPLET: 
            case CLASSIC_APPLET: {
                return true;
            }
            case EXTENSION_LIBRARY: 
            case CLASSIC_LIBRARY: {
                return false;
            }
        }
        throw new AssertionError();
    }

    public boolean isApplet() {
        switch (this) {
            case EXTENDED_APPLET: 
            case CLASSIC_APPLET: {
                return true;
            }
            case WEB: 
            case EXTENSION_LIBRARY: 
            case CLASSIC_LIBRARY: {
                return false;
            }
        }
        throw new AssertionError();
    }

    public boolean isLibrary() {
        return !this.isApplet() && this != WEB;
    }

    public String getLookupMergerPath() {
        return this.projectLayerPath() + "/Lookup";
    }

    private String projectLayerPath() {
        String val = "Projects/";
        switch (this) {
            case WEB: {
                return val + "org-netbeans-modules-javacard-webproject";
            }
            case CLASSIC_APPLET: {
                return val + "org-netbeans-modules-javacard-capproject";
            }
            case EXTENDED_APPLET: {
                return val + "org-netbeans-modules-javacard-eapproject";
            }
            case CLASSIC_LIBRARY: {
                return val + "org-netbeans-modules-javacard-clslibproject";
            }
            case EXTENSION_LIBRARY: {
                return val + "org-netbeans-modules-javacard-extlibproject";
            }
        }
        throw new AssertionError();
    }

    public String nodeFactoryPath() {
        return this.projectLayerPath() + "/Nodes";
    }

    public String importantFilesPath() {
        return this.projectLayerPath() + "/ImportantFiles";
    }

    public String customizerPath() {
        return this.projectLayerPath() + "/Customizer";
    }

    public static ProjectKind kindForTemplate(FileObject template) {
        String attr = (String)template.getAttribute(FO_ATTR_PROJECT_TYPE);
        ProjectKind result = ProjectKind.valueOf(attr);
        if (result == null) {
            throw new IllegalArgumentException("Unknown template type " + template.getPath());
        }
        return result;
    }

    public static ProjectKind forName(String type) {
        for (ProjectKind kind : ProjectKind.values()) {
            if (!kind.toString().equals(type)) continue;
            return kind;
        }
        return null;
    }

    public static ProjectKind kindForProject(FileObject projectXml) {
        try {
            if (projectXml != null) {
                BufferedInputStream in = new BufferedInputStream(projectXml.getInputStream());
                return ProjectKind.fastKindForProject(in);
            }
        }
        catch (IOException ioe) {
            Logger.getLogger(ProjectKind.class.getName()).log(Level.INFO, "Error parsing project.xml " + projectXml.getPath(), ioe);
        }
        return null;
    }

    public static ProjectKind kindForProject(AntProjectHelper helper) {
        FileObject projectXml = helper.getProjectDirectory().getFileObject("nbproject/project.xml");
        return ProjectKind.kindForProject(projectXml);
    }

    public static ProjectKind fastKindForProject(InputStream in) throws IOException {
        try {
            InputSource src = new InputSource(in);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(new FastProjectKindDetector());
            reader.parse(src);
        }
        catch (SAXException e) {
            if (e instanceof FastProjectKindDetector.FoundProjectTypeException) {
                ProjectKind reader = ProjectKind.forName(e.getMessage());
                return reader;
            }
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            in.close();
        }
        return null;
    }

    public static ProjectKind forManifestType(String manifestType) {
        for (ProjectKind k : ProjectKind.values()) {
            if (!manifestType.equals(k.getManifestApplicationType())) continue;
            return k;
        }
        return null;
    }

    public String getManifestApplicationType() {
        switch (this) {
            case WEB: {
                return "web";
            }
            case EXTENDED_APPLET: {
                return "extended-applet";
            }
            case CLASSIC_APPLET: {
                return "classic-applet";
            }
            case EXTENSION_LIBRARY: {
                return "extension-lib";
            }
            case CLASSIC_LIBRARY: {
                return "classic-lib";
            }
        }
        throw new AssertionError();
    }

    public static Set<ProjectKind> kindsFor(String s, boolean returnAllIfEmpty) {
        if (s == null || "".equals(s.trim())) {
            return returnAllIfEmpty ? new HashSet<ProjectKind>(Arrays.asList(ProjectKind.values())) : Collections.emptySet();
        }
        String[] els = s.split(",");
        HashSet<ProjectKind> result = new HashSet<ProjectKind>(5);
        boolean noMatch = true;
        for (String el : els) {
            el = el.trim();
            for (ProjectKind k : ProjectKind.values()) {
                if (!k.getManifestApplicationType().equals(el)) continue;
                result.add(k);
                noMatch = false;
            }
            if (noMatch) {
                Logger.getLogger(ProjectKind.class.getName()).log(Level.WARNING, "Unrecognized project kind '" + el + "' in '" + s + "'", new Exception());
            }
            noMatch = true;
        }
        return result;
    }

    public String getBundleFileExtension() {
        switch (this) {
            case WEB: {
                return "war";
            }
            case EXTENSION_LIBRARY: {
                return "jar";
            }
            case EXTENDED_APPLET: {
                return "eap";
            }
            case CLASSIC_APPLET: 
            case CLASSIC_LIBRARY: {
                return "cap";
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectKind forJarFile(File jarFile) throws IOException {
        JarFile jf = new JarFile(jarFile);
        try {
            Manifest m = jf.getManifest();
            String appType = m.getMainAttributes().getValue("Application-Type");
            Logger log = Logger.getLogger(ProjectKind.class.getName());
            ProjectKind result = null;
            if (appType == null) {
                log.log(Level.FINER, "Could not detect JAR type from manifest attributes: {0}.  Scanning contents", jarFile);
                for (JarEntry je : NbCollections.iterable(jf.entries())) {
                    String name = je.getName();
                    if (!name.endsWith("javacard/ConstantPool.cap")) continue;
                    result = CLASSIC_LIBRARY;
                    log.log(Level.FINEST, "Detected as classic library due to {0}: {1}", new Object[]{name, jarFile});
                    break;
                }
            }
            result = result == null ? (appType == null ? null : ProjectKind.forManifestType(appType)) : result;
            log.log(Level.FINE, "Detected jar type {0} for {1}", new Object[]{result, jarFile});
            ProjectKind projectKind = result;
            return projectKind;
        }
        finally {
            jf.close();
        }
    }
}

