/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;

public abstract class WSCompletionItem
implements CompletionItem {
    private static final String COLOR_END = "</font>";
    private static final String STRIKE = "<s>";
    private static final String STRIKE_END = "</s>";
    int substitutionOffset;

    public static final WSCompletionItem createWsdlFileItem(FileObject wsdlFolder, FileObject wsdlFile, int substitutionOffset) {
        String wsdlPath = FileUtil.getRelativePath((FileObject)wsdlFolder.getParent().getParent(), (FileObject)wsdlFile);
        if (wsdlPath.startsWith("conf/")) {
            wsdlPath = "META-INF/" + wsdlPath.substring(5);
        }
        String displayPath = FileUtil.getRelativePath((FileObject)wsdlFolder, (FileObject)wsdlFile);
        return new WsdlFileItem(wsdlPath, displayPath, substitutionOffset);
    }

    public static final WSCompletionItem createEnumItem(String itemName, String itemType, int substitutionOffset) {
        return new EnumItem(itemName, itemType, substitutionOffset);
    }

    public WSCompletionItem(int substitutionOffset) {
        this.substitutionOffset = substitutionOffset;
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int caretOffset = component.getSelectionEnd();
            this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, null);
        }
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        return false;
    }

    public int getSortPriority() {
        return 100;
    }

    public abstract CharSequence getSortText();

    public abstract CharSequence getInsertPrefix();

    protected abstract String getLeftHtmlText();

    protected String getRightHtmlText() {
        return null;
    }

    protected ImageIcon getIcon() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void substituteText(JTextComponent c, int offset, int len, String toAdd) {
        BaseDocument doc = (BaseDocument)c.getDocument();
        String text = this.getInsertPrefix().toString();
        if (text != null) {
            doc.atomicLock();
            try {
                String textToReplace = doc.getText(offset, len);
                if (text.equals(textToReplace)) {
                    return;
                }
                Position position = doc.createPosition(offset);
                doc.remove(offset, len);
                doc.insertString(position.getOffset(), text, null);
            }
            catch (BadLocationException e) {
            }
            finally {
                doc.atomicUnlock();
            }
        }
    }

    private static class EnumItem
    extends WSCompletionItem {
        private static final String ENUM_ICON = "org/netbeans/modules/websvc/editor/completion/resources/field_static_16.png";
        private static final String COLOR = "<font color=#0000b2>";
        private String leftText;
        private String itemName;
        private String itemType;
        private ImageIcon icon;

        private EnumItem(String itemName, String itemType, int substitutionOffset) {
            super(substitutionOffset);
            this.itemName = itemName;
            this.itemType = itemType;
        }

        @Override
        protected ImageIcon getIcon() {
            if (this.icon == null) {
                this.icon = ImageUtilities.loadImageIcon((String)ENUM_ICON, (boolean)false);
            }
            return this.icon;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(COLOR);
                sb.append(this.itemName);
                sb.append(WSCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        @Override
        protected String getRightHtmlText() {
            return this.itemType;
        }

        @Override
        public CharSequence getSortText() {
            return this.itemName;
        }

        @Override
        public CharSequence getInsertPrefix() {
            return this.itemName;
        }

        @Override
        public int getSortPriority() {
            return 10;
        }
    }

    private static class WsdlFileItem
    extends WSCompletionItem {
        private static final String FILE_ICON = "org/netbeans/modules/websvc/editor/completion/resources/fileProtocol.gif";
        private static final String COLOR = "<font color=#005600>";
        private String leftText;
        String wsdlPath;
        String displayPath;
        private static ImageIcon icon;

        private WsdlFileItem(String wsdlPath, String displayPath, int substitutionOffset) {
            super(substitutionOffset);
            this.wsdlPath = wsdlPath;
            this.displayPath = displayPath;
        }

        @Override
        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)FILE_ICON, (boolean)false);
            }
            return icon;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(COLOR);
                sb.append(this.displayPath);
                sb.append(WSCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        @Override
        public CharSequence getSortText() {
            return this.displayPath;
        }

        @Override
        public CharSequence getInsertPrefix() {
            return this.wsdlPath;
        }
    }
}

