/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.content.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.FileMacrosKey;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.DefaultCache;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.openide.util.CharSequences;

public class FileComponentMacros
extends FileComponent {
    private final TreeMap<NameSortedKey, CsmUID<CsmMacro>> macros;
    private final ReadWriteLock macrosLock = new ReentrantReadWriteLock();
    private static final FileComponentMacros EMPTY = new FileComponentMacros(){

        @Override
        public void appendFrom(FileComponentMacros other) {
        }

        @Override
        public void addMacro(CsmMacro macro) {
        }

        @Override
        void put() {
        }
    };

    public static FileComponentMacros empty() {
        return EMPTY;
    }

    FileComponentMacros(FileComponentMacros other, boolean empty) {
        super(other);
        this.macros = this.createMacros(empty ? null : other.macros);
    }

    public FileComponentMacros(FileImpl file) {
        super(new FileMacrosKey(file));
        this.macros = this.createMacros(null);
    }

    public FileComponentMacros(RepositoryDataInput input) throws IOException {
        super(input);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        this.macros = factory.readNameSortedToUIDMap(input, DefaultCache.getManager());
    }

    private FileComponentMacros() {
        super((Key)null);
        this.macros = this.createMacros(null);
    }

    void clean() {
        this._clearMacros();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearMacros() {
        ArrayList<CsmUID<CsmMacro>> copy;
        try {
            this.macrosLock.writeLock().lock();
            copy = new ArrayList<CsmUID<CsmMacro>>(this.macros.values());
            this.macros.clear();
        }
        finally {
            this.macrosLock.writeLock().unlock();
        }
        RepositoryUtils.remove(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacro(CsmMacro macro) {
        CsmUID<CsmMacro> macroUID = RepositoryUtils.put(macro);
        NameSortedKey key = new NameSortedKey(macro);
        assert (macroUID != null);
        try {
            this.macrosLock.writeLock().lock();
            this.macros.put(key, macroUID);
        }
        finally {
            this.macrosLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmMacro> getMacros() {
        Collection<CsmMacro> out;
        try {
            this.macrosLock.readLock().lock();
            out = UIDCsmConverter.UIDsToMacros(this.macros.values());
        }
        finally {
            this.macrosLock.readLock().unlock();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmMacro> getMacros(CsmSelect.CsmFilter filter) {
        Iterator<CsmMacro> out;
        try {
            this.macrosLock.readLock().lock();
            out = UIDCsmConverter.UIDsToMacros(this.macros.values(), filter);
        }
        finally {
            this.macrosLock.readLock().unlock();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmMacro>> findMacroUids(CharSequence name) {
        ArrayList<CsmUID<CsmMacro>> uids = new ArrayList<CsmUID<CsmMacro>>(2);
        NameSortedKey from = NameSortedKey.getStartKey(name);
        NameSortedKey to = NameSortedKey.getEndKey(name);
        try {
            this.macrosLock.readLock().lock();
            for (Map.Entry<NameSortedKey, CsmUID<CsmMacro>> entry : this.macros.subMap(from, to).entrySet()) {
                uids.add(entry.getValue());
            }
        }
        finally {
            this.macrosLock.readLock().unlock();
        }
        return uids;
    }

    private TreeMap<NameSortedKey, CsmUID<CsmMacro>> createMacros(TreeMap<NameSortedKey, CsmUID<CsmMacro>> other) {
        if (other != null) {
            return new TreeMap<NameSortedKey, CsmUID<CsmMacro>>((SortedMap<NameSortedKey, CsmUID<CsmMacro>>)other);
        }
        return new TreeMap<NameSortedKey, CsmUID<CsmMacro>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        try {
            this.macrosLock.readLock().lock();
            factory.writeNameSortedToUIDMap(this.macros, output, false);
        }
        finally {
            this.macrosLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendFrom(FileComponentMacros other) {
        try {
            this.macrosLock.writeLock().lock();
            this.macros.putAll(other.macros);
        }
        finally {
            this.macrosLock.writeLock().unlock();
        }
    }

    public static final class NameSortedKey
    implements Comparable<NameSortedKey>,
    Persistent,
    SelfPersistent {
        private int start = 0;
        private CharSequence name;

        private NameSortedKey(CsmMacro macro) {
            this(macro.getName(), macro.getStartOffset());
        }

        private NameSortedKey(CharSequence name, int start) {
            this.start = start;
            this.name = NameCache.getManager().getString(name);
        }

        @Override
        public int compareTo(NameSortedKey o) {
            int res = CharSequences.comparator().compare(this.name, o.name);
            if (res == 0) {
                res = this.start - o.start;
            }
            return res;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NameSortedKey) {
                NameSortedKey key = (NameSortedKey)obj;
                return this.compareTo(key) == 0;
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + this.start;
            hash = 37 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return "NameSortedKey: " + this.name + "[" + this.start;
        }

        public static NameSortedKey getStartKey(CharSequence name) {
            return new NameSortedKey(name, 0);
        }

        public static NameSortedKey getEndKey(CharSequence name) {
            return new NameSortedKey(name, Integer.MAX_VALUE);
        }

        public void write(RepositoryDataOutput output) throws IOException {
            output.writeInt(this.start);
            PersistentUtils.writeUTF(this.name, output);
        }

        public NameSortedKey(RepositoryDataInput input) throws IOException {
            this.start = input.readInt();
            this.name = PersistentUtils.readUTF(input, NameCache.getManager());
        }
    }
}

