/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.content.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmValidable;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.modelimpl.cache.impl.WeakContainer;
import org.netbeans.modules.cnd.modelimpl.content.file.FakeIncludePair;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponent;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponentDeclarations;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponentIncludes;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponentInstantiations;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponentMacros;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponentReferences;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.IncludeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.ErrorDirectiveImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.spi.CsmParserProvider;
import org.netbeans.modules.cnd.modelimpl.repository.FileDeclarationsKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileIncludesKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileInstantiationsKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileMacrosKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileReferencesKey;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Pair;
import org.openide.util.Union2;

public final class FileContent
implements MutableDeclarationsContainer {
    private final FileImpl fileImpl;
    private final boolean persistent;
    private final List<FakeIncludePair> fakeIncludeRegistrations;
    private final List<CsmUID<FunctionImplEx<?>>> fakeFunctionRegistrations;
    private int parserErrorsCount;
    private final Set<ErrorDirectiveImpl> errors;
    private final Union2<FileComponentDeclarations, WeakContainer<FileComponentDeclarations>> fileComponentDeclarations;
    private final Union2<FileComponentMacros, WeakContainer<FileComponentMacros>> fileComponentMacros;
    private final Union2<FileComponentIncludes, WeakContainer<FileComponentIncludes>> fileComponentIncludes;
    private final AtomicBoolean hasBrokenIncludes;
    private final Union2<FileComponentInstantiations, WeakContainer<FileComponentInstantiations>> fileComponentInstantiations;
    private final Union2<FileComponentReferences, WeakContainer<FileComponentReferences>> fileComponentReferences;
    private final Collection<CsmParserProvider.ParserError> parserErrors;
    private final Set<FileContent> includedFileContents = new HashSet<FileContent>(0);
    private final Map<CsmUID<FunctionImplEx<?>>, Pair<AST, MutableDeclarationsContainer>> fakeFuncData = new HashMap();
    private static final boolean TRACE = false;

    public static FileContent createFileContent(FileImpl fileImpl, CsmValidable owner) {
        return new FileContent(fileImpl, owner, true, new FileComponentDeclarations(fileImpl), new FileComponentMacros(fileImpl), new FileComponentIncludes(fileImpl), false, new FileComponentInstantiations(fileImpl), new FileComponentReferences(fileImpl), FileContent.createFakeIncludes(Collections.emptyList()), FileContent.createFakeFunctions(Collections.emptyList()), FileContent.createErrors(Collections.emptySet()), 0, FileContent.createParserErrors(Collections.emptyList()));
    }

    private FileContent(FileImpl fileImpl, CsmValidable owner, boolean persistent, FileComponentDeclarations fcd, FileComponentMacros fcm, FileComponentIncludes fcinc, boolean hasBrokenIncludes, FileComponentInstantiations fcinst, FileComponentReferences fcr, List<FakeIncludePair> fakeIncludeRegistrations, List<CsmUID<FunctionImplEx<?>>> fakeFunctionRegistrations, Set<ErrorDirectiveImpl> errors, int parserErrorsCount, Collection<CsmParserProvider.ParserError> parserErrors) {
        this.persistent = persistent;
        this.fileImpl = fileImpl;
        this.fileComponentDeclarations = this.asUnion(owner, fcd, persistent);
        this.fileComponentMacros = this.asUnion(owner, fcm, persistent);
        this.fileComponentIncludes = this.asUnion(owner, fcinc, persistent);
        this.hasBrokenIncludes = new AtomicBoolean(hasBrokenIncludes);
        this.fileComponentInstantiations = this.asUnion(owner, fcinst, persistent);
        this.fileComponentReferences = this.asUnion(owner, fcr, persistent);
        this.fakeIncludeRegistrations = fakeIncludeRegistrations;
        this.fakeFunctionRegistrations = fakeFunctionRegistrations;
        this.errors = errors;
        this.parserErrorsCount = parserErrorsCount;
        this.parserErrors = parserErrors;
        if (persistent) {
            fcd.put();
            fcm.put();
            fcinc.put();
            fcinst.put();
            fcr.put();
        }
        this.checkValid();
    }

    public Collection<CsmScopeElement> getScopeElements() {
        ArrayList<CsmScopeElement> l = new ArrayList<CsmScopeElement>();
        l.addAll(this.getFileDeclarations().getStaticVariableDeclarations());
        l.addAll(this.getFileDeclarations().getStaticFunctionDeclarations());
        return l;
    }

    public static FileContent getHardReferenceBasedCopy(FileContent other, boolean emptyContent) {
        other.checkValid();
        return new FileContent(other.fileImpl, (CsmValidable)other.fileImpl, false, new FileComponentDeclarations(other.getFileDeclarations(), emptyContent), new FileComponentMacros(other.getFileMacros(), emptyContent), new FileComponentIncludes(other.getFileIncludes(), emptyContent), emptyContent ? false : other.hasBrokenIncludes(), new FileComponentInstantiations(other.getFileInstantiations(), emptyContent), new FileComponentReferences(other.getFileReferences(), emptyContent), FileContent.createFakeIncludes(emptyContent || other.fakeIncludeRegistrations.isEmpty() ? Collections.emptyList() : other.fakeIncludeRegistrations), FileContent.createFakeFunctions(emptyContent || other.fakeFunctionRegistrations.isEmpty() ? Collections.emptyList() : other.fakeFunctionRegistrations), FileContent.createErrors(emptyContent || other.errors.isEmpty() ? Collections.emptySet() : other.errors), emptyContent ? 0 : other.parserErrorsCount, FileContent.createParserErrors(emptyContent || other.parserErrors.isEmpty() ? Collections.emptyList() : other.parserErrors));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileContent toWeakReferenceBasedCopy() {
        this.checkValid();
        try {
            FileContent fileContent = new FileContent(this.fileImpl, (CsmValidable)this.fileImpl, true, this.getFileDeclarations(), this.getFileMacros(), this.getFileIncludes(), this.hasBrokenIncludes(), this.getFileInstantiations(), this.getFileReferences(), this.fakeIncludeRegistrations, this.fakeFunctionRegistrations, this.errors, this.parserErrorsCount, this.parserErrors);
            return fileContent;
        }
        finally {
            this.parserErrorsCount = -1;
        }
    }

    public final int getErrorCount() {
        this.checkValid();
        return this.parserErrorsCount;
    }

    public void setErrorCount(int errorCount) {
        this.checkValid();
        this.parserErrorsCount = errorCount;
        this.checkValid();
    }

    public final void onFakeRegisration(FunctionImplEx<?> decl, Pair<AST, MutableDeclarationsContainer> data) {
        CsmUID<FunctionImplEx<?>> aUid;
        this.checkValid();
        CsmUID<FunctionImplEx<?>> uidDecl = aUid = UIDCsmConverter.declarationToUID(decl);
        this.fakeFunctionRegistrations.add(uidDecl);
        this.trackFakeFunctionData(uidDecl, data);
    }

    public final boolean onFakeIncludeRegistration(IncludeImpl include, CsmOffsetableDeclaration container) {
        this.checkValid();
        if (include != null && container != null) {
            CsmUID includeUid = UIDCsmConverter.identifiableToUID(include);
            CsmUID<CsmOffsetableDeclaration> containerUID = UIDCsmConverter.declarationToUID(container);
            if (includeUid != null && containerUID != null) {
                for (FakeIncludePair fakeIncludePair : this.fakeIncludeRegistrations) {
                    if (!fakeIncludePair.includeUid.equals(includeUid)) continue;
                    if (!fakeIncludePair.containerUid.equals(containerUID)) {
                        CndUtils.assertTrueInConsole((boolean)false, (String)("trying to replace? " + include + " for container " + container + " was: " + fakeIncludePair));
                    }
                    return false;
                }
                this.fakeIncludeRegistrations.add(new FakeIncludePair(includeUid, containerUID));
                return true;
            }
        }
        return false;
    }

    public List<CsmUID<FunctionImplEx<?>>> getFakeFunctionRegistrations() {
        this.checkValid();
        return this.fakeFunctionRegistrations;
    }

    public List<FakeIncludePair> getFakeIncludeRegistrations() {
        this.checkValid();
        return this.fakeIncludeRegistrations;
    }

    public final void addIncludedFileContent(FileContent includedFileContent) {
        assert (TraceFlags.PARSE_HEADERS_WITH_SOURCES);
        boolean added = this.includedFileContents.add(includedFileContent);
        this.traceAddRemove(added ? "+FILE" : "SKIP", includedFileContent.fileImpl.getAbsolutePath());
    }

    public Set<FileContent> getIncludedFileContents() {
        return Collections.unmodifiableSet(this.includedFileContents);
    }

    public void addError(ErrorDirectiveImpl error) {
        this.checkValid();
        this.traceAddRemove("ERROR", error);
        this.errors.add(error);
    }

    public void addParsingError(CsmParserProvider.ParserError error) {
        this.parserErrors.add(error);
    }

    public void addMacro(CsmMacro macro) {
        this.checkValid();
        this.traceAddRemove("MACRO", macro);
        FileComponentMacros fileMacros = this.getFileMacros();
        fileMacros.addMacro(macro);
        if (this.persistent) {
            fileMacros.put();
        }
    }

    @Override
    public void addDeclaration(CsmOffsetableDeclaration decl) {
        this.checkValid();
        this.traceAddRemove("DECL", decl);
        FileComponentDeclarations fileDeclarations = this.getFileDeclarations();
        fileDeclarations.addDeclaration(decl);
        if (this.persistent) {
            fileDeclarations.put();
        }
    }

    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int startOffset, int endOffset, CharSequence name) {
        this.checkValid();
        return this.getFileDeclarations().findExistingDeclaration(startOffset, endOffset, name);
    }

    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int startOffset, CharSequence name, CsmDeclaration.Kind kind) {
        this.checkValid();
        return this.getFileDeclarations().findExistingDeclaration(startOffset, name, kind);
    }

    public Collection<CsmInclude> getIncludes() {
        this.checkValid();
        return this.getFileIncludes().getIncludes();
    }

    public void addInclude(IncludeImpl includeImpl, boolean broken) {
        this.checkValid();
        this.traceAddRemove("INCL", includeImpl);
        FileComponentIncludes fileIncludes = this.getFileIncludes();
        this.hasBrokenIncludes.set(fileIncludes.addInclude(includeImpl, broken));
        if (this.persistent) {
            fileIncludes.put();
        }
    }

    public void addInstantiation(CsmInstantiation inst) {
        this.checkValid();
        this.traceAddRemove("INST", inst);
        FileComponentInstantiations fileInstantiations = this.getFileInstantiations();
        fileInstantiations.addInstantiation(inst);
        if (this.persistent) {
            fileInstantiations.put();
        }
    }

    public boolean addReference(CsmReference ref, CsmObject referencedObject) {
        this.checkValid();
        this.traceAddRemove("REF", ref);
        FileComponentReferences fileReferences = this.getFileReferences();
        boolean out = fileReferences.addReference(ref, referencedObject);
        if (this.persistent) {
            fileReferences.put();
        }
        return out;
    }

    public boolean addResolvedReference(CsmReference ref, CsmObject referencedObject) {
        this.checkValid();
        this.traceAddRemove("RREF", ref);
        FileComponentReferences fileReferences = this.getFileReferences();
        boolean out = fileReferences.addResolvedReference(ref, referencedObject);
        if (this.persistent) {
            fileReferences.put();
        }
        return out;
    }

    public String toString() {
        return (this.parserErrorsCount < 0 ? "INVALID " : "") + (this.persistent ? "PERSISTENT " : "") + "File Content for " + this.fileImpl;
    }

    private static List<CsmUID<FunctionImplEx<?>>> createFakeFunctions(List<CsmUID<FunctionImplEx<?>>> in) {
        return new CopyOnWriteArrayList(in);
    }

    private static List<FakeIncludePair> createFakeIncludes(List<FakeIncludePair> in) {
        return new CopyOnWriteArrayList<FakeIncludePair>(in);
    }

    private static Set<ErrorDirectiveImpl> createErrors(Set<ErrorDirectiveImpl> in) {
        TreeSet<CsmOffsetable> out = new TreeSet<CsmOffsetable>(FileImpl.START_OFFSET_COMPARATOR);
        out.addAll(in);
        return out;
    }

    private static Collection<CsmParserProvider.ParserError> createParserErrors(Collection<CsmParserProvider.ParserError> in) {
        ArrayList<CsmParserProvider.ParserError> out = new ArrayList<CsmParserProvider.ParserError>();
        out.addAll(in);
        return out;
    }

    public FileComponentDeclarations getFileDeclarations() {
        this.checkValid();
        return this.getFileComponent(this.fileComponentDeclarations);
    }

    public Set<? extends CsmErrorDirective> getErrors() {
        this.checkValid();
        return Collections.unmodifiableSet(this.errors);
    }

    public Collection<CsmParserProvider.ParserError> getParserErrors() {
        return Collections.unmodifiableCollection(this.parserErrors);
    }

    public FileComponentMacros getFileMacros() {
        this.checkValid();
        return this.getFileComponent(this.fileComponentMacros);
    }

    public FileComponentIncludes getFileIncludes() {
        this.checkValid();
        return this.getFileComponent(this.fileComponentIncludes);
    }

    public boolean hasBrokenIncludes() {
        this.checkValid();
        return this.hasBrokenIncludes.get();
    }

    public FileComponentReferences getFileReferences() {
        this.checkValid();
        return this.getFileComponent(this.fileComponentReferences);
    }

    public FileComponentInstantiations getFileInstantiations() {
        this.checkValid();
        return this.getFileComponent(this.fileComponentInstantiations);
    }

    private <T extends FileComponent> T getFileComponent(Union2<T, WeakContainer<T>> ref) {
        if (ref.hasFirst()) {
            assert (!this.persistent) : "non persistent must have hard reference";
            return (T)((FileComponent)ref.first());
        }
        assert (this.persistent) : "persistent must have weak reference";
        return (T)((FileComponent)((WeakContainer)ref.second()).getContainer());
    }

    private <T extends FileComponent> Key getFileComponentKey(Union2<T, WeakContainer<T>> ref) {
        if (ref.hasFirst()) {
            assert (!this.persistent) : "non persistent must have hard reference";
            return ((FileComponent)ref.first()).getKey();
        }
        assert (this.persistent) : "persistent must have weak reference";
        return ((WeakContainer)ref.second()).getKey();
    }

    private void trackFakeFunctionData(CsmUID<FunctionImplEx<?>> funUID, Pair<AST, MutableDeclarationsContainer> data) {
        if (data == null) {
            this.fakeFuncData.remove(funUID);
        } else {
            this.fakeFuncData.put(funUID, data);
        }
    }

    public void write(RepositoryDataOutput output) throws IOException {
        this.checkValid();
        assert (this.persistent) : "only persistent content can be put into repository";
        FileDeclarationsKey fileDeclarationsKey = (FileDeclarationsKey)this.getFileComponentKey(this.fileComponentDeclarations);
        assert (fileDeclarationsKey != null) : "file declaratios key can not be null";
        fileDeclarationsKey.write(output);
        FileIncludesKey fileIncludesKey = (FileIncludesKey)this.getFileComponentKey(this.fileComponentIncludes);
        assert (fileIncludesKey != null) : "file includes key can not be null";
        fileIncludesKey.write(output);
        output.writeBoolean(this.hasBrokenIncludes.get());
        FileMacrosKey fileMacrosKey = (FileMacrosKey)this.getFileComponentKey(this.fileComponentMacros);
        assert (fileMacrosKey != null) : "file macros key can not be null";
        fileMacrosKey.write(output);
        ((WeakContainer)this.fileComponentReferences.second()).getKey();
        FileReferencesKey fileReferencesKey = (FileReferencesKey)this.getFileComponentKey(this.fileComponentReferences);
        assert (fileReferencesKey != null) : "file referebces key can not be null";
        fileReferencesKey.write(output);
        FileInstantiationsKey fileInstantiationsKey = (FileInstantiationsKey)this.getFileComponentKey(this.fileComponentInstantiations);
        assert (fileInstantiationsKey != null) : "file instantiation references key can not be null";
        fileInstantiationsKey.write(output);
        PersistentUtils.writeErrorDirectives(this.errors, output);
        output.writeInt(this.parserErrorsCount);
        FakeIncludePair.write(this.fakeIncludeRegistrations, output);
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.fakeFunctionRegistrations, output, false);
    }

    public FileContent(FileImpl file, CsmValidable owner, RepositoryDataInput input) throws IOException {
        this.fileImpl = file;
        this.persistent = true;
        FileDeclarationsKey fileDeclarationsKey = new FileDeclarationsKey(input);
        assert (fileDeclarationsKey != null) : "file declaratios key can not be null";
        this.fileComponentDeclarations = Union2.createSecond(new WeakContainer(owner, fileDeclarationsKey));
        FileIncludesKey fileIncludesKey = new FileIncludesKey(input);
        assert (fileIncludesKey != null) : "file includes key can not be null";
        this.fileComponentIncludes = Union2.createSecond(new WeakContainer(owner, fileIncludesKey));
        this.hasBrokenIncludes = new AtomicBoolean(input.readBoolean());
        FileMacrosKey fileMacrosKey = new FileMacrosKey(input);
        assert (fileMacrosKey != null) : "file macros key can not be null";
        this.fileComponentMacros = Union2.createSecond(new WeakContainer(owner, fileMacrosKey));
        FileReferencesKey fileReferencesKey = new FileReferencesKey(input);
        assert (fileReferencesKey != null) : "file referebces key can not be null";
        this.fileComponentReferences = Union2.createSecond(new WeakContainer(owner, fileReferencesKey));
        FileInstantiationsKey fileInstantiationsKey = new FileInstantiationsKey(input);
        assert (fileInstantiationsKey != null) : "file instantiation references key can not be null";
        this.fileComponentInstantiations = Union2.createSecond(new WeakContainer(owner, fileInstantiationsKey));
        this.errors = FileContent.createErrors(Collections.emptySet());
        PersistentUtils.readErrorDirectives(this.errors, input);
        this.parserErrorsCount = input.readInt();
        this.fakeIncludeRegistrations = FileContent.createFakeIncludes(Collections.emptyList());
        FakeIncludePair.read(this.fakeIncludeRegistrations, input);
        this.fakeFunctionRegistrations = FileContent.createFakeFunctions(Collections.emptyList());
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.fakeFunctionRegistrations, input);
        this.parserErrors = FileContent.createParserErrors(Collections.emptyList());
        this.checkValid();
    }

    private <T extends FileComponent> Union2<T, WeakContainer<T>> asUnion(CsmValidable stateOwner, T fc, boolean persistent) {
        if (persistent) {
            return Union2.createSecond(new WeakContainer(stateOwner, fc.getKey()));
        }
        return Union2.createFirst(fc);
    }

    private void checkValid() {
        assert (this.parserErrorsCount >= 0) : "invalid object for " + this.fileImpl.getAbsolutePath();
    }

    @Override
    public void removeDeclaration(CsmOffsetableDeclaration declaration) {
        FileComponentDeclarations fileDeclarations = this.getFileDeclarations();
        this.traceAddRemove("remove", declaration);
        fileDeclarations.removeDeclaration(declaration);
        if (this.persistent) {
            fileDeclarations.put();
        }
    }

    @Override
    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        return this.getFileDeclarations().getDeclarations();
    }

    public void cleanOther() {
        FileComponentIncludes fileIncludes = this.getFileIncludes();
        fileIncludes.clean();
        FileComponentMacros fileMacros = this.getFileMacros();
        fileMacros.clean();
        FileComponentReferences fileReferences = this.getFileReferences();
        fileReferences.clean();
        FileComponentInstantiations fileInstantiations = this.getFileInstantiations();
        fileInstantiations.clean();
        if (this.persistent) {
            fileIncludes.put();
            fileMacros.put();
            fileReferences.put();
            fileInstantiations.put();
        }
    }

    public Collection<CsmUID<CsmOffsetableDeclaration>> cleanDeclarations() {
        FileComponentDeclarations fileDeclarations = this.getFileDeclarations();
        Collection<CsmUID<CsmOffsetableDeclaration>> uids = fileDeclarations.clean();
        if (this.persistent) {
            fileDeclarations.put();
        }
        return uids;
    }

    public void put() {
        assert (this.persistent);
        this.getFileIncludes().put();
        this.getFileMacros().put();
        this.getFileReferences().put();
        this.getFileInstantiations().put();
        this.getFileDeclarations().put();
    }

    public FileImpl getFile() {
        return this.fileImpl;
    }

    public Map<CsmUID<FunctionImplEx<?>>, Pair<AST, MutableDeclarationsContainer>> getFakeFuncData() {
        return this.fakeFuncData;
    }

    private void traceAddRemove(String mark, Object obj) {
    }
}

