/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.modelimpl.csm.CsmObjectBuilder;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionBase;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public final class VariableDefinitionImpl
extends VariableImpl<CsmVariableDefinition>
implements CsmVariableDefinition,
CsmTemplate {
    private CsmUID<CsmVariable> declarationUID;
    private CharSequence qualifiedName;
    private final CharSequence[] classOrNspNames;
    private final TemplateDescriptor templateDescriptor;

    private VariableDefinitionImpl(AST ast, CsmFile file, CsmType type, NameHolder name, boolean _static, boolean _extern) {
        super(ast, file, type, name, null, _static, _extern);
        this.templateDescriptor = VariableDefinitionImpl.createTemplateDescriptor(ast, file, null, null, true);
        this.classOrNspNames = VariableDefinitionImpl.getClassOrNspNames(ast);
    }

    private VariableDefinitionImpl(CharSequence name, CharSequence[] classOrNspNames, CsmType type, TemplateDescriptor templateDescriptor, boolean _static, boolean _extern, ExpressionBase initExpr, CsmFile file, int startOffset, int endOffset) {
        super(type, name, null, _static, _extern, initExpr, file, startOffset, endOffset);
        this.templateDescriptor = templateDescriptor;
        this.classOrNspNames = classOrNspNames;
    }

    public static VariableDefinitionImpl create(AST ast, CsmFile file, CsmType type, NameHolder name, boolean _static, boolean _extern) {
        VariableDefinitionImpl variableDefinitionImpl = new VariableDefinitionImpl(ast, file, type, name, _static, _extern);
        VariableDefinitionImpl.postObjectCreateRegistration(true, variableDefinitionImpl);
        return variableDefinitionImpl;
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.VARIABLE_DEFINITION;
    }

    public CsmVariable getDeclaration() {
        CsmVariable declaration = this._getDeclaration();
        if (declaration == null) {
            this._setDeclaration(null);
            declaration = this.findDeclaration();
            this._setDeclaration(declaration);
        }
        return declaration;
    }

    private CsmVariable _getDeclaration() {
        return UIDCsmConverter.UIDtoDeclaration(this.declarationUID);
    }

    private void _setDeclaration(CsmVariable decl) {
        this.declarationUID = UIDCsmConverter.declarationToUID(decl);
        assert (this.declarationUID != null || decl == null);
    }

    @Override
    public CharSequence getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = QualifiedNameCache.getManager().getString(this.findQualifiedName());
        }
        return this.qualifiedName;
    }

    @Override
    protected boolean registerInProject() {
        CharSequence prevFQN = this.qualifiedName;
        boolean out = super.registerInProject();
        return out;
    }

    @Override
    protected boolean unregisterInProject() {
        return super.unregisterInProject();
    }

    private CharSequence findQualifiedName() {
        CsmVariable declaration = this._getDeclaration();
        if (declaration != null) {
            return declaration.getQualifiedName();
        }
        CsmObject owner = this.findOwner();
        if (owner instanceof CsmQualifiedNamedElement) {
            return CharSequenceUtils.concatenate((CharSequence)((CsmQualifiedNamedElement)owner).getQualifiedName(), (CharSequence)"::", (CharSequence)this.getQualifiedNamePostfix());
        }
        CharSequence[] cnn = this.classOrNspNames;
        CsmNamespaceDefinition nsd = this.findNamespaceDefinition();
        StringBuilder sb = new StringBuilder();
        if (nsd != null) {
            sb.append(nsd.getQualifiedName());
        }
        if (cnn != null) {
            for (int i = 0; i < cnn.length; ++i) {
                if (sb.length() > 0) {
                    sb.append("::");
                }
                sb.append(cnn[i]);
            }
        }
        if (sb.length() == 0) {
            sb.append("unknown>");
        }
        sb.append("::");
        sb.append(this.getQualifiedNamePostfix());
        return sb;
    }

    private CsmNamespaceDefinition findNamespaceDefinition() {
        CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION});
        return this.findNamespaceDefinition(CsmSelect.getDeclarations((CsmFile)this.getContainingFile(), (CsmSelect.CsmFilter)filter), filter);
    }

    private CsmNamespaceDefinition findNamespaceDefinition(Iterator<CsmOffsetableDeclaration> it, CsmSelect.CsmFilter filter) {
        CsmOffsetableDeclaration decl;
        while (it.hasNext() && (decl = it.next()).getStartOffset() <= this.getStartOffset()) {
            if (decl.getKind() != CsmDeclaration.Kind.NAMESPACE_DEFINITION || this.getEndOffset() >= decl.getEndOffset()) continue;
            CsmNamespaceDefinition nsdef = (CsmNamespaceDefinition)decl;
            CsmNamespaceDefinition inner = this.findNamespaceDefinition(CsmSelect.getDeclarations((CsmNamespaceDefinition)nsdef, (CsmSelect.CsmFilter)filter), filter);
            return inner == null ? nsdef : inner;
        }
        return null;
    }

    private CsmVariable findDeclaration() {
        if (!this.isValid()) {
            return null;
        }
        String uname = CharSequenceUtils.toString((CharSequence)CsmDeclaration.Kind.VARIABLE.toString(), (char)':', (CharSequence)this.getQualifiedName());
        CsmDeclaration def = this.getContainingFile().getProject().findDeclaration((CharSequence)uname);
        if (def == null) {
            CsmObject owner = this.findOwner();
            if (owner instanceof CsmClass) {
                CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createNameFilter(this.getName(), true, true, false);
                def = this.findByName(CsmSelect.getClassMembers((CsmClass)((CsmClass)owner), (CsmSelect.CsmFilter)filter), this.getName());
            } else if (owner instanceof CsmNamespace) {
                CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createCompoundFilter(CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE}), CsmSelect.getFilterBuilder().createNameFilter(this.getName(), true, true, false));
                Iterator it = CsmSelect.getDeclarations((CsmNamespace)((CsmNamespace)owner), (CsmSelect.CsmFilter)filter);
                while (it.hasNext()) {
                    def = (CsmDeclaration)it.next();
                }
            }
        }
        return (CsmVariable)def;
    }

    private CsmVariable findByName(Iterator<CsmMember> it, CharSequence name) {
        while (it.hasNext()) {
            CsmMember decl = it.next();
            if (!decl.getName().equals(name) || !(decl instanceof CsmVariable)) continue;
            return (CsmVariable)decl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmObject findOwner() {
        CharSequence[] cnn = this.classOrNspNames;
        if (cnn != null && cnn.length > 0) {
            CsmObject obj = null;
            Resolver resolver = ResolverFactory.createResolver(this);
            try {
                obj = resolver.resolve(cnn, 3);
            }
            finally {
                ResolverFactory.releaseResolver(resolver);
            }
            if (obj instanceof CsmClass) {
                return (CsmClass)obj;
            }
            if (obj instanceof CsmNamespace) {
                return (CsmNamespace)obj;
            }
        }
        return null;
    }

    private static CharSequence[] getClassOrNspNames(AST ast) {
        AST qid = VariableDefinitionImpl.getQialifiedId(ast);
        if (qid == null) {
            return null;
        }
        int cnt = qid.getNumberOfChildren();
        if (cnt >= 1) {
            ArrayList<CharSequence> l = new ArrayList<CharSequence>();
            for (AST token = qid.getFirstChild(); token != null; token = token.getNextSibling()) {
                if (token.getType() != 91 || token.getNextSibling() == null) continue;
                CharSequence name = AstUtil.getText(token);
                l.add(NameCache.getManager().getString(name));
            }
            return l.toArray(new CharSequence[l.size()]);
        }
        return null;
    }

    private static AST getQialifiedId(AST ast) {
        AST varAst = ast;
        for (AST token = varAst.getFirstChild(); token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 596: 
                case 597: {
                    return token.getFirstChild();
                }
                case 91: 
                case 563: {
                    return token;
                }
            }
        }
        return null;
    }

    public CharSequence getDisplayName() {
        return this.templateDescriptor != null ? CharSequences.create((CharSequence)CharSequenceUtils.concatenate((CharSequence)this.getName(), (CharSequence)this.templateDescriptor.getTemplateSuffix())) : this.getName();
    }

    public boolean isTemplate() {
        return this.templateDescriptor != null;
    }

    public boolean isSpecialization() {
        return false;
    }

    public boolean isExplicitSpecialization() {
        return false;
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateDescriptor != null ? this.templateDescriptor.getTemplateParameters() : Collections.emptyList();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeUTF(this.qualifiedName, output);
        PersistentUtils.writeStrings(this.classOrNspNames, output);
        PersistentUtils.writeTemplateDescriptor(this.templateDescriptor, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.declarationUID, output);
    }

    public VariableDefinitionImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.qualifiedName = PersistentUtils.readUTF(input, QualifiedNameCache.getManager());
        this.classOrNspNames = PersistentUtils.readStrings(input, NameCache.getManager());
        this.templateDescriptor = PersistentUtils.readTemplateDescriptor(input);
        this.declarationUID = UIDObjectFactory.getDefaultFactory().readUID(input);
    }

    public static class VariableDefinitionBuilder
    extends VariableImpl.VariableBuilder
    implements CsmObjectBuilder {
        public VariableDefinitionBuilder(OffsetableDeclarationBase.SimpleDeclarationBuilder builder) {
            super(builder);
        }

        @Override
        public VariableDefinitionImpl create() {
            VariableDefinitionImpl var = new VariableDefinitionImpl(this.getName(), this.getScopeNames(), this.getType(), this.getTemplateDescriptor(), this.isStatic(), this.isExtern(), null, this.getFile(), this.getStartOffset(), this.getEndOffset());
            VariableDefinitionImpl.postObjectCreateRegistration(this.isGlobal(), var);
            this.addDeclaration(var);
            return var;
        }
    }
}

