/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmValidable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsAdapter;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.apt.support.APTFileSearch;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTIncludePathStorage;
import org.netbeans.modules.cnd.apt.support.APTSystemStorage;
import org.netbeans.modules.cnd.apt.support.ClankDriver;
import org.netbeans.modules.cnd.apt.support.api.PPIncludeHandler;
import org.netbeans.modules.cnd.apt.support.api.PPMacroMap;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.support.api.StartEntry;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.indexing.api.CndTextIndex;
import org.netbeans.modules.cnd.indexing.api.CndTextIndexKey;
import org.netbeans.modules.cnd.modelimpl.cache.impl.WeakContainer;
import org.netbeans.modules.cnd.modelimpl.content.project.ClassifierContainer;
import org.netbeans.modules.cnd.modelimpl.content.project.DeclarationContainerProject;
import org.netbeans.modules.cnd.modelimpl.content.project.FileContainer;
import org.netbeans.modules.cnd.modelimpl.content.project.GraphContainer;
import org.netbeans.modules.cnd.modelimpl.content.project.IncludedFileContainer;
import org.netbeans.modules.cnd.modelimpl.content.project.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.ClassEnumBase;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardEnum;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.CreateFilesWorker;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FakeRegistrationWorker;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.NativeProjectListenerImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParseFinishNotificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParseStatistics;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProgressSupport;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.SourceRootContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.Terminator;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.impl.services.FileInfoQueryImpl;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTTokenStreamProducer;
import org.netbeans.modules.cnd.modelimpl.platform.CsmEventDispatcher;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelimpl.repository.ClassifierContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.GraphContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.KeyHolder;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectDeclarationContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.ProjectNameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.trace.TraceUtils;
import org.netbeans.modules.cnd.modelimpl.uid.LazyCsmCollection;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDManager;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.api.UnitDescriptor;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Cancellable;
import org.openide.util.CharSequences;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public abstract class ProjectBase
implements CsmProject,
Persistent,
SelfPersistent,
CsmIdentifiable,
CndFileSystemProvider.CndFileSystemProblemListener {
    static final Logger WAIT_PARSE_LOGGER = Logger.getLogger("cnd.wait.parse");
    private final Object fileCreateLock = new Object();
    private static final boolean TRACE_FILE = TraceFlags.TRACE_FILE_NAME != null;
    private final IncludedFileContainer includedFileContainer;
    private int preventMultiplyDiagnosticExceptionsGlobalNamespace = 0;
    private CsmUID<CsmProject> uid = null;
    private final Object uidLock = new Object();
    private final Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, Pair<AST, MutableDeclarationsContainer>>> filesFakeFuncData = new WeakHashMap();
    private volatile int hash = 0;
    private volatile Status status;
    private Cancellable initializationTask;
    private final Object initializationTaskLock = new InitializationTaskLock();
    private final Object waitParseLock = new WaitParseLock();
    private final Object classifierReplaceLock = new ClassifierReplaceLock();
    private ModelImpl model;
    private Unresolved unresolved;
    private final Object unresolvedLock = new Object();
    private CharSequence name;
    private CsmUID<CsmNamespace> globalNamespaceUID;
    private NamespaceImpl FAKE_GLOBAL_NAMESPACE;
    private volatile Object platformProject;
    private final FileSystem fileSystem;
    private boolean hasFileSystemProblems;
    private final Object fileSystemProblemsLock = new Object();
    private final AtomicBoolean disposing = new AtomicBoolean(false);
    private final ReadWriteLock disposeLock = new ReentrantReadWriteLock();
    private final CharSequence uniqueName;
    private final int unitId;
    private final LibraryManager libraryManager;
    private final Map<CharSequence, CsmUID<CsmNamespace>> namespaces;
    private final Key classifierStorageKey;
    private final APTSystemStorage sysAPTData;
    private final APTIncludePathStorage userPathStorage;
    private final Object namespaceLock = new NamespaceLock();
    private final Key declarationsSorageKey;
    private final Key fileContainerKey;
    private final Object fileContainerLock = new FileContainerLock();
    private final Key graphStorageKey;
    private volatile NativeProjectListenerImpl projectListener;
    private final Object projectListenerLock = new Object();
    public static final boolean TRACE_PP_STATE_OUT = DebugUtils.getBoolean((String)"cnd.dump.preproc.state", (boolean)false);
    public static final int GATHERING_MACROS = 0;
    public static final int GATHERING_TOKENS = 1;
    public static final boolean DO_NOT_TRCE_DUMMY_FORWARD_CLASSIFIER = DebugUtils.getBoolean((String)"cnd.dump.skip.dummy.forward.classifier", (boolean)false);
    private final WeakContainer<DeclarationContainerProject> weakDeclarationContainer;
    private final WeakContainer<FileContainer> weakFileContainer;
    private final WeakContainer<GraphContainer> weakGraphContainer;
    private final WeakContainer<ClassifierContainer> weakClassifierContainer;
    private static final Comparator<NativeFileItem> NATIVE_FILE_ITEMS_COMPARATOR = new Comparator<NativeFileItem>(){

        @Override
        public int compare(NativeFileItem o1, NativeFileItem o2) {
            return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
        }
    };

    protected ProjectBase(ModelImpl model, FileSystem fs, Object platformProject, CharSequence name, Key key) {
        this.namespaces = new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>();
        this.uniqueName = ProjectBase.getUniqueName(fs, platformProject);
        RepositoryUtils.openUnit(key);
        this.unitId = key.getUnitId();
        this.setStatus(Status.Initial);
        this.name = ProjectNameCache.getManager().getString(name);
        this.fileSystem = fs;
        this.init(model, platformProject);
        this.sysAPTData = APTSystemStorage.getInstance();
        this.userPathStorage = new APTIncludePathStorage();
        this.declarationsSorageKey = new ProjectDeclarationContainerKey(this.unitId);
        this.weakDeclarationContainer = new WeakContainer((CsmValidable)this, this.declarationsSorageKey);
        this.classifierStorageKey = new ClassifierContainerKey(this.unitId);
        this.weakClassifierContainer = new WeakContainer((CsmValidable)this, this.classifierStorageKey);
        this.fileContainerKey = new FileContainerKey(this.unitId);
        this.weakFileContainer = new WeakContainer((CsmValidable)this, this.fileContainerKey);
        this.graphStorageKey = new GraphContainerKey(this.unitId);
        this.weakGraphContainer = new WeakContainer((CsmValidable)this, this.graphStorageKey);
        this.includedFileContainer = new IncludedFileContainer(this);
        this.initFields();
        this.libraryManager = LibraryManager.getInstance(this.getUnitId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initFields() {
        NamespaceImpl ns;
        Object object = this.namespaceLock;
        synchronized (object) {
            ns = NamespaceImpl.create(this, false);
        }
        assert (ns != null);
        this.globalNamespaceUID = UIDCsmConverter.namespaceToUID(ns);
        DeclarationContainerProject declarationContainer = new DeclarationContainerProject(this);
        CndUtils.assertTrue((boolean)this.declarationsSorageKey.equals(declarationContainer.getKey()));
        this.weakDeclarationContainer.clear();
        ClassifierContainer classifierContainer = new ClassifierContainer(this);
        CndUtils.assertTrue((boolean)this.classifierStorageKey.equals(classifierContainer.getKey()));
        this.weakClassifierContainer.clear();
        FileContainer fileContainer = new FileContainer(this);
        CndUtils.assertTrue((boolean)this.fileContainerKey.equals(fileContainer.getKey()));
        this.weakFileContainer.clear();
        GraphContainer graphContainer = new GraphContainer(this);
        CndUtils.assertTrue((boolean)this.graphStorageKey.equals(graphContainer.getKey()));
        this.weakGraphContainer.clear();
        this.includedFileContainer.clear();
        this.FAKE_GLOBAL_NAMESPACE = NamespaceImpl.create(this, true);
    }

    private void init(ModelImpl model, Object platformProject) {
        this.model = model;
        assert (platformProject instanceof NativeProject || platformProject instanceof CharSequence);
        this.platformProject = platformProject;
        RepositoryUtils.hang(this);
        if (TraceFlags.CLOSE_AFTER_PARSE) {
            Terminator.create(this);
        }
    }

    private boolean checkConsistency(boolean restoring) {
        long time;
        long l = time = TraceFlags.TIMING ? System.currentTimeMillis() : 0L;
        if (this.getFileContainer() == FileContainer.empty()) {
            return false;
        }
        if (this.getDeclarationsSorage() == DeclarationContainerProject.empty()) {
            return false;
        }
        if (this.getGraph() == GraphContainer.empty()) {
            return false;
        }
        if (this.getGlobalNamespace() == this.FAKE_GLOBAL_NAMESPACE) {
            return false;
        }
        if (TraceFlags.CHECK_CONSISTENCY || CndUtils.isUnitTestMode()) {
            if (TraceFlags.TIMING) {
                System.err.printf("Consistency check took %d ms%n", System.currentTimeMillis() - time);
            }
            time = System.currentTimeMillis();
            this.checkFileContainerConsistency(restoring);
            if (TraceFlags.TIMING) {
                System.err.printf("File Container Consistency check took %d ms%n", System.currentTimeMillis() - time);
            }
        }
        return true;
    }

    private void checkFileContainerConsistency(boolean restoring) {
        if (this.isArtificial()) {
            return;
        }
        HashSet<FileImpl> allFileImpls = new HashSet<FileImpl>(this.getAllFileImpls());
        IncludedFileContainer.Storage storageForSelf = this.includedFileContainer.getStorageForProject(this);
        if (storageForSelf != null) {
            for (Map.Entry entry : storageForSelf.getInternalMap().entrySet()) {
                FileImpl file = this.getFileContainer().getFile((CharSequence)entry.getKey(), true);
                if (file != null && allFileImpls.contains(file)) continue;
                CndUtils.assertTrueInConsole((boolean)false, (String)"no file enty for included file ", (Object)entry);
            }
        }
        for (FileImpl fileImpl : allFileImpls) {
            this.checkFileEntryConsistency(fileImpl, restoring);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileEntryConsistency(FileImpl fileImpl, boolean restoring) {
        CharSequence fileKey = fileImpl.getAbsolutePath();
        FileImpl.State fileState = fileImpl.getState();
        FileContainer.FileEntry entry = this.getFileContainer().getEntry(fileKey);
        if (entry != null) {
            Object lock;
            Object object = lock = entry.getLock();
            synchronized (object) {
                FileContainer.FileEntry includedFileEntry;
                ArrayList<PreprocessorStatePair> fcPairs = new ArrayList<PreprocessorStatePair>(entry.getStatePairs());
                if (fcPairs.isEmpty() && fileState != FileImpl.State.INITIAL) {
                    CndUtils.assertTrueInConsole((boolean)false, (String)"no states for own file ", (Object)fileImpl);
                }
                boolean hasParsing = false;
                Boolean hasValid = fcPairs.isEmpty() ? Boolean.TRUE : null;
                for (PreprocessorStatePair fcPair : fcPairs) {
                    if (fileState == FileImpl.State.PARSED) {
                        CndUtils.assertTrueInConsole((boolean)fcPair.state.isValid(), (String)"FC Should not contain invalid ", (Object)fcPair);
                        CndUtils.assertTrueInConsole((fcPair.pcState != FilePreprocessorConditionState.PARSING ? 1 : 0) != 0, (String)"FC Should not contain PARSING ", (Object)fcPair);
                    }
                    if (fcPair.pcState == FilePreprocessorConditionState.PARSING) {
                        hasParsing = true;
                    }
                    if (hasValid == null) {
                        hasValid = fcPair.state.isValid();
                    }
                    CndUtils.assertTrueInConsole((hasValid.booleanValue() == fcPair.state.isValid() ? 1 : 0) != 0, (String)("FC Should not contain " + hasValid), (Object)fcPair);
                }
                CsmUID<CsmFile> testFileUID = entry.getTestFileUID();
                FileImpl testFileImpl = (FileImpl)UIDCsmConverter.UIDtoFile(testFileUID);
                if (!testFileImpl.equals(fileImpl)) {
                    CndUtils.assertTrueInConsole((boolean)false, (String)("different files: " + fileImpl), (Object)testFileImpl);
                }
                if ((includedFileEntry = this.includedFileContainer.getIncludedFileEntry(lock, this, fileKey)) != null) {
                    ArrayList<PreprocessorStatePair> inclPairs = new ArrayList<PreprocessorStatePair>(includedFileEntry.getStatePairs());
                    if (inclPairs.isEmpty()) {
                        CndUtils.assertTrueInConsole((boolean)false, (String)"no included states for included file ", (Object)fileImpl);
                    } else {
                        for (PreprocessorStatePair inclPair : inclPairs) {
                            ComparisonResult resultPC;
                            if (fileState == FileImpl.State.PARSED) {
                                CndUtils.assertTrueInConsole((boolean)inclPair.state.isValid(), (String)"Should not contain invalid ", (Object)inclPair);
                                CndUtils.assertTrueInConsole((inclPair.pcState != FilePreprocessorConditionState.PARSING ? 1 : 0) != 0, (String)"Should not contain PARSING ", (Object)inclPair);
                            }
                            ArrayList<PreprocessorStatePair> statesToKeep = new ArrayList<PreprocessorStatePair>(4);
                            AtomicBoolean newStateFound = new AtomicBoolean();
                            ComparisonResult resultPP = ProjectBase.fillStatesToKeepBasedOnPPState(inclPair.state, fcPairs, statesToKeep, newStateFound);
                            if (inclPair.state.isValid()) {
                                if (resultPP != ComparisonResult.KEEP_WITH_OTHERS) {
                                    CndUtils.assertTrueInConsole((boolean)false, (String)("Should not contribute [" + restoring + "," + hasParsing + "] " + newStateFound + " " + (Object)((Object)resultPP) + " pair into File Container (state based) " + inclPair + "vs.\n"), fcPairs);
                                }
                            } else {
                                CndUtils.assertTrueInConsole((resultPP == ComparisonResult.DISCARD && hasValid == false ? 1 : 0) != 0, (String)("Should not contribute invalid [" + restoring + "," + hasParsing + "] " + newStateFound + " " + (Object)((Object)resultPP) + " pair into File Container (state based) " + inclPair + "vs.\n"), fcPairs);
                            }
                            if ((resultPC = ProjectBase.fillStatesToKeepBasedOnPCState(inclPair.pcState, fcPairs, statesToKeep)) == ComparisonResult.DISCARD) continue;
                            CndUtils.assertTrueInConsole((inclPair.pcState == FilePreprocessorConditionState.PARSING && hasParsing ? 1 : 0) != 0, (String)("Should not contribute [" + restoring + "," + hasParsing + "] " + newStateFound + " " + (Object)((Object)resultPC) + " pair into File Container (PCState based) " + inclPair), fcPairs);
                        }
                    }
                }
            }
        } else {
            CndUtils.assertTrueInConsole((boolean)false, (String)"no entry for ", (Object)fileKey);
        }
    }

    private void setStatus(Status newStatus) {
        this.status = newStatus;
    }

    protected static ProjectBase readInstance(ModelImpl model, Key key, Object platformProject, CharSequence name) {
        long time = 0L;
        if (TraceFlags.TIMING) {
            System.err.printf("Project %s: instantiating...%n", name);
            time = System.currentTimeMillis();
        }
        assert (TraceFlags.PERSISTENT_REPOSITORY);
        RepositoryUtils.openUnit(key);
        Persistent o = RepositoryUtils.get(key);
        if (o != null) {
            assert (o instanceof ProjectBase);
            ProjectBase impl = (ProjectBase)o;
            CharSequence aName = ProjectNameCache.getManager().getString(name);
            if (!impl.name.equals(aName)) {
                impl.setName(aName);
            }
            impl.init(model, platformProject);
            if (TraceFlags.TIMING) {
                time = System.currentTimeMillis() - time;
                System.err.printf("Project %s: loaded. %d ms%n", name, time);
            }
            UIDManager.instance().clearProjectCache(key);
            if (impl.checkConsistency(true)) {
                return impl;
            }
        }
        return null;
    }

    public final CsmNamespace getGlobalNamespace() {
        return this._getGlobalNamespace();
    }

    public final CharSequence getName() {
        return this.name;
    }

    protected final void setName(CharSequence name) {
        this.name = name;
    }

    public final CharSequence getUniqueName() {
        return this.uniqueName;
    }

    public static CharSequence getUniqueName(NativeProject platformProject) {
        return ProjectBase.getUniqueName(platformProject.getFileSystem(), platformProject);
    }

    public final LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public String getDisplayName() {
        if (CndFileUtils.isLocalFileSystem((FileSystem)this.fileSystem)) {
            return this.name.toString();
        }
        return NbBundle.getMessage(this.getClass(), (String)"ProjectDisplayName", (Object)this.name, (Object)this.fileSystem.getDisplayName());
    }

    public String getHtmlDisplayName() {
        if (CndFileUtils.isLocalFileSystem((FileSystem)this.fileSystem)) {
            return this.name.toString();
        }
        return NbBundle.getMessage(this.getClass(), (String)"ProjectHtmlDisplayName", (Object)this.name, (Object)this.fileSystem.getDisplayName());
    }

    public static CharSequence getRepositoryUnitName(FileSystem fs, CharSequence projectSourceRoot) {
        Parameters.notNull((CharSequence)"FileSystem", (Object)fs);
        String result = projectSourceRoot.toString() + "/N/";
        return ProjectNameCache.getManager().getString((CharSequence)result);
    }

    public static CharSequence getRepositoryUnitName(FileSystem fs, NativeProject nativeProject) {
        Parameters.notNull((CharSequence)"FileSystem", (Object)fs);
        String result = nativeProject.getProjectRoot() + "/N/";
        return ProjectNameCache.getManager().getString((CharSequence)result);
    }

    public static CharSequence getUniqueName(FileSystem fs, Object platformProject) {
        String result;
        String postfix;
        Parameters.notNull((CharSequence)"FileSystem", (Object)fs);
        String string = postfix = CndFileUtils.isLocalFileSystem((FileSystem)fs) ? "" : fs.getDisplayName();
        if (platformProject instanceof NativeProject) {
            result = ((NativeProject)platformProject).getProjectRoot() + "/N/" + postfix;
        } else if (platformProject instanceof CharSequence) {
            result = ((CharSequence)platformProject).toString() + "/L/" + postfix;
        } else {
            if (platformProject == null) {
                throw new IllegalArgumentException("Incorrect platform project: null");
            }
            throw new IllegalArgumentException("Incorrect platform project class: " + platformProject.getClass());
        }
        return ProjectNameCache.getManager().getString((CharSequence)result);
    }

    public final Object getPlatformProject() {
        assert (this.platformProject == null || this.platformProject instanceof NativeProject || this.platformProject instanceof CharSequence);
        return this.platformProject;
    }

    private UnitDescriptor getUnitDescriptor() {
        if (this.platformProject instanceof NativeProject) {
            return KeyUtilities.createUnitDescriptor((NativeProject)this.platformProject);
        }
        if (this.platformProject instanceof CharSequence) {
            return KeyUtilities.createUnitDescriptor((CharSequence)this.platformProject, this.fileSystem);
        }
        if (this.platformProject == null) {
            return null;
        }
        throw new IllegalArgumentException("Incorrect platform project class: " + this.platformProject.getClass());
    }

    protected final void setPlatformProject(CharSequence platformProject) {
        this.setPlatformProjectImpl(platformProject);
    }

    protected final void setPlatformProject(NativeProject platformProject) {
        this.setPlatformProjectImpl(platformProject);
    }

    private void setPlatformProjectImpl(Object platformProject) {
        assert (platformProject == null || platformProject instanceof NativeProject || platformProject instanceof CharSequence);
        CndUtils.assertTrue((this.platformProject == null ? 1 : 0) != 0);
        CndUtils.assertNotNull((Object)platformProject, (CharSequence)"Passing null project for ", (Object)this);
        this.platformProject = platformProject;
        this.checkUniqueNameConsistency();
    }

    private void checkUniqueNameConsistency() {
        CharSequence expectedUniqueName;
        CharSequence defactoUniqueName;
        if (CndUtils.isDebugMode() && !(defactoUniqueName = this.uniqueName).equals(expectedUniqueName = ProjectBase.getUniqueName(this.fileSystem, this.platformProject))) {
            CndUtils.assertTrue((boolean)false, (String)("Existing project unique name differ: " + defactoUniqueName + " - expected " + expectedUniqueName));
        }
    }

    public final CsmNamespace findNamespace(CharSequence qualifiedName, boolean findInLibraries) {
        CsmNamespace result;
        block1: {
            CsmProject lib;
            result = this.findNamespace(qualifiedName);
            if (result != null || !findInLibraries) break block1;
            Iterator it = this.getLibraries().iterator();
            while (it.hasNext() && (result = (lib = (CsmProject)it.next()).findNamespace(qualifiedName)) == null) {
            }
        }
        return result;
    }

    public final CsmNamespace findNamespace(CharSequence qualifiedName) {
        NamespaceImpl nsp = this._getNamespace(qualifiedName);
        return nsp;
    }

    private static CharSequence getNestedNamespaceQualifiedName(CharSequence name, NamespaceImpl parent, boolean createForEmptyNames) {
        StringBuilder sb = new StringBuilder(name);
        if (parent != null) {
            if (name.length() == 0 && createForEmptyNames) {
                sb.append(parent.getNameForUnnamedElement());
            }
            if (!parent.isGlobal()) {
                sb.insert(0, "::");
                sb.insert(0, parent.getQualifiedName());
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final NamespaceImpl findNamespaceCreateIfNeeded(NamespaceImpl parent, CharSequence name) {
        Object object = this.namespaceLock;
        synchronized (object) {
            CharSequence qualifiedName = ProjectBase.getNestedNamespaceQualifiedName(name, parent, true);
            NamespaceImpl nsp = this._getNamespace(qualifiedName);
            if (nsp == null) {
                nsp = NamespaceImpl.create(this, parent, name, qualifiedName);
            }
            return nsp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CsmUID<CsmNamespace> addNamespaceDefinition(NamespaceImpl parent, CsmNamespaceDefinition nsDefinition) {
        Object object = this.namespaceLock;
        synchronized (object) {
            CharSequence qualifiedName = ProjectBase.getNestedNamespaceQualifiedName(nsDefinition.getName(), parent, true);
            NamespaceImpl nsp = this._getNamespace(qualifiedName);
            if (nsp == null) {
                nsp = NamespaceImpl.create(this, parent, nsDefinition.getName(), qualifiedName);
            }
            nsp.addNamespaceDefinition(nsDefinition);
            return UIDCsmConverter.namespaceToUID(nsp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNamespaceDefinition(CsmNamespaceDefinition nsDefinition) {
        Object object = this.namespaceLock;
        synchronized (object) {
            NamespaceImpl nsp = (NamespaceImpl)nsDefinition.getNamespace();
            if (nsp != null) {
                nsp.removeNamespaceDefinition(nsDefinition);
            }
        }
    }

    public final boolean holdsNamespaceLock() {
        return Thread.holdsLock(this.namespaceLock);
    }

    public final void registerNamespace(NamespaceImpl namespace) {
        assert (this.holdsNamespaceLock()) : "Modifications of namespace can be performed only under namespaceLock!";
        this._registerNamespace(namespace);
    }

    public final void unregisterNamesace(NamespaceImpl namespace) {
        assert (this.holdsNamespaceLock()) : "Modifications of namespace can be performed only under namespaceLock!";
        this._unregisterNamespace(namespace);
    }

    public final CsmClassifier findClassifier(CharSequence qualifiedName, boolean findInLibraries) {
        CsmClassifier result;
        block1: {
            CsmProject lib;
            result = this.findClassifier(qualifiedName);
            if (result != null || !findInLibraries) break block1;
            Iterator it = this.getLibraries().iterator();
            while (it.hasNext() && (result = (lib = (CsmProject)it.next()).findClassifier(qualifiedName)) == null) {
            }
        }
        return result;
    }

    public final CsmClassifier findClassifier(CharSequence qualifiedName) {
        CsmClassifier result = this.getClassifierSorage().getClassifier(qualifiedName);
        return result;
    }

    public final Collection<CsmClassifier> findClassifiers(CharSequence qualifiedName) {
        CsmClassifier result = this.getClassifierSorage().getClassifier(qualifiedName);
        ArrayList<CsmClassifier> out = new ArrayList<CsmClassifier>();
        if (result != null) {
            if (CsmKindUtilities.isBuiltIn((CsmObject)result)) {
                return Collections.singletonList(result);
            }
            CharSequence[] allClassifiersUniqueNames = Utils.getAllClassifiersUniqueNames(result.getUniqueName());
            ArrayList<CsmClassifier> fwds = new ArrayList<CsmClassifier>(1);
            for (CharSequence curUniqueName : allClassifiersUniqueNames) {
                Collection<CsmOffsetableDeclaration> decls;
                Collection<CsmOffsetableDeclaration> classifiers = decls = this.findDeclarations(curUniqueName);
                for (CsmClassifier csmClassifier : classifiers) {
                    if (ForwardClass.isForwardClass((CsmObject)csmClassifier)) {
                        fwds.add(csmClassifier);
                        continue;
                    }
                    out.add(csmClassifier);
                }
            }
            out.addAll(fwds);
        }
        return out;
    }

    public final Collection<CsmInheritance> findInheritances(CharSequence name) {
        return this.getClassifierSorage().getInheritances(name);
    }

    public final CsmDeclaration findDeclaration(CharSequence uniqueName) {
        return this.getDeclarationsSorage().getDeclaration(uniqueName);
    }

    public final Collection<CsmOffsetableDeclaration> findDeclarations(CharSequence uniqueName) {
        return this.getDeclarationsSorage().findDeclarations(uniqueName);
    }

    public final Collection<CsmOffsetableDeclaration> findDeclarationsByPrefix(String uniquNamePrefix) {
        char maxChar = '\u00ff';
        return this.getDeclarationsSorage().getDeclarationsRange((CharSequence)uniquNamePrefix, uniquNamePrefix + maxChar);
    }

    public final Collection<CsmFriend> findFriendDeclarations(CsmOffsetableDeclaration decl) {
        return this.getDeclarationsSorage().findFriends(decl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean registerDeclaration(CsmOffsetableDeclaration decl) {
        if (!Utils.canRegisterDeclaration((CsmDeclaration)decl)) {
            if (TraceFlags.TRACE_REGISTRATION) {
                ProjectBase.traceRegistration("not registered decl " + decl + " UID " + UIDs.get((Object)decl));
            }
            return false;
        }
        if (CsmKindUtilities.isClass((CsmObject)decl) || CsmKindUtilities.isEnum((CsmObject)decl)) {
            ClassEnumBase cls = (ClassEnumBase)decl;
            CharSequence qname = cls.getQualifiedName();
            Object object = this.classifierReplaceLock;
            synchronized (object) {
                CsmClassifier old = this.getClassifierSorage().getClassifier(qname);
                if (old != null) {
                    if (cls.shouldBeReplaced(old)) {
                        if (TraceFlags.TRACE_REGISTRATION) {
                            ProjectBase.traceRegistration("not registered decl " + decl + " UID " + UIDs.get((Object)decl));
                        }
                        return false;
                    }
                    if (old instanceof ClassEnumBase && ((ClassEnumBase)old).shouldBeReplaced((CsmClassifier)cls)) {
                        if (TraceFlags.TRACE_REGISTRATION) {
                            System.err.println("disposing old decl " + old + " UID " + UIDs.get((Object)decl));
                        }
                        ((ClassEnumBase)old).dispose();
                    }
                }
                this.getDeclarationsSorage().putDeclaration(decl);
                this.getClassifierSorage().putClassifier((CsmClassifier)decl);
            }
        } else if (CsmKindUtilities.isTypedef((CsmObject)decl) || CsmKindUtilities.isTypeAlias((CsmObject)decl)) {
            this.getDeclarationsSorage().putDeclaration(decl);
            this.getClassifierSorage().putClassifier((CsmClassifier)decl);
        } else {
            this.getDeclarationsSorage().putDeclaration(decl);
        }
        if (TraceFlags.TRACE_REGISTRATION) {
            System.err.println("registered " + decl + " UID " + UIDs.get((Object)decl));
        }
        return true;
    }

    public final void unregisterDeclaration(CsmOffsetableDeclaration decl) {
        if (TraceFlags.TRACE_REGISTRATION) {
            ProjectBase.traceRegistration("unregistered " + decl + " UID " + UIDs.get((Object)decl));
        }
        if (decl instanceof CsmClassifier) {
            this.getClassifierSorage().removeClassifier((CsmDeclaration)decl);
        }
        this.getDeclarationsSorage().removeDeclaration(decl);
    }

    private static void traceRegistration(String text) {
        assert (TraceFlags.TRACE_REGISTRATION) : "TraceFlags.TRACE_REGISTRATION should be checked *before* call !";
        System.err.printf("registration: %s%n", text);
    }

    protected void addModifiedFile(FileImpl file) {
    }

    protected void removeModifiedFile(FileImpl file) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void waitParse() {
        block5: {
            if (WAIT_PARSE_LOGGER.isLoggable(Level.FINE)) {
                WAIT_PARSE_LOGGER.fine(String.format("##> waitParse %s %d", this.getName(), System.currentTimeMillis()));
            }
            try {
                boolean insideParser = ParserThreadManager.instance().isParserThread();
                if (insideParser) {
                    new Throwable("project.waitParse should NEVER be called in parser thread !!!").printStackTrace(System.err);
                }
                if (!insideParser) break block5;
                if (!WAIT_PARSE_LOGGER.isLoggable(Level.FINE)) return;
            }
            catch (Throwable throwable) {
                if (!WAIT_PARSE_LOGGER.isLoggable(Level.FINE)) throw throwable;
                WAIT_PARSE_LOGGER.fine(String.format("##< waitParse %d", System.currentTimeMillis()));
                throw throwable;
            }
            WAIT_PARSE_LOGGER.fine(String.format("##< waitParse %d", System.currentTimeMillis()));
            return;
        }
        this.ensureFilesCreated();
        this.ensureChangedFilesEnqueued();
        this.model.waitModelTasks();
        this.waitParseImpl();
        if (!WAIT_PARSE_LOGGER.isLoggable(Level.FINE)) return;
        WAIT_PARSE_LOGGER.fine(String.format("##< waitParse %d", System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitParseImpl() {
        Object object = this.waitParseLock;
        synchronized (object) {
            while (ParserQueue.instance().hasPendingProjectRelatedWork(this, null)) {
                try {
                    this.waitParseLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void ensureChangedFilesEnqueued() {
    }

    protected boolean hasChangedFiles(CsmFile skipFile) {
        return false;
    }

    protected boolean hasEditedFiles() {
        return false;
    }

    private Set<FileSystem> getIncludesFileSystems(NativeProject nativeProject) {
        HashSet<FileSystem> fileSystems = new HashSet<FileSystem>();
        for (FSPath fsPath : nativeProject.getSystemIncludePaths()) {
            fileSystems.add(fsPath.getFileSystem());
        }
        return fileSystems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void problemOccurred(FSPath fsPath) {
        Object object = this.fileSystemProblemsLock;
        synchronized (object) {
            this.hasFileSystemProblems = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recovered(FileSystem fileSystem) {
        boolean prev;
        Object object = this.fileSystemProblemsLock;
        synchronized (object) {
            prev = this.hasFileSystemProblems;
            this.hasFileSystemProblems = false;
        }
        if (prev) {
            ModelImpl.instance().scheduleReparse(Collections.singleton(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enableProjectListeners(boolean enable) {
        if (TraceFlags.MERGE_EVENTS) {
            if (this.platformProject instanceof NativeProject) {
                CsmEventDispatcher.getInstance().enableListening(this, enable);
            }
        } else {
            Object object = this.projectListenerLock;
            synchronized (object) {
                if (this.projectListener != null) {
                    this.projectListener.enableListening(enable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void registerProjectListeners() {
        block9: {
            if (!(this.platformProject instanceof NativeProject)) break block9;
            if (TraceFlags.MERGE_EVENTS) {
                CsmEventDispatcher.getInstance().registerProject(this);
                NativeProject nativeProject = (NativeProject)this.platformProject;
                for (FileSystem fs : this.getIncludesFileSystems(nativeProject)) {
                    CndFileSystemProvider.addFileSystemProblemListener((CndFileSystemProvider.CndFileSystemProblemListener)this, (FileSystem)fs);
                }
            } else {
                Object object = this.projectListenerLock;
                synchronized (object) {
                    if (this.platformProject instanceof NativeProject) {
                        if (this.projectListener == null) {
                            this.projectListener = new NativeProjectListenerImpl(this.getModel(), (NativeProject)this.platformProject, this);
                        }
                        NativeProject nativeProject = (NativeProject)this.platformProject;
                        nativeProject.addProjectItemsListener((NativeProjectItemsListener)this.projectListener);
                        for (FileSystem fs : this.getIncludesFileSystems(nativeProject)) {
                            CndFileSystemProvider.addFileSystemProblemListener((CndFileSystemProvider.CndFileSystemProblemListener)this, (FileSystem)fs);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void unregisterProjectListeners() {
        block9: {
            if (!(this.platformProject instanceof NativeProject)) break block9;
            if (TraceFlags.MERGE_EVENTS) {
                CsmEventDispatcher.getInstance().unregisterProject(this);
                NativeProject nativeProject = (NativeProject)this.platformProject;
                for (FileSystem fs : this.getIncludesFileSystems(nativeProject)) {
                    CndFileSystemProvider.removeFileSystemProblemListener((CndFileSystemProvider.CndFileSystemProblemListener)this, (FileSystem)fs);
                }
            } else {
                Object object = this.projectListenerLock;
                synchronized (object) {
                    if (this.projectListener != null) {
                        if (this.platformProject instanceof NativeProject) {
                            NativeProject nativeProject = (NativeProject)this.platformProject;
                            nativeProject.removeProjectItemsListener((NativeProjectItemsListener)this.projectListener);
                            for (FileSystem fs : this.getIncludesFileSystems(nativeProject)) {
                                CndFileSystemProvider.removeFileSystemProblemListener((CndFileSystemProvider.CndFileSystemProblemListener)this, (FileSystem)fs);
                            }
                        }
                        this.projectListener = null;
                    }
                }
            }
        }
    }

    final void scheduleReparse() {
        this.ensureFilesCreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureFilesCreated() {
        if (this.status == Status.Ready) {
            return;
        }
        boolean notify = false;
        try {
            Object object = this.fileCreateLock;
            synchronized (object) {
                if (this.status == Status.Initial || this.status == Status.Restored) {
                    try {
                        this.setStatus(this.status == Status.Initial ? Status.AddingFiles : Status.Validating);
                        long time = 0L;
                        if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                            System.err.println("suspend queue");
                            ParserQueue.instance().suspend();
                            if (TraceFlags.TIMING) {
                                time = System.currentTimeMillis();
                            }
                        }
                        ParserQueue.instance().onStartAddingProjectFiles(this);
                        notify = true;
                        this.registerProjectListeners();
                        NativeProject nativeProject = ModelSupport.getNativeProject(this.platformProject);
                        if (nativeProject != null) {
                            try {
                                ParserQueue.instance().suspend();
                                this.createProjectFilesIfNeed(nativeProject);
                            }
                            finally {
                                ParserQueue.instance().resume();
                            }
                        }
                        if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                            if (TraceFlags.TIMING) {
                                time = System.currentTimeMillis() - time;
                                System.err.println("getting files from project system + put in queue took " + time + "ms");
                            }
                            System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec before resuming queue");
                            this.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                        }
                    }
                    finally {
                        if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                            System.err.println("woke up after sleep");
                            ParserQueue.instance().resume();
                        }
                        this.setStatus(Status.Ready);
                    }
                }
            }
        }
        finally {
            if (notify) {
                ParserQueue.instance().onEndAddingProjectFiles(this);
            }
        }
    }

    private void sleep(int millisec) {
        try {
            Thread.sleep(millisec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void createProjectFilesIfNeed(NativeProject nativeProject) {
        block35: {
            block36: {
                if (TraceFlags.TIMING) {
                    System.err.printf("%n%nGetting files from project system for %s...%n", new Object[]{this.getName()});
                }
                if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                    try {
                        System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec before getting files from project");
                        Thread.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                        System.err.println("woke up after sleep");
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                time = System.currentTimeMillis();
                removedFileItems = Collections.synchronizedSet(new HashSet<E>());
                readOnlyRemovedFilesSet = Collections.unmodifiableSet(removedFileItems);
                projectItemListener = new NativeProjectItemsAdapter(){

                    public void filesRemoved(List<NativeFileItem> fileItems) {
                        removedFileItems.addAll(fileItems);
                    }

                    public void filesPropertiesChanged(List<NativeFileItem> fileItems) {
                        for (NativeFileItem item : fileItems) {
                            if (!item.isExcluded()) continue;
                            removedFileItems.add(item);
                        }
                    }
                };
                nativeProject.addProjectItemsListener((NativeProjectItemsListener)projectItemListener);
                sources = new ArrayList<NativeFileItem>();
                headers = new ArrayList<NativeFileItem>();
                block14: for (NativeFileItem item : nativeProject.getAllFiles()) {
                    if (!item.isExcluded()) {
                        switch (4.$SwitchMap$org$netbeans$modules$cnd$api$project$NativeFileItem$Language[item.getLanguage().ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                sources.add(item);
                                continue block14;
                            }
                            case 4: {
                                headers.add(item);
                                continue block14;
                            }
                        }
                        continue;
                    }
                    switch (4.$SwitchMap$org$netbeans$modules$cnd$api$project$NativeFileItem$Language[item.getLanguage().ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: {
                            removedFileItems.add(item);
                            break;
                        }
                    }
                }
                if (TraceFlags.TIMING) {
                    time = System.currentTimeMillis() - time;
                    System.err.printf("Getting files from project system took  %d ms for %s%n", new Object[]{time, this.getName()});
                    System.err.printf("FILES COUNT for %s:%nSource files:\t%d%nHeader files:\t%d%nTotal files:\t%d%n", new Object[]{this.getName(), sources.size(), headers.size(), sources.size() + headers.size()});
                    time = System.currentTimeMillis();
                }
                if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                    try {
                        System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec after getting files from project");
                        Thread.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                        System.err.println("woke up after sleep");
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                if (TraceFlags.DUMP_PROJECT_ON_OPEN) {
                    ModelSupport.dumpNativeProject(nativeProject);
                }
                this.disposeLock.readLock().lock();
                if (TraceFlags.TIMING) {
                    time = System.currentTimeMillis() - time;
                    System.err.printf("Waited on disposeLock: %d ms for %s%n", new Object[]{time, this.getName()});
                    time = System.currentTimeMillis();
                }
                if (!this.isDisposing()) break block35;
                if (TraceFlags.TRACE_MODEL_STATE) {
                    System.err.printf("filling parser queue interrupted for %s%n", new Object[]{this.getName()});
                }
                this.disposeLock.readLock().unlock();
                if (!TraceFlags.TIMING) break block36;
                time = System.currentTimeMillis() - time;
                System.err.printf("FILLING PARSER QUEUE took %d ms for %s%n", new Object[]{time, this.getName()});
            }
            return;
        }
        try {
            validator = false;
            if (this.status == Status.Validating) {
                validator = true;
            }
            if (this.status == Status.Validating && RepositoryUtils.getRepositoryErrorCount(this) > 0) {
                System.err.println("Clean index for project \"" + this.getUniqueName() + "\" because index was corrupted (was " + RepositoryUtils.getRepositoryErrorCount(this) + " errors).");
                validator = false;
                this.reopenUnit();
            }
            this.getProjectRoots().fixFolder(nativeProject.getProjectRoot());
            for (String root : nativeProject.getSourceRoots()) {
                this.getProjectRoots().fixFolder(root);
            }
            this.getProjectRoots().addSources(sources);
            this.getProjectRoots().addSources(headers);
            this.getProjectRoots().addSources(removedFileItems);
            if (CndUtils.isDebugMode()) {
                this.checkConsistency(false);
            }
            worker = new CreateFilesWorker(this, readOnlyRemovedFilesSet, validator);
            if (TraceFlags.SORT_PARSED_FILES) {
                Collections.sort(sources, ProjectBase.NATIVE_FILE_ITEMS_COMPARATOR);
            }
            worker.createProjectFilesIfNeed(sources, true);
            if (this.status != Status.Validating || RepositoryUtils.getRepositoryErrorCount(this) == 0) {
                worker.createProjectFilesIfNeed(headers, false);
            }
            if (this.status == Status.Validating && RepositoryUtils.getRepositoryErrorCount(this) > 0) {
                if (!TraceFlags.DEBUG_BROKEN_REPOSITORY) {
                    System.err.println("Clean index for project \"" + this.getUniqueName() + "\" because index was corrupted (was " + RepositoryUtils.getRepositoryErrorCount(this) + " errors).");
                }
                this.reopenUnit();
                validator = false;
                worker = new CreateFilesWorker(this, readOnlyRemovedFilesSet, validator);
                worker.createProjectFilesIfNeed(sources, true);
                worker.createProjectFilesIfNeed(headers, false);
            }
            worker.checkLibraries();
            if (CndUtils.isDebugMode()) {
                this.checkConsistency(validator);
            }
            worker.finishProjectFilesCreation();
            if (CndUtils.isDebugMode()) {
                this.checkConsistency(false);
            }
            this.disposeLock.readLock().unlock();
            ** if (!TraceFlags.TIMING) goto lbl-1000
        }
        catch (Throwable var12_14) {
            this.disposeLock.readLock().unlock();
            if (TraceFlags.TIMING) {
                time = System.currentTimeMillis() - time;
                System.err.printf("FILLING PARSER QUEUE took %d ms for %s%n", new Object[]{time, this.getName()});
            }
            throw var12_14;
        }
lbl-1000:
        // 1 sources

        {
            time = System.currentTimeMillis() - time;
            System.err.printf("FILLING PARSER QUEUE took %d ms for %s%n", new Object[]{time, this.getName()});
        }
lbl-1000:
        // 2 sources

        {
        }
        nativeProject.removeProjectItemsListener((NativeProjectItemsListener)projectItemListener);
    }

    private void reopenUnit() {
        this.setStatus(Status.Initial);
        ParserQueue.instance().clean(this);
        RepositoryUtils.closeUnit(this.getUnitId(), null, true);
        RepositoryUtils.openUnit(this);
        RepositoryUtils.hang(this);
        this.initFields();
    }

    private FileAndHandler preCreateIfNeed(NativeFileItem nativeFile) {
        assert (nativeFile != null && nativeFile.getFileObject() != null);
        if (!Utils.acceptNativeItem(nativeFile)) {
            return null;
        }
        CsmFile.FileType fileType = Utils.getFileType(nativeFile);
        FileAndHandler fileAndHandler = this.createOrFindFileImpl(ModelSupport.createFileBuffer(nativeFile.getFileObject()), nativeFile, fileType);
        if (fileAndHandler.preprocHandler == null) {
            fileAndHandler.preprocHandler = this.createPreprocHandler(nativeFile);
        }
        return fileAndHandler;
    }

    final FileImpl createIfNeed(NativeFileItem nativeFile, boolean validator, Collection<FileImpl> reparseOnEdit, Collection<NativeFileItem> reparseOnPropertyChanged) {
        FileAndHandler fileAndHandler = this.preCreateIfNeed(nativeFile);
        if (fileAndHandler == null) {
            return null;
        }
        FileImpl fileImpl = fileAndHandler.fileImpl;
        if (validator) {
            if (fileImpl.validate()) {
                if (fileImpl.isParsed()) {
                    if (this.getGraph().getInLinksUids(fileImpl).isEmpty()) {
                        if (APTHandlersSupport.getCompilationUnitCRC((PreprocHandler)fileAndHandler.preprocHandler) != fileImpl.getLastParsedCompilationUnitCRC()) {
                            if (TraceFlags.TRACE_VALIDATION) {
                                System.err.printf("Validation: %s properties are changed %n", nativeFile.getAbsolutePath());
                            }
                            reparseOnPropertyChanged.add(nativeFile);
                        } else if (TraceFlags.TRACE_VALIDATION) {
                            System.err.printf("Validation: %s file is skipped as valid PARSED%n", nativeFile.getAbsolutePath());
                        }
                    } else if (TraceFlags.TRACE_VALIDATION) {
                        System.err.printf("Validation: %s file is skipped as non compilation unit PARSED%n", nativeFile.getAbsolutePath());
                    }
                } else {
                    if (TraceFlags.TRACE_VALIDATION) {
                        System.err.printf("Validation: %s file to be parsed, because of state %s%n", new Object[]{nativeFile.getAbsolutePath(), fileImpl.getState()});
                    }
                    if (APTHandlersSupport.getCompilationUnitCRC((PreprocHandler)fileAndHandler.preprocHandler) != fileImpl.getLastParsedCompilationUnitCRC()) {
                        if (fileImpl.getState() == FileImpl.State.INITIAL) {
                            fileAndHandler.preprocHandler = this.createPreprocHandler(nativeFile);
                            ParserQueue.instance().add(fileImpl, fileAndHandler.preprocHandler.getState(), ParserQueue.Position.TAIL);
                        } else {
                            if (TraceFlags.TRACE_VALIDATION) {
                                System.err.printf("Validation: %s properties are changed %n", nativeFile.getAbsolutePath());
                            }
                            reparseOnPropertyChanged.add(nativeFile);
                        }
                    } else {
                        ParserQueue.instance().add(fileImpl, fileAndHandler.preprocHandler.getState(), ParserQueue.Position.TAIL);
                    }
                }
            } else {
                if (TraceFlags.TRACE_VALIDATION) {
                    System.err.printf("Validation: file %s is changed%n", nativeFile.getAbsolutePath());
                }
                if (APTHandlersSupport.getCompilationUnitCRC((PreprocHandler)fileAndHandler.preprocHandler) != fileImpl.getLastParsedCompilationUnitCRC()) {
                    reparseOnPropertyChanged.add(nativeFile);
                } else {
                    reparseOnEdit.add(fileImpl);
                }
            }
        } else {
            boolean addToQueue = true;
            if (TraceFlags.PARSE_HEADERS_WITH_SOURCES) {
                addToQueue = fileImpl.isSourceFile();
            }
            if (addToQueue) {
                ParserQueue.instance().add(fileImpl, fileAndHandler.preprocHandler.getState(), ParserQueue.Position.TAIL);
            }
        }
        return fileImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onAddedToModel() {
        boolean isRestored;
        boolean bl = isRestored = this.status == Status.Restored;
        if (this.status == Status.Initial || this.status == Status.Restored) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProjectBase.this.onAddedToModelImpl(isRestored);
                    Object object = ProjectBase.this.initializationTaskLock;
                    synchronized (object) {
                        ProjectBase.this.initializationTask = null;
                    }
                }
            };
            String text = this.status == Status.Initial ? "Filling parser queue for " : "Validating files for ";
            Object object = this.initializationTaskLock;
            synchronized (object) {
                this.initializationTask = ModelImpl.instance().enqueueModelTask(r, text + this.getName());
            }
        }
    }

    protected final Status getStatus() {
        return this.status;
    }

    boolean isValidating() {
        return this.status == Status.Validating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAddedToModelImpl(boolean isRestored) {
        if (TraceFlags.TRACE_182342_BUG) {
            new Exception("Restored: " + isRestored + " disposing: " + this.isDisposing()).printStackTrace(System.err);
        }
        if (this.isDisposing()) {
            return;
        }
        try {
            this.disposeLock.readLock().lock();
            if (this.isDisposing()) {
                return;
            }
            this.ensureFilesCreated();
            if (this.isDisposing()) {
                return;
            }
            Notificator.instance().flush();
        }
        finally {
            this.disposeLock.readLock().unlock();
        }
        if (isRestored) {
            FileImpl.incParseCount();
            ProgressSupport.instance().fireProjectLoaded(this);
        }
        try {
            this.disposeLock.readLock().lock();
            if (isRestored && !this.isDisposing()) {
                try {
                    this.waitParseImpl();
                    this.checkForRemoved();
                }
                catch (Exception e) {
                    DiagnosticExceptoins.register(e);
                }
            }
            if (this.isDisposing()) {
                return;
            }
            Notificator.instance().flush();
        }
        finally {
            this.disposeLock.readLock().unlock();
        }
    }

    public final void checkForRemoved() {
        CndUtils.assertTrueInConsole((boolean)ModelImpl.isModelRequestProcessorThread(), (String)"should be called from model RP");
        NativeProject nativeProject = this.platformProject instanceof NativeProject ? (NativeProject)this.platformProject : null;
        Set prjNotExcludedSourceFileItems = Collections.emptySet();
        Set prjNotExcludedHeaderFileItems = Collections.emptySet();
        if (nativeProject != null) {
            prjNotExcludedSourceFileItems = new HashSet();
            prjNotExcludedHeaderFileItems = new HashSet();
            block5: for (NativeFileItem item : nativeProject.getAllFiles()) {
                if (item.isExcluded()) continue;
                switch (item.getLanguage()) {
                    case C: 
                    case CPP: 
                    case FORTRAN: {
                        prjNotExcludedSourceFileItems.add(item.getAbsolutePath());
                        continue block5;
                    }
                    case C_HEADER: {
                        prjNotExcludedHeaderFileItems.add(item.getAbsolutePath());
                        continue block5;
                    }
                    case OTHER: {
                        continue block5;
                    }
                }
                throw new AssertionError(item.getLanguage());
            }
        }
        LinkedList<FileImpl> liveStartFiles = new LinkedList<FileImpl>();
        Collection<FileImpl> prjFileImpls = this.getAllFileImpls();
        HashMap<FileImpl, Boolean> allFileImpls = new HashMap<FileImpl, Boolean>(prjFileImpls.size());
        boolean hasChanges = false;
        for (FileImpl fileImpl : prjFileImpls) {
            allFileImpls.put(fileImpl, null);
            FileObject fo = fileImpl.getFileObject();
            if (fo == null || !fo.isValid()) {
                allFileImpls.put(fileImpl, Boolean.FALSE);
                hasChanges = true;
                continue;
            }
            if (nativeProject != null) {
                if (prjNotExcludedSourceFileItems.contains(fileImpl.getAbsolutePath().toString())) {
                    liveStartFiles.addLast(fileImpl);
                    allFileImpls.put(fileImpl, Boolean.TRUE);
                    continue;
                }
                if (prjNotExcludedHeaderFileItems.contains(fileImpl.getAbsolutePath().toString())) {
                    liveStartFiles.addLast(fileImpl);
                    allFileImpls.put(fileImpl, Boolean.TRUE);
                    continue;
                }
                hasChanges = true;
                continue;
            }
            liveStartFiles.addLast(fileImpl);
            allFileImpls.put(fileImpl, Boolean.TRUE);
        }
        if (!hasChanges) {
            if (CndUtils.isDebugMode() || CndUtils.isUnitTestMode()) {
                for (Map.Entry entry : allFileImpls.entrySet()) {
                    CndUtils.assertTrue((entry.getValue() == Boolean.TRUE ? 1 : 0) != 0);
                }
            }
            return;
        }
        while (!liveStartFiles.isEmpty()) {
            FileImpl curLiveFile = (FileImpl)liveStartFiles.removeFirst();
            for (CsmFile csmFile : this.getGraph().getOutLinks(curLiveFile)) {
                Boolean result;
                FileImpl includedFileImpl = (FileImpl)csmFile;
                if (!includedFileImpl.getProjectUID().equals(this.getUID())) continue;
                if (CndUtils.isDebugMode() || CndUtils.isUnitTestMode()) {
                    CndUtils.assertTrueInConsole((boolean)allFileImpls.containsKey(includedFileImpl), (String)("no record for: " + includedFileImpl), (Object)("\n\twhile checking out links for " + curLiveFile));
                }
                if ((result = (Boolean)allFileImpls.get(includedFileImpl)) != null) continue;
                allFileImpls.put(includedFileImpl, Boolean.TRUE);
                liveStartFiles.addLast(includedFileImpl);
            }
        }
        HashSet<FileImpl> removedPhysically = new HashSet<FileImpl>();
        HashSet<FileImpl> hashSet = new HashSet<FileImpl>();
        for (Map.Entry entry : allFileImpls.entrySet()) {
            Boolean value = (Boolean)entry.getValue();
            FileImpl fileImpl = (FileImpl)entry.getKey();
            if (value == null) {
                if (!this.getGraph().getInLinksUids(fileImpl).isEmpty()) continue;
                hashSet.add(fileImpl);
                if (!TraceFlags.TRACE_VALIDATION) continue;
                System.err.printf("Validation: removing (removed from project) %s%n", fileImpl.getAbsolutePath());
                continue;
            }
            if (value != Boolean.FALSE) continue;
            removedPhysically.add(fileImpl);
            if (!TraceFlags.TRACE_VALIDATION) continue;
            System.err.printf("Validation: removing (physically deleted) %s%n", fileImpl.getAbsolutePath());
        }
        if (!removedPhysically.isEmpty() || !hashSet.isEmpty()) {
            this.onFileImplRemoved(removedPhysically, hashSet);
        }
    }

    public final PreprocHandler createEmptyPreprocHandler(CharSequence absPath) {
        StartEntry startEntry = new StartEntry(this.getFileSystem(), FileContainer.getFileKey(absPath, true).toString(), this.getUIDKey());
        return APTHandlersSupport.createEmptyPreprocHandler((StartEntry)startEntry);
    }

    protected final PreprocHandler createPreprocHandler(NativeFileItem nativeFile) {
        assert (nativeFile != null);
        PPMacroMap macroMap = this.getMacroMap(nativeFile);
        PPIncludeHandler inclHandler = this.getIncludeHandler(nativeFile);
        return APTHandlersSupport.createPreprocHandler((PPMacroMap)macroMap, (PPIncludeHandler)inclHandler, (boolean)this.isSourceFile(nativeFile), (CharSequence)nativeFile.getLanguage().toString(), (CharSequence)nativeFile.getLanguageFlavor().toString());
    }

    private PPIncludeHandler getIncludeHandler(NativeFileItem nativeFile) {
        if (!this.isSourceFile(nativeFile)) {
            nativeFile = DefaultFileItem.toDefault(nativeFile);
        }
        List origUserIncludePaths = nativeFile.getUserIncludePaths();
        if (TraceFlags.DUMP_NATIVE_FILE_ITEM_USER_INCLUDE_PATHS) {
            System.err.println("Item " + nativeFile.getAbsolutePath());
            for (FSPath path : origUserIncludePaths) {
                System.err.println("\tPath " + path.getPath());
            }
        }
        List origSysIncludePaths = nativeFile.getSystemIncludePaths();
        List userIncludePaths = this.userPathStorage.get((CharSequence)origUserIncludePaths.toString(), origUserIncludePaths);
        List sysIncludePaths = this.sysAPTData.getIncludes((CharSequence)origSysIncludePaths.toString(), origSysIncludePaths);
        List includeFileEntries = nativeFile.getIncludeFiles();
        String entryKey = FileContainer.getFileKey(nativeFile.getAbsolutePath(), true).toString();
        if (CndUtils.isDebugMode()) {
            FileSystem curPrjFS = this.getFileSystem();
            FileSystem nativeProjectFS = nativeFile.getNativeProject().getFileSystem();
            CndUtils.assertTrue((boolean)nativeProjectFS.equals(curPrjFS), (String)("File systems differ: incoming=" + nativeProjectFS + ";cur=" + curPrjFS));
        }
        StartEntry startEntry = new StartEntry(this.getFileSystem(), entryKey, this.getUIDKey());
        APTFileSearch searcher = null;
        UnitDescriptor unitDescriptor = this.getUnitDescriptor();
        if (unitDescriptor != null) {
            searcher = APTFileSearch.get((Key)KeyUtilities.createProjectKey(unitDescriptor));
        }
        return APTHandlersSupport.createIncludeHandler((StartEntry)startEntry, (List)sysIncludePaths, (List)userIncludePaths, (List)includeFileEntries, (APTFileSearch)searcher);
    }

    private PPMacroMap getMacroMap(NativeFileItem nativeFile) {
        if (!this.isSourceFile(nativeFile)) {
            nativeFile = DefaultFileItem.toDefault(nativeFile);
        }
        List userMacros = nativeFile.getUserMacroDefinitions();
        List sysMacros = nativeFile.getSystemMacroDefinitions();
        PPMacroMap map = APTHandlersSupport.createMacroMap((PPMacroMap)this.getSysMacroMap(sysMacros), (List)userMacros);
        return map;
    }

    protected final boolean isSourceFile(NativeFileItem nativeFile) {
        CsmFile.FileType type = Utils.getFileType(nativeFile);
        return FileImpl.isSourceFileType(type);
    }

    private PPMacroMap getSysMacroMap(List<String> sysMacros) {
        PPMacroMap map = this.sysAPTData.getMacroMap(sysMacros.toString(), sysMacros);
        return map;
    }

    final PreprocHandler getPreprocHandler(CharSequence absPath, PreprocessorStatePair statePair) {
        assert (statePair != null);
        return this.createPreprocHandlerFromState(absPath, statePair.state);
    }

    public final PreprocHandler createPreprocHandlerFromState(CharSequence absPath, PreprocHandler.State state) {
        Collection<PreprocHandler> out = this.createPreprocHandlerFromStates(Collections.singleton(state), absPath, Interrupter.DUMMY);
        return out.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PreprocHandler.State getFirstValidPreprocState(CharSequence fileKey) {
        FileContainer.FileEntry entry = this.getFileContainer().getEntry(fileKey);
        if (entry == null) {
            return null;
        }
        Object lock = entry.getLock();
        Collection<ProjectBase> dependentProjects = this.getDependentProjects();
        Object object = lock;
        synchronized (object) {
            for (PreprocessorStatePair pair : entry.getStatePairs()) {
                StartEntry startEntry = APTHandlersSupport.extractStartEntry((PreprocHandler.State)pair.state);
                if (ModelImpl.isClosedProject(startEntry.getStartFileProject())) continue;
                return pair.state;
            }
            Collection<FileContainer.FileEntry> includedFileEntries = this.getIncludedFileEntries(lock, fileKey, dependentProjects);
            for (FileContainer.FileEntry fileEntry : includedFileEntries) {
                Iterator<PreprocHandler.State> i$ = fileEntry.getPrerocStates().iterator();
                if (!i$.hasNext()) continue;
                PreprocHandler.State state = i$.next();
                return state;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Collection<PreprocessorStatePair> getPreprocessorStatePairs(FileImpl fileImpl) {
        Collection<PreprocessorStatePair> out;
        Object lock;
        CharSequence fileKey = FileContainer.getFileKey(fileImpl.getAbsolutePath(), false);
        FileContainer.FileEntry entry = this.getFileContainer().getEntry(fileKey);
        if (entry == null) {
            return Collections.emptyList();
        }
        Collection<ProjectBase> dependentProjects = this.getDependentProjects();
        Object object = lock = entry.getLock();
        synchronized (object) {
            Collection<PreprocessorStatePair> containerStatePairs = entry.getStatePairs();
            if (this.hasClosedStartEntry(lock, containerStatePairs)) {
                FileSystem fs = fileImpl.getFileSystem();
                Collection<FileContainer.FileEntry> includedFileEntries = this.getIncludedFileEntries(lock, fileKey, dependentProjects);
                FileContainer.FileEntry mergeEntry = FileContainer.createFileEntryForMerge(fs, fileKey);
                for (FileContainer.FileEntry fileEntry : includedFileEntries) {
                    for (PreprocessorStatePair pair : fileEntry.getStatePairs()) {
                        if (pair.pcState == FilePreprocessorConditionState.PARSING) continue;
                        this.updateFileEntryBasedOnIncludedStatePair(mergeEntry, pair, fileKey, fileImpl, null, null, new AtomicBoolean());
                    }
                }
                out = mergeEntry.getStatePairs();
            } else {
                out = containerStatePairs;
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<PreprocHandler> getPreprocHandlersForParse(FileImpl fileImpl, Interrupter interrupter) {
        Object lock;
        CharSequence fileKey = FileContainer.getFileKey(fileImpl.getAbsolutePath(), false);
        FileContainer.FileEntry entry = this.getFileContainer().getEntry(fileKey);
        if (entry == null) {
            return Collections.emptyList();
        }
        Collection<ProjectBase> dependentProjects = this.getDependentProjects();
        HashSet<PreprocHandler.State> states = new HashSet<PreprocHandler.State>();
        Object object = lock = entry.getLock();
        synchronized (object) {
            for (PreprocessorStatePair pair : entry.getStatePairs()) {
                StartEntry startEntry = APTHandlersSupport.extractStartEntry((PreprocHandler.State)pair.state);
                if (ModelImpl.isClosedProject(startEntry.getStartFileProject())) continue;
                states.add(pair.state);
            }
            Collection<FileContainer.FileEntry> includedFileEntries = this.getIncludedFileEntries(lock, fileKey, dependentProjects);
            for (FileContainer.FileEntry fileEntry : includedFileEntries) {
                for (PreprocessorStatePair pair : fileEntry.getStatePairs()) {
                    states.add(pair.state);
                }
            }
        }
        Collection<PreprocHandler> result = this.createPreprocHandlerFromStates(states, fileKey, interrupter);
        return result;
    }

    private boolean hasClosedStartEntry(Object lock, Collection<PreprocessorStatePair> containerStatePairs) {
        assert (Thread.holdsLock(lock)) : " must hold lock ";
        for (PreprocessorStatePair pair : containerStatePairs) {
            StartEntry startEntry = APTHandlersSupport.extractStartEntry((PreprocHandler.State)pair.state);
            if (!ModelImpl.isClosedProject(startEntry.getStartFileProject())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Collection<PreprocessorStatePair> getFileContainerStatePairsToDump(CharSequence absPath) {
        FileContainer.FileEntry entry = this.getFileContainer().getEntry(absPath);
        if (entry == null) {
            return Collections.emptyList();
        }
        Object object = entry.getLock();
        synchronized (object) {
            return entry.getStatePairs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<PreprocHandler> getFileContainerPreprocHandlersToDump(CharSequence absPath) {
        Collection<PreprocHandler.State> states;
        FileContainer.FileEntry entry = this.getFileContainer().getEntry(absPath);
        if (entry == null) {
            return Collections.emptyList();
        }
        Object object = entry.getLock();
        synchronized (object) {
            states = entry.getPrerocStates();
        }
        return this.createPreprocHandlerFromStates(states, absPath, Interrupter.DUMMY);
    }

    private Collection<PreprocHandler> createPreprocHandlerFromStates(Collection<PreprocHandler.State> states, CharSequence absPath, Interrupter interrupter) {
        ArrayList<PreprocHandler> result = new ArrayList<PreprocHandler>(states.size());
        for (PreprocHandler.State state : states) {
            PreprocHandler preprocHandler = this.createEmptyPreprocHandler(absPath);
            if (state != null) {
                if (state.isCleaned()) {
                    preprocHandler = this.restorePreprocHandler(absPath, preprocHandler, state, interrupter);
                } else {
                    if (TRACE_PP_STATE_OUT) {
                        System.err.println("copying state for " + absPath);
                    }
                    preprocHandler.setState(state);
                }
            }
            if (TRACE_PP_STATE_OUT) {
                System.err.printf("null state for %s, returning default one", absPath);
            }
            result.add(preprocHandler);
        }
        return result;
    }

    public final CsmFile testAPTParseFile(NativeFileItem item) {
        PreprocHandler preprocHandler = this.createPreprocHandler(item);
        return this.findFile(item.getAbsolutePath(), false, Utils.getFileType(item), preprocHandler, true, preprocHandler.getState(), item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final PreprocHandler.State setChangedFileState(NativeFileItem nativeFile) {
        FileContainer fileContainer = this.getFileContainer();
        FileContainer.FileEntry entry = fileContainer.getEntry(nativeFile.getAbsolutePath());
        if (entry == null) {
            return null;
        }
        PreprocHandler.State state = this.createPreprocHandler(nativeFile).getState();
        Object object = entry.getLock();
        synchronized (object) {
            entry.invalidateStates();
            entry.setState(state, FilePreprocessorConditionState.PARSING);
        }
        fileContainer.put();
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void invalidatePreprocState(CharSequence absPath) {
        FileContainer fileContainer = this.getFileContainer();
        Object stateLock = fileContainer.getLock(absPath);
        Collection<ProjectBase> dependentProjects = this.getDependentProjects();
        Object object = stateLock;
        synchronized (object) {
            fileContainer.invalidatePreprocState(absPath);
            this.invalidateIncludedPreprocState(stateLock, this, absPath);
            for (ProjectBase projectBase : dependentProjects) {
                projectBase.invalidateIncludedPreprocState(stateLock, this, absPath);
            }
        }
        this.putContainers(dependentProjects, fileContainer);
    }

    private void putContainers(Collection<ProjectBase> dependentProjects, FileContainer fileContainer) {
        this.includedFileContainer.putStorage(this);
        for (ProjectBase prj : dependentProjects) {
            prj.includedFileContainer.putStorage(this);
        }
        fileContainer.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void markAsParsingPreprocStates(FileImpl fileImpl) {
        CharSequence absPath = fileImpl.getAbsolutePath();
        FileContainer fileContainer = this.getFileContainer();
        FileContainer.FileEntry fileEntry = fileContainer.getEntry(absPath);
        if (fileEntry == null) {
            CndUtils.assertTrueInConsole((!fileImpl.isValid() ? 1 : 0) != 0, (String)"null entry for valid file ", (Object)fileImpl);
            return;
        }
        Object stateLock = fileEntry.getLock();
        Collection<ProjectBase> dependentProjects = this.getDependentProjects();
        Object object = stateLock;
        synchronized (object) {
            fileEntry.markAsParsingPreprocStates();
            Collection<FileContainer.FileEntry> entries = this.getIncludedFileEntries(stateLock, absPath, dependentProjects);
            for (FileContainer.FileEntry includedFileEntry : entries) {
                includedFileEntry.markAsParsingPreprocStates();
            }
        }
    }

    public final void debugInvalidateFiles() {
        Collection<FileImpl> allFileImpls = this.getAllFileImpls();
        for (FileImpl fileImpl : allFileImpls) {
            fileImpl.debugInvalidate();
        }
        this.getFileContainer().debugClearState();
        this.includedFileContainer.debugClearState();
        for (ProjectBase lib : this.getLibraries()) {
            lib.debugInvalidateFiles();
        }
    }

    public final FileImpl prepareIncludedFile(ProjectBase startProject, CharSequence file, PreprocHandler preprocHandler) {
        assert (preprocHandler != null) : "null preprocHandler for " + file;
        if (this.isDisposing() || startProject.isDisposing()) {
            return null;
        }
        if (!CsmModelAccessor.isModelAlive()) {
            if (TraceFlags.TRACE_VALIDATION || TraceFlags.TRACE_MODEL_STATE) {
                System.err.printf("prepareIncludedFile: %s file [%s] is interrupted on closing model%n", file, this.getName());
            }
            return null;
        }
        FileImpl csmFile = this.findFile(file, true, CsmFile.FileType.HEADER_FILE, preprocHandler, false, null, null);
        return csmFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean checkIfFileWasIncludedBeforeWithBetterOrEqualContent(FileImpl preIncludedFile, PreprocHandler ppPreIncludeHandler) {
        CharSequence path = preIncludedFile.getAbsolutePath();
        FileContainer.FileEntry entry = this.getFileContainer().getEntry(path);
        if (entry == null) {
            this.entryNotFoundMessage(path);
            return true;
        }
        Object object = entry.getLock();
        synchronized (object) {
            for (PreprocessorStatePair keptPair : entry.getStatePairs()) {
                if (!keptPair.pcState.isAllIncluded() || !keptPair.state.isCompileContext() || !keptPair.state.isCompileContext()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postIncludeFile(ProjectBase startProject, FileImpl csmFile, CharSequence file, PreprocessorStatePair newStatePair, APTFileCacheEntry aptCacheEntry) {
        boolean thisProjectUpdateResult = false;
        boolean startProjectUpdateResult = false;
        try {
            if (this.isDisposing() || startProject.isDisposing()) {
                return;
            }
            FileContainer.FileEntry entry = this.getFileContainer().getEntry(csmFile.getAbsolutePath());
            if (entry == null) {
                this.entryNotFoundMessage(file);
                return;
            }
            Object object = entry.getLock();
            synchronized (object) {
                AtomicBoolean newStateFoundInStartProject = new AtomicBoolean();
                ArrayList<PreprocHandler.State> statesToParse = new ArrayList<PreprocHandler.State>(4);
                startProjectUpdateResult = startProject.updateFileEntryForIncludedFile(entry, this, file, csmFile, newStatePair, newStateFoundInStartProject);
                statesToParse.add(newStatePair.state);
                AtomicBoolean clean = new AtomicBoolean(false);
                AtomicBoolean newStateFoundInFileContainer = new AtomicBoolean();
                thisProjectUpdateResult = this.updateFileEntryBasedOnIncludedStatePair(entry, newStatePair, file, csmFile, clean, statesToParse, newStateFoundInFileContainer);
                if (thisProjectUpdateResult && !startProjectUpdateResult && !newStateFoundInStartProject.get()) {
                    CndUtils.assertTrueInConsole((boolean)false, (String)(" this project " + this + " thinks that new state for " + file + " is the best but start project does not take it " + startProject));
                }
                if (thisProjectUpdateResult && !this.isDisposing() && !startProject.isDisposing()) {
                    assert (!APTTraceFlags.USE_CLANK || aptCacheEntry == null) : "aptCacheEntry must not be used in Clank Mode";
                    if (aptCacheEntry != null) {
                        csmFile.setAPTCacheEntry(newStatePair.state, aptCacheEntry, clean.get());
                    }
                    if (!TraceFlags.PARSE_HEADERS_WITH_SOURCES) {
                        if (APTTraceFlags.USE_CLANK) {
                            for (int i = 0; i < statesToParse.size(); ++i) {
                                PreprocHandler.State ppState = (PreprocHandler.State)statesToParse.get(i);
                                PreprocHandler.State cacheReady = APTHandlersSupport.preparePreprocStateCachesIfPossible((PreprocHandler.State)ppState);
                                statesToParse.set(i, cacheReady);
                            }
                        }
                        ParserQueue.instance().add(csmFile, statesToParse, ParserQueue.Position.HEAD, clean.get(), clean.get() ? ParserQueue.FileAction.MARK_REPARSE : ParserQueue.FileAction.MARK_MORE_PARSE);
                    }
                }
            }
        }
        finally {
            if (thisProjectUpdateResult) {
                this.getFileContainer().put();
            }
            if (startProjectUpdateResult) {
                startProject.putIncludedFileStorage(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<FileImpl> checkLibrariesAfterRestore() {
        HashSet<CharSequence> filesToReparseLibs = new HashSet<CharSequence>(1024);
        Collection libraries = this.getLibraries();
        for (CsmProject lib : libraries) {
            ProjectBase libProject = (ProjectBase)lib;
            IncludedFileContainer.Storage libStorage = this.getIncludedLibraryStorage(libProject);
            if (libStorage == null) {
                Utils.LOG.log(Level.INFO, "Can not find storage for dependent library {0}\n\tinside project {1}", new Object[]{libProject, this});
                continue;
            }
            Map<CharSequence, FileContainer.FileEntry> internalMap = libStorage.getInternalMap();
            for (Map.Entry<CharSequence, FileContainer.FileEntry> entry : internalMap.entrySet()) {
                List<PreprocessorStatePair> libCurrentPairs;
                CharSequence fileName = entry.getKey();
                FileContainer.FileEntry entryFromLibrary = libProject.getFileContainer().getEntry(fileName);
                if (entryFromLibrary != null) {
                    Object object = entryFromLibrary.getLock();
                    synchronized (object) {
                        libCurrentPairs = new ArrayList<PreprocessorStatePair>(entryFromLibrary.getStatePairs());
                    }
                } else {
                    libCurrentPairs = Collections.emptyList();
                }
                FileContainer.FileEntry includedEntry = entry.getValue();
                for (PreprocessorStatePair pair : includedEntry.getStatePairs()) {
                    boolean addToReparse = false;
                    if (!pair.state.isValid() || pair.pcState == FilePreprocessorConditionState.PARSING) {
                        addToReparse = true;
                    }
                    if (!addToReparse) {
                        ComparisonResult comResult = ProjectBase.fillStatesToKeepBasedOnPCState(pair.pcState, libCurrentPairs, new ArrayList<PreprocessorStatePair>());
                        boolean bl = addToReparse = comResult != ComparisonResult.DISCARD;
                    }
                    if (!addToReparse) continue;
                    StartEntry se = APTHandlersSupport.extractStartEntry((PreprocHandler.State)pair.state);
                    filesToReparseLibs.add(se.getStartFile());
                    includedEntry.invalidateStates();
                }
            }
        }
        HashSet<FileImpl> res = new HashSet<FileImpl>(filesToReparseLibs.size());
        for (CharSequence path : filesToReparseLibs) {
            FileImpl file = this.getFile(path, true);
            CndUtils.assertTrueInConsole((file != null ? 1 : 0) != 0, (String)"no fileImpl for ", (Object)path);
            if (file == null) continue;
            res.add(file);
        }
        return res;
    }

    private boolean updateFileEntryForIncludedFile(FileContainer.FileEntry entryToLockOn, ProjectBase includedProject, CharSequence includedFileKey, FileImpl includedFile, PreprocessorStatePair newStatePair, AtomicBoolean newStateFound) {
        boolean startProjectUpdateResult;
        FileContainer.FileEntry includedFileEntryFromStartProject = this.includedFileContainer.getOrCreateEntryForIncludedFile(entryToLockOn, includedProject, includedFile);
        if (includedFileEntryFromStartProject != null) {
            startProjectUpdateResult = this.updateFileEntryBasedOnIncludedStatePair(includedFileEntryFromStartProject, newStatePair, includedFileKey, includedFile, null, null, newStateFound);
        } else {
            newStateFound.set(false);
            startProjectUpdateResult = false;
        }
        return startProjectUpdateResult;
    }

    private void putIncludedFileStorage(ProjectBase includedProject) {
        boolean putStorage = this.includedFileContainer.putStorage(includedProject);
        assert (putStorage) : "no storage for " + this + " and included " + includedProject;
    }

    void invalidateLibraryStorage(CsmUID<CsmProject> libraryUID) {
        this.includedFileContainer.invalidateIncludeStorage(libraryUID);
    }

    IncludedFileContainer.Storage getIncludedLibraryStorage(ProjectBase includedProject) {
        return this.includedFileContainer.getStorageForProject(includedProject);
    }

    void prepareIncludeStorage(ProjectBase includedProject) {
        this.includedFileContainer.prepareIncludeStorage(includedProject);
    }

    Map<CsmUID<CsmProject>, Collection<PreprocessorStatePair>> getIncludedPreprocStatePairs(FileImpl fileToSearch) {
        return this.includedFileContainer.getPairsToDump(fileToSearch);
    }

    private void invalidateIncludedPreprocState(Object lock, ProjectBase includedFileOwner, CharSequence absPath) {
        this.includedFileContainer.invalidate(lock, includedFileOwner, absPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PreprocHandler.State> getIncludedPreprocStates(FileImpl impl) {
        Collection<ProjectBase> dependentProjects = this.getDependentProjects();
        CharSequence fileKey = FileContainer.getFileKey(impl.getAbsolutePath(), false);
        Object stateLock = this.getFileContainer().getLock(fileKey);
        ArrayList<PreprocHandler.State> states = new ArrayList<PreprocHandler.State>(dependentProjects.size() + 1);
        Object object = stateLock;
        synchronized (object) {
            Collection<FileContainer.FileEntry> entries = this.getIncludedFileEntries(stateLock, fileKey, dependentProjects);
            for (FileContainer.FileEntry fileEntry : entries) {
                states.addAll(fileEntry.getPrerocStates());
            }
        }
        return states;
    }

    private Collection<FileContainer.FileEntry> getIncludedFileEntries(Object stateLock, CharSequence fileKey, Collection<ProjectBase> dependentProjects) {
        assert (Thread.holdsLock(stateLock)) : " must hold state lock for " + fileKey;
        ArrayList<FileContainer.FileEntry> out = new ArrayList<FileContainer.FileEntry>(dependentProjects.size() + 1);
        FileContainer.FileEntry ownEntry = this.includedFileContainer.getIncludedFileEntry(stateLock, this, fileKey);
        if (ownEntry != null) {
            out.add(ownEntry);
        }
        for (ProjectBase dep : dependentProjects) {
            FileContainer.FileEntry depPrjEntry = dep.includedFileContainer.getIncludedFileEntry(stateLock, this, fileKey);
            if (depPrjEntry == null) continue;
            out.add(depPrjEntry);
        }
        return out;
    }

    private boolean updateFileEntryBasedOnIncludedStatePair(FileContainer.FileEntry entry, PreprocessorStatePair newStatePair, CharSequence file, FileImpl csmFile, AtomicBoolean cleanOut, List<PreprocHandler.State> statesToParse, AtomicBoolean newStateFound) {
        boolean clean;
        newStateFound.set(false);
        String prefix = statesToParse == null ? "lib update:" : "parsing:";
        PreprocHandler.State newState = newStatePair.state;
        FilePreprocessorConditionState pcState = newStatePair.pcState;
        ArrayList<PreprocessorStatePair> statesToKeep = new ArrayList<PreprocessorStatePair>(4);
        Collection<PreprocessorStatePair> entryStatePairs = entry.getStatePairs();
        ComparisonResult comparisonResult = ProjectBase.fillStatesToKeepBasedOnPPState(newState, entryStatePairs, statesToKeep, newStateFound);
        if (TRACE_FILE && FileImpl.traceFile(file)) {
            ProjectBase.traceIncludeStates(prefix + "comparison 2 " + (Object)((Object)comparisonResult), csmFile, newState, pcState, newStateFound.get(), null, statesToKeep);
        }
        if (comparisonResult == ComparisonResult.DISCARD) {
            if (TRACE_FILE && FileImpl.traceFile(file)) {
                ProjectBase.traceIncludeStates(prefix + "worse 2", csmFile, newState, pcState, false, null, statesToKeep);
            }
            return false;
        }
        if (comparisonResult == ComparisonResult.KEEP_WITH_OTHERS && newStateFound.get()) {
            if (TRACE_FILE && FileImpl.traceFile(file)) {
                ProjectBase.traceIncludeStates(prefix + "state is already here ", csmFile, newState, pcState, false, null, statesToKeep);
            }
            return false;
        }
        assert (comparisonResult != ComparisonResult.DISCARD);
        if (comparisonResult == ComparisonResult.REPLACE_OTHERS) {
            clean = true;
            CndUtils.assertTrueInConsole((boolean)statesToKeep.isEmpty(), (String)"states to keep must be empty 2");
            if (TRACE_FILE && FileImpl.traceFile(file)) {
                ProjectBase.traceIncludeStates(prefix + "best state", csmFile, newState, pcState, clean, statesToParse, statesToKeep);
            }
        } else {
            clean = false;
            comparisonResult = ProjectBase.fillStatesToKeepBasedOnPCState(pcState, new ArrayList<PreprocessorStatePair>(statesToKeep), statesToKeep);
            if (TRACE_FILE && FileImpl.traceFile(file)) {
                ProjectBase.traceIncludeStates(prefix + "pc state comparison " + (Object)((Object)comparisonResult), csmFile, newState, pcState, clean, statesToParse, statesToKeep);
            }
            switch (comparisonResult) {
                case REPLACE_OTHERS: {
                    CndUtils.assertTrueInConsole((boolean)statesToKeep.isEmpty(), (String)"states to keep must be empty 3");
                    clean = true;
                    break;
                }
                case KEEP_WITH_OTHERS: {
                    break;
                }
                case DISCARD: {
                    return false;
                }
                default: {
                    assert (false) : prefix + "unexpected comparison result: " + (Object)((Object)comparisonResult);
                    return false;
                }
            }
        }
        if (statesToParse != null && clean) {
            for (PreprocessorStatePair pair : statesToKeep) {
                if (pair.pcState == FilePreprocessorConditionState.PARSING) continue;
                statesToParse.add(pair.state);
            }
        }
        entry.setStates(statesToKeep, newStatePair);
        if (statesToParse != null && TRACE_FILE && FileImpl.traceFile(file) && (TraceFlags.TRACE_PC_STATE || TraceFlags.TRACE_PC_STATE_COMPARISION)) {
            ProjectBase.traceIncludeStates(prefix + "scheduling", csmFile, newState, pcState, clean, statesToParse, statesToKeep);
        }
        if (cleanOut != null) {
            cleanOut.set(clean);
        }
        return true;
    }

    private void entryNotFoundMessage(CharSequence file) {
        if (Utils.LOG.isLoggable(Level.INFO)) {
            Status st;
            StringBuilder buf = new StringBuilder("File container does not have file ");
            buf.append("[").append(file).append("]");
            if (this.getFileContainer() == FileContainer.empty()) {
                buf.append(" because file container is EMPTY.");
            } else {
                buf.append(".");
            }
            if (this.isDisposing()) {
                buf.append("\n\tIt is very strange but project is disposing.");
            }
            if (!this.isValid()) {
                buf.append("\n\tIt is very strange but project is invalid.");
            }
            if ((st = this.getStatus()) != null) {
                buf.append("\n\tProject ").append(this.toString()).append(" has status ").append((Object)st).append(".");
            }
            Utils.LOG.info(buf.toString());
        }
    }

    private static void traceIncludeStates(CharSequence title, FileImpl file, PreprocHandler.State newState, FilePreprocessorConditionState pcState, boolean clean, Collection<PreprocHandler.State> statesToParse, Collection<PreprocessorStatePair> statesToKeep) {
        StringBuilder sb = new StringBuilder();
        for (PreprocessorStatePair pair : statesToKeep) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(pair.pcState);
        }
        PreprocHandler preprocHandler = file.getProjectImpl(true).createEmptyPreprocHandler(file.getAbsolutePath());
        preprocHandler.setState(newState);
        System.err.printf("%s %s (1) %s%n\tfrom %s %n\t%s %s %n\t%s keeping [%s]%n", title, clean ? "reparse" : "  parse", file.getAbsolutePath(), APTHandlersSupport.extractStartEntry((PreprocHandler.State)newState).getStartFile(), TraceUtils.getPreprocStateString(preprocHandler.getState()), TraceUtils.getMacroString(preprocHandler, TraceFlags.logMacros), pcState, sb);
        if (statesToParse != null) {
            for (PreprocHandler.State state : statesToParse) {
                if (newState.equals(state)) continue;
                FilePreprocessorConditionState currPcState = null;
                for (PreprocessorStatePair pair : statesToKeep) {
                    if (!newState.equals(pair.state)) continue;
                    currPcState = pair.pcState;
                    break;
                }
                System.err.printf("%s %s (2) %s %n\tfrom %s%n\t valid %b context %b %s%n", title, "  parse", file.getAbsolutePath(), APTHandlersSupport.extractStartEntry((PreprocHandler.State)state).getStartFile(), state.isValid(), state.isCompileContext(), currPcState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setParsedPCState(FileImpl csmFile, PreprocHandler.State ppState, FilePreprocessorConditionState pcState) {
        boolean updateFileContainer;
        CharSequence fileKey = csmFile.getAbsolutePath();
        FileContainer.FileEntry entry = this.getFileContainer().getEntry(fileKey);
        if (entry == null) {
            this.entryNotFoundMessage(fileKey);
            return;
        }
        Object lock = entry.getLock();
        StartEntry startEntry = APTHandlersSupport.extractStartEntry((PreprocHandler.State)ppState);
        boolean updateStartProjectStorage = false;
        ProjectBase startProject = Utils.getStartProject(startEntry);
        Object object = lock;
        synchronized (object) {
            updateFileContainer = ProjectBase.updateFileEntryBasedOnParsedState(entry, fileKey, ppState, pcState);
            FileContainer.FileEntry includedEntry = startProject.includedFileContainer.getIncludedFileEntry(lock, this, fileKey);
            if (includedEntry != null) {
                updateStartProjectStorage = ProjectBase.updateFileEntryBasedOnParsedState(includedEntry, fileKey, ppState, pcState);
            }
        }
        if (updateFileContainer) {
            FileContainer fileContainer = this.getFileContainer();
            fileContainer.put();
        }
        if (updateStartProjectStorage) {
            startProject.includedFileContainer.putStorage(this);
        }
    }

    private static boolean updateFileEntryBasedOnParsedState(FileContainer.FileEntry entry, CharSequence fileKey, PreprocHandler.State ppState, FilePreprocessorConditionState pcState) {
        ArrayList<PreprocessorStatePair> statesToKeep = new ArrayList<PreprocessorStatePair>(4);
        Collection<PreprocessorStatePair> entryStatePairs = entry.getStatePairs();
        if (TraceFlags.TRACE_182342_BUG) {
            System.err.printf("setParsedPCState: original states for file: %s %n with new state: %s%n and pcState: %s%n", fileKey, ppState, pcState);
            if (entryStatePairs.isEmpty()) {
                System.err.println("NO ORIGINAL STATES");
            } else {
                int i = 0;
                for (PreprocessorStatePair preprocessorStatePair : entryStatePairs) {
                    System.err.printf("setParsedPCState: State %d from original %s%n", i++, preprocessorStatePair);
                }
            }
        }
        ArrayList<PreprocessorStatePair> copy = new ArrayList<PreprocessorStatePair>();
        boolean entryFound = false;
        for (PreprocessorStatePair pair : entryStatePairs) {
            assert (pair != null) : "can not be null element in " + entryStatePairs;
            assert (pair.state != null) : "state can not be null in pair " + pair + " for file " + fileKey;
            if (pair.pcState == FilePreprocessorConditionState.PARSING && APTHandlersSupport.equalsIgnoreInvalid((PreprocHandler.State)pair.state, (PreprocHandler.State)ppState)) {
                assert (!entryFound);
                entryFound = true;
                continue;
            }
            copy.add(pair);
        }
        if (TraceFlags.TRACE_182342_BUG) {
            System.err.printf("setParsedPCState: %s found PARSING entry for file: %s %n", entryFound ? "" : "NOT", fileKey);
            if (copy.isEmpty()) {
                System.err.println("NO KEPT STATES");
            } else {
                int i = 0;
                for (PreprocessorStatePair preprocessorStatePair : copy) {
                    System.err.printf("setParsedPCState: State %d from copy %s%n", i++, preprocessorStatePair);
                }
            }
        }
        if (entryFound) {
            ComparisonResult comparisonResult = ProjectBase.fillStatesToKeepBasedOnPCState(pcState, copy, statesToKeep);
            switch (comparisonResult) {
                case REPLACE_OTHERS: {
                    CndUtils.assertTrueInConsole((boolean)statesToKeep.isEmpty(), (String)"states to keep must be empty 3");
                    entry.setStates(statesToKeep, new PreprocessorStatePair(ppState, pcState));
                    break;
                }
                case KEEP_WITH_OTHERS: {
                    assert (!statesToKeep.isEmpty());
                    entry.setStates(statesToKeep, new PreprocessorStatePair(ppState, pcState));
                    break;
                }
                case DISCARD: {
                    assert (!copy.isEmpty());
                    entry.setStates(copy, null);
                    break;
                }
                default: {
                    assert (false) : "unexpected comparison result: " + (Object)((Object)comparisonResult);
                    break;
                }
            }
        }
        return entryFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyOnWaitParseLock() {
        Object object = this.waitParseLock;
        synchronized (object) {
            this.waitParseLock.notifyAll();
        }
    }

    public Iterator<CsmUID<CsmFile>> getFilteredFileUIDs(CsmSelect.NameAcceptor nameFilter) {
        FileContainer fileContainer = this.getFileContainer();
        Collection<CsmUID<CsmFile>> filesUID = fileContainer.getFilesUID();
        ArrayList<CsmUID<CsmFile>> out = new ArrayList<CsmUID<CsmFile>>(filesUID.size());
        for (CsmUID<CsmFile> fileUID : filesUID) {
            CharSequence fileName = FileInfoQueryImpl.getFileName(fileUID);
            if (!nameFilter.accept(fileName)) continue;
            out.add(fileUID);
        }
        return out.iterator();
    }

    protected abstract SourceRootContainer getProjectRoots();

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    private static ComparisonResult fillStatesToKeepBasedOnPPState(PreprocHandler.State newState, Collection<PreprocessorStatePair> oldStates, Collection<PreprocessorStatePair> statesToKeep, AtomicBoolean newStateFound) {
        if (newState == null || !newState.isValid()) {
            return ComparisonResult.DISCARD;
        }
        statesToKeep.clear();
        newStateFound.set(false);
        ComparisonResult result = ComparisonResult.KEEP_WITH_OTHERS;
        for (PreprocessorStatePair pair : oldStates) {
            if (newState.equals(pair.state)) {
                assert (!newStateFound.get());
                newStateFound.set(true);
                continue;
            }
            boolean keep = false;
            if (pair.state != null && pair.state.isValid()) {
                if (pair.state.isCompileContext()) {
                    keep = true;
                    if (!newState.isCompileContext()) {
                        return ComparisonResult.DISCARD;
                    }
                } else {
                    boolean bl = keep = !newState.isCompileContext();
                }
            }
            if (keep) {
                if (!pair.state.isCleaned()) {
                    pair = new PreprocessorStatePair(APTHandlersSupport.createCleanPreprocState((PreprocHandler.State)pair.state), pair.pcState);
                }
                statesToKeep.add(pair);
                result = ComparisonResult.KEEP_WITH_OTHERS;
                continue;
            }
            CndUtils.assertTrueInConsole((statesToKeep.isEmpty() || !newState.isCompileContext() ? 1 : 0) != 0, (String)"states to keep must be empty for new compile context entry");
            result = statesToKeep.isEmpty() ? ComparisonResult.REPLACE_OTHERS : ComparisonResult.KEEP_WITH_OTHERS;
        }
        if (result == ComparisonResult.REPLACE_OTHERS) {
            CndUtils.assertTrueInConsole((boolean)statesToKeep.isEmpty(), (String)"states to keep must be empty ");
        }
        return result;
    }

    private static ComparisonResult fillStatesToKeepBasedOnPCState(FilePreprocessorConditionState pcState, List<PreprocessorStatePair> oldStates, List<PreprocessorStatePair> statesToKeep) {
        boolean isSuperset = true;
        statesToKeep.clear();
        int size = oldStates.size();
        for (int i = 0; i < size; ++i) {
            PreprocessorStatePair old = oldStates.get(i);
            if (old.pcState == FilePreprocessorConditionState.PARSING) {
                isSuperset = false;
                if (!old.state.isCleaned()) {
                    old = new PreprocessorStatePair(APTHandlersSupport.createCleanPreprocState((PreprocHandler.State)old.state), old.pcState);
                }
                statesToKeep.add(old);
                continue;
            }
            if (old.pcState.isBetterOrEqual(pcState)) {
                return ComparisonResult.DISCARD;
            }
            if (pcState.isBetterOrEqual(old.pcState)) continue;
            isSuperset = false;
            if (!old.state.isCleaned()) {
                old = new PreprocessorStatePair(APTHandlersSupport.createCleanPreprocState((PreprocHandler.State)old.state), old.pcState);
            }
            statesToKeep.add(old);
        }
        if (isSuperset) {
            assert (statesToKeep.isEmpty()) : "should be empty, but it is: " + Arrays.toString(statesToKeep.toArray());
            return ComparisonResult.REPLACE_OTHERS;
        }
        return ComparisonResult.KEEP_WITH_OTHERS;
    }

    public ProjectBase findFileProject(CharSequence absPath, boolean waitFilesCreated) {
        if (waitFilesCreated) {
            this.ensureFilesCreated();
        }
        if (this.getFileUID(absPath, false) != null) {
            return this;
        }
        for (CsmProject prj : this.getLibraries()) {
            if (waitFilesCreated) {
                ((ProjectBase)prj).ensureFilesCreated();
            }
            if (((ProjectBase)prj).getFileUID(absPath, false) == null) continue;
            return (ProjectBase)prj;
        }
        return null;
    }

    public ProjectBase findFileProject(FSPath fsPath, boolean waitFilesCreated) {
        if (this.getFileSystem() == fsPath.getFileSystem()) {
            if (waitFilesCreated) {
                this.ensureFilesCreated();
            }
            if (this.getFileUID(fsPath.getPath(), false) != null) {
                return this;
            }
        }
        for (CsmProject prj : this.getLibraries()) {
            if (((ProjectBase)prj).getFileSystem() != fsPath.getFileSystem()) continue;
            if (waitFilesCreated) {
                ((ProjectBase)prj).ensureFilesCreated();
            }
            if (((ProjectBase)prj).getFileUID(fsPath.getPath(), false) == null) continue;
            return (ProjectBase)prj;
        }
        return null;
    }

    public final boolean isMySource(CharSequence includePath) {
        return this.getProjectRoots().isMySource(includePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFileItemsRemoved(List<NativeFileItem> items) {
        CndUtils.assertTrueInConsole((!this.isArtificial() ? 1 : 0) != 0, (String)"library is not expected here ", (Object)this);
        try {
            ParserQueue.instance().onStartAddingProjectFiles(this);
            this.checkForRemoved();
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFileItemRenamed(String oldPath, NativeFileItem newFileIetm) {
        CndUtils.assertTrueInConsole((!this.isArtificial() ? 1 : 0) != 0, (String)"library is not expected here ", (Object)this);
        try {
            ParserQueue.instance().onStartAddingProjectFiles(this);
            this.checkForRemoved();
            this.onFileItemsAdded(Collections.singletonList(newFileIetm));
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFileItemsAdded(List<NativeFileItem> items) {
        CndUtils.assertTrueInConsole((!this.isArtificial() ? 1 : 0) != 0, (String)"library is not expected here ", (Object)this);
        try {
            ParserQueue.instance().onStartAddingProjectFiles(this);
            for (NativeFileItem item : items) {
                PreprocHandler ppHandler;
                assert (item != null && item.getFileObject() != null);
                if (!Utils.acceptNativeItem(item) || (ppHandler = this.createPreprocHandler(item)) == null) continue;
                this.findFile(item.getAbsolutePath(), true, Utils.getFileType(item), ppHandler, true, ppHandler.getState(), item);
            }
        }
        finally {
            Notificator.instance().flush();
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    public void onFileItemsPropertyChanged(List<NativeFileItem> items, boolean invalidateLibs) {
        CndUtils.assertTrueInConsole((!this.isArtificial() ? 1 : 0) != 0, (String)"library is not expected here ", (Object)this);
        if (!this.isValid()) {
            return;
        }
        if (items.size() > 0) {
            DeepReparsingUtils.reparseOnPropertyChanged(items, this, invalidateLibs);
        }
    }

    protected abstract ParserQueue.Position getIncludedFileParserQueuePosition();

    public abstract NativeFileItem getNativeFileItem(CsmUID<CsmFile> var1);

    protected abstract void putNativeFileItem(CsmUID<CsmFile> var1, NativeFileItem var2);

    protected abstract NativeFileItem removeNativeFileItem(CsmUID<CsmFile> var1);

    protected abstract void clearNativeFileContainer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFileImplRemoved(Collection<FileImpl> physicallyRemoved, Collection<FileImpl> excluded) {
        try {
            DeepReparsingUtils.reparseOnRemoved(this.removeFileImplsFromProjectInternal(physicallyRemoved), this.removeFileImplsFromProjectInternal(excluded), this);
        }
        finally {
            Notificator.instance().flush();
        }
    }

    private LinkedList<FileImpl> removeFileImplsFromProjectInternal(Collection<FileImpl> files) {
        LinkedList<FileImpl> removedFromProject = new LinkedList<FileImpl>();
        for (FileImpl impl : files) {
            if (impl == null) continue;
            this.removeNativeFileItem(impl.getUID());
            if (this.removeFile(impl.getAbsolutePath())) {
                removedFromProject.addLast(impl);
                impl.dispose();
                FileBuffer buf = impl.getBuffer();
                APTDriver.invalidateAPT((APTFileBuffer)buf);
                ClankDriver.invalidate((APTFileBuffer)buf);
                APTFileCacheManager.getInstance((FileSystem)buf.getFileSystem()).invalidate(buf.getAbsolutePath());
                ParserQueue.instance().remove(impl);
                if (CndTraceFlags.TEXT_INDEX) {
                    CndTextIndex.remove((CndTextIndexKey)impl.getTextIndexKey());
                }
            }
            ProgressSupport.instance().fireFileRemoved(impl);
        }
        return removedFromProject;
    }

    public final void onFileObjectExternalCreate(FileObject file) {
        this.onFileObjectExternalCreate(Arrays.asList(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFileObjectExternalCreate(Collection<FileObject> files) {
        try {
            ParserQueue.instance().onStartAddingProjectFiles(this);
            CndFileUtils.clearFileExistenceCache();
            ArrayList<NativeFileItem> nativeFileItems = new ArrayList<NativeFileItem>();
            if (this.getPlatformProject() instanceof NativeProject) {
                NativeProject prj = (NativeProject)this.getPlatformProject();
                for (FileObject fo : files) {
                    NativeFileItem item;
                    if (prj == null || (item = prj.findFileItem(fo)) == null) continue;
                    nativeFileItems.add(item);
                }
            }
            if (!nativeFileItems.isEmpty()) {
                this.onFileItemsAdded(nativeFileItems);
            }
            DeepReparsingUtils.reparseOnAdded(nativeFileItems, this);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    public final void onFileImplExternalChange(FileImpl file) {
        DeepReparsingUtils.tryPartialReparseOnChangedFile(this, file);
    }

    public final CsmFile findFile(Object absolutePathOrNativeFileItem, boolean createIfPossible, boolean snapShot) {
        CsmFile res = null;
        if (absolutePathOrNativeFileItem instanceof FSPath) {
            FSPath fsPath = (FSPath)absolutePathOrNativeFileItem;
            if (this.getFileSystem() != fsPath.getFileSystem()) {
                return null;
            }
            absolutePathOrNativeFileItem = fsPath.getPath();
        }
        if (absolutePathOrNativeFileItem instanceof CharSequence) {
            res = this.findFileByPath((CharSequence)absolutePathOrNativeFileItem, createIfPossible);
        } else if (absolutePathOrNativeFileItem instanceof NativeFileItem) {
            res = this.findFileByItem((NativeFileItem)absolutePathOrNativeFileItem, createIfPossible);
        }
        if (snapShot && res instanceof FileImpl) {
            res = ((FileImpl)res).getSnapshot();
        }
        return res;
    }

    final int getFileContainerSize() {
        return this.getFileContainer().getSize();
    }

    private CsmFile findFileByPath(CharSequence absolutePath, boolean createIfPossible) {
        if (!this.isValid()) {
            return null;
        }
        absolutePath = CndFileUtils.normalizeAbsolutePath((FileSystem)this.fileSystem, (String)absolutePath.toString());
        PreprocHandler preprocHandler = null;
        if (this.getFileContainer().getEntry(absolutePath) == null) {
            NativeProject prj;
            if (!createIfPossible) {
                return null;
            }
            NativeFileItem nativeFile = null;
            if (this.getPlatformProject() instanceof NativeProject && (prj = (NativeProject)this.getPlatformProject()) != null) {
                FileObject fo = CndFileUtils.toFileObject((FileSystem)prj.getFileSystem(), (CharSequence)absolutePath.toString());
                if (fo != null) {
                    nativeFile = prj.findFileItem(fo);
                }
                if (nativeFile == null) {
                    return null;
                }
                if (!Utils.acceptNativeItem(nativeFile)) {
                    return null;
                }
                preprocHandler = this.createPreprocHandler(nativeFile);
            }
            if (preprocHandler != null) {
                return this.findFile(absolutePath, false, CsmFile.FileType.UNDEFINED_FILE, preprocHandler, true, preprocHandler.getState(), nativeFile);
            }
        }
        return this.findFile(absolutePath, false, CsmFile.FileType.UNDEFINED_FILE, preprocHandler, true, null, null);
    }

    private CsmFile findFileByItem(NativeFileItem nativeFile, boolean createIfPossible) {
        if (!this.isValid()) {
            return null;
        }
        String file = nativeFile.getAbsolutePath();
        PreprocHandler preprocHandler = null;
        if (this.getFileContainer().getEntry(file) == null) {
            NativeProject prj;
            if (!createIfPossible || !Utils.acceptNativeItem(nativeFile)) {
                return null;
            }
            if (this.getPlatformProject() instanceof NativeProject && (prj = nativeFile.getNativeProject()) != null && nativeFile.getFileObject() != null && nativeFile.getFileObject().isValid()) {
                preprocHandler = this.createPreprocHandler(nativeFile);
            }
            if (preprocHandler != null) {
                return this.findFile(file, false, CsmFile.FileType.UNDEFINED_FILE, preprocHandler, true, preprocHandler.getState(), nativeFile);
            }
        }
        return this.findFile(file, false, CsmFile.FileType.UNDEFINED_FILE, preprocHandler, true, null, null);
    }

    protected final FileImpl findFile(CharSequence absPath, boolean treatSymlinkAsSeparateFile, CsmFile.FileType fileType, PreprocHandler preprocHandler, boolean scheduleParseIfNeed, PreprocHandler.State initial, NativeFileItem nativeFileItem) {
        FileImpl impl = this.getFile(absPath, treatSymlinkAsSeparateFile);
        if (impl == null) {
            CndUtils.assertTrueInConsole((preprocHandler != null ? 1 : 0) != 0, (String)"null preprocHandler");
            if (preprocHandler == null) {
                PreprocHandler.State state = this.getFirstValidPreprocState(absPath);
                preprocHandler = this.createPreprocHandlerFromState(absPath, state);
            }
            impl = this.findFileImpl(absPath, treatSymlinkAsSeparateFile, fileType, preprocHandler, scheduleParseIfNeed, initial, nativeFileItem);
        }
        return impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileImpl findFileImpl(CharSequence absPath, boolean treatSymlinkAsSeparateFile, CsmFile.FileType fileType, PreprocHandler preprocHandler, boolean scheduleParseIfNeed, PreprocHandler.State initial, NativeFileItem nativeFileItem) {
        FileImpl impl;
        boolean create = false;
        Object object = this.fileContainerLock;
        synchronized (object) {
            impl = this.getFile(absPath, treatSymlinkAsSeparateFile);
            if (impl == null) {
                create = true;
            }
        }
        if (create) {
            assert (preprocHandler != null) : "null preprocHandler for " + absPath;
            FileObject fo = CndFileUtils.toFileObject((FileSystem)this.fileSystem, (CharSequence)absPath);
            CndUtils.assertTrueInConsole((fo != null ? 1 : 0) != 0, (String)"file object not found ", (Object)absPath);
            if (fo == null) {
                return null;
            }
            FileBuffer fileBuffer = ModelSupport.createFileBuffer(fo);
            Object object2 = this.fileContainerLock;
            synchronized (object2) {
                impl = this.getFile(absPath, treatSymlinkAsSeparateFile);
                if (impl == null) {
                    try {
                        impl = new FileImpl(fileBuffer, this, fileType, nativeFileItem);
                        if (nativeFileItem != null) {
                            this.putNativeFileItem(impl.getUID(), nativeFileItem);
                        }
                        this.putFile(impl, initial);
                        if (scheduleParseIfNeed) {
                            PreprocHandler.State ppState = preprocHandler.getState();
                            ParserQueue.instance().add(impl, ppState, ParserQueue.Position.TAIL);
                        }
                    }
                    finally {
                        Notificator.instance().flush();
                    }
                }
            }
        }
        if (initial == null) {
            if (fileType == CsmFile.FileType.SOURCE_FILE && !impl.isSourceFile()) {
                impl.setSourceFile();
            } else if (fileType == CsmFile.FileType.HEADER_FILE && !impl.isHeaderFile()) {
                impl.setHeaderFile();
            }
        }
        return impl;
    }

    protected final FileImpl createOrFindFileImpl(FileBuffer buf, NativeFileItem nativeFile) {
        return this.createOrFindFileImpl(buf, nativeFile, Utils.getFileType(nativeFile)).fileImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileAndHandler createOrFindFileImpl(FileBuffer buf, NativeFileItem nativeFile, CsmFile.FileType fileType) {
        PreprocHandler preprocHandler = null;
        CharSequence absPath = buf.getAbsolutePath();
        FileImpl impl = this.getFile(absPath, true);
        CsmUID<CsmFile> aUid = null;
        if (impl == null) {
            preprocHandler = this.createPreprocHandler(nativeFile);
            Object object = this.fileContainerLock;
            synchronized (object) {
                impl = this.getFile(absPath, true);
                if (impl == null) {
                    assert (preprocHandler != null);
                    impl = new FileImpl(buf, this, fileType, nativeFile);
                    this.putFile(impl, preprocHandler.getState());
                } else {
                    aUid = impl.getUID();
                    impl.attachToProject(this);
                }
            }
        } else {
            aUid = impl.getUID();
            impl.attachToProject(this);
        }
        if (aUid != null) {
            this.putNativeFileItem(aUid, nativeFile);
        }
        return new FileAndHandler(impl, preprocHandler);
    }

    public final FileImpl getFile(CharSequence absPath, boolean treatSymlinkAsSeparateFile) {
        return this.getFileContainer().getFile(absPath, treatSymlinkAsSeparateFile);
    }

    public final CsmUID<CsmFile> getFileUID(CharSequence absPath, boolean treatSymlinkAsSeparateFile) {
        return this.getFileContainer().getFileUID(absPath, treatSymlinkAsSeparateFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean removeFile(CharSequence file) {
        FileContainer fileContainer = this.getFileContainer();
        FileContainer.FileEntry entry = fileContainer.getEntry(file);
        if (entry == null) {
            return false;
        }
        assert (file.toString().contentEquals(UIDUtilities.getFileName(entry.getTestFileUID())));
        Object lock = entry.getLock();
        Collection<ProjectBase> dependentProjects = this.getDependentProjects();
        Object object = lock;
        synchronized (object) {
            this.includedFileContainer.remove(lock, this, file);
            for (ProjectBase prj : dependentProjects) {
                prj.includedFileContainer.remove(lock, this, file);
            }
            Object object2 = this.fileContainerLock;
            synchronized (object2) {
                fileContainer.removeFile(file);
            }
        }
        this.putContainers(dependentProjects, fileContainer);
        return true;
    }

    private void putFile(FileImpl impl, PreprocHandler.State state) {
        assert (Thread.holdsLock(this.fileContainerLock));
        if (state != null && !state.isCleaned()) {
            state = APTHandlersSupport.createCleanPreprocState((PreprocHandler.State)state);
        }
        this.getFileContainer().putFile(impl, state);
    }

    protected abstract Collection<Key> getLibrariesKeys();

    public List<CsmProject> getLibraries() {
        int i;
        int size;
        ArrayList<CsmProject> res = new ArrayList<CsmProject>();
        if (this.platformProject instanceof NativeProject) {
            List dependences = ((NativeProject)this.platformProject).getDependences();
            size = dependences.size();
            for (i = 0; i < size; ++i) {
                NativeProject nativeLib = (NativeProject)dependences.get(i);
                ProjectBase prj = this.model.findProject(nativeLib);
                if (prj == null) continue;
                res.add(prj);
            }
        }
        if (!this.isArtificial()) {
            List<LibProjectImpl> libraries = this.getLibraryManager().getLibraries((ProjectImpl)this);
            size = libraries.size();
            for (i = 0; i < size; ++i) {
                res.add(libraries.get(i));
            }
        }
        return res;
    }

    public Collection<ProjectBase> getDependentProjects() {
        ArrayList<ProjectBase> res = new ArrayList<ProjectBase>();
        for (CsmProject prj : this.model.projects()) {
            if (!(prj instanceof ProjectBase) || !prj.getLibraries().contains(this)) continue;
            res.add((ProjectBase)prj);
        }
        return res;
    }

    public static CsmClass getDummyForUnresolved(CharSequence[] nameTokens, CsmOffsetable owner) {
        ProjectBase project;
        CsmFile file;
        if (owner != null && (file = owner.getContainingFile()) != null && (project = (ProjectBase)file.getProject()) != null) {
            return project.getDummyForUnresolved(nameTokens, file, owner.getStartOffset());
        }
        return null;
    }

    private CsmClass getDummyForUnresolved(CharSequence[] nameTokens, CsmFile file, int offset) {
        if (Diagnostic.needStatistics()) {
            Diagnostic.onUnresolvedError(nameTokens, file, offset);
        }
        return this.getUnresolved().getDummyForUnresolved(nameTokens);
    }

    public final CsmClass getDummyForUnresolved(CharSequence name) {
        return this.getUnresolved().getDummyForUnresolved(name);
    }

    public final CsmNamespace getUnresolvedNamespace() {
        return this.getUnresolved().getUnresolvedNamespace();
    }

    public final CsmFile getUnresolvedFile() {
        return this.getUnresolved().getUnresolvedFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unresolved getUnresolved() {
        Object object = this.unresolvedLock;
        synchronized (object) {
            if (this.unresolved == null) {
                this.unresolved = new Unresolved(this);
            }
            return this.unresolved;
        }
    }

    public final boolean isValid() {
        return this.platformProject != null && !this.isDisposing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisposed() {
        this.disposing.set(true);
        Object object = this.initializationTaskLock;
        synchronized (object) {
            if (this.initializationTask != null) {
                this.initializationTask.cancel();
                this.initializationTask = null;
            }
        }
        this.unregisterProjectListeners();
        ParserQueue.instance().removeAll(this);
    }

    public final boolean isDisposing() {
        return this.disposing.get();
    }

    AtomicBoolean getDisposingFlag() {
        return this.disposing;
    }

    protected void onDispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose(boolean cleanPersistent) {
        long time = 0L;
        if (TraceFlags.TIMING) {
            System.err.printf("%n%nProject %s: disposing...%n", this.name);
            time = System.currentTimeMillis();
        }
        this.setDisposed();
        try {
            this.disposeLock.writeLock().lock();
            if (this.platformProject != null) {
                if (CndUtils.isDebugMode()) {
                    this.checkConsistency(false);
                }
                this.getUnresolved().dispose();
                RepositoryUtils.closeUnit(this.getUID(), this.getRequiredUnits(), cleanPersistent);
                this.onDispose();
                this.platformProject = null;
                this.unresolved = null;
                this.uid = null;
            }
        }
        finally {
            this.disposeLock.writeLock().unlock();
        }
        if (TraceFlags.TIMING) {
            time = System.currentTimeMillis() - time;
            System.err.printf("Project %s: disposing took %d ms%n", this.name, time);
        }
    }

    private Set<Integer> getRequiredUnits() {
        HashSet<Integer> requiredUnits = new HashSet<Integer>();
        for (Key dependent : this.getLibrariesKeys()) {
            requiredUnits.add(dependent.getUnitId());
        }
        return requiredUnits;
    }

    private NamespaceImpl _getGlobalNamespace() {
        NamespaceImpl ns = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(this.globalNamespaceUID);
        if (ns == null && this.preventMultiplyDiagnosticExceptionsGlobalNamespace < 5) {
            DiagnosticExceptoins.registerIllegalRepositoryStateException("Failed to get global namespace by key ", this.globalNamespaceUID);
            ++this.preventMultiplyDiagnosticExceptionsGlobalNamespace;
        }
        return ns != null ? ns : this.FAKE_GLOBAL_NAMESPACE;
    }

    private NamespaceImpl _getNamespace(CharSequence key) {
        key = CharSequences.create((CharSequence)key);
        CsmUID<CsmNamespace> nsUID = this.namespaces.get(key);
        NamespaceImpl ns = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(nsUID);
        return ns;
    }

    private void _registerNamespace(NamespaceImpl ns) {
        assert (ns != null);
        CharSequence key = ns.getQualifiedName();
        assert (CharSequences.isCompact((CharSequence)key));
        CsmUID<NamespaceImpl> nsUID = RepositoryUtils.put(ns);
        assert (nsUID != null);
        CsmUID<NamespaceImpl> prev = this.namespaces.put(key, nsUID);
        CndUtils.assertTrueInConsole((prev == null || prev == nsUID ? 1 : 0) != 0, (String)("Why replacing " + prev + " by " + nsUID + "?"));
    }

    private void _unregisterNamespace(NamespaceImpl ns) {
        assert (ns != null);
        assert (!ns.isGlobal());
        CharSequence key = ns.getQualifiedName();
        assert (CharSequences.isCompact((CharSequence)key));
        CsmUID<CsmNamespace> nsUID = this.namespaces.remove(key);
        assert (nsUID != null);
        RepositoryUtils.remove(nsUID, ns);
    }

    protected final ModelImpl getModel() {
        return this.model;
    }

    public void onFileEditStart(FileBuffer buf, NativeFileItem nativeFile) {
    }

    public void onFileEditEnd(FileBuffer buf, NativeFileItem nativeFile, boolean undo) {
    }

    public void onSnapshotChanged(FileImpl file, Snapshot snapshot) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CsmUID<CsmProject> getUID() {
        CsmUID<CsmProject> out = this.uid;
        if (out == null) {
            Object object = this.uidLock;
            synchronized (object) {
                if (this.uid == null) {
                    this.uid = out = UIDUtilities.createProjectUID(this);
                    assert (UIDUtilities.getProjectID(this.uid) == this.unitId) : this.unitId + " vs. " + UIDUtilities.getProjectID(this.uid) + " " + this.uid;
                }
            }
        }
        return out;
    }

    public final Key getUIDKey() {
        CsmUID<CsmProject> uid = this.getUID();
        assert (uid instanceof KeyHolder) : "project UID should be key based ";
        return ((KeyHolder)uid).getKey();
    }

    public boolean isStable(CsmFile skipFile) {
        if (this.status == Status.Ready && !this.isDisposing()) {
            return !ParserQueue.instance().hasPendingProjectRelatedWork(this, (FileImpl)skipFile);
        }
        return false;
    }

    public final void onParseFinish() {
        this.onParseFinishImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onParseFinishImpl(boolean libsAlreadyParsed) {
        FileImpl.incParseCount();
        Object object = this.waitParseLock;
        synchronized (object) {
            this.waitParseLock.notifyAll();
        }
        try {
            this.disposeLock.readLock().lock();
            if (!this.isDisposing() && !this.hasEditedFiles()) {
                new FakeRegistrationWorker(this, this.disposing).fixFakeRegistration(libsAlreadyParsed);
            }
        }
        catch (Exception e) {
            DiagnosticExceptoins.register(e);
        }
        finally {
            this.disposeLock.readLock().unlock();
            ProjectBase.checkStates(this, libsAlreadyParsed);
            if (!libsAlreadyParsed) {
                ParseFinishNotificator.onParseFinish(this);
            }
        }
        if (TraceFlags.PARSE_STATISTICS) {
            ParseStatistics.getInstance().printResults(this);
            ParseStatistics.getInstance().clear(this);
        }
    }

    private static void checkStates(ProjectBase prj, boolean libsAlreadyParsed) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void trackFakeFunctionData(CsmUID<CsmFile> fileUID, CsmUID<FunctionImplEx<?>> funUID, Pair<AST, MutableDeclarationsContainer> funData) {
        Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, Pair<AST, MutableDeclarationsContainer>>> map = this.filesFakeFuncData;
        synchronized (map) {
            Map<CsmUID<FunctionImplEx<?>>, Pair<AST, MutableDeclarationsContainer>> fileData = this.filesFakeFuncData.get(fileUID);
            if (fileData == null) {
                fileData = new HashMap();
                if (funData != null) {
                    this.filesFakeFuncData.put(fileUID, fileData);
                }
            }
            if (funData == null) {
                fileData.remove(funUID);
            } else {
                fileData.put(funUID, funData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cleanAllFakeFunctionAST(CsmUID<CsmFile> fileUID) {
        Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, Pair<AST, MutableDeclarationsContainer>>> map = this.filesFakeFuncData;
        synchronized (map) {
            this.filesFakeFuncData.remove(fileUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cleanAllFakeFunctionAST() {
        Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, Pair<AST, MutableDeclarationsContainer>>> map = this.filesFakeFuncData;
        synchronized (map) {
            this.filesFakeFuncData.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<AST, MutableDeclarationsContainer> getFakeFunctionData(CsmUID<CsmFile> fileUID, CsmUID<FunctionImplEx<?>> fakeUid) {
        Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, Pair<AST, MutableDeclarationsContainer>>> map = this.filesFakeFuncData;
        synchronized (map) {
            Map<CsmUID<FunctionImplEx<?>>, Pair<AST, MutableDeclarationsContainer>> fileDatas = this.filesFakeFuncData.get(fileUID);
            return fileDatas == null ? null : fileDatas.get(fakeUid);
        }
    }

    final void onLibParseFinish() {
        this.onParseFinishImpl(true);
    }

    public final Collection<CsmFile> getAllFiles() {
        return this.getFileContainer().getFiles();
    }

    public final Collection<CsmUID<CsmFile>> getAllFilesUID() {
        return this.getFileContainer().getFilesUID();
    }

    public final Collection<CsmUID<CsmFile>> getHeaderFilesUID() {
        ArrayList<CsmUID<CsmFile>> uids = new ArrayList<CsmUID<CsmFile>>();
        for (FileImpl file : this.getAllFileImpls()) {
            if (file.isSourceFile()) continue;
            uids.add(file.getUID());
        }
        return uids;
    }

    public final Collection<FileImpl> getAllFileImpls() {
        return this.getFileContainer().getFileImpls();
    }

    public final Collection<CsmFile> getSourceFiles() {
        ArrayList uids = new ArrayList();
        for (FileImpl file : this.getAllFileImpls()) {
            if (!file.isSourceFile()) continue;
            uids.add(file.getUID());
        }
        return new LazyCsmCollection(uids, TraceFlags.SAFE_UID_ACCESS);
    }

    public final Collection<CsmFile> getHeaderFiles() {
        return new LazyCsmCollection(this.getHeaderFilesUID(), TraceFlags.SAFE_UID_ACCESS);
    }

    public final long getMemoryUsageEstimation() {
        return this.getFileContainer().getSize();
    }

    public final String toString() {
        return this.getName().toString() + ' ' + this.getClass().getName() + " @" + this.hashCode() + ":" + System.identityHashCode(this);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = super.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public StartEntryInfo getStartEntryInfo(PreprocHandler fallbackHandler, PreprocHandler.State state) {
        NativeFileItem nativeFile;
        FileImpl csmFile;
        PreprocHandler preprocHandler = null;
        StartEntry startEntry = APTHandlersSupport.extractStartEntry((PreprocHandler.State)state);
        ProjectBase startProject = Utils.getStartProject(startEntry);
        FileImpl fileImpl = csmFile = startProject == null ? null : startProject.getFile(startEntry.getStartFile(), false);
        if (csmFile != null && (nativeFile = csmFile.getNativeFileItem()) != null && nativeFile.getFileObject() != null && nativeFile.getFileObject().isValid()) {
            preprocHandler = startProject.createPreprocHandler(nativeFile);
        }
        if (preprocHandler == null) {
            preprocHandler = fallbackHandler;
        }
        return new StartEntryInfo(preprocHandler, startProject, csmFile);
    }

    private PreprocHandler restorePreprocHandler(CharSequence interestedFile, PreprocHandler emptyHandler, PreprocHandler.State state, Interrupter interrupter) {
        assert (state != null);
        assert (state.isCleaned());
        LinkedList reverseInclStack = APTHandlersSupport.extractIncludeStack((PreprocHandler.State)state);
        assert (reverseInclStack != null);
        if (reverseInclStack.isEmpty()) {
            if (TRACE_PP_STATE_OUT) {
                System.err.println("stack is empty; return default for " + interestedFile);
            }
            return this.getStartEntryInfo((PreprocHandler)emptyHandler, (PreprocHandler.State)state).preprocHandler;
        }
        if (TRACE_PP_STATE_OUT) {
            System.err.println("restoring for " + interestedFile);
        }
        if (APTTraceFlags.USE_CLANK) {
            PreprocHandler ppHandler = this.getStartEntryInfo(null, (PreprocHandler.State)state).preprocHandler;
            if (ppHandler != null) {
                ppHandler.setState(state);
                return ppHandler;
            }
            return this.createDefaultPreprocHandler(interestedFile);
        }
        return APTTokenStreamProducer.restorePreprocHandlerFromIncludeStack(this, reverseInclStack, interestedFile, emptyHandler, state, interrupter);
    }

    private NativeProject findNativeProjectHolder(Set<ProjectBase> visited) {
        NativeProject nativeProject;
        block1: {
            visited.add(this);
            nativeProject = ModelSupport.getNativeProject(this.getPlatformProject());
            if (nativeProject != null) break block1;
            for (ProjectBase dependentPrj : this.getDependentProjects()) {
                if (!visited.contains(dependentPrj) && (nativeProject = dependentPrj.findNativeProjectHolder(visited)) != null) break;
            }
        }
        return nativeProject;
    }

    public PreprocHandler createDefaultPreprocHandler(CharSequence interestedFile) {
        PreprocHandler out;
        NativeProject nativeProject = this.findNativeProjectHolder(new HashSet<ProjectBase>(10));
        if (nativeProject != null) {
            DefaultFileItem item = new DefaultFileItem(nativeProject, interestedFile.toString());
            out = this.createPreprocHandler(item);
        } else {
            out = this.createEmptyPreprocHandler(interestedFile);
        }
        assert (out != null) : "failed creating default ppState for " + interestedFile;
        return out;
    }

    final GraphContainer getGraph() {
        return this.getGraphStorage();
    }

    public final Set<CsmFile> getParentFiles(CsmFile referencedFile) {
        return this.getGraphStorage().getParentFiles(referencedFile);
    }

    public static List<String> testGetRestoredFiles() {
        return APTTokenStreamProducer.testGetRestoredFiles();
    }

    public void write(RepositoryDataOutput aStream) throws IOException {
        assert (aStream != null);
        aStream.writeUnitId(this.unitId);
        PersistentUtils.writeFileSystem(this.fileSystem, aStream);
        UIDObjectFactory aFactory = UIDObjectFactory.getDefaultFactory();
        assert (aFactory != null);
        assert (this.name != null);
        aStream.writeFilePathForFileSystem(this.fileSystem, this.name);
        aFactory.writeUID(this.globalNamespaceUID, aStream);
        aFactory.writeStringToUIDMap(this.namespaces, aStream, false);
        ProjectComponent.writeKey(this.fileContainerKey, aStream);
        ProjectComponent.writeKey(this.declarationsSorageKey, aStream);
        ProjectComponent.writeKey(this.graphStorageKey, aStream);
        ProjectComponent.writeKey(this.classifierStorageKey, aStream);
        this.includedFileContainer.write(aStream);
        aStream.writeFilePathForFileSystem(this.fileSystem, this.uniqueName);
        aStream.writeBoolean(this.hasFileSystemProblems);
        this.checkUniqueNameConsistency();
    }

    protected ProjectBase(RepositoryDataInput aStream) throws IOException {
        this.unitId = aStream.readUnitId();
        this.fileSystem = PersistentUtils.readFileSystem(aStream);
        assert (this.fileSystem != null);
        this.sysAPTData = APTSystemStorage.getInstance();
        this.userPathStorage = new APTIncludePathStorage();
        this.setStatus(Status.Restored);
        assert (aStream != null);
        UIDObjectFactory aFactory = UIDObjectFactory.getDefaultFactory();
        assert (aFactory != null) : "default UID factory can not be bull";
        this.name = ProjectNameCache.getManager().getString(aStream.readFilePathForFileSystem(this.fileSystem));
        assert (this.name != null) : "project name can not be null";
        this.globalNamespaceUID = aFactory.readUID(aStream);
        assert (this.globalNamespaceUID != null) : "globalNamespaceUID can not be null";
        int collSize = aStream.readInt();
        this.namespaces = collSize <= 0 ? new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>(0) : new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>(collSize);
        aFactory.readStringToUIDMap(this.namespaces, aStream, QualifiedNameCache.getManager(), collSize);
        this.fileContainerKey = ProjectComponent.readKey(aStream);
        assert (this.fileContainerKey != null) : "fileContainerKey can not be null";
        this.weakFileContainer = new WeakContainer((CsmValidable)this, this.fileContainerKey);
        this.declarationsSorageKey = ProjectComponent.readKey(aStream);
        assert (this.declarationsSorageKey != null) : "declarationsSorageKey can not be null";
        this.weakDeclarationContainer = new WeakContainer((CsmValidable)this, this.declarationsSorageKey);
        this.graphStorageKey = ProjectComponent.readKey(aStream);
        assert (this.graphStorageKey != null) : "graphStorageKey can not be null";
        this.weakGraphContainer = new WeakContainer((CsmValidable)this, this.graphStorageKey);
        this.classifierStorageKey = ProjectComponent.readKey(aStream);
        assert (this.classifierStorageKey != null) : "classifierStorageKey can not be null";
        this.weakClassifierContainer = new WeakContainer((CsmValidable)this, this.classifierStorageKey);
        this.includedFileContainer = new IncludedFileContainer(aStream);
        this.uniqueName = ProjectNameCache.getManager().getString(aStream.readFilePathForFileSystem(this.fileSystem));
        assert (this.uniqueName != null) : "uniqueName can not be null";
        this.model = (ModelImpl)CsmModelAccessor.getModel();
        this.FAKE_GLOBAL_NAMESPACE = NamespaceImpl.create(this, true);
        this.hasFileSystemProblems = aStream.readBoolean();
        this.libraryManager = LibraryManager.getInstance(this.getUnitId());
    }

    public final int getUnitId() {
        return this.unitId;
    }

    private DeclarationContainerProject getDeclarationsSorage() {
        DeclarationContainerProject dc = this.weakDeclarationContainer.getContainer();
        return dc != null ? dc : DeclarationContainerProject.empty();
    }

    private FileContainer getFileContainer() {
        FileContainer fc = this.weakFileContainer.getContainer();
        return fc != null ? fc : FileContainer.empty();
    }

    public final GraphContainer getGraphStorage() {
        GraphContainer gc = this.weakGraphContainer.getContainer();
        return gc != null ? gc : GraphContainer.empty();
    }

    private ClassifierContainer getClassifierSorage() {
        ClassifierContainer cc = this.weakClassifierContainer.getContainer();
        return cc != null ? cc : ClassifierContainer.empty();
    }

    public static void dumpProjectContainers(PrintStream printStream, CsmProject prj, boolean dumpFiles) {
        ProjectBase project = (ProjectBase)prj;
        ProjectBase.dumpProjectClassifierContainer(project, printStream, !dumpFiles);
        ProjectBase.dumpProjectDeclarationContainer(project, printStream);
        if (dumpFiles) {
            ProjectBase.dumpFileContainer(project, new PrintWriter(printStream));
            ProjectBase.dumpProjectGrapthContainer(project, new PrintWriter(printStream));
        }
    }

    public static void dumpProjectGrapthContainer(CsmProject prj, PrintWriter printStream) {
        ProjectBase project = (ProjectBase)prj;
        GraphContainer container = project.getGraphStorage();
        printStream.println("%n++++++++++ Dumping Graph container " + project.getDisplayName());
        TreeMap<CharSequence, CsmFile> map = new TreeMap<CharSequence, CsmFile>();
        for (CsmFile f : project.getAllFiles()) {
            map.put(f.getAbsolutePath(), f);
        }
        for (CsmFile file : map.values()) {
            printStream.println("%n========== Dumping links for file " + file.getAbsolutePath());
            TreeMap<CharSequence, FileImpl> set = new TreeMap<CharSequence, FileImpl>();
            for (CsmFile f : container.getInLinks(file)) {
                set.put(f.getAbsolutePath(), (FileImpl)f);
            }
            if (set.size() > 0) {
                printStream.println("\tInput");
                for (CsmFile f : set.values()) {
                    printStream.println("\t\t" + f.getAbsolutePath());
                }
                set.clear();
            }
            for (CsmFile f : container.getOutLinks(file)) {
                set.put(f.getAbsolutePath(), (FileImpl)f);
            }
            if (set.size() <= 0) continue;
            printStream.println("\tOutput");
            for (CsmFile f : set.values()) {
                printStream.println("\t\t" + f.getAbsolutePath());
            }
        }
    }

    @SuppressWarnings(value={"NP"})
    static void dumpProjectClassifierContainer(ProjectBase project, PrintStream printStream, boolean offsetString) {
        ClassifierContainer container = project.getClassifierSorage();
        for (int phase = 0; phase < 3; ++phase) {
            Map<CharSequence, CsmClassifier> map = null;
            switch (phase) {
                case 0: {
                    printStream.printf("%n========== Dumping %s Project Classifiers%n", project.getName());
                    map = container.getTestClassifiers();
                    break;
                }
                case 1: {
                    printStream.printf("%n========== Dumping %s Project Short Classifiers%n", project.getName());
                    map = container.getTestShortClassifiers();
                    break;
                }
                case 2: {
                    printStream.printf("%n========== Dumping %s Project Typedefs%n", project.getName());
                    map = container.getTestTypedefs();
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                printStream.print("\t" + ((CharSequence)entry.getKey()).toString() + " ");
                CsmClassifier value = (CsmClassifier)entry.getValue();
                if (value == null) {
                    printStream.println("null");
                    continue;
                }
                String pos = offsetString ? CsmTracer.getOffsetString((CsmObject)value, (boolean)true) : "";
                printStream.printf("%s %s%n", value.getUniqueName(), pos);
            }
        }
    }

    static void dumpProjectDeclarationContainer(ProjectBase project, PrintStream printStream) {
        TreeMap<CharSequence, Object> set;
        printStream.println("%n========== Dumping Project declarations");
        DeclarationContainerProject container = project.getDeclarationsSorage();
        for (Map.Entry<CharSequence, Object> entry : container.getTestDeclarations().entrySet()) {
            printStream.println("\t" + entry.getKey().toString());
            set = new TreeMap<CharSequence, Object>();
            Object o = entry.getValue();
            if (o instanceof CsmUID[]) {
                CsmUID[] csmUIDArray;
                for (CsmUID uidt : csmUIDArray = (CsmUID[])o) {
                    CsmDeclaration object = (CsmDeclaration)uidt.getObject();
                    if (object != null) {
                        set.put(((CsmOffsetableDeclaration)object).getContainingFile().getAbsolutePath(), object);
                        continue;
                    }
                    printStream.println("\tNO OBJECT FOR " + entry.getKey().toString() + "%n\t" + uidt);
                }
            } else if (o instanceof CsmUID) {
                CsmUID csmUID = (CsmUID)o;
                CsmDeclaration csmDeclaration = (CsmDeclaration)csmUID.getObject();
                if (csmDeclaration != null) {
                    set.put(((CsmOffsetableDeclaration)csmDeclaration).getContainingFile().getAbsolutePath(), csmDeclaration);
                } else {
                    printStream.println("\tNO OBJECT FOR " + entry.getKey().toString() + "%n\t" + csmUID);
                }
            }
            for (Map.Entry entry2 : set.entrySet()) {
                if (DO_NOT_TRCE_DUMMY_FORWARD_CLASSIFIER && (ForwardClass.isForwardClass((CsmObject)entry2.getValue()) || ForwardEnum.isForwardEnum((CsmObject)entry2.getValue()))) continue;
                printStream.println("\t\t" + entry2.getValue() + " from " + entry2.getKey());
            }
        }
        printStream.println("%n========== Dumping Project friends");
        for (Map.Entry<CharSequence, Object> entry : container.getTestFriends().entrySet()) {
            printStream.println("\t" + entry.getKey().toString());
            set = new TreeMap();
            for (CsmUID csmUID : (Set)entry.getValue()) {
                CsmFriend csmFriend = (CsmFriend)csmUID.getObject();
                set.put(csmFriend.getQualifiedName(), csmFriend);
            }
            for (Map.Entry entry3 : set.entrySet()) {
                printStream.println("\t\t" + entry3.getKey() + " " + entry3.getValue());
            }
        }
    }

    public static void dumpFileContainer(CsmProject project, PrintWriter printStream) {
        FileContainer fileContainer = ((ProjectBase)project).getFileContainer();
        printStream.println("%n++++++++++ Dumping File container " + project.getDisplayName());
        Map<CharSequence, Object> names = fileContainer.getCanonicalNames();
        Map<CharSequence, FileContainer.FileEntry> files = fileContainer.getFileStorage();
        for (Map.Entry<CharSequence, FileContainer.FileEntry> entry : files.entrySet()) {
            CharSequence key = entry.getKey();
            printStream.println("\tFile " + key.toString());
            Object name = names.get(key);
            if (name instanceof CharSequence[]) {
                for (CharSequence alt : (CharSequence[])name) {
                    printStream.println("\t\tAlias " + alt.toString());
                }
            } else if (name instanceof CharSequence) {
                printStream.println("\t\tAlias " + name.toString());
            }
            FileContainer.FileEntry file = entry.getValue();
            CsmFile csmFile = (CsmFile)file.getTestFileUID().getObject();
            printStream.println("\t\tModel File " + csmFile.getAbsolutePath());
            printStream.println("\t\tNumber of states " + file.getPrerocStates().size());
            Collection<PreprocessorStatePair> statePairs = file.getStatePairs();
            ArrayList<String> states = new ArrayList<String>();
            for (PreprocessorStatePair preprocessorStatePair : statePairs) {
                states.add(FilePreprocessorConditionState.toStringBrief(preprocessorStatePair.pcState));
            }
            Collections.sort(states);
            for (String state : states) {
                StringTokenizer st = new StringTokenizer(state, "%n");
                boolean first = true;
                while (st.hasMoreTokens()) {
                    if (first) {
                        printStream.println("\t\tState " + st.nextToken());
                        first = false;
                        continue;
                    }
                    printStream.println("\t\t\t" + st.nextToken());
                }
            }
            printStream.flush();
        }
        printStream.flush();
    }

    private static final class FileContainerLock {
        private FileContainerLock() {
        }
    }

    private static final class NamespaceLock {
        private NamespaceLock() {
        }
    }

    private static final class ClassifierReplaceLock {
        private ClassifierReplaceLock() {
        }
    }

    private static final class WaitParseLock {
        private WaitParseLock() {
        }
    }

    private static final class InitializationTaskLock {
        private InitializationTaskLock() {
        }
    }

    protected static enum Status {
        Initial,
        Restored,
        AddingFiles,
        Validating,
        Ready;

    }

    private static final class DefaultFileItem
    implements NativeFileItem {
        private final NativeProject project;
        private final String normalizedAbsPath;

        public DefaultFileItem(NativeProject project, String absolutePath) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"absolutePath", (Object)absolutePath);
            this.project = project;
            this.normalizedAbsPath = CndFileUtils.normalizeAbsolutePath((FileSystem)project.getFileSystem(), (String)absolutePath);
        }

        public DefaultFileItem(NativeFileItem nativeFile) {
            Parameters.notNull((CharSequence)"nativeFile", (Object)nativeFile);
            this.project = nativeFile.getNativeProject();
            this.normalizedAbsPath = nativeFile.getAbsolutePath();
            CndUtils.assertNormalized((FileSystem)this.project.getFileSystem(), (CharSequence)this.normalizedAbsPath);
            Parameters.notNull((CharSequence)"nativeFile.getAbsolutePath()", (Object)this.normalizedAbsPath);
        }

        public static NativeFileItem toDefault(NativeFileItem nativeFile) {
            if (!(nativeFile instanceof DefaultFileItem)) {
                nativeFile = new DefaultFileItem(nativeFile);
            }
            return nativeFile;
        }

        public List<String> getUserMacroDefinitions() {
            if (this.project != null) {
                return this.project.getUserMacroDefinitions();
            }
            return Collections.emptyList();
        }

        public List<FSPath> getUserIncludePaths() {
            if (this.project != null) {
                return this.project.getUserIncludePaths();
            }
            return Collections.emptyList();
        }

        public List<String> getIncludeFiles() {
            if (this.project != null) {
                return this.project.getIncludeFiles();
            }
            return Collections.emptyList();
        }

        public List<String> getSystemMacroDefinitions() {
            if (this.project != null) {
                return this.project.getSystemMacroDefinitions();
            }
            return Collections.emptyList();
        }

        public List<FSPath> getSystemIncludePaths() {
            if (this.project != null) {
                return this.project.getSystemIncludePaths();
            }
            return Collections.emptyList();
        }

        public NativeProject getNativeProject() {
            return this.project;
        }

        public FileObject getFileObject() {
            FileObject fo = CndFileUtils.toFileObject((FileSystem)this.project.getFileSystem(), (CharSequence)this.normalizedAbsPath);
            if (fo == null) {
                fo = InvalidFileObjectSupport.getInvalidFileObject((FileSystem)this.project.getFileSystem(), (CharSequence)this.normalizedAbsPath);
            }
            return fo;
        }

        public String getAbsolutePath() {
            return this.normalizedAbsPath;
        }

        public String getName() {
            return CndPathUtilities.getBaseName((String)this.normalizedAbsPath);
        }

        public NativeFileItem.Language getLanguage() {
            return NativeFileItem.Language.C_HEADER;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return NativeFileItem.LanguageFlavor.UNKNOWN;
        }

        public boolean isExcluded() {
            return false;
        }

        public String toString() {
            return this.normalizedAbsPath + ' ' + this.project.getFileSystem().getDisplayName();
        }
    }

    public static class StartEntryInfo {
        public final PreprocHandler preprocHandler;
        public final ProjectBase startProject;
        public final FileImpl csmFile;

        public StartEntryInfo(PreprocHandler preprocHandler, ProjectBase startProject, FileImpl csmFile) {
            this.preprocHandler = preprocHandler;
            this.startProject = startProject;
            this.csmFile = csmFile;
        }
    }

    private static class FileAndHandler {
        private final FileImpl fileImpl;
        private PreprocHandler preprocHandler;

        public FileAndHandler(FileImpl fileImpl, PreprocHandler preprocHandler) {
            this.fileImpl = fileImpl;
            this.preprocHandler = preprocHandler;
        }
    }

    private static enum ComparisonResult {
        REPLACE_OTHERS,
        KEEP_WITH_OTHERS,
        DISCARD;

    }
}

