/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.accessors.CsmCorePackageAccessor;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.spi.CsmParserProvider;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;

public abstract class LazyStatementImpl
extends StatementBase
implements CsmScope {
    private static final List<CsmStatement> ANTILOOP_EMPTY_LIST = Collections.unmodifiableList(new ArrayList(0));
    private final ThreadLocal<AtomicBoolean> inResolveLazyStatements_AndStatementsRefLoc = new ThreadLocal<AtomicBoolean>(){

        @Override
        protected AtomicBoolean initialValue() {
            return new AtomicBoolean(false);
        }
    };
    private volatile SoftReference<List<CsmStatement>> statements = null;

    protected LazyStatementImpl(CsmFile file, int start, int end, CsmFunction scope) {
        super(file, start, end, (CsmScope)scope);
    }

    public CsmStatement.Kind getKind() {
        return CsmStatement.Kind.COMPOUND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<CsmStatement> getStatements() {
        List<CsmStatement> list;
        ThreadLocal<AtomicBoolean> statementsLoc;
        ThreadLocal<AtomicBoolean> threadLocal = statementsLoc = this.inResolveLazyStatements_AndStatementsRefLoc;
        synchronized (threadLocal) {
            list = this.statements == null ? null : this.statements.get();
        }
        if (list == null) {
            return this.createStatements();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CsmStatement> createStatements() {
        AtomicBoolean statementsAntiLoop = this.inResolveLazyStatements_AndStatementsRefLoc.get();
        if (statementsAntiLoop.get()) {
            return ANTILOOP_EMPTY_LIST;
        }
        CndUtils.assertTrueInConsole((!SwingUtilities.isEventDispatchThread() || CndUtils.isCodeCompletionUnitTestMode() ? 1 : 0) != 0, (String)"Calling Parser in UI Thread");
        ThreadLocal<AtomicBoolean> statementsLoc = this.inResolveLazyStatements_AndStatementsRefLoc;
        LazyStatementImpl lazyStatementImpl = this;
        synchronized (lazyStatementImpl) {
            Object object;
            block18: {
                ThreadLocal<AtomicBoolean> threadLocal = statementsLoc;
                synchronized (threadLocal) {
                    List<CsmStatement> refList;
                    if (this.statements != null && (refList = this.statements.get()) != null) {
                        return refList;
                    }
                }
                boolean prev = this.inResolveLazyStatements_AndStatementsRefLoc.get().getAndSet(true);
                assert (!prev) : Thread.currentThread().getName() + " can not enter in create Statements twice in the same thread:" + this;
                try {
                    List<Object> list = new ArrayList<CsmStatement>();
                    if (!this.renderStatements(list)) {
                        list = Collections.emptyList();
                    } else {
                        list.trimToSize();
                    }
                    object = statementsLoc;
                    synchronized (object) {
                        this.statements = new SoftReference<ArrayList<CsmStatement>>((ArrayList<CsmStatement>)list);
                    }
                    object = list;
                    prev = this.inResolveLazyStatements_AndStatementsRefLoc.get().getAndSet(false);
                    if ($assertionsDisabled || prev) break block18;
                }
                catch (Throwable throwable) {
                    prev = this.inResolveLazyStatements_AndStatementsRefLoc.get().getAndSet(false);
                    assert (prev) : Thread.currentThread().getName() + " can not leave create Statements twice from the same thread:" + this;
                    throw throwable;
                }
                throw new AssertionError((Object)(Thread.currentThread().getName() + " can not leave create Statements twice from the same thread:" + this));
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renderStatements(List<CsmStatement> list) {
        boolean bl;
        block6: {
            FileImpl file = (FileImpl)this.getContainingFile();
            TokenStream stream = file.getTokenStream(this.getStartOffset(), this.getEndOffset(), this.getFirstTokenID(), true);
            if (stream == null) {
                int startOffset = this.getStartOffset();
                int[] lineColumn = file.getLineColumn(startOffset);
                Utils.LOG.log(Level.SEVERE, "Can''t create compound statement: can''t create token stream for file {0} at {1}:{2}", new Object[]{file.getAbsolutePath(), lineColumn[0], lineColumn[1]});
                return false;
            }
            FileContent tmpFileContent = null;
            try {
                CsmParserProvider.CsmParserResult result;
                FileImpl fileImpl;
                if (TraceFlags.PARSE_HEADERS_WITH_SOURCES && (fileImpl = (FileImpl)this.getContainingFile()).getParsingFileContent() == null) {
                    tmpFileContent = CsmCorePackageAccessor.get().prepareLazyStatementParsingContent(fileImpl);
                }
                if ((result = this.resolveLazyStatement(stream)) != null) {
                    result.render(list);
                }
                bl = true;
                if (tmpFileContent == null) break block6;
            }
            catch (Throwable throwable) {
                if (tmpFileContent != null) {
                    FileImpl fileImpl = (FileImpl)this.getContainingFile();
                    CsmCorePackageAccessor.get().releaseLazyStatementParsingContent(fileImpl, tmpFileContent);
                }
                throw throwable;
            }
            FileImpl fileImpl = (FileImpl)this.getContainingFile();
            CsmCorePackageAccessor.get().releaseLazyStatementParsingContent(fileImpl, tmpFileContent);
        }
        return bl;
    }

    public void renderStatements(AST ast, List<CsmStatement> list, Map<Integer, CsmObject> objects) {
        AST aST = ast = ast == null ? null : ast.getFirstChild();
        while (ast != null) {
            StatementBase stmt = AstRenderer.renderStatement(ast, this.getContainingFile(), this, objects);
            if (stmt != null) {
                list.add(stmt);
            }
            ast = ast.getNextSibling();
        }
    }

    public Collection<CsmScopeElement> getScopeElements() {
        List<CsmStatement> out = this.getStatements();
        return out;
    }

    protected abstract CsmParserProvider.CsmParserResult resolveLazyStatement(TokenStream var1);

    protected abstract int getFirstTokenID();

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
    }

    public LazyStatementImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.statements = null;
    }
}

