/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenBuffer;
import org.netbeans.modules.cnd.api.model.CsmExpressionBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmCacheMap;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageSupport;
import org.netbeans.modules.cnd.modelimpl.csm.ExpressionBasedSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.impl.services.evaluator.VariableProvider;
import org.netbeans.modules.cnd.modelimpl.impl.services.evaluator.parser.generated.EvaluatorParser;
import org.netbeans.modules.cnd.modelimpl.util.MapHierarchy;
import org.netbeans.modules.cnd.spi.model.services.CsmExpressionEvaluatorProvider;

public class ExpressionEvaluator
implements CsmExpressionEvaluatorProvider {
    private static final Logger LOG = Logger.getLogger(ExpressionEvaluator.class.getSimpleName());
    private final int level;
    private static final Callable<CsmCacheMap> EVAL_INITIALIZER = new Callable<CsmCacheMap>(){

        @Override
        public CsmCacheMap call() {
            return new CsmCacheMap("Evaluator: eval cache", 1);
        }
    };
    private static final Callable<CsmCacheMap> GET_MAPPING_INITIALIZER = new Callable<CsmCacheMap>(){

        @Override
        public CsmCacheMap call() {
            return new CsmCacheMap("Evaluator: get mapping cache", 1);
        }
    };

    public ExpressionEvaluator() {
        this.level = 0;
    }

    public ExpressionEvaluator(int level) {
        this.level = level;
    }

    public Object eval(String expr, CsmScope scope) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "\nEvaluating expression \"{0}\"\n", expr);
        }
        org.netbeans.modules.cnd.antlr.TokenStream ts = APTTokenStreamBuilder.buildTokenStream((String)expr, (String)"Gnu C++ Language");
        APTLanguageFilter lang = APTLanguageSupport.getInstance().getFilter("Gnu C++ Language");
        ts = lang.getFilteredStream(ts);
        TokenBuffer tb = new TokenBuffer(ts);
        int result = 0;
        try {
            MyTokenStream tokens = new MyTokenStream(tb);
            EvaluatorParser parser = new EvaluatorParser(tokens);
            parser.setVariableProvider(new VariableProvider(this.level + 1, scope));
            result = parser.expr();
        }
        catch (RecognitionException ex) {
            // empty catch block
        }
        return result;
    }

    public Object eval(String expr, CsmInstantiation inst, CsmScope scope) {
        boolean[] found;
        EvaluateRequest key;
        CsmCacheMap cache = this.getEvaluatorEvalCache();
        Object cached = CsmCacheMap.getFromCache((CsmCacheMap)cache, (Object)(key = new EvaluateRequest(expr, inst, scope)), (boolean[])(found = new boolean[]{false}));
        if (cached != null && found[0]) {
            return cached;
        }
        long time = System.currentTimeMillis();
        Object result = CsmKindUtilities.isOffsetableDeclaration((Object)inst) ? this.eval(expr, (CsmOffsetableDeclaration)inst, scope, this.getMapping(inst)) : this.eval(expr, inst.getTemplateDeclaration(), scope, this.getMapping(inst));
        time = System.currentTimeMillis() - time;
        if (cache != null) {
            cache.put((Object)key, CsmCacheMap.toValue((Object)result, (long)time));
        }
        return result;
    }

    public Object eval(String expr, CsmOffsetableDeclaration decl, CsmScope scope, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
        return this.eval(expr, decl, scope, new MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter>(mapping));
    }

    public Object eval(String expr, CsmOffsetableDeclaration decl, CsmScope scope, MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
        return this.eval(expr, decl, scope, null, 0, 0, mapping);
    }

    public Object eval(String expr, CsmOffsetableDeclaration decl, CsmScope scope, CsmFile expressionFile, int startOffset, int endOffset, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
        return this.eval(expr, decl, scope, expressionFile, startOffset, endOffset, new MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter>(mapping));
    }

    public Object eval(String expr, CsmOffsetableDeclaration decl, CsmScope scope, CsmFile expressionFile, int startOffset, int endOffset, MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "\nEvaluating expression \"{0}\"\n", expr);
        }
        org.netbeans.modules.cnd.antlr.TokenStream ts = APTTokenStreamBuilder.buildTokenStream((String)expr, (String)"Gnu C++ Language");
        APTLanguageFilter lang = APTLanguageSupport.getInstance().getFilter("Gnu C++ Language");
        ts = lang.getFilteredStream(ts);
        TokenBuffer tb = new TokenBuffer(ts);
        int result = 0;
        try {
            MyTokenStream tokens = new MyTokenStream(tb);
            EvaluatorParser parser = new EvaluatorParser(tokens);
            parser.setVariableProvider(new VariableProvider(decl, scope, mapping, expressionFile, startOffset, endOffset, this.level + 1));
            result = parser.expr();
        }
        catch (RecognitionException ex) {
            // empty catch block
        }
        return result;
    }

    public boolean isValid(Object evaluated) {
        return evaluated instanceof Integer && (Integer)evaluated != Integer.MAX_VALUE;
    }

    private MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> getMapping(CsmInstantiation inst) {
        boolean[] found;
        GetMappingRequest key;
        CsmCacheMap cache = this.getEvaluatorGetMappingCache();
        Object cached = CsmCacheMap.getFromCache((CsmCacheMap)cache, (Object)(key = new GetMappingRequest(inst)), (boolean[])(found = new boolean[]{false}));
        if (cached != null && found[0]) {
            return (MapHierarchy)cached;
        }
        long time = System.currentTimeMillis();
        MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> mapHierarchy = new MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter>(inst.getMapping());
        if (TraceFlags.EXPRESSION_EVALUATOR_RECURSIVE_CALC) {
            while (CsmKindUtilities.isInstantiation((CsmObject)inst.getTemplateDeclaration())) {
                inst = (CsmInstantiation)inst.getTemplateDeclaration();
                HashMap mapping = new HashMap();
                mapHierarchy.push(mapping);
                ArrayList orderedParamsList = new ArrayList(inst.getMapping().keySet());
                final CsmInstantiation finalInst = inst;
                Collections.sort(orderedParamsList, new Comparator<CsmTemplateParameter>(){

                    @Override
                    public int compare(CsmTemplateParameter o1, CsmTemplateParameter o2) {
                        int score1 = this.calcScore(o1);
                        int score2 = this.calcScore(o2);
                        return score1 - score2;
                    }

                    private int calcScore(CsmTemplateParameter param) {
                        CsmSpecializationParameter spec = (CsmSpecializationParameter)finalInst.getMapping().get(param);
                        if (CsmKindUtilities.isExpressionBasedSpecalizationParameter((CsmObject)spec) && !((CsmExpressionBasedSpecializationParameter)spec).isDefaultValue()) {
                            return -1;
                        }
                        return param.getStartOffset();
                    }
                });
                for (CsmTemplateParameter param : orderedParamsList) {
                    HashMap<CsmTemplateParameter, ExpressionBasedSpecializationParameterImpl> newMapping = new HashMap<CsmTemplateParameter, ExpressionBasedSpecializationParameterImpl>();
                    CsmSpecializationParameter spec = (CsmSpecializationParameter)inst.getMapping().get(param);
                    if (CsmKindUtilities.isExpressionBasedSpecalizationParameter((CsmObject)spec)) {
                        Object o = this.eval(((CsmExpressionBasedSpecializationParameter)spec).getText().toString(), inst.getTemplateDeclaration(), spec.getScope(), spec.getContainingFile(), spec.getStartOffset(), spec.getEndOffset(), mapHierarchy);
                        ExpressionBasedSpecializationParameterImpl newSpec = ExpressionBasedSpecializationParameterImpl.create(o.toString(), ((CsmExpressionBasedSpecializationParameter)spec).getScope(), spec.getContainingFile(), spec.getStartOffset(), spec.getEndOffset());
                        newMapping.put(param, newSpec);
                    } else {
                        newMapping.put(param, (ExpressionBasedSpecializationParameterImpl)spec);
                    }
                    mapping.putAll(newMapping);
                }
            }
        } else {
            while (CsmKindUtilities.isInstantiation((CsmObject)inst.getTemplateDeclaration())) {
                inst = (CsmInstantiation)inst.getTemplateDeclaration();
                mapHierarchy.push(inst.getMapping());
            }
        }
        time = System.currentTimeMillis() - time;
        if (cache != null) {
            cache.put((Object)key, CsmCacheMap.toValue(mapHierarchy, (long)time));
        }
        return mapHierarchy;
    }

    private CsmCacheMap getEvaluatorEvalCache() {
        if (this.level > 0) {
            return null;
        }
        return (CsmCacheMap)CsmCacheManager.getClientCache(EvaluateRequest.class, EVAL_INITIALIZER);
    }

    private CsmCacheMap getEvaluatorGetMappingCache() {
        if (this.level > 0) {
            return null;
        }
        return (CsmCacheMap)CsmCacheManager.getClientCache(GetMappingRequest.class, GET_MAPPING_INITIALIZER);
    }

    private static final class GetMappingRequest {
        private final CsmInstantiation instantiation;

        public GetMappingRequest(CsmInstantiation instantiation) {
            this.instantiation = instantiation;
        }

        public int hashCode() {
            return System.identityHashCode(this.instantiation);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GetMappingRequest other = (GetMappingRequest)obj;
            return this.instantiation == other.instantiation;
        }
    }

    private static final class EvaluateRequest {
        private final String expression;
        private final CsmInstantiation instantiation;
        private final CsmScope scope;

        public EvaluateRequest(String expression, CsmInstantiation instantiation, CsmScope scope) {
            this.expression = expression;
            this.instantiation = instantiation;
            this.scope = scope;
        }

        public int hashCode() {
            int hash = 5;
            hash = 19 * hash + Objects.hashCode(this.expression);
            hash = 19 * hash + System.identityHashCode(this.instantiation);
            hash = 19 * hash + System.identityHashCode(this.scope);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EvaluateRequest other = (EvaluateRequest)obj;
            if (!Objects.equals(this.expression, other.expression)) {
                return false;
            }
            if (this.instantiation != other.instantiation) {
                return false;
            }
            return this.scope == other.scope;
        }
    }

    private static class MyTokenStream
    implements TokenStream {
        TokenBuffer tb;
        int lastMark;

        public MyTokenStream(TokenBuffer tb) {
            this.tb = tb;
        }

        public org.antlr.runtime.Token LT(int arg0) {
            return new MyToken(this.tb.LT(arg0));
        }

        public void consume() {
            this.tb.consume();
        }

        public int LA(int arg0) {
            return this.tb.LA(arg0);
        }

        public int mark() {
            this.lastMark = this.tb.index();
            return this.tb.mark();
        }

        public int index() {
            return this.tb.index();
        }

        public void rewind(int arg0) {
            this.tb.rewind(arg0);
        }

        public void rewind() {
            this.tb.mark();
            this.tb.rewind(this.lastMark);
        }

        public void seek(int arg0) {
            this.tb.seek(arg0);
        }

        public org.antlr.runtime.Token get(int arg0) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public TokenSource getTokenSource() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String toString(int arg0, int arg1) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String toString(org.antlr.runtime.Token arg0, org.antlr.runtime.Token arg1) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void release(int arg0) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int size() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getSourceName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int range() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class MyToken
    implements org.antlr.runtime.Token {
        Token t;

        public MyToken(Token t) {
            this.t = t;
        }

        public String getText() {
            return this.t.getText();
        }

        public void setText(String arg0) {
            this.t.setText(arg0);
        }

        public int getType() {
            return this.t.getType();
        }

        public void setType(int arg0) {
            this.t.setType(arg0);
        }

        public int getLine() {
            return this.t.getLine();
        }

        public void setLine(int arg0) {
            this.t.setLine(arg0);
        }

        public int getCharPositionInLine() {
            return this.t.getColumn();
        }

        public void setCharPositionInLine(int arg0) {
            this.t.setColumn(arg0);
        }

        public int getChannel() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setChannel(int arg0) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getTokenIndex() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setTokenIndex(int arg0) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CharStream getInputStream() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setInputStream(CharStream arg0) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

