/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.platform.CndParserResult;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserFactory;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakSet;

public final class CndParserFactory
extends ParserFactory {
    private static final Set<ParserImpl> registry = new WeakSet();
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.model.tasks");
    private static final int NO_DOCUMENT_VERSION = -1;

    public Parser createParser(Collection<Snapshot> snapshots) {
        ParserImpl cndParser;
        boolean filter = false;
        int size = 0;
        for (Snapshot s : snapshots) {
            FileObject fo = s.getSource().getFileObject();
            if (CsmUtilities.isCsmSuitable((FileObject)fo)) {
                ++size;
                continue;
            }
            filter = true;
        }
        if (filter) {
            if (size == 0) {
                return null;
            }
            ArrayList<Snapshot> filtered = new ArrayList<Snapshot>(size);
            for (Snapshot s : snapshots) {
                FileObject fo = s.getSource().getFileObject();
                if (!CsmUtilities.isCsmSuitable((FileObject)fo)) continue;
                filtered.add(s);
            }
            cndParser = new ParserImpl(filtered);
        } else {
            cndParser = new ParserImpl(snapshots);
        }
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)cndParser);
        return cndParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void firePropertyChanged() {
        HashSet<ParserImpl> set = new HashSet<ParserImpl>();
        Set<ParserImpl> set2 = registry;
        synchronized (set2) {
            set.addAll(registry);
        }
        for (ParserImpl parser : set) {
            if (parser == null) continue;
            ParserImpl.Lock lock = parser.lock;
            synchronized (lock) {
                CsmFile file;
                FileObject fo;
                Snapshot snapshot;
                if (parser.cndParserResult != null && (snapshot = parser.cndParserResult.getSnapshot()) != null && (fo = snapshot.getSource().getFileObject()) != null && (file = CsmUtilities.getCsmFile((FileObject)fo, (boolean)false, (boolean)false)) != null) {
                    LOG.log(Level.FINE, "update parse result for {0} because property changed", snapshot);
                    long fileVersion = CsmFileInfoQuery.getDefault().getFileVersion(file);
                    parser.cndParserResult = new CndParserResult(file, snapshot, fileVersion, CndParserFactory.getDocumentVersion(snapshot));
                    parser.listeners.fireChange();
                }
            }
        }
    }

    private static long getDocumentVersion(Snapshot snapshot) {
        Document doc = snapshot.getSource().getDocument(false);
        long docVersion = -1L;
        if (doc != null) {
            docVersion = System.identityHashCode(doc);
        }
        return docVersion;
    }

    private static class ParserImpl
    extends Parser
    implements CsmProgressListener {
        private CndParserResult cndParserResult;
        private final Lock lock = new Lock();
        private final ChangeSupport listeners = new ChangeSupport((Object)this);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ParserImpl(Collection<Snapshot> snapshots) {
            Object object = this.lock;
            synchronized (object) {
                this.cndParserResult = new CndParserResult(null, snapshots.size() == 1 ? snapshots.iterator().next() : null, 0L, -1L);
            }
            object = registry;
            synchronized (object) {
                registry.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
            long oldDocVersion;
            CharSequence oldText;
            CsmFile oldFile;
            long oldVersion;
            LOG.log(Level.FINE, "parse called for {0}", snapshot);
            if (snapshot == null) {
                return;
            }
            Lock lock = this.lock;
            synchronized (lock) {
                if (this.cndParserResult == null) {
                    oldVersion = 0L;
                    oldFile = null;
                    oldText = null;
                    oldDocVersion = -1L;
                } else {
                    oldVersion = this.cndParserResult.getFileVersion();
                    oldFile = this.cndParserResult.getCsmFile();
                    oldText = this.cndParserResult.getSnapshot().getText();
                    oldDocVersion = this.cndParserResult.getDocumentVersion();
                }
            }
            FileObject fo = snapshot.getSource().getFileObject();
            long docVersion = CndParserFactory.getDocumentVersion(snapshot);
            CsmFile file = CsmUtilities.getCsmFile((FileObject)fo, (boolean)false, (boolean)false);
            boolean allowStandalone = true;
            if (allowStandalone && file == null) {
                file = CsmStandaloneFileProvider.getDefault().getCsmFile(fo);
            }
            if (file != null && !TraceFlags.USE_PARSER_API) {
                try {
                    file.scheduleParsing(true);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            Lock lock2 = this.lock;
            synchronized (lock2) {
                long fileVersion = CsmFileInfoQuery.getDefault().getFileVersion(file);
                if (oldVersion != fileVersion || !snapshot.getText().equals(oldText) || docVersion != oldDocVersion) {
                    if (TraceFlags.USE_PARSER_API) {
                        if (file instanceof FileImpl) {
                            FileImpl fileImpl = (FileImpl)file;
                            ProjectBase projectImpl = fileImpl.getProjectImpl(false);
                            if (projectImpl != null) {
                                projectImpl.onSnapshotChanged(fileImpl, snapshot);
                            }
                        } else if (file != null) {
                            throw new IllegalStateException("should be instance of FileImpl: " + file.getClass());
                        }
                    }
                    this.cndParserResult = new CndParserResult(file, snapshot, fileVersion, docVersion);
                }
            }
            if (oldFile != null && file != oldFile && !CsmStandaloneFileProvider.getDefault().isStandalone(file)) {
                CsmStandaloneFileProvider.getDefault().notifyClosed(oldFile);
            }
        }

        public void cancel(Parser.CancelReason reason, SourceModificationEvent event) {
            super.cancel(reason, event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CndParserResult getResult(Task task) throws ParseException {
            Lock lock = this.lock;
            synchronized (lock) {
                LOG.log(Level.FINE, "getResult for {0}, Task={1}, Result={2}", new Object[]{task.getClass().getName(), System.identityHashCode(task), System.identityHashCode((Object)this.cndParserResult)});
                return this.cndParserResult;
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.removeChangeListener(changeListener);
        }

        public void projectParsingStarted(CsmProject project) {
        }

        public void projectFilesCounted(CsmProject project, int filesCount) {
        }

        public void projectParsingFinished(CsmProject project) {
            this.fireProjectReadyImpl(project);
        }

        public void projectParsingCancelled(CsmProject project) {
        }

        public void projectLoaded(CsmProject project) {
            this.fireProjectReadyImpl(project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireProjectReadyImpl(CsmProject project) {
            Lock lock = this.lock;
            synchronized (lock) {
                CsmFile file;
                FileObject fo;
                Snapshot snapshot;
                if (this.cndParserResult != null && (snapshot = this.cndParserResult.getSnapshot()) != null && (fo = snapshot.getSource().getFileObject()) != null && (file = project.findFile((Object)fo.getPath(), false, false)) != null) {
                    LOG.log(Level.FINE, "update parse result for {0} because project ready", snapshot);
                    long fileVersion = CsmFileInfoQuery.getDefault().getFileVersion(file);
                    this.cndParserResult = new CndParserResult(file, snapshot, fileVersion, CndParserFactory.getDocumentVersion(snapshot));
                    this.listeners.fireChange();
                }
            }
        }

        public void fileInvalidated(CsmFile file) {
        }

        public void fileAddedToParse(CsmFile file) {
        }

        public void fileParsingStarted(CsmFile file) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileParsingFinished(CsmFile file) {
            Lock lock = this.lock;
            synchronized (lock) {
                FileObject fo;
                Snapshot snapshot;
                if (this.cndParserResult != null && (snapshot = this.cndParserResult.getSnapshot()) != null && (fo = snapshot.getSource().getFileObject()) != null && fo.equals(file.getFileObject())) {
                    LOG.log(Level.FINE, "update parse result for {0} because file parsed", snapshot);
                    long fileVersion = CsmFileInfoQuery.getDefault().getFileVersion(file);
                    this.cndParserResult = new CndParserResult(file, snapshot, fileVersion, CndParserFactory.getDocumentVersion(snapshot));
                    this.listeners.fireChange();
                }
            }
        }

        public void parserIdle() {
        }

        public void fileRemoved(CsmFile file) {
        }

        private static final class Lock {
            private Lock() {
            }
        }
    }
}

