/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.platform.ParsingProgress;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.openide.util.Cancellable;

public class ProgressListenerImpl
implements CsmProgressListener {
    private final Map<CsmProject, ParsingProgress> handles = new HashMap<CsmProject, ParsingProgress>();
    private static final Logger LOG = Logger.getLogger(ProgressListenerImpl.class.getName());

    private synchronized ParsingProgress getHandle(final CsmProject project, boolean createIfNeed) {
        ParsingProgress handle = this.handles.get(project);
        if (handle == null && createIfNeed) {
            Cancellable cancellable = null;
            if (Boolean.getBoolean("cnd.cancellable.parse")) {
                cancellable = new Cancellable(){

                    public boolean cancel() {
                        UIGesturesSupport.submit((String)"USG_CND_CANCEL_PARSE", (Object[])new Object[0]);
                        LOG.log(Level.INFO, "Cancel Parse requst for project {0}", project);
                        CsmModel model = CsmModelAccessor.getModel();
                        if (model instanceof ModelImpl && project instanceof ProjectBase) {
                            final ModelImpl modelImpl = (ModelImpl)model;
                            modelImpl.enqueueModelTask(new Runnable(){

                                @Override
                                public void run() {
                                    LOG.log(Level.INFO, "Enqueue disabling Code Assistance for project {0}", project);
                                    modelImpl.disableProjectBase((ProjectBase)project);
                                }
                            }, "disable " + project.getDisplayName());
                            return true;
                        }
                        return false;
                    }
                };
            }
            handle = new ParsingProgress(project, cancellable);
            this.handles.put(project, handle);
        }
        return handle;
    }

    public void projectParsingStarted(CsmProject project) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ProgressListenerImpl.projectParsingStarted " + project.getName());
        }
        this.getHandle(project, true).start();
    }

    public void projectFilesCounted(CsmProject project, int filesCount) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ProgressListenerImpl.projectFilesCounted " + project.getName() + ' ' + filesCount);
        }
        this.getHandle(project, true).switchToDeterminate(filesCount);
    }

    public void projectParsingFinished(CsmProject project) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ProgressListenerImpl.projectParsingFinished " + project.getName());
        }
        this.done(project);
    }

    public void projectLoaded(CsmProject project) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ProgressListenerImpl.projectLoaded " + project.getName());
        }
    }

    public void projectParsingCancelled(CsmProject project) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ProgressListenerImpl.projectParsingCancelled " + project.getName());
        }
        this.done(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done(CsmProject project) {
        this.getHandle(project, true).finish();
        ProgressListenerImpl progressListenerImpl = this;
        synchronized (progressListenerImpl) {
            this.handles.remove(project);
        }
    }

    public void fileInvalidated(CsmFile file) {
    }

    public void fileAddedToParse(CsmFile file) {
        CsmProject project = file.getProject();
        ParsingProgress handle = this.getHandle(project, false);
        if (handle != null) {
            handle.addedToParse(file);
        } else if (project.isArtificial()) {
            for (CsmProject p : CsmModelAccessor.getModel().projects()) {
                if (p.isArtificial() || !p.getLibraries().contains(project) || (handle = this.getHandle(p, false)) == null) continue;
                handle.addedToParse(file);
            }
        }
    }

    public void fileParsingStarted(CsmFile file) {
        CsmProject project;
        ParsingProgress handle;
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("  ProgressListenerImpl.fileParsingStarted " + file.getAbsolutePath());
        }
        if ((handle = this.getHandle(project = file.getProject(), false)) != null) {
            handle.nextCsmFile(file);
        } else if (project.isArtificial()) {
            for (CsmProject p : CsmModelAccessor.getModel().projects()) {
                if (p.isArtificial() || !p.getLibraries().contains(project) || (handle = this.getHandle(p, false)) == null) continue;
                handle.nextCsmFile(file);
            }
        }
    }

    public void fileParsingFinished(CsmFile file) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("  ProgressListenerImpl.fileParsingFinished " + file.getAbsolutePath());
        }
    }

    public void parserIdle() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("  ProgressListenerImpl.parserIdle");
        }
    }

    public void fileRemoved(CsmFile file) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("  ProgressListenerImpl.fileRemoved " + file.getAbsolutePath());
        }
    }
}

