/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.CppParserActionImpl;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class TraceFactory {
    public static TraceWriter getTraceWriter(Object parser) {
        if (CndUtils.isUnitTestMode() || CndUtils.isStandalone()) {
            return new SimpleTraceWriter(parser);
        }
        if (TraceFlags.TRACE_CPP_PARSER_SHOW_AST) {
            return new TreeTraceWriter(parser);
        }
        return new OutputTraceWriter(parser);
    }

    private static class ASTFrame
    extends JFrame {
        private final JTree tree;
        private final JTextArea text;

        private ASTFrame(String lab, MyTreeNode root) {
            super(lab);
            this.tree = new JTree(root, true);
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
            MyTreeSelectionListener listener = new MyTreeSelectionListener();
            this.tree.addTreeSelectionListener(listener);
            this.tree.getSelectionModel().setSelectionMode(1);
            JScrollPane treeScroller = new JScrollPane(this.tree);
            Container content = this.getContentPane();
            content.setLayout(new BorderLayout());
            this.text = new JTextArea(){

                @Override
                public Insets getInsets() {
                    return new Insets(6, 6, 6, 6);
                }
            };
            this.text.setEditable(false);
            this.text.setTabSize(4);
            JScrollPane textScroller = new JScrollPane(this.text);
            JSplitPane splitter = new JSplitPane(0);
            splitter.setLeftComponent(treeScroller);
            splitter.setRightComponent(textScroller);
            splitter.setDividerSize(2);
            splitter.setResizeWeight(0.6);
            content.add((Component)splitter, "Center");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Frame f = (Frame)e.getSource();
                    f.setVisible(false);
                    f.dispose();
                }
            });
            this.setSize(320, 480);
        }

        private void displayText(String s) {
            this.text.setText(s);
        }

        private class MyTreeSelectionListener
        implements TreeSelectionListener {
            private MyTreeSelectionListener() {
            }

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                TreePath path = event.getPath();
                MyTreeNode ast = (MyTreeNode)path.getLastPathComponent();
                StringBuilder buf = new StringBuilder();
                buf.append("name:\t").append(ast.message);
                if (ast.currentFile != null) {
                    buf.append("\nfile:\t").append(ast.currentFile.getAbsolutePath());
                    if (!APTUtils.isEOF((Token)ast.token[0])) {
                        buf.append("\npos:\t").append(ast.token[0].getLine()).append(':').append(ast.token[0].getColumn());
                    }
                }
                for (int i = 0; i < ast.token.length; ++i) {
                    buf.append("\ntoken:\t").append(ast.token[i]);
                }
                ASTFrame.this.displayText(buf.toString());
            }
        }
    }

    private static final class MyTreeNode
    extends DefaultMutableTreeNode {
        private final String message;
        private final Token[] token;
        private final CsmFile currentFile;

        private MyTreeNode(String message, CsmFile currentFile, Token ... token) {
            this.message = message;
            this.token = token;
            this.currentFile = currentFile;
        }

        private void addNode(MyTreeNode node) {
            this.insert(node, this.getChildCount());
        }

        @Override
        public String toString() {
            return this.getUserObject().toString();
        }

        @Override
        public Object getUserObject() {
            StringBuilder buf = new StringBuilder(this.message);
            if (this.currentFile != null) {
                buf.append(" ").append(PathUtilities.getBaseName((String)this.currentFile.getAbsolutePath().toString()));
                if (this.token.length > 0 && !APTUtils.isEOF((Token)this.token[0])) {
                    buf.append("[").append(this.token[0].getLine()).append(':').append(this.token[0].getColumn()).append("]");
                }
            }
            if (this.token.length > 0) {
                buf.append(' ');
                buf.append(this.token[0]);
            }
            return buf.toString();
        }
    }

    private static final class TreeTraceWriter
    extends OutputTraceWriter {
        private final MyTreeNode root;
        private ASTFrame tree;
        private volatile MyTreeNode current;

        private TreeTraceWriter(Object parser) {
            super(parser);
            final CsmFile mainFile = parser instanceof CppParserActionImpl ? ((CppParserActionImpl)parser).getMainFile() : null;
            this.current = this.root = new MyTreeNode("root", null, new Token[0]);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (mainFile == null) {
                        TreeTraceWriter.this.tree = new ASTFrame("AST", TreeTraceWriter.this.root);
                    } else {
                        TreeTraceWriter.this.tree = new ASTFrame(CndPathUtilities.getBaseName((String)mainFile.getAbsolutePath().toString()), TreeTraceWriter.this.root);
                    }
                    TreeTraceWriter.this.tree.setVisible(true);
                }
            });
        }

        @Override
        public void printIn(String message, Token ... token) {
            super.printIn(message, token);
            if (this.current != null) {
                CsmFile currentFile = null;
                if (this.parser != null) {
                    currentFile = this.parser.getCurrentFile();
                }
                MyTreeNode node = new MyTreeNode(message, currentFile, token);
                this.current.addNode(node);
                this.current = node;
            }
        }

        @Override
        public void printOut(String message, Token ... token) {
            super.printOut(message, token);
            if (this.current != null) {
                this.current = (MyTreeNode)this.current.getParent();
                if (this.current != null) {
                    CsmFile currentFile = null;
                    if (this.parser != null) {
                        currentFile = this.parser.getCurrentFile();
                    }
                    MyTreeNode node = new MyTreeNode(message, currentFile, token);
                    this.current.addNode(node);
                }
            }
        }

        @Override
        public void print(String message, Token ... token) {
            super.print(message, token);
            if (this.current != null) {
                CsmFile currentFile = null;
                if (this.parser != null) {
                    currentFile = this.parser.getCurrentFile();
                }
                MyTreeNode node = new MyTreeNode(message, currentFile, token);
                this.current.addNode(node);
            }
        }
    }

    private static class OutputTraceWriter
    extends SimpleTraceWriter {
        private final InputOutput io;
        private final OutputWriter out;

        private OutputTraceWriter(Object parser) {
            super(parser);
            CsmFile mainFile = parser instanceof CppParserActionImpl ? ((CppParserActionImpl)parser).getMainFile() : null;
            this.io = mainFile == null ? IOProvider.getDefault().getIO("Trace actions", false) : IOProvider.getDefault().getIO("Trace actions " + CndPathUtilities.getBaseName((String)mainFile.getAbsolutePath().toString()), false);
            this.io.select();
            this.out = this.io.getOut();
        }

        @Override
        protected void println(String s) {
            this.out.println(s);
        }
    }

    private static class SimpleTraceWriter
    implements TraceWriter {
        private final LinkedList<String> stack = new LinkedList();
        private int level = 0;
        protected final CppParserActionImpl parser;

        private SimpleTraceWriter(Object parser) {
            this.parser = parser instanceof CppParserActionImpl ? (CppParserActionImpl)parser : null;
        }

        protected void println(String s) {
            System.out.println(s);
        }

        @Override
        public void printIn(String message, Token ... token) {
            this.stack.addLast(message);
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.level; ++i) {
                buf.append(' ').append(' ');
            }
            buf.append('>');
            buf.append(message);
            int backTracking = 0;
            CharSequence path = "";
            if (this.parser != null) {
                backTracking = this.parser.getBacktrackingLevel();
                path = this.parser.getCurrentFile().getAbsolutePath();
            }
            if (backTracking != 0) {
                buf.append(" GUESSING LEVEL = ");
                buf.append(Integer.toString(backTracking));
            }
            if (token.length > 0) {
                buf.append(' ');
                buf.append(path);
                if (!APTUtils.isEOF((Token)token[0])) {
                    buf.append('[');
                    buf.append(Integer.toString(token[0].getLine()));
                    buf.append(',');
                    buf.append(Integer.toString(token[0].getColumn()));
                    buf.append(']');
                }
                for (int j = 0; j < token.length; ++j) {
                    buf.append(' ');
                    buf.append(token[j]);
                }
            }
            this.println(buf.toString());
            ++this.level;
        }

        @Override
        public void printOut(String message, Token ... token) {
            String top = this.stack.removeLast();
            if (!message.equals(top)) {
                this.println("UNBALANCED exit. Actual " + message + " Expected " + top);
            }
            --this.level;
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.level; ++i) {
                buf.append(' ').append(' ');
            }
            buf.append('<');
            buf.append(message);
            int backTracking = 0;
            CharSequence path = "";
            if (this.parser != null) {
                backTracking = this.parser.getBacktrackingLevel();
                path = this.parser.getCurrentFile().getAbsolutePath();
            }
            if (backTracking != 0) {
                buf.append(" GUESSING LEVEL = ");
                buf.append(Integer.toString(backTracking));
            }
            if (token.length > 0) {
                buf.append(' ');
                buf.append(path);
                if (!APTUtils.isEOF((Token)token[0])) {
                    buf.append('[');
                    buf.append(Integer.toString(token[0].getLine()));
                    buf.append(',');
                    buf.append(Integer.toString(token[0].getColumn()));
                    buf.append(']');
                    buf.append(' ');
                }
                for (int j = 0; j < token.length; ++j) {
                    buf.append(' ');
                    buf.append(token[j]);
                }
            }
            this.println(buf.toString());
        }

        @Override
        public void print(String message, Token ... token) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.level; ++i) {
                buf.append(' ').append(' ');
            }
            buf.append(' ');
            buf.append(message);
            int backTracking = 0;
            CharSequence path = "";
            if (this.parser != null) {
                backTracking = this.parser.getBacktrackingLevel();
                path = this.parser.getCurrentFile().getAbsolutePath();
            }
            if (backTracking != 0) {
                buf.append(" GUESSING LEVEL = ");
                buf.append(Integer.toString(backTracking));
            }
            if (token.length > 0) {
                buf.append(' ');
                buf.append(path);
                if (!APTUtils.isEOF((Token)token[0])) {
                    buf.append('[');
                    buf.append(Integer.toString(token[0].getLine()));
                    buf.append(',');
                    buf.append(Integer.toString(token[0].getColumn()));
                    buf.append(']');
                    buf.append(' ');
                }
                for (int j = 0; j < token.length; ++j) {
                    buf.append(' ');
                    buf.append(token[j]);
                }
            }
            this.println(buf.toString());
        }
    }

    public static interface TraceWriter {
        public void printIn(String var1, Token ... var2);

        public void printOut(String var1, Token ... var2);

        public void print(String var1, Token ... var2);
    }
}

