/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.antlr.ASTVisitor;
import org.netbeans.modules.cnd.antlr.RecognitionException;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTBuilder;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTIncludePathStorage;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTMacroExpandedStream;
import org.netbeans.modules.cnd.apt.support.APTSystemStorage;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.support.ClankDriver;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.support.api.PPIncludeHandler;
import org.netbeans.modules.cnd.apt.support.api.PPMacroMap;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.support.api.StartEntry;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageSupport;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTTraceUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.accessors.CsmCorePackageAccessor;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.CPPParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelimpl.trace.APTWalkerTest;
import org.netbeans.modules.cnd.modelimpl.trace.ASTFrameEx;
import org.netbeans.modules.cnd.modelimpl.trace.TraceModelBase;
import org.netbeans.modules.cnd.modelimpl.trace.TraceModelFileFilter;
import org.netbeans.modules.cnd.repository.support.RepositoryTestUtils;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;

public class TraceModel
extends TraceModelBase {
    private static final int APT_REPEAT_TEST = Integer.getInteger("apt.repeat.test", 3);
    private static CsmTracer tracer = new CsmTracer(false);
    private boolean showAstWindow = false;
    private boolean dumpAst = false;
    private boolean dumpModel = false;
    private boolean dumpLib = false;
    private boolean dumpFileOnly = false;
    private boolean showTime = false;
    private boolean testLibProject = false;
    private boolean deep = true;
    private boolean showMemoryUsage = false;
    private boolean testUniqueName = false;
    private int testAPTIterations = APT_REPEAT_TEST;
    private boolean testAPT = false;
    private boolean testAPTLexer = false;
    private boolean testAPTDriver = false;
    private boolean testAPTWalkerVisit = false;
    private boolean testAPTWalkerGetStream = false;
    private boolean testAPTWalkerGetExpandedStream = false;
    private boolean testAPTWalkerGetFilteredStream = false;
    private boolean testAPTParser = false;
    private boolean breakAfterAPT = false;
    private boolean stopBeforeAll = false;
    private boolean stopAfterAll = false;
    private boolean printTokens = false;
    private boolean dumpModelAfterCleaningCache = false;
    private boolean dumpTemplateParameters = false;
    private int repeatCount = 1;
    private boolean dumpStatistics = false;
    private static final int DEFAULT_TRACEMODEL_STATISTICS_LEVEL = 1;
    private String dumpFile = null;
    private String dumpDir = null;
    private static final String statPostfix = ".stat";
    private boolean dumpPPState = false;
    private boolean listFilesAtEnd = false;
    private boolean testRawPerformance = false;
    private boolean printUserFileList = false;
    private boolean quiet = false;
    private boolean memBySize = false;
    private boolean doCleanRepository = Boolean.getBoolean("cnd.clean.repository");
    private Map<String, Long> cacheTimes = new HashMap<String, Long>();
    private int lap = 0;
    private final Map<CsmFile, PreprocHandler> states = new ConcurrentHashMap<CsmFile, PreprocHandler>();
    TestHook hook = new TestHook(){

        @Override
        public void parsingFinished(CsmFile file, PreprocHandler preprocHandler) {
            if (TraceModel.this.dumpPPState) {
                TraceModel.this.states.put(file, preprocHandler);
            }
        }
    };
    private ParsingTimeResultListener parsingTimeResultListener;
    private final APTSystemStorage sysAPTData = APTSystemStorage.getInstance();
    private final APTIncludePathStorage userPathStorage = new APTIncludePathStorage();
    private static String firstFile = null;
    long minDriver = Long.MAX_VALUE;
    long maxDriver = Long.MIN_VALUE;

    void addParsingTimeResultListener(ParsingTimeResultListener listener) {
        this.parsingTimeResultListener = listener;
    }

    public static void main(String[] args) {
        new TraceModel(true).test(args);
        APTDriver.close();
        ClankDriver.close();
        APTFileCacheManager.close();
    }

    public void setDumpModel(boolean dumpModel) {
        this.dumpModel = dumpModel;
    }

    public void setDumpPPState(boolean dumpPPState) {
        this.dumpPPState = dumpPPState;
    }

    public boolean isDumpingPPState() {
        return this.dumpPPState;
    }

    private void notifyPrseTime(TestResult total) {
        if (this.parsingTimeResultListener != null) {
            this.parsingTimeResultListener.notifyParsingTime(total);
        }
    }

    @Override
    protected void shutdown(boolean clearCache) {
        super.shutdown(clearCache);
        this.states.clear();
    }

    public TraceModel(boolean cleanCache) {
        this(cleanCache, null);
    }

    public TraceModel(boolean cleanCache, TraceModelFileFilter filter) {
        super(cleanCache, filter);
        CsmCorePackageAccessor.get().setFileImplTestHook(this.hook);
    }

    @Override
    protected TraceModelBase.ProcessFlagResult processFlag(char flag, String argRest) {
        TraceModelBase.ProcessFlagResult result = super.processFlag(flag, argRest);
        if (result != TraceModelBase.ProcessFlagResult.NONE_PROCESSED) {
            return result;
        }
        result = TraceModelBase.ProcessFlagResult.CHAR_PROCESSED;
        switch (flag) {
            case 'n': {
                this.deep = false;
                break;
            }
            case 'E': {
                this.testAPTIterations = 0;
                this.testAPTWalkerGetFilteredStream = true;
                this.printTokens = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'e': {
                System.setErr(System.out);
                break;
            }
            case 'w': {
                this.showAstWindow = true;
                break;
            }
            case 'a': {
                this.dumpAst = true;
                break;
            }
            case 'm': {
                this.dumpModel = true;
                this.dumpFileOnly = false;
                break;
            }
            case 'M': {
                this.showMemoryUsage = true;
                break;
            }
            case 'u': {
                this.testUniqueName = true;
                break;
            }
            case 'f': {
                if (this.dumpModel) break;
                this.dumpModel = true;
                this.dumpFileOnly = true;
                break;
            }
            case 't': {
                this.showTime = true;
                break;
            }
            case 'l': {
                this.testLibProject = true;
                break;
            }
            case 'p': {
                this.dumpPPState = true;
                break;
            }
            case 'S': {
                this.dumpStatistics = true;
                if (argRest.length() <= 0) break;
                File perFileDumpDir = new File(argRest);
                perFileDumpDir.mkdirs();
                if (!perFileDumpDir.isDirectory()) {
                    TraceModel.print("Parameter -S" + argRest + " does not specify valid directory");
                } else {
                    this.dumpDir = perFileDumpDir.getAbsolutePath();
                }
                result = TraceModelBase.ProcessFlagResult.ALL_PROCESSED;
                break;
            }
            case 's': {
                this.dumpStatistics = true;
                if (argRest.length() <= 0) break;
                File globalDumpFile = new File(argRest);
                if (globalDumpFile.exists()) {
                    globalDumpFile.delete();
                }
                try {
                    if (globalDumpFile.getParentFile() == null) break;
                    globalDumpFile.getParentFile().mkdirs();
                    globalDumpFile.createNewFile();
                    this.dumpFile = globalDumpFile.getAbsolutePath();
                    result = TraceModelBase.ProcessFlagResult.ALL_PROCESSED;
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                break;
            }
            case 'A': {
                this.testAPT = true;
                this.testAPTWalkerVisit = true;
                this.testAPTWalkerGetStream = true;
                this.testAPTWalkerGetExpandedStream = true;
                this.testAPTWalkerGetFilteredStream = true;
                this.testAPTLexer = true;
                this.breakAfterAPT = true;
                this.testAPTDriver = true;
                break;
            }
            case 'B': {
                this.testAPTLexer = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'o': {
                this.printTokens = true;
                break;
            }
            case 'v': {
                this.testAPTWalkerVisit = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'g': {
                this.testAPTWalkerGetStream = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'G': {
                this.testAPTWalkerGetExpandedStream = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'F': {
                this.testAPTWalkerGetFilteredStream = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'd': {
                this.testAPTDriver = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'h': {
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'H': {
                this.testAPTParser = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'O': {
                this.stopBeforeAll = true;
                this.stopAfterAll = true;
                break;
            }
            case 'q': {
                this.quiet = true;
                break;
            }
            default: {
                result = TraceModelBase.ProcessFlagResult.NONE_PROCESSED;
            }
        }
        return result;
    }

    @Override
    protected boolean processFlag(String flag) {
        if (super.processFlag(flag)) {
            return true;
        }
        if ("dumplib".equals(flag)) {
            this.dumpLib = true;
        } else if ("listfiles".equals(flag)) {
            this.listFilesAtEnd = true;
        } else if ("raw".equals(flag)) {
            this.testRawPerformance = true;
        } else if ("listfiles".equals(flag)) {
            this.printUserFileList = true;
        } else if ("mbs".equals(flag)) {
            this.memBySize = true;
        } else if ("cleanrepository".equals(flag)) {
            this.doCleanRepository = true;
        } else if ("clean4dump".equals(flag)) {
            this.dumpModelAfterCleaningCache = true;
        } else if ("tparm".equals(flag)) {
            this.dumpTemplateParameters = true;
        } else if ("repeat".equals(flag) || flag.startsWith("repeat:")) {
            int len = "repeat".length();
            this.repeatCount = flag.length() == len ? 2 : Integer.parseInt(flag.substring(len + 1));
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(String[] args) {
        try {
            this.processArguments(args);
            this.doTest();
        }
        catch (Error thr) {
            System.err.printf("%n", new Object[0]);
            DiagnosticExceptoins.register(thr);
            return;
        }
        finally {
            this.getModel().shutdown();
        }
    }

    void doTest() {
        if (this.repeatCount > 1) {
            for (int i = 0; i < this.repeatCount; ++i) {
                TraceModel.print("\n\n==================== Pass " + i + "====================\n");
                this.doTest2();
                this.resetProject();
            }
        } else {
            this.doTest2();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doTest2() {
        List<String> restoredFiles;
        if (this.stopBeforeAll) {
            this.waitAnyKey();
        }
        if (this.dumpStatistics) {
            if (this.dumpFile == null && this.dumpDir == null) {
                TraceModel.print("Turning OFF statistics as neither global file nor directory is specified");
                this.dumpStatistics = false;
            } else {
                TraceModel.print("Dumping Statistics is ON");
                if (Diagnostic.getStatisticsLevel() == 0) {
                    Diagnostic.setStatisticsLevel(1);
                }
                if (this.dumpFile != null) {
                    TraceModel.print("Global Dump file is " + this.dumpFile);
                }
                if (this.dumpDir != null) {
                    TraceModel.print("Dump directory for per file statistics is " + this.dumpDir);
                }
            }
        }
        if (this.testLibProject) {
            this.testLibProject();
        }
        if (this.printUserFileList) {
            TraceModel.print("Processing files:\n");
            for (NativeFileItem file : this.getFileItems()) {
                this.print(file.getAbsolutePath() + ' ', false);
            }
            TraceModel.print("");
        }
        long memUsed = 0L;
        if (this.showMemoryUsage) {
            memUsed = this.usedMemory();
        }
        long t = System.currentTimeMillis();
        TestResult total = this.test();
        total.time = System.currentTimeMillis() - t;
        this.notifyPrseTime(total);
        if (this.testRawPerformance) {
            TraceModel.print("Take one finished.");
            TraceModel.print("Total parsing time " + total.time + " ms");
            this.calculateAverageLPS(total, true);
            TraceModel.print("Lines count " + total.lineCount);
            TraceModel.print("Average LPS " + total.getLPS());
            if (this.showMemoryUsage) {
                this.showMemoryUsage(memUsed);
            }
            TraceModel.print("\nTesting raw performance: parsing project, take two\n");
            this.resetProject();
            if (this.stopBeforeAll) {
                this.waitAnyKey();
            }
            t = System.currentTimeMillis();
            total = this.test();
            total.time = System.currentTimeMillis() - t;
        }
        if (this.dumpLib) {
            CsmCacheManager.enter();
            try {
                for (CsmProject lib : this.getProject().getLibraries()) {
                    tracer.dumpModel(lib);
                }
            }
            finally {
                CsmCacheManager.leave();
            }
        }
        if (this.isShowTime()) {
            int maxLen = 0;
            for (int i = 0; i < CPPParserEx.MAX_GUESS_IDX; ++i) {
                int len;
                if (CPPParserEx.guessingNames[i] == null || (len = CPPParserEx.guessingNames[i].length()) <= maxLen) continue;
                maxLen = len;
            }
            boolean printGuessStat = false;
            for (int i = 0; i < CPPParserEx.MAX_GUESS_IDX; ++i) {
                if (CPPParserEx.guessingCount[i] == 0L) continue;
                printGuessStat = true;
                break;
            }
            if (this.listFilesAtEnd) {
                TraceModel.print("\n========== User project files ==========");
                ArrayList<CharSequence> l = new ArrayList<CharSequence>(this.getProject().getAllFiles().size());
                for (CsmFile file : this.getProject().getAllFiles()) {
                    l.add(file.getAbsolutePath());
                }
                Collections.sort(l, CharSequences.comparator());
                Iterator<Object> it = l.iterator();
                while (it.hasNext()) {
                    TraceModel.print((String)it.next());
                }
                TraceModel.print("\n========== Library files ==========");
                l = new ArrayList();
                for (ProjectBase lib : this.getProject().getLibraries()) {
                    for (CsmFile file : lib.getAllFiles()) {
                        l.add(file.getAbsolutePath());
                    }
                }
                Collections.sort(l, CharSequences.comparator());
                it = l.iterator();
                while (it.hasNext()) {
                    TraceModel.print((String)it.next());
                }
            }
            if (printGuessStat) {
                TraceModel.print("\nGuessing statistics:");
                TraceModel.print("Id\t" + this.padR("Rule:Line", maxLen) + "\tTime" + "\tCount" + "\tFail" + "\tSuccess, %");
                long guessingTime = 0L;
                for (int i = 0; i < CPPParserEx.MAX_GUESS_IDX; ++i) {
                    guessingTime += CPPParserEx.guessingTimes[i];
                    double usa = 0.0;
                    if (CPPParserEx.guessingCount[i] != 0L) {
                        usa = (1.0 - (double)CPPParserEx.guessingFailures[i] / (double)CPPParserEx.guessingCount[i]) * 100.0;
                    }
                    TraceModel.print("" + i + "\t" + this.padR(CPPParserEx.guessingNames[i], maxLen) + "\t" + CPPParserEx.guessingTimes[i] + "\t" + CPPParserEx.guessingCount[i] + "\t" + CPPParserEx.guessingFailures[i] + "\t" + (int)usa);
                }
                TraceModel.print("\nTotal guessing time: " + guessingTime + "ms " + "(" + (total.getTime() != 0L ? guessingTime * 100L / total.getTime() : -1L) + "% of total parse time)");
            }
        }
        if (this.isShowTime() || this.testRawPerformance) {
            TraceModel.print("Total parsing time: " + total.getTime() + "ms");
            this.calculateAverageLPS(total, !this.testRawPerformance);
            TraceModel.print("Lines count " + total.lineCount);
            String text = this.testRawPerformance ? "Raw performance (average LPS): " : "Average LPS: ";
            TraceModel.print(text + total.getLPS());
            int userFiles = this.countUserFiles();
            int systemHeaders = this.countSystemHeaders();
            TraceModel.print("" + userFiles + " user files");
            TraceModel.print("" + systemHeaders + " system headers");
        }
        if (this.showMemoryUsage) {
            this.showMemoryUsage(memUsed);
        }
        if (this.isShowTime() || this.showMemoryUsage || this.dumpModel || this.dumpFileOnly || this.dumpPPState) {
            TraceModel.print("\n");
        }
        if (this.dumpStatistics && this.dumpFile != null) {
            try {
                Diagnostic.dumpUnresolvedStatistics(this.dumpFile, true);
            }
            catch (FileNotFoundException e) {
                DiagnosticExceptoins.register(e);
            }
        }
        if (TraceFlags.CLEAN_MACROS_AFTER_PARSE && (restoredFiles = ProjectBase.testGetRestoredFiles()) != null) {
            System.err.println("the number of restored files " + restoredFiles.size());
            for (int i = 0; i < restoredFiles.size(); ++i) {
                System.err.println("#" + i + ":" + restoredFiles.get(i));
            }
        }
        if (this.dumpModelAfterCleaningCache) {
            this.anyKey("Press any key to clean repository:");
            RepositoryTestUtils.deleteDefaultCacheLocation();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            this.anyKey("Press any key to dump model:");
            if (!this.dumpFileOnly) {
                CsmCacheManager.enter();
                try {
                    tracer.dumpModel((CsmProject)this.getProject());
                }
                finally {
                    CsmCacheManager.leave();
                }
            }
        }
        if (this.stopAfterAll) {
            System.gc();
            this.anyKey("Press any key to finish:");
        }
    }

    private void anyKey(String message) {
        System.err.println(message);
        try {
            System.in.read();
        }
        catch (IOException ex) {
            DiagnosticExceptoins.register(ex);
        }
    }

    private void showMemoryUsage(long memUsed) {
        long newMemUsed = this.usedMemory();
        long memDelta = newMemUsed - memUsed;
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setGroupingUsed(true);
        nf.setMinimumIntegerDigits(6);
        TraceModel.print("Amount of memory used" + this.getLap() + ": " + nf.format(memDelta / 1024L) + " Kb");
        if (this.memBySize) {
            TestResult rInc = new TestResult();
            TestResult rExc = new TestResult();
            this.calculateAverageLPS(rInc, true);
            this.calculateAverageLPS(rExc, false);
            TraceModel.print("User code lines:  " + rExc.lineCount);
            TraceModel.print("Total lines (including all headers):  " + rInc.lineCount);
            TraceModel.print("Memory usage per (user) line " + this.getLap() + '\t' + nf.format(memDelta / rExc.lineCount) + " bytes per line");
            TraceModel.print("Memory usage per (total) line" + this.getLap() + '\t' + nf.format(memDelta / rInc.lineCount) + " bytes per line");
        }
    }

    private void waitAnyKey() {
        System.out.println("Press any key to continue:");
        try {
            System.in.read();
        }
        catch (IOException ex) {
            DiagnosticExceptoins.register(ex);
        }
    }

    private TestResult test() {
        ++this.lap;
        TestResult total = new TestResult();
        for (NativeFileItem item : this.getFileItems()) {
            try {
                TestResult res = this.test(item);
                total.accumulate(res);
            }
            catch (Exception e) {
                DiagnosticExceptoins.register(e);
            }
        }
        return total;
    }

    private String getLap() {
        return " (lap " + this.lap + ") ";
    }

    private String padR(String s, int len) {
        if (s == null) {
            s = "";
        }
        if (s.length() >= len) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        sb.setLength(len);
        for (int i = s.length(); i < len; ++i) {
            sb.setCharAt(i, ' ');
        }
        return sb.toString();
    }

    private void sleep(int timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private PPIncludeHandler getIncludeHandler(FileObject fo) {
        FileSystem localFS = CndFileUtils.getLocalFileSystem();
        List systemIncludes = CndFileUtils.toFSPathList((FileSystem)localFS, this.getSystemIncludes());
        List sysIncludes = this.sysAPTData.getIncludes((CharSequence)systemIncludes.toString(), systemIncludes);
        List<String> qInc = this.getQuoteIncludePaths();
        if (this.isPathsRelCurFile()) {
            qInc = new ArrayList<String>(this.getQuoteIncludePaths().size());
            for (String path : this.getQuoteIncludePaths()) {
                if (CndPathUtilities.isPathAbsolute((CharSequence)path)) {
                    qInc.add(path);
                    continue;
                }
                FileObject dirFO = fo.getParent();
                FileObject pathFile = dirFO.getFileObject(path);
                if (pathFile == null || !pathFile.isValid()) continue;
                path = pathFile.getPath();
                qInc.add(path);
            }
        }
        StartEntry startEntry = new StartEntry(localFS, fo.getPath(), this.getProject().getUIDKey());
        List userIncludes = this.userPathStorage.get((CharSequence)qInc.toString(), CndFileUtils.toFSPathList((FileSystem)localFS, qInc));
        return APTHandlersSupport.createIncludeHandler((StartEntry)startEntry, (List)sysIncludes, (List)userIncludes, Collections.emptyList(), null);
    }

    private PPMacroMap getMacroMap(FileObject fo) {
        PPMacroMap map = APTHandlersSupport.createMacroMap((PPMacroMap)this.getSysMap(fo), this.getMacros());
        return map;
    }

    private PPMacroMap getSysMap(FileObject fo) {
        PPMacroMap map = this.sysAPTData.getMacroMap("TraceModelSysMacros", this.getSysMacros());
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long testAPTLexer(FileObject fo, boolean printTokens) throws FileNotFoundException, RecognitionException, TokenStreamException, IOException, ClassNotFoundException {
        TraceModel.print("Testing APT lexer:");
        long time = System.currentTimeMillis();
        Reader reader = null;
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(fo.getInputStream(), TraceFlags.BUF_SIZE);
            reader = new InputStreamReader((InputStream)stream, FileEncodingQuery.getDefaultEncoding());
            TokenStream ts = APTTokenStreamBuilder.buildTokenStream((CharSequence)fo.getPath(), (Reader)reader, (String)TraceModel.getFileLanguage(fo));
            Token t = ts.nextToken();
            while (!APTUtils.isEOF((Token)t)) {
                if (printTokens) {
                    TraceModel.print("" + t);
                }
                t = ts.nextToken();
            }
            time = System.currentTimeMillis() - time;
            if (this.isShowTime()) {
                TraceModel.print("APT Lexing " + fo.getNameExt() + " took " + time + " ms");
            }
            long l = time;
            return l;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (stream != null) {
                ((InputStream)stream).close();
            }
        }
    }

    private long testAPTWalkerVisit(APTFile apt, FileBuffer buffer) throws TokenStreamException, IOException {
        FileObject fo = buffer.getFileObject();
        boolean cleanAPT = apt == null;
        long time = System.currentTimeMillis();
        if (cleanAPT) {
            this.invalidateAPT(buffer);
            time = System.currentTimeMillis();
            apt = APTDriver.findAPTLight((APTFileBuffer)buffer);
        }
        PreprocHandler ppHandler = APTHandlersSupport.createPreprocHandler((PPMacroMap)this.getMacroMap(fo), (PPIncludeHandler)this.getIncludeHandler(fo), (boolean)true, (CharSequence)CharSequences.empty(), (CharSequence)CharSequences.empty());
        APTWalkerTest walker = new APTWalkerTest(apt, ppHandler);
        walker.visit();
        time = System.currentTimeMillis() - time;
        if (this.isShowTime()) {
            TraceModel.print("Visiting APT " + (cleanAPT ? "with cleaning APT in driver" : "") + " took " + time + " ms");
            TraceModel.print(" resolving include paths took " + walker.getIncludeResolvingTime() + " ms");
        }
        return time;
    }

    private long testAPTWalkerGetStream(APTFile apt, FileBuffer buffer, boolean expand, boolean filter, boolean printTokens) throws TokenStreamException, IOException {
        FileObject fo = buffer.getFileObject();
        boolean cleanAPT = apt == null;
        long time = System.currentTimeMillis();
        if (cleanAPT) {
            this.invalidateAPT(buffer);
            time = System.currentTimeMillis();
            apt = APTDriver.findAPT((APTFileBuffer)buffer, (String)TraceModel.getFileLanguage(fo), (String)"");
        }
        PPMacroMap macroMap = this.getMacroMap(fo);
        PreprocHandler ppHandler = APTHandlersSupport.createPreprocHandler((PPMacroMap)macroMap, (PPIncludeHandler)this.getIncludeHandler(fo), (boolean)true, (CharSequence)CharSequences.empty(), (CharSequence)CharSequences.empty());
        APTWalkerTest walker = new APTWalkerTest(apt, ppHandler);
        TokenStream ts = walker.getTokenStream();
        if (expand) {
            ts = new APTMacroExpandedStream(ts, (APTMacroCallback)macroMap, false);
        }
        if (filter) {
            ts = APTLanguageSupport.getInstance().getFilter("Gnu C++ Language").getFilteredStream((TokenStream)new APTCommentsFilter(ts));
        }
        int lastLine = -1;
        boolean forceNewLine = false;
        Token t = ts.nextToken();
        while (!APTUtils.isEOF((Token)t)) {
            if (printTokens) {
                String text = " " + t.getText();
                boolean newLine = forceNewLine || t.getLine() != lastLine;
                forceNewLine = false;
                if (TraceModel.isIncludeToken(t.getType())) {
                    APTToken aptToken = (APTToken)t;
                    ResolvedPath path = (ResolvedPath)aptToken.getProperty(ResolvedPath.class);
                    if (path != null) {
                        assert (aptToken.getProperty(Boolean.class) != null);
                        String prefix = (Boolean)aptToken.getProperty(Boolean.class) != false ? "#=> " : "#<= ";
                        text = prefix + "\"" + path.getPath() + "\" [" + path.getFolder() + "]";
                    } else {
                        text = "#include " + t.toString();
                    }
                    newLine = true;
                    forceNewLine = true;
                }
                this.print(text, newLine);
            }
            lastLine = t.getLine();
            t = ts.nextToken();
        }
        if (printTokens && lastLine >= 0) {
            this.print("", true);
        }
        time = System.currentTimeMillis() - time;
        if (this.isShowTime()) {
            TraceModel.print("Getting" + (expand ? " expanded" : "") + (filter ? " filtered" : "") + " APT token stream " + (cleanAPT ? "with cleaning APT in driver" : "") + " took " + time + " ms");
            TraceModel.print(" resolving include paths took " + walker.getIncludeResolvingTime() + " ms");
        }
        return time;
    }

    private static boolean isIncludeToken(int kind) {
        return kind == 95 || kind == 96;
    }

    private long testAPTParser(NativeFileItem item, boolean cleanAPT) throws IOException, RecognitionException, TokenStreamException {
        FileBuffer buffer = ModelSupport.createFileBuffer(item.getFileObject());
        TraceModel.print("Testing APT Parser");
        long time = System.currentTimeMillis();
        if (cleanAPT) {
            this.invalidateAPT(buffer);
            time = System.currentTimeMillis();
        }
        FileImpl fileImpl = (FileImpl)this.getProject().testAPTParseFile(item);
        this.getProject().waitParse();
        time = System.currentTimeMillis() - time;
        if (this.isShowTime()) {
            TraceModel.print("Parsing" + (cleanAPT ? " with cleaning APT in driver" : "") + " took " + time + " ms");
        }
        return time;
    }

    private void testAPT(NativeFileItem item) throws FileNotFoundException, RecognitionException, TokenStreamException, IOException, ClassNotFoundException {
        FileObject fo = item.getFileObject();
        FileBuffer buffer = ModelSupport.createFileBuffer(item.getFileObject());
        TraceModel.print("Testing APT: " + fo.getNameExt());
        long minLexer = Long.MAX_VALUE;
        long maxLexer = Long.MIN_VALUE;
        long minAPTLexer = Long.MAX_VALUE;
        long maxAPTLexer = Long.MIN_VALUE;
        if (this.testAPTLexer) {
            for (int i = -1; i < this.testAPTIterations; ++i) {
                long val = this.testAPTLexer(fo, i == -1 ? this.printTokens : false);
                minAPTLexer = Math.min(minAPTLexer, val);
                maxAPTLexer = Math.max(maxAPTLexer, val);
            }
        }
        APTFile apt = null;
        this.minDriver = Long.MAX_VALUE;
        this.maxDriver = Long.MIN_VALUE;
        if (this.testAPTDriver) {
            for (int i = -1; i < this.testAPTIterations; ++i) {
                this.invalidateAPT(buffer);
                apt = this.testAPTDriver(buffer, i == -1);
            }
        }
        boolean cleanAPT = this.minDriver == Long.MAX_VALUE;
        long minVisit = Long.MAX_VALUE;
        long maxVisit = Long.MIN_VALUE;
        if (this.testAPTWalkerVisit) {
            for (int i = -1; i < this.testAPTIterations; ++i) {
                long val = this.testAPTWalkerVisit(apt, buffer);
                minVisit = Math.min(minVisit, val);
                maxVisit = Math.max(maxVisit, val);
            }
        }
        long minGetTS = Long.MAX_VALUE;
        long maxGetTS = Long.MIN_VALUE;
        if (this.testAPTWalkerGetStream) {
            for (int i = -1; i < this.testAPTIterations; ++i) {
                long val = this.testAPTWalkerGetStream(apt, buffer, false, false, i == -1 ? this.printTokens : false);
                minGetTS = Math.min(minGetTS, val);
                maxGetTS = Math.max(maxGetTS, val);
            }
        }
        long minGetExpandedTS = Long.MAX_VALUE;
        long maxGetExpandedTS = Long.MIN_VALUE;
        if (this.testAPTWalkerGetExpandedStream) {
            for (int i = -1; i < this.testAPTIterations; ++i) {
                long val = this.testAPTWalkerGetStream(apt, buffer, true, false, i == -1 ? this.printTokens : false);
                minGetExpandedTS = Math.min(minGetExpandedTS, val);
                maxGetExpandedTS = Math.max(maxGetExpandedTS, val);
            }
        }
        long minGetFilteredTS = Long.MAX_VALUE;
        long maxGetFilteredTS = Long.MIN_VALUE;
        if (this.testAPTWalkerGetFilteredStream) {
            for (int i = -1; i < this.testAPTIterations; ++i) {
                long val = this.testAPTWalkerGetStream(apt, buffer, true, true, i == -1 ? this.printTokens : false);
                minGetFilteredTS = Math.min(minGetFilteredTS, val);
                maxGetFilteredTS = Math.max(maxGetFilteredTS, val);
            }
        }
        long minParsing = Long.MAX_VALUE;
        long maxParsing = Long.MIN_VALUE;
        long minAPTParsing = Long.MAX_VALUE;
        long maxAPTParsing = Long.MIN_VALUE;
        if (this.testAPTParser) {
            for (int i = -1; i < this.testAPTIterations; ++i) {
                long val = this.testAPTParser(item, cleanAPT);
                minAPTParsing = Math.min(minAPTParsing, val);
                maxAPTParsing = Math.max(maxAPTParsing, val);
            }
        }
        if (this.isShowTime()) {
            TraceModel.print("APT BEST/WORST results for " + fo.getPath());
            if (minLexer != Long.MAX_VALUE) {
                TraceModel.print(minLexer + " ms BEST Plain lexer");
                TraceModel.print(maxLexer + " ms WORST Plain lexer");
            }
            if (minAPTLexer != Long.MAX_VALUE) {
                TraceModel.print(minAPTLexer + " ms BEST APT lexer");
                TraceModel.print(maxAPTLexer + " ms WORST APT lexer");
            }
            if (this.minDriver != Long.MAX_VALUE) {
                TraceModel.print(this.minDriver + " ms BEST Building APT:");
                TraceModel.print(this.maxDriver + " ms WORST Building APT:");
            }
            if (minVisit != Long.MAX_VALUE) {
                TraceModel.print(minVisit + " ms BEST Visiting APT" + (cleanAPT ? " with cleaning APT in driver:" : ":"));
                TraceModel.print(maxVisit + " ms WORST Visiting APT" + (cleanAPT ? " with cleaning APT in driver:" : ":"));
            }
            if (minGetTS != Long.MAX_VALUE) {
                TraceModel.print(minGetTS + " ms BEST Getting APT token stream" + (cleanAPT ? " with cleaning APT in driver:" : ":"));
                TraceModel.print(maxGetTS + " ms WORST Getting APT token stream" + (cleanAPT ? " with cleaning APT in driver:" : ":"));
            }
            if (minGetExpandedTS != Long.MAX_VALUE) {
                TraceModel.print(minGetExpandedTS + " ms BEST Getting Expanded APT token stream" + (cleanAPT ? " with cleaning APT in driver:" : ":"));
                TraceModel.print(maxGetExpandedTS + " ms WORST Getting Expanded APT token stream" + (cleanAPT ? " with cleaning APT in driver:" : ":"));
            }
            if (minGetFilteredTS != Long.MAX_VALUE) {
                TraceModel.print(minGetFilteredTS + " ms BEST Getting Expanded Filtered APT token stream" + (cleanAPT ? " with cleaning APT in driver:" : ":"));
                TraceModel.print(maxGetFilteredTS + " ms WORST Getting Expanded Filtered APT token stream" + (cleanAPT ? " with cleaning APT in driver:" : ":"));
            }
            if (minParsing != Long.MAX_VALUE) {
                TraceModel.print(minParsing + " ms BEST Plaing Parsing");
                TraceModel.print(maxParsing + " ms WORST Plaing Parsing");
            }
            if (minAPTParsing != Long.MAX_VALUE) {
                TraceModel.print(minAPTParsing + " ms BEST APT parsing" + (cleanAPT ? " with cleaning APT in driver:" : ":"));
                TraceModel.print(maxAPTParsing + " ms WORST APT parsing" + (cleanAPT ? " with cleaning APT in driver:" : ":"));
            }
        }
    }

    private void invalidateAPT(FileBuffer buffer) {
        String absPath = buffer.getAbsolutePath().toString();
        if (firstFile == null || firstFile.equalsIgnoreCase(absPath)) {
            firstFile = absPath;
            APTDriver.invalidateAll();
            ClankDriver.invalidateAll();
            APTFileCacheManager.invalidateAll();
            this.getProject().debugInvalidateFiles();
        } else {
            APTDriver.invalidateAPT((APTFileBuffer)buffer);
            ClankDriver.invalidate((APTFileBuffer)buffer);
            APTFileCacheManager.getInstance((FileSystem)buffer.getFileSystem()).invalidate(buffer.getAbsolutePath());
        }
    }

    private APTFile testAPTDriver(FileBuffer buffer, boolean buildXML) throws IOException, FileNotFoundException {
        FileObject fo = buffer.getFileObject();
        long oldMem = this.usedMemory();
        long time = System.currentTimeMillis();
        APTFile apt = APTDriver.findAPT((APTFileBuffer)buffer, (String)TraceModel.getFileLanguage(fo), (String)"");
        time = System.currentTimeMillis() - time;
        long newMem = this.usedMemory();
        if (this.isShowTime()) {
            this.minDriver = Math.min(this.minDriver, time);
            this.maxDriver = Math.max(this.maxDriver, time);
            TraceModel.print("Building APT for " + fo.getNameExt() + "\n SIZE OF FILE:" + fo.getSize() / 1024L + "Kb\n TIME: took " + time + " ms\n MEMORY: changed from " + oldMem / 1024L + " to " + newMem / 1024L + "[" + (newMem - oldMem) / 1024L + "]Kb");
        }
        if (buildXML) {
            File outDir = new File("/tmp/aptout/");
            outDir.mkdirs();
            File outFile = new File(outDir, fo.getNameExt() + ".xml");
            if (outFile.exists()) {
                outFile.delete();
            }
            outFile.createNewFile();
            BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
            APTTraceUtils.xmlSerialize((APT)apt, (Writer)out);
            ((Writer)out).flush();
            APT light = APTBuilder.buildAPTLight((APT)apt);
            File outFileLW = new File(outDir, fo.getNameExt() + "_lw.xml");
            if (outFileLW.exists()) {
                outFileLW.delete();
            }
            outFileLW.createNewFile();
            BufferedWriter outLW = new BufferedWriter(new FileWriter(outFileLW));
            APTTraceUtils.xmlSerialize((APT)light, (Writer)outLW);
            ((Writer)outLW).flush();
        }
        return apt;
    }

    @SuppressWarnings(value={"DM_GC"})
    private long usedMemory() {
        System.gc();
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    void test(String[] args, PrintStream out, PrintStream err) throws Exception {
        tracer.setPrintStream(out);
        this.processArguments(args);
        this.doTest();
        this.initDataObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private TestResult test(NativeFileItem item) throws FileNotFoundException, RecognitionException, TokenStreamException, IOException, ClassNotFoundException {
        result = new TestResult();
        if (this.testAPT) {
            this.testAPT(item);
            if (this.breakAfterAPT) {
                return new TestResult();
            }
        }
        ast = null;
        if (this.dumpStatistics) {
            Diagnostic.initFileStatistics(item.getAbsolutePath());
        }
        time = System.currentTimeMillis();
        tree = null;
        errCount = 0;
        fileImpl = (FileImpl)this.getProject().testAPTParseFile(item);
        TraceModel.waitProjectParsed(this.getProject(), false);
        if (this.dumpAst || this.showAstWindow) {
            tree = fileImpl.debugParse();
        }
        errCount = CsmCorePackageAccessor.get().getErrorCount(fileImpl);
        if (this.dumpPPState) {
            antiLoop = 0;
            while (antiLoop++ < 100 && !this.states.containsKey(fileImpl)) {
                this.sleep(100);
            }
            preprocHandler = this.states.get(fileImpl);
            if (!TraceModel.$assertionsDisabled && preprocHandler == null) {
                throw new AssertionError((Object)("no handler was kept for " + fileImpl));
            }
            this.dumpMacroMap(preprocHandler.getMacroMap());
        }
        time = System.currentTimeMillis() - time;
        if (this.isShowTime()) {
            TestResult.access$600(result, time);
            TestResult.access$700(result, this.countLines(fileImpl));
            if (!this.quiet) {
                TraceModel.print("Processing " + item.getName() + " took " + time + " ms; LPS=" + result.getLPS() + "; error count: " + errCount);
            }
        }
        if (this.dumpStatistics) {
            if (this.dumpDir != null) {
                postfix = ".stat";
                if (Diagnostic.getStatisticsLevel() > 1) {
                    postfix = postfix + "." + Diagnostic.getStatisticsLevel();
                }
                name = item.getName() + postfix;
                theDumpFile = new File(this.dumpDir, name).getAbsolutePath();
                Diagnostic.dumpFileStatistics(theDumpFile);
            }
            if (this.dumpFile != null) {
                Diagnostic.dumpFileStatistics(this.dumpFile, true);
            }
        }
        if (this.dumpAst) {
            System.out.println("AST DUMP for file " + item.getName());
            TraceModel.dumpAst(tree);
        }
        if (this.doCleanRepository) {
            prj = fileImpl.getProject();
            absPath = fileImpl.getAbsolutePath();
            fileImpl = null;
            ParserThreadManager.instance().waitEmptyProjectQueue((ProjectBase)prj);
            TraceModel.waitProjectParsed(this.getProject(), false);
            RepositoryTestUtils.deleteDefaultCacheLocation();
            fileImpl = (FileImpl)prj.findFile((Object)absPath, true, false);
        }
        if (this.dumpModel) {
            if (fileImpl != null) {
                CsmCacheManager.enter();
                try {
                    TraceModel.tracer.setDeep(this.deep);
                    TraceModel.tracer.setDumpTemplateParameters(this.dumpTemplateParameters);
                    TraceModel.tracer.setTestUniqueName(this.testUniqueName);
                    TraceModel.tracer.dumpModel((CsmFile)fileImpl);
                    if (this.dumpFileOnly) ** GOTO lbl68
                    TraceModel.tracer.dumpModel((CsmProject)this.getProject());
                }
                finally {
                    CsmCacheManager.leave();
                }
            } else {
                TraceModel.print("FileImpl is null - not possible to dump File Model");
            }
        }
lbl68:
        // 5 sources

        if (this.showAstWindow) {
            this.test(tree, item.getName());
        }
        return result;
    }

    private boolean hasNonEmptyIncludes(CsmFile fileImpl) {
        for (CsmInclude inc : fileImpl.getIncludes()) {
            if (inc.getIncludeFile() == null) continue;
            return true;
        }
        return false;
    }

    private long countLines(CsmFile fileImpl) {
        return this.countLines(fileImpl, false);
    }

    private long countLines(CsmFile fileImpl, boolean allowResolvedIncludes) {
        if (fileImpl == null) {
            return -1L;
        }
        if (!allowResolvedIncludes && this.hasNonEmptyIncludes(fileImpl)) {
            return -1L;
        }
        CharSequence text = fileImpl.getText();
        long cnt = 0L;
        for (int pos = 0; pos < text.length(); ++pos) {
            if (text.charAt(pos) != '\n') continue;
            ++cnt;
        }
        return cnt;
    }

    private void test(AST tree, String label) {
        ASTFrameEx frame = new ASTFrameEx(label, tree);
        frame.setVisible(true);
    }

    public static void getFileErrors(CsmFile file, ErrorListener errorListener) {
        CsmCorePackageAccessor.get().testFileImplErrors((FileImpl)file, errorListener);
    }

    public static void dumpAst(AST ast) {
        ASTVisitor visitor = new ASTVisitor(){

            public void visit(AST node) {
                for (AST node2 = node; node2 != null; node2 = node2.getNextSibling()) {
                    String ofStr = node2 instanceof CsmAST ? " offset=" + ((CsmAST)node2).getOffset() + " file = " + ((CsmAST)node2).getFilename() : "";
                    TraceModel.print("" + node2.getText() + " [" + node2.getType() + "] " + node2.getLine() + ':' + node2.getColumn() + ofStr);
                    if (node2.getFirstChild() == null) continue;
                    TraceModel.indent();
                    this.visit(node2.getFirstChild());
                    TraceModel.unindent();
                }
            }
        };
        visitor.visit(ast);
    }

    private void dumpMacroMap(PPMacroMap macroMap) {
        tracer.print("State of macro map:");
        tracer.print(macroMap == null ? "empty macro map" : macroMap.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testLibProject() {
        LibProjectImpl libProject = LibProjectImpl.createInstance(this.getModel(), CndFileUtils.getLocalFileSystem(), "/usr/include", -1);
        this.getModel().testAddProject(libProject);
        CsmCacheManager.enter();
        try {
            tracer.dumpModel((CsmProject)libProject);
        }
        finally {
            CsmCacheManager.leave();
        }
    }

    private static void print(String s) {
        tracer.print(s);
    }

    private void print(String s, boolean newLine) {
        tracer.print(s, newLine);
    }

    private static void indent() {
        tracer.indent();
    }

    private static void unindent() {
        tracer.unindent();
    }

    private int countUserFiles() {
        return this.getProject().getAllFiles().size();
    }

    private int countSystemHeaders() {
        int cnt = 0;
        HashSet processedProjects = new HashSet();
        Iterator it = this.getProject().getLibraries().iterator();
        while (it.hasNext()) {
            cnt += this.countFiles((ProjectBase)it.next(), processedProjects);
        }
        return cnt;
    }

    private int countFiles(ProjectBase prj, Collection processedProjects) {
        if (processedProjects.contains(prj)) {
            return 0;
        }
        int cnt = prj.getAllFiles().size();
        Iterator it = prj.getLibraries().iterator();
        while (it.hasNext()) {
            cnt += this.countFiles((ProjectBase)it.next(), processedProjects);
        }
        return cnt;
    }

    private void calculateAverageLPS(TestResult total, boolean includeLibs) {
        total.lineCount = 0L;
        for (CsmFile file : this.getProject().getAllFiles()) {
            total.lineCount += this.countLines(file, true);
        }
        if (includeLibs) {
            for (ProjectBase lib : this.getProject().getLibraries()) {
                for (CsmFile file : lib.getAllFiles()) {
                    total.lineCount += this.countLines(file, true);
                }
            }
        }
    }

    boolean isShowTime() {
        return this.showTime;
    }

    private List<NativeFileItem> getFileItems() {
        ArrayList<NativeFileItem> result = new ArrayList<NativeFileItem>();
        Object platformProject = this.getProject().getPlatformProject();
        if (platformProject instanceof NativeProject) {
            NativeProject nativeProject = (NativeProject)platformProject;
            result.addAll(nativeProject.getAllFiles());
        }
        return result;
    }

    private static String getFileLanguage(FileObject fo) {
        String lang = "Gnu C++ Language";
        String ext = fo.getExt();
        if (ext.equals("c")) {
            lang = "Gnu C Language";
        }
        if (ext.equals("f")) {
            lang = "Fortran Language";
        }
        return lang;
    }

    public static interface ErrorListener {
        public void error(String var1, int var2, int var3);
    }

    public static interface TestHook {
        public void parsingFinished(CsmFile var1, PreprocHandler var2);
    }

    public static interface ParsingTimeResultListener {
        public void notifyParsingTime(TestResult var1);
    }

    public static final class TestResult {
        private long time;
        private long lineCount;

        private TestResult() {
            this(0L);
        }

        private TestResult(long time) {
            this.setTime(time);
        }

        private TestResult(long time, long lineCount) {
            this.setTime(time);
            this.setLineCount(lineCount);
        }

        public String getLPS() {
            if (this.time == 0L || this.lineCount <= 0L) {
                return "N/A";
            }
            return "" + this.lineCount * 1000L / this.time;
        }

        public long getTime() {
            return this.time;
        }

        private void setTime(long time) {
            this.time = time;
        }

        public long getLineCount() {
            return this.lineCount < 0L ? 0L : this.lineCount;
        }

        public boolean isLineCountValid() {
            return this.lineCount >= 0L;
        }

        private void setLineCount(long lineCount) {
            this.lineCount = lineCount;
        }

        private void accumulate(TestResult toAdd) {
            this.time += toAdd.time;
            if (this.isLineCountValid() && toAdd.isLineCountValid()) {
                this.lineCount += toAdd.getLineCount();
            }
        }

        static /* synthetic */ void access$600(TestResult x0, long x1) {
            x0.setTime(x1);
        }

        static /* synthetic */ void access$700(TestResult x0, long x1) {
            x0.setLineCount(x1);
        }
    }
}

