/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class WeakList<T>
implements Iterable<T> {
    private final List<WeakReference<T>> list = new ArrayList<WeakReference<T>>();

    public synchronized void add(T element) {
        this.list.add(new WeakReference<T>(element));
    }

    public synchronized void addAll(Iterator<T> elements) {
        while (elements.hasNext()) {
            this.list.add(new WeakReference<T>(elements.next()));
        }
    }

    public synchronized void remove(T element) {
        Iterator<WeakReference<T>> it = this.list.iterator();
        while (it.hasNext()) {
            WeakReference<T> ref = it.next();
            if (ref.get() != element) continue;
            it.remove();
        }
    }

    public synchronized void clear() {
        this.list.clear();
    }

    @Override
    public synchronized Iterator<T> iterator() {
        ArrayList result = new ArrayList();
        this.addTo(result);
        return result.iterator();
    }

    public synchronized Collection<T> join(Collection<? extends T> collection) {
        ArrayList<T> result = new ArrayList<T>(collection.size() + this.list.size());
        result.addAll(collection);
        this.addTo(result);
        return result;
    }

    private void addTo(Collection<T> collection) {
        for (WeakReference<T> ref : this.list) {
            Object element = ref.get();
            if (element == null) continue;
            collection.add(element);
        }
    }
}

