/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.editor.JSFConfigEditorContext;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigComponent;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationCase;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.netbeans.modules.web.jsf.navigation.FacesModelPropertyChangeListener;
import org.netbeans.modules.web.jsf.navigation.FacesModelUtility;
import org.netbeans.modules.web.jsf.navigation.NavigationCaseEdge;
import org.netbeans.modules.web.jsf.navigation.NotWebFolder;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.WebFolderListener;
import org.netbeans.modules.web.jsf.navigation.pagecontentmodel.PageContentModelProvider;
import org.netbeans.modules.xml.xam.Component;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class PageFlowController {
    private PageFlowView view;
    private JSFConfigModel configModel;
    private DataObject configDataObj;
    private final Map<NavigationCase, NavigationCaseEdge> navCase2NavCaseEdge = new WeakHashMap<NavigationCase, NavigationCaseEdge>();
    private final Map<NavigationRule, String> navRule2String = new WeakHashMap<NavigationRule, String>();
    private final HashMap<String, WeakReference<Page>> pageName2Page = new HashMap();
    private static final String NO_WEB_FOLDER_WARNING = NbBundle.getMessage(PageFlowController.class, (String)"MSG_NoWebFolder");
    private static final String NO_WEB_FOLDER_TITLE = NbBundle.getMessage(PageFlowController.class, (String)"TLE_NoWebFolder");
    private volatile FileObject webFolder;
    private AtomicBoolean isListenerRegistered = new AtomicBoolean(false);
    private Collection<FileObject> webFiles;
    private static final String PROP_SHOW_NO_WEB_FOLDER = "showNoWebFolder";
    private PropertyChangeListener pcl;
    private FileChangeListener fcl;
    private boolean isWellFormed = true;
    private boolean isGraphDirty = false;
    private boolean isFilesDirty = false;
    private static final String CASE_STRING = "case";
    private PropertyChangeListener otherFacesConfigListener = null;
    public Stack<String> PageFlowCreationStack = new Stack();
    private int PageFlowCreationCount = 0;
    public Stack<String> PageFlowDestroyStack = new Stack();
    private int PageFlowDestroyCount = 0;
    private static final Logger LOGGER = Logger.getLogger(PageFlowController.class.getName());

    public PageFlowController(JSFConfigEditorContext context, PageFlowView view) {
        this.view = view;
        FileObject configFile = context.getFacesConfigFile();
        try {
            this.configDataObj = DataObject.find((FileObject)configFile);
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
        }
        this.configModel = ConfigurationUtils.getConfigModel((FileObject)configFile, (boolean)true);
        assert (this.configModel != null);
        this.webFolder = PageFlowView.getWebFolder(configFile);
        this.webFiles = this.setupWebFiles(this.webFolder);
    }

    private Collection<FileObject> setupWebFiles(FileObject webFolder) {
        final LinkedList<FileObject> myWebFiles = new LinkedList<FileObject>();
        if (webFolder == null) {
            this.ifNecessaryShowNoWebFolderDialog();
        } else {
            AtomicBoolean canceled = new AtomicBoolean();
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    myWebFiles.addAll(PageFlowController.this.getAllProjectRelevantFilesObjects());
                }
            }, (String)NbBundle.getMessage(PageFlowController.class, (String)"MSG_LoadingWebFiles"), (AtomicBoolean)canceled, (boolean)false);
        }
        return myWebFiles;
    }

    protected void ifNecessaryShowNoWebFolderDialog() {
        if (this.isShowNoWebFolderDialog()) {
            NotWebFolder panel = new NotWebFolder(NO_WEB_FOLDER_WARNING);
            DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NO_WEB_FOLDER_TITLE, true, -1, NotifyDescriptor.YES_OPTION, null);
            JButton okButton = new JButton(NbBundle.getMessage(PageFlowController.class, (String)"MSG_OkButtonText"));
            descriptor.setOptions(new Object[]{okButton});
            descriptor.setMessageType(-1);
            descriptor.setClosingOptions(new Object[]{okButton});
            descriptor.setOptionsAlign(0);
            Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
            d.setSize(400, 200);
            d.setVisible(true);
            this.setShowNoWebFolderDialog(panel.getShowDialog());
        }
    }

    public void destroy() {
        this.webFolder = null;
        this.configModel = null;
        this.view = null;
        this.webFiles.clear();
        this.navCase2NavCaseEdge.clear();
        this.navRule2String.clear();
        this.pageName2Page.clear();
    }

    public final void setShowNoWebFolderDialog(boolean show) {
        PageFlowController.getPreferences().putBoolean(PROP_SHOW_NO_WEB_FOLDER, show);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(PageFlowController.class);
    }

    public final boolean isShowNoWebFolderDialog() {
        return PageFlowController.getPreferences().getBoolean(PROP_SHOW_NO_WEB_FOLDER, true);
    }

    public synchronized boolean isListenerRegistered() {
        return this.isListenerRegistered.get();
    }

    public synchronized void registerListeners() {
        if (this.isListenerRegistered.get()) {
            return;
        }
        if (this.pcl != null || this.configModel == null) {
            return;
        }
        this.pcl = new FacesModelPropertyChangeListener(this);
        this.configModel.addPropertyChangeListener(this.pcl);
        this.isListenerRegistered.set(true);
        FileObject myWebFolder = this.getWebFolder();
        if (this.fcl == null) {
            this.fcl = new WebFolderListener(this);
            if (myWebFolder != null) {
                try {
                    FileSystem fileSystem = myWebFolder.getFileSystem();
                    fileSystem.addFileChangeListener(this.fcl);
                }
                catch (FileStateInvalidException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public void unregisterListeners() {
        if (this.pcl != null) {
            if (this.configModel != null) {
                this.configModel.removePropertyChangeListener(this.pcl);
            }
            this.pcl = null;
        }
        FileObject myWebFolder = this.getWebFolder();
        if (this.fcl != null && myWebFolder != null) {
            try {
                FileSystem fileSystem = myWebFolder.getFileSystem();
                fileSystem.removeFileChangeListener(this.fcl);
                this.fcl = null;
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    FileChangeListener getFCL() {
        return this.fcl;
    }

    void flushGraphIfDirty() {
        if (this.isFilesDirty) {
            this.webFiles = this.setupWebFiles(this.webFolder);
            this.isFilesDirty = false;
        }
        if (this.isGraphDirty) {
            if (this.isWellFormed) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (PageFlowController.this.view == null) {
                            return;
                        }
                        PageFlowController.this.view.removeUserMalFormedFacesConfig();
                        PageFlowController.this.setupGraph();
                    }
                });
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (PageFlowController.this.view == null) {
                            return;
                        }
                        PageFlowController.this.view.clearGraph();
                        PageFlowController.this.view.warnUserMalFormedFacesConfig();
                    }
                });
            }
            this.isGraphDirty = false;
        }
    }

    protected void setGraphDirtyWellFormed(boolean isWellFormed) {
        this.isGraphDirty = true;
        this.isWellFormed = isWellFormed;
    }

    protected void setGraphDirty() {
        this.isGraphDirty = true;
    }

    protected void setFilesDirty() {
        this.isFilesDirty = true;
        this.isGraphDirty = true;
    }

    public boolean isCurrentScope(PageFlowToolbarUtilities.Scope scope) {
        return PageFlowToolbarUtilities.getInstance(this.view).getCurrentScope().equals((Object)scope);
    }

    public NavigationCase createLink(Page source, Page target, Pin pinNode) {
        if (source == null) {
            throw new NullPointerException("Source page should not be null.");
        }
        if (target == null) {
            throw new NullPointerException("Target page should not be null");
        }
        String sourceName = source.getDisplayName();
        int caseNum = 1;
        this.configModel.startTransaction();
        FacesConfig facesConfig = this.configModel.getRootComponent();
        NavigationRule navRule = this.getRuleWithFromViewID(facesConfig, source.getDisplayName());
        NavigationCase navCase = this.configModel.getFactory().createNavigationCase();
        if (navRule == null) {
            navRule = this.configModel.getFactory().createNavigationRule();
            FacesModelUtility.setFromViewId(navRule, source.getDisplayName());
            facesConfig.addNavigationRule(navRule);
            this.navRule2String.put(navRule, FacesModelUtility.getFromViewIdFiltered(navRule));
        } else {
            caseNum = this.getNewCaseNumber(navRule);
        }
        String caseName = CASE_STRING + Integer.toString(caseNum);
        if (pinNode != null) {
            pinNode.setFromOutcome(caseName);
        }
        navCase.setFromOutcome(caseName);
        FacesModelUtility.setToViewId(navCase, target.getDisplayName());
        navRule.addNavigationCase(navCase);
        try {
            this.configModel.endTransaction();
            this.configModel.sync();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalStateException ise) {
            Exceptions.printStackTrace((Throwable)ise);
        }
        return navCase;
    }

    public void updatePageItems(Page pageNode) {
        this.view.resetNodeWidget(pageNode, true);
        this.view.validateGraph();
    }

    private int getNewCaseNumber(NavigationRule navRule) {
        HashSet<String> caseOutcomes = new HashSet<String>();
        List navCases = navRule.getNavigationCases();
        for (NavigationCase navCase : navCases) {
            caseOutcomes.add(navCase.getFromOutcome());
        }
        int caseNum = 1;
        while (caseOutcomes.contains(CASE_STRING + Integer.toString(caseNum))) {
            ++caseNum;
        }
        return caseNum;
    }

    private NavigationRule getRuleWithFromViewID(FacesConfig facesConfig, String fromViewId) {
        for (NavigationRule navRule : facesConfig.getNavigationRules()) {
            String rulefromViewId = FacesModelUtility.getFromViewIdFiltered(navRule);
            if (rulefromViewId == null || !rulefromViewId.equals(fromViewId)) continue;
            return navRule;
        }
        return null;
    }

    private final Collection<FileObject> getAllProjectRelevantFilesObjects() {
        return this.getProjectKnownFileOjbects(this.getWebFolder());
    }

    private Collection<FileObject> getProjectKnownFileOjbects(FileObject folder) {
        LinkedList<FileObject> projectKnownFiles = new LinkedList<FileObject>();
        FileObject[] childrenFiles = new FileObject[]{};
        if (folder != null) {
            childrenFiles = folder.getChildren();
        }
        for (FileObject file : childrenFiles) {
            if (!file.isFolder()) {
                if (!this.isKnownFile(file)) continue;
                projectKnownFiles.add(file);
                continue;
            }
            if (!this.isKnownFolder(file)) continue;
            projectKnownFiles.addAll(this.getProjectKnownFileOjbects(file));
        }
        return projectKnownFiles;
    }

    public final boolean isKnownFile(FileObject file) {
        String[] knownMimeTypes = new String[]{"text/x-jsp", "text/html", "text/xhtml"};
        String mimeType = file.getMIMEType(knownMimeTypes);
        if (mimeType.equals("text/x-jsp") && !file.getExt().equals("jspf")) {
            return true;
        }
        return mimeType.equals("text/html") || mimeType.equals("text/xhtml");
    }

    public final boolean isKnownFolder(FileObject folder) {
        if (!folder.isFolder()) {
            return false;
        }
        if (!folder.getPath().contains(this.getWebFolder().getPath())) {
            return false;
        }
        return !folder.getPath().contains("WEB-INF") && !folder.getPath().contains("META-INF");
    }

    public boolean setupGraph() {
        this.view.saveLocations();
        return this.setupGraphNoSaveData();
    }

    private PropertyChangeListener getOtherFacesConfigListener() {
        if (this.otherFacesConfigListener == null) {
            return new OtherFacesModelListener();
        }
        return this.otherFacesConfigListener;
    }

    private void removeOtherFacesConfigListener() {
        FileObject[] configFiles;
        WebModule webModule = WebModule.getWebModule((FileObject)this.getWebFolder());
        for (FileObject aConfigFile : configFiles = ConfigurationUtils.getFacesConfigFiles((WebModule)webModule)) {
            JSFConfigModel aConfigModel = ConfigurationUtils.getConfigModel((FileObject)aConfigFile, (boolean)true);
            aConfigModel.removePropertyChangeListener(this.otherFacesConfigListener);
        }
        this.otherFacesConfigListener = null;
    }

    protected void releaseGraphInfo() {
        if (this.otherFacesConfigListener != null) {
            this.removeOtherFacesConfigListener();
        }
        this.view.clearGraph();
        this.clearPageName2Page();
        this.navCase2NavCaseEdge.clear();
        this.navRule2String.clear();
    }

    public boolean setupGraphNoSaveData() {
        LOGGER.entering(PageFlowController.class.toString(), "setupGraphNoSaveData()");
        assert (this.configModel != null);
        assert (this.webFiles != null);
        this.releaseGraphInfo();
        FacesConfig facesConfig = this.configModel.getRootComponent();
        if (facesConfig == null) {
            return false;
        }
        try {
            ArrayList<NavigationRule> rules = null;
            if (this.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_FACESCONFIG)) {
                rules = facesConfig.getNavigationRules();
                for (NavigationRule navRule : rules) {
                    this.navRule2String.put(navRule, FacesModelUtility.getFromViewIdFiltered(navRule));
                }
                Collection<String> pagesInConfig = this.getFacesConfigPageNames((Collection<NavigationRule>)rules);
                this.createFacesConfigPages(pagesInConfig);
            } else if (this.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_PROJECT)) {
                rules = facesConfig.getNavigationRules();
                for (NavigationRule navRule : rules) {
                    this.navRule2String.put(navRule, FacesModelUtility.getFromViewIdFiltered(navRule));
                }
                Collection<String> pagesInConfig = this.getFacesConfigPageNames((Collection<NavigationRule>)rules);
                this.createAllProjectPages(pagesInConfig);
            } else if (this.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_ALL_FACESCONFIG)) {
                ArrayList<NavigationRule> allRules = new ArrayList<NavigationRule>();
                FileObject myWebFolder = this.getWebFolder();
                if (myWebFolder != null) {
                    FileObject[] configFiles;
                    WebModule webModule = WebModule.getWebModule((FileObject)myWebFolder);
                    for (FileObject aConfigFile : configFiles = ConfigurationUtils.getFacesConfigFiles((WebModule)webModule)) {
                        JSFConfigModel aConfigModel = ConfigurationUtils.getConfigModel((FileObject)aConfigFile, (boolean)true);
                        if (aConfigModel == null) continue;
                        allRules.addAll(aConfigModel.getRootComponent().getNavigationRules());
                        if (this.configModel.equals(aConfigModel)) continue;
                        aConfigModel.addPropertyChangeListener(this.getOtherFacesConfigListener());
                    }
                    for (NavigationRule navRule : allRules) {
                        this.navRule2String.put(navRule, FacesModelUtility.getFromViewIdFiltered(navRule));
                    }
                    Collection<String> pagesInConfig = this.getFacesConfigPageNames(allRules);
                    this.createFacesConfigPages(pagesInConfig);
                    rules = allRules;
                } else {
                    rules = facesConfig.getNavigationRules();
                    for (NavigationRule navRule : rules) {
                        this.navRule2String.put(navRule, FacesModelUtility.getFromViewIdFiltered(navRule));
                    }
                    Collection<String> pagesInConfig = this.getFacesConfigPageNames((Collection<NavigationRule>)rules);
                    this.createAllProjectPages(pagesInConfig);
                }
            }
            this.createAllEdges((List<NavigationRule>)rules);
            this.view.validateGraph();
            LOGGER.log(new LogRecord(Level.FINE, "PageFlowEditor # Rules: " + rules.size() + "\n" + "               # WebPages: " + this.webFiles.size() + "\n" + "               # TotalPages: " + this.pageName2Page.size()));
        }
        catch (IllegalStateException ise) {
            this.view.warnUserMalFormedFacesConfig();
            this.view.validateGraph();
            LOGGER.log(new LogRecord(Level.FINE, "Illegal SateException thrown: " + ise.toString()));
        }
        LOGGER.exiting(PageFlowController.class.toString(), "setupGraphNoSaveData()");
        return true;
    }

    private void createAllEdges(List<NavigationRule> rules) {
        List editableRules = this.configModel.getRootComponent().getNavigationRules();
        for (NavigationRule rule : rules) {
            List navCases = rule.getNavigationCases();
            boolean isModifableEdge = editableRules.contains(rule);
            for (NavigationCase navCase : navCases) {
                NavigationCaseEdge navEdge = new NavigationCaseEdge(this, navCase);
                this.navCase2NavCaseEdge.put(navCase, navEdge);
                navEdge.setModifiable(isModifableEdge);
                if (navEdge.getFromViewId() == null || navEdge.getToViewId() == null) continue;
                this.createEdge(navEdge);
            }
        }
    }

    protected void createEdge(NavigationCaseEdge caseNode) {
        String fromPage = caseNode.getFromViewId();
        String toPage = caseNode.getToViewId();
        if (this.getPageName2Page(fromPage) == null || this.getPageName2Page(toPage) == null) {
            System.err.println("Why is this node null? CaseNode: " + caseNode);
            System.err.println("FromPage: " + fromPage);
            System.err.println("ToPage: " + toPage);
            Thread.dumpStack();
        } else {
            this.view.createEdge(caseNode, this.getPageName2Page(fromPage), this.getPageName2Page(toPage));
        }
    }

    private Collection<String> getFacesConfigPageNames(Collection<NavigationRule> navRules) {
        HashSet<String> pages = new HashSet<String>();
        for (NavigationRule navRule : navRules) {
            String pageName = FacesModelUtility.getFromViewIdFiltered(navRule);
            pages.add(pageName);
            List navCases = navRule.getNavigationCases();
            for (NavigationCase navCase : navCases) {
                String toPage = FacesModelUtility.getToViewIdFiltered(navCase);
                if (toPage == null) continue;
                pages.add(toPage);
            }
        }
        return pages;
    }

    public Page createPage(Node node) {
        Page pageNode = new Page(this, node);
        Calendar rightNow = Calendar.getInstance();
        this.PageFlowCreationStack.push("\n" + this.PageFlowCreationCount + ". " + rightNow.get(12) + ":" + rightNow.get(13) + " -  " + pageNode);
        ++this.PageFlowCreationCount;
        return pageNode;
    }

    public Page createPage(String pageName) {
        Page node = null;
        if (pageName == null) {
            throw new NullPointerException("Page name string is null");
        }
        assert (pageName.length() != 0);
        AbstractNode tmpNode = new AbstractNode(Children.LEAF);
        tmpNode.setName(pageName);
        node = this.createPage((Node)tmpNode);
        return node;
    }

    private void destroyPageFlowNode(Page page) {
        if (page != null) {
            page.destroy2();
            Calendar rightNow = Calendar.getInstance();
            this.PageFlowDestroyStack.push("\n" + this.PageFlowDestroyCount + ". " + rightNow.get(12) + ":" + rightNow.get(13) + " -  " + page);
            ++this.PageFlowDestroyCount;
        }
    }

    private void createAllProjectPages(Collection<String> pagesInConfig) {
        FileObject[] webFilesTmp;
        HashSet<String> pages = new HashSet<String>(pagesInConfig);
        for (FileObject webFile : webFilesTmp = this.webFiles.toArray(new FileObject[0])) {
            String webFileName = Page.getFolderDisplayName(this.getWebFolder(), webFile);
            Page node = null;
            try {
                node = this.createPage(DataObject.find((FileObject)webFile).getNodeDelegate());
                this.view.createNode(node, null, null);
                pages.remove(webFileName);
            }
            catch (DataObjectNotFoundException ex) {
                this.webFiles.remove(webFile);
            }
        }
        for (String pageName : pages) {
            if (pageName == null) continue;
            AbstractNode tmpNode = new AbstractNode(Children.LEAF);
            tmpNode.setName(pageName);
            Page node = this.createPage((Node)tmpNode);
            this.view.createNode(node, null, null);
        }
    }

    private FileObject getFileObject(String pageName) {
        for (FileObject webFile : this.webFiles) {
            String webFileName = Page.getFolderDisplayName(this.getWebFolder(), webFile);
            if (!webFileName.equals(pageName)) continue;
            return webFile;
        }
        return null;
    }

    private void createFacesConfigPages(Collection<String> pagesInConfig) {
        HashSet<String> pages = new HashSet<String>(pagesInConfig);
        for (String pageName : pages) {
            if (pageName == null) continue;
            FileObject file = this.getFileObject(pageName);
            AbstractNode wrapNode = null;
            if (file == null) {
                wrapNode = new AbstractNode(Children.LEAF);
                wrapNode.setName(pageName);
            } else {
                try {
                    wrapNode = DataObject.find((FileObject)file).getNodeDelegate();
                }
                catch (DataObjectNotFoundException donfe) {
                    Exceptions.printStackTrace((Throwable)donfe);
                }
            }
            Page node = this.createPage((Node)wrapNode);
            this.view.createNode(node, null, null);
        }
    }

    public Page removePageName2Page(Page page, boolean permDestroy) {
        return this.removePageName2Page(page.getDisplayName(), permDestroy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page removePageName2Page(String pageName, boolean permDestroy) {
        LOGGER.finest("PageName2Page: remove " + pageName);
        this.checkAWTThread();
        HashMap<String, WeakReference<Page>> hashMap = this.pageName2Page;
        synchronized (hashMap) {
            Page node = null;
            WeakReference<Page> nodeRef = this.pageName2Page.remove(pageName);
            if (nodeRef != null) {
                node = (Page)nodeRef.get();
                if (permDestroy) {
                    this.destroyPageFlowNode(node);
                }
            }
            return node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replacePageName2Page(Page page, String newName, String oldName) {
        LOGGER.finest("PageName2Page: replace " + oldName + " to " + newName);
        if (page == null) {
            throw new NullPointerException("Page can not be null.");
        }
        this.checkAWTThread();
        HashMap<String, WeakReference<Page>> hashMap = this.pageName2Page;
        synchronized (hashMap) {
            WeakReference<Page> page2Ref = this.pageName2Page.remove(oldName);
            if (page2Ref != null) {
                Page pageFound = (Page)page2Ref.get();
                if (pageFound != null) {
                    LOGGER.finest("Trying to replace page in map, but page not found:" + page);
                }
                this.pageName2Page.put(newName, new WeakReference<Page>(page));
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearPageName2Page() {
        HashSet<String> keys;
        LOGGER.finest("PageName2Page: clear");
        HashMap<String, WeakReference<Page>> hashMap = this.pageName2Page;
        synchronized (hashMap) {
            keys = new HashSet<String>(this.pageName2Page.keySet());
        }
        for (String key : keys) {
            this.removePageName2Page(key, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putPageName2Page(String displayName, Page page) {
        LOGGER.finest("PageName2Page: put " + displayName);
        if (page == null) {
            throw new NullPointerException("putPageName2Page does not accept null pages.");
        }
        this.checkAWTThread();
        HashMap<String, WeakReference<Page>> hashMap = this.pageName2Page;
        synchronized (hashMap) {
            this.pageName2Page.put(displayName, new WeakReference<Page>(page));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Page getPageName2Page(String displayName) {
        this.checkAWTThread();
        if (displayName == null) {
            throw new NullPointerException("Displayname should not be null. You may be using this method incorrectly.");
        }
        HashMap<String, WeakReference<Page>> hashMap = this.pageName2Page;
        synchronized (hashMap) {
            Page page = null;
            WeakReference<Page> pageRef = this.pageName2Page.get(displayName);
            if (pageRef != null) {
                page = (Page)pageRef.get();
            }
            return page;
        }
    }

    private void checkAWTThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
            throw new RuntimeException("Not a Dispatched Thread");
        }
    }

    public void renamePageInModel(String oldName, String newName) {
        FacesModelUtility.renamePageInModel(this.configModel, oldName, newName);
    }

    public void removeSceneNodeEdges(Page pageNode) {
        Collection<NavigationCaseEdge> navCaseNodes = this.view.getNodeEdges(pageNode);
        for (NavigationCaseEdge navCaseNode : navCaseNodes) {
            try {
                navCaseNode.destroy();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void removePageInModel(String displayName) {
        this.configModel.startTransaction();
        FacesConfig facesConfig = this.configModel.getRootComponent();
        List navRules = facesConfig.getNavigationRules();
        for (NavigationRule navRule : navRules) {
            String fromViewId = FacesModelUtility.getFromViewIdFiltered(navRule);
            if (fromViewId != null && fromViewId.equals(displayName)) {
                facesConfig.removeNavigationRule(navRule);
                continue;
            }
            List navCases = navRule.getNavigationCases();
            for (NavigationCase navCase : navCases) {
                String toViewId = FacesModelUtility.getToViewIdFiltered(navCase);
                if (toViewId == null || !toViewId.equals(displayName)) continue;
                navRule.removeNavigationCase(navCase);
            }
        }
        try {
            this.configModel.endTransaction();
            this.configModel.sync();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalStateException ise) {
            Exceptions.printStackTrace((Throwable)ise);
        }
    }

    public FileObject getWebFolder() {
        return this.webFolder;
    }

    public boolean isPageInAnyFacesConfig(String name) {
        FileObject[] configFiles;
        WebModule webModule = WebModule.getWebModule((FileObject)this.getWebFolder());
        for (FileObject aConfigFile : configFiles = ConfigurationUtils.getFacesConfigFiles((WebModule)webModule)) {
            JSFConfigModel aConfigModel = ConfigurationUtils.getConfigModel((FileObject)aConfigFile, (boolean)true);
            List rules = aConfigModel.getRootComponent().getNavigationRules();
            Collection<String> pagesInConfig = this.getFacesConfigPageNames(rules);
            if (!pagesInConfig.contains(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isNavCaseInFacesConfig(NavigationCaseEdge navEdge) {
        NavigationCase navCase = this.getNavCase2NavCaseEdge(navEdge);
        JSFConfigComponent navRule = (JSFConfigComponent)navCase.getParent();
        return this.configModel.getRootComponent().getNavigationRules().contains(navRule);
    }

    public void changeToAbstractNode(Page oldNode, String displayName) {
        AbstractNode tmpNode = new AbstractNode(Children.LEAF);
        tmpNode.setName(displayName);
        oldNode.replaceWrappedNode((Node)tmpNode);
        this.view.resetNodeWidget(oldNode, true);
    }

    public DataObject getConfigDataObject() {
        return this.configDataObj;
    }

    public void saveLocation(String oldDisplayName, String newDisplayName) {
        this.view.saveLocation(oldDisplayName, newDisplayName);
    }

    public final boolean removeWebFile(FileObject fileObj) {
        return this.webFiles.remove(fileObj);
    }

    public final boolean addWebFile(FileObject fileObj) {
        return this.webFiles.add(fileObj);
    }

    public final boolean containsWebFile(FileObject fileObj) {
        return this.webFiles.contains(fileObj);
    }

    public final void putNavCase2NavCaseEdge(NavigationCase navCase, NavigationCaseEdge navCaseEdge) {
        this.navCase2NavCaseEdge.put(navCase, navCaseEdge);
    }

    public final NavigationCaseEdge getNavCase2NavCaseEdge(NavigationCase navCase) {
        return this.navCase2NavCaseEdge.get(navCase);
    }

    private final NavigationCase getNavCase2NavCaseEdge(NavigationCaseEdge navEdge) {
        Set<Map.Entry<NavigationCase, NavigationCaseEdge>> entries = this.navCase2NavCaseEdge.entrySet();
        for (Map.Entry<NavigationCase, NavigationCaseEdge> entry : entries) {
            if (!((Object)entry.getValue()).equals(navEdge)) continue;
            return entry.getKey();
        }
        return null;
    }

    public final NavigationCaseEdge removeNavCase2NavCaseEdge(NavigationCase navCase) {
        return this.navCase2NavCaseEdge.remove(navCase);
    }

    public final String removeNavRule2String(NavigationRule navRule) {
        return this.navRule2String.remove(navRule);
    }

    public final String putNavRule2String(NavigationRule navRule, String navRuleName) {
        return this.navRule2String.put(navRule, navRuleName);
    }

    public PageFlowView getView() {
        return this.view;
    }

    public void setModelNavigationCaseName(NavigationCase navCase, String newName) {
        this.configModel.startTransaction();
        if (navCase.getFromOutcome() != null) {
            navCase.setFromOutcome(newName);
        }
        if (navCase.getFromAction() != null) {
            navCase.setFromAction(newName);
        }
        try {
            this.configModel.endTransaction();
            this.configModel.sync();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalStateException ise) {
            Exceptions.printStackTrace((Throwable)ise);
        }
    }

    public void removeModelNavigationCase(NavigationCase navCase) throws IOException {
        this.configModel.startTransaction();
        NavigationRule navRule = (NavigationRule)navCase.getParent();
        if (navRule != null && navRule.getNavigationCases().contains(navCase)) {
            navRule.removeNavigationCase(navCase);
            if (navRule.getNavigationCases().size() < 1) {
                this.configModel.removeChildComponent((Component)navRule);
            }
        }
        try {
            this.configModel.endTransaction();
        }
        catch (IllegalStateException ise) {
            Exceptions.printStackTrace((Throwable)ise);
        }
        this.configModel.sync();
    }

    public void serializeNodeLocations() {
        if (this.view != null && this.configDataObj != null) {
            this.view.serializeNodeLocations(PageFlowView.getStorageFile(this.configDataObj.getPrimaryFile()));
        } else {
            LOGGER.log(Level.WARNING, "Either Page Flow TopComponent of Faces Config DataObject is null");
        }
    }

    public void openNavigationCase(NavigationCaseEdge navCaseEdge) {
        EditorCookie.Observable ec;
        EditCookie ec2;
        final NavigationCase navCase = this.getNavCase2NavCaseEdge(navCaseEdge);
        if (navCase == null) {
            PageFlowController.log("There is null NavigationCase for NavigationCaseEdge, navCaseEdge=" + navCaseEdge);
            return;
        }
        DataObject dobj = this.getConfigDataObject();
        if (dobj != null && (ec2 = (EditCookie)dobj.getCookie(EditCookie.class)) != null && (ec = (EditorCookie.Observable)dobj.getCookie(EditorCookie.Observable.class)) != null) {
            StatusDisplayer.getDefault().setStatusText("otvirani");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ec2.edit();
                    JEditorPane[] panes = ec.getOpenedPanes();
                    if (panes != null && panes.length > 0) {
                        PageFlowController.this.openPane(panes[0], navCase);
                    } else {
                        ec.addPropertyChangeListener(new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                if ("openedPanes".equals(evt.getPropertyName())) {
                                    JEditorPane[] panes = ec.getOpenedPanes();
                                    if (panes != null && panes.length > 0) {
                                        PageFlowController.this.openPane(panes[0], navCase);
                                    }
                                    ec.removePropertyChangeListener((PropertyChangeListener)this);
                                }
                            }
                        });
                        ec.open();
                    }
                }
            });
        }
    }

    private void openPane(JEditorPane pane, NavigationCase navCase) {
        Cursor editCursor = pane.getCursor();
        pane.setCursor(Cursor.getPredefinedCursor(3));
        pane.setCaretPosition(navCase.findPosition() + 2);
        pane.setCursor(editCursor);
        StatusDisplayer.getDefault().setStatusText("");
    }

    public static final Collection<? extends PageContentModelProvider> getPageContentModelProviders() {
        Lookup.Template templ = new Lookup.Template(PageContentModelProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(templ);
        Collection impls = result.allInstances();
        return impls;
    }

    private static void log(String message) {
        Logger.getLogger(PageFlowController.class.getName()).log(Level.INFO, message);
    }

    static class TestAccessor {
        TestAccessor() {
        }

        static Collection<String> getPagesInFacesConfig(PageFlowController controller) {
            Set<NavigationRule> rules = TestAccessor.getAllNavigationRules(controller);
            return controller.getFacesConfigPageNames(rules);
        }

        static Collection<FileObject> getAllRelevantFiles(PageFlowController controller) {
            return controller.getAllProjectRelevantFilesObjects();
        }

        static Set<NavigationRule> getAllNavigationRules(PageFlowController controller) {
            return controller.navRule2String.keySet();
        }

        static Set<NavigationCase> getAllNavigationCases(PageFlowController controller) {
            return controller.navCase2NavCaseEdge.keySet();
        }
    }

    private class OtherFacesModelListener
    implements PropertyChangeListener {
        private OtherFacesModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PageFlowController.this.view == null) {
                        return;
                    }
                    PageFlowController.this.setupGraph();
                }
            });
        }
    }
}

