/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.codeception;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.codeception.commands.Codecept;
import org.netbeans.modules.php.codeception.preferences.CodeceptionPreferences;
import org.netbeans.modules.php.spi.phpmodule.ImportantFilesImplementation;
import org.netbeans.modules.php.spi.phpmodule.ImportantFilesSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public final class ImportantFilesImpl
implements ImportantFilesImplementation,
PreferenceChangeListener {
    private final Project project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final ImportantFilesSupport defaultConfigSupport;
    private volatile boolean initialized = false;

    public ImportantFilesImpl(Project project) {
        assert (project != null);
        this.project = project;
        this.defaultConfigSupport = ImportantFilesSupport.create((FileObject)project.getProjectDirectory(), (String[])new String[]{"codeception.yml"});
    }

    public Collection<ImportantFilesImplementation.FileInfo> getFiles() {
        FileObject codeceptionYml;
        PhpModule phpModule = PhpModule.Factory.lookupPhpModule((Project)this.project);
        if (phpModule == null) {
            return Collections.emptyList();
        }
        if (!this.initialized) {
            this.initialized = true;
            CodeceptionPreferences.addPreferenceChangeListener(phpModule, (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, CodeceptionPreferences.class));
        }
        ArrayList<ImportantFilesImplementation.FileInfo> files = new ArrayList<ImportantFilesImplementation.FileInfo>();
        files.addAll(this.defaultConfigSupport.getFiles(null));
        if (CodeceptionPreferences.isCustomCodeceptionYmlEnabled(phpModule) && (codeceptionYml = Codecept.getCodeceptionYml(phpModule)) != null) {
            files.add(new ImportantFilesImplementation.FileInfo(codeceptionYml));
        }
        return files;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
        this.defaultConfigSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
        this.defaultConfigSupport.removeChangeListener(listener);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if ("custom.codeception.yml.path".equals(evt.getKey()) || "custom.codeception.yml.enabled".equals(evt.getKey())) {
            this.fireChange();
        }
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }
}

