/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.ArrayList;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.ClassRewriter;
import org.netbeans.lib.profiler.instrumentation.DynamicConstantPoolExtension;
import org.netbeans.lib.profiler.instrumentation.SingleMethodScaner;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.lib.profiler.wireprotocol.RootClassLoadedCommand;

public abstract class MemoryProfMethodInstrumentor
extends ClassManager {
    protected ArrayList instrClasses = new ArrayList();
    protected String[] instantiatableClasses;
    protected int injType;
    protected int instrClassId;
    protected int nInstantiatableClasses;
    protected int nInstrClasses;
    protected int nInstrMethods;

    public MemoryProfMethodInstrumentor(ProfilingSessionStatus status, int injType) {
        super(status);
        this.status = status;
        this.instantiatableClasses = new String[100];
        this.injType = injType;
    }

    public Object[] getInitialMethodsToInstrument(RootClassLoadedCommand rootLoaded) {
        ArrayList<DynamicClassInfo> classes = new ArrayList<DynamicClassInfo>();
        MemoryProfMethodInstrumentor.resetLoadedClassData();
        this.initInstrumentationPackData();
        this.instrClassId = 0;
        MemoryProfMethodInstrumentor.storeClassFileBytesForCustomLoaderClasses(rootLoaded);
        String[] loadedClasses = rootLoaded.getAllLoadedClassNames();
        int[] loadedClassLoaderIds = rootLoaded.getAllLoadedClassLoaderIds();
        for (int i = 0; i < loadedClasses.length; ++i) {
            DynamicClassInfo clazz = MemoryProfMethodInstrumentor.javaClassForName(loadedClasses[i], loadedClassLoaderIds[i]);
            if (this.classNeedsInstrumentation(clazz)) {
                clazz.preloadBytecode();
            }
            classes.add(clazz);
        }
        for (DynamicClassInfo clazz : classes) {
            this.findAndMarkMethodsToInstrumentInClass(clazz);
        }
        return this.createInstrumentedMethodPack();
    }

    public String[] getInstantiatableClasses() {
        return this.instantiatableClasses;
    }

    public Object[] getMethodsToInstrumentUponClassLoad(String className, int classLoaderId) {
        this.initInstrumentationPackData();
        this.findAndMarkMethodsToInstrumentInClass(className, classLoaderId);
        return this.createInstrumentedMethodPack();
    }

    public int getNInstantiatableClasses() {
        return this.nInstantiatableClasses;
    }

    protected void findAndMarkMethodsToInstrumentInClass(String className, int classLoaderId) {
        this.findAndMarkMethodsToInstrumentInClass(MemoryProfMethodInstrumentor.javaClassForName(className, classLoaderId));
    }

    protected void findAndMarkMethodsToInstrumentInClass(DynamicClassInfo clazz) {
        if (clazz == null) {
            return;
        }
        if (!clazz.isLoaded()) {
            clazz.setLoaded(true);
            if (clazz.getInstrClassId() == -1 && !clazz.isInterface()) {
                clazz.setInstrClassId(this.getNextClassId(clazz.getName()));
            }
            if (this.classNeedsInstrumentation(clazz)) {
                String[] methodNames = clazz.getMethodNames();
                boolean found = false;
                for (int i = 0; i < methodNames.length; ++i) {
                    if (clazz.isMethodNative(i) || clazz.isMethodAbstract(i)) {
                        clazz.setMethodUnscannable(i);
                        continue;
                    }
                    if (!this.methodNeedsInstrumentation(clazz, i)) continue;
                    ++this.nInstrMethods;
                    clazz.setMethodInstrumented(i);
                    found = true;
                }
                if (found) {
                    ++this.nInstrClasses;
                    this.instrClasses.add(clazz);
                }
            }
        }
    }

    protected void initInstrumentationPackData() {
        this.instrClasses.clear();
        this.nInstrMethods = 0;
        this.nInstrClasses = 0;
        this.nInstantiatableClasses = 0;
    }

    protected abstract boolean classNeedsInstrumentation(ClassInfo var1);

    protected abstract boolean methodNeedsInstrumentation(ClassInfo var1, int var2);

    protected Object[] createInstrumentedMethodPack() {
        if (this.nInstrMethods == 0) {
            return null;
        }
        return this.createInstrumentedMethodPack15();
    }

    protected boolean hasNewOpcodes(ClassInfo clazz, int methodIdx, boolean checkForOpcNew, boolean checkForOpcNewArray, InstrumentationFilter instrFilter) {
        MethodScanerForNewOpcodes msfno = new MethodScanerForNewOpcodes(clazz, methodIdx, instrFilter);
        return msfno.hasNewOpcodes(this, checkForOpcNew, checkForOpcNewArray);
    }

    protected abstract byte[] instrumentMethod(DynamicClassInfo var1, int var2);

    protected boolean methodNeedsRewriting(DynamicClassInfo clazz, int methodIdx) {
        return clazz.isMethodInstrumented(methodIdx);
    }

    int getNextClassId(String className) {
        if (this.nInstantiatableClasses == this.instantiatableClasses.length) {
            String[] oldInstantiatableClasses = this.instantiatableClasses;
            this.instantiatableClasses = new String[oldInstantiatableClasses.length + 100];
            System.arraycopy(oldInstantiatableClasses, 0, this.instantiatableClasses, 0, oldInstantiatableClasses.length);
        }
        this.instantiatableClasses[this.nInstantiatableClasses++] = className;
        this.status.updateAllocatedInstancesCountInfoInClient(className);
        return this.instrClassId++;
    }

    private Object[] createInstrumentedMethodPack15() {
        String[] instrMethodClasses = new String[this.nInstrClasses];
        int[] instrClassLoaderIds = new int[this.nInstrClasses];
        byte[][] replacementClassFileBytes = new byte[this.nInstrClasses][];
        for (int j = 0; j < this.nInstrClasses; ++j) {
            DynamicClassInfo clazz = (DynamicClassInfo)this.instrClasses.get(j);
            instrMethodClasses[j] = clazz.getName().replace('/', '.');
            instrClassLoaderIds[j] = clazz.getLoaderId();
            String[] methodNames = clazz.getMethodNames();
            int nMethods = methodNames.length;
            byte[][] replacementMethodInfos = new byte[nMethods][];
            DynamicConstantPoolExtension.getCPFragment(clazz, this.injType);
            for (int i = 0; i < nMethods; ++i) {
                replacementMethodInfos[i] = this.methodNeedsRewriting(clazz, i) ? this.instrumentMethod(clazz, i) : clazz.getMethodInfo(i);
            }
            DynamicConstantPoolExtension wholeECP = DynamicConstantPoolExtension.getAllAddedCPFragments(clazz);
            int nAddedCPEntries = wholeECP.getNEntries();
            byte[] addedCPContents = wholeECP.getContents();
            replacementClassFileBytes[j] = ClassRewriter.rewriteClassFile(clazz, replacementMethodInfos, nAddedCPEntries, addedCPContents);
        }
        return new Object[]{instrMethodClasses, instrClassLoaderIds, replacementClassFileBytes};
    }

    static class MethodScanerForNewOpcodes
    extends SingleMethodScaner {
        private final InstrumentationFilter instrFilter;

        MethodScanerForNewOpcodes(ClassInfo clazz, int methodIdx, InstrumentationFilter filter) {
            super(clazz, methodIdx);
            this.instrFilter = filter;
        }

        boolean hasNewOpcodes(MemoryProfMethodInstrumentor minstr, boolean checkForOpcNew, boolean checkForOpcNewArray) {
            if (!checkForOpcNew && !checkForOpcNewArray) {
                return false;
            }
            int loaderId = this.clazz.getLoaderId();
            boolean found = false;
            for (int bci = 0; bci < this.bytecodesLength; bci += this.opcodeLength(bci)) {
                int arrayClassId;
                BaseClassInfo refClazz;
                String className;
                BaseClassInfo refClazz2;
                String refClassName;
                int classCPIdx;
                int bc = this.bytecodes[bci] & 0xFF;
                if (bc == 187 && checkForOpcNew) {
                    classCPIdx = this.getU2(bci + 1);
                    refClassName = this.clazz.getRefClassName(classCPIdx);
                    if (!this.instrFilter.passesFilter(refClassName)) continue;
                    found = true;
                    refClazz2 = ClassManager.javaClassOrPlaceholderForName(refClassName, loaderId);
                    if (refClazz2.getInstrClassId() != -1) continue;
                    refClazz2.setInstrClassId(minstr.getNextClassId(refClazz2.getName()));
                    continue;
                }
                if ((bc == 189 || bc == 197) && checkForOpcNewArray) {
                    classCPIdx = this.getU2(bci + 1);
                    refClassName = this.clazz.getRefClassName(classCPIdx);
                    refClazz2 = null;
                    if (bc == 189) {
                        if (this.instrFilter.passesFilter(refClassName.concat("[]"))) {
                            refClazz2 = ClassManager.javaClassForObjectArrayType(refClassName);
                        }
                    } else if (this.instrFilter.passesFilter(MethodScanerForNewOpcodes.getMultiArrayClassName(refClassName))) {
                        refClazz2 = ClassRepository.lookupSpecialClass(refClassName);
                    }
                    if (refClazz2 == null) continue;
                    found = true;
                    if (refClazz2.getInstrClassId() != -1) continue;
                    refClazz2.setInstrClassId(minstr.getNextClassId(refClazz2.getName()));
                    continue;
                }
                if (bc != 188 || !checkForOpcNewArray || !this.instrFilter.passesFilter(className = StringUtils.userFormClassName((refClazz = ClassManager.javaClassForPrimitiveArrayType(arrayClassId = this.getByte(bci + 1))).getName()))) continue;
                found = true;
                if (refClazz.getInstrClassId() != -1) continue;
                refClazz.setInstrClassId(minstr.getNextClassId(refClazz.getName()));
            }
            return found;
        }

        private static String getMultiArrayClassName(String refClassName) {
            int dimension = refClassName.lastIndexOf(91);
            String baseClass = refClassName.substring(dimension + 1);
            if (VMUtils.isVMPrimitiveType(baseClass)) {
                return StringUtils.userFormClassName(refClassName);
            }
            StringBuilder arrayClass = new StringBuilder(refClassName.length() + dimension + 1);
            arrayClass.append(refClassName.substring(dimension + 1));
            for (int i = 0; i <= dimension; ++i) {
                arrayClass.append("[]");
            }
            return arrayClass.toString();
        }
    }
}

