/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.FilterSortSupport;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;

public class PresoObjAllocCCTNode
extends CCTNode {
    public static final String VM_ALLOC_CLASS = "org.netbeans.lib.profiler.server.ProfilerRuntimeMemory";
    public static final String VM_ALLOC_METHOD = "traceVMObjectAlloc";
    private static final String VM_ALLOC_TEXT = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.memory.Bundle").getString("PresoObjAllocCCTNode_VMAllocMsg");
    private static final String UKNOWN_NODENAME = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.memory.Bundle").getString("PresoObjAllocCCTNode_UnknownMsg");
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_ALLOC_OBJ_SIZE = 2;
    public static final int SORT_BY_ALLOC_OBJ_NUMBER = 3;
    public long nCalls;
    public long totalObjSize;
    protected PresoObjAllocCCTNode parent;
    String className;
    String methodName;
    String nodeName;
    protected PresoObjAllocCCTNode[] children;
    int methodId;
    JMethodIdTable.JMethodIdTableEntry entry;
    protected char flags;

    public static PresoObjAllocCCTNode rootNode(PresoObjAllocCCTNode[] children) {
        PresoObjAllocCCTNode root = new PresoObjAllocCCTNode();
        root.setChildren(children);
        return root;
    }

    public PresoObjAllocCCTNode(String className, long nCalls, long totalObjSize) {
        this.className = className;
        this.nCalls = nCalls;
        this.totalObjSize = totalObjSize;
        this.methodName = "*";
    }

    PresoObjAllocCCTNode() {
    }

    protected PresoObjAllocCCTNode(RuntimeMemoryCCTNode rtNode) {
        this.methodId = rtNode.methodId;
        if (rtNode instanceof RuntimeObjAllocTermCCTNode) {
            RuntimeObjAllocTermCCTNode rtTermNode = (RuntimeObjAllocTermCCTNode)rtNode;
            this.nCalls += rtTermNode.nCalls;
            this.totalObjSize += rtTermNode.totalObjSize;
        }
    }

    protected final void setChildren(PresoObjAllocCCTNode[] children) {
        this.children = children;
        for (PresoObjAllocCCTNode child : children) {
            child.parent = this;
        }
    }

    @Override
    public CCTNode createFilteredNode() {
        PresoObjAllocCCTNode filtered = new PresoObjAllocCCTNode();
        this.setupFilteredNode(filtered);
        return filtered;
    }

    protected void setupFilteredNode(PresoObjAllocCCTNode filtered) {
        filtered.setFilteredNode();
        filtered.parent = this.parent;
        filtered.nCalls = this.nCalls;
        filtered.totalObjSize = this.totalObjSize;
        Collection<PresoObjAllocCCTNode> _childrenL = PresoObjAllocCCTNode.resolveChildren(this);
        filtered.children = _childrenL.toArray(new PresoObjAllocCCTNode[_childrenL.size()]);
    }

    @Override
    public void merge(CCTNode node) {
        if (node instanceof PresoObjAllocCCTNode) {
            PresoObjAllocCCTNode _node = (PresoObjAllocCCTNode)node;
            this.nCalls += _node.nCalls;
            this.totalObjSize += _node.totalObjSize;
            ArrayList<PresoObjAllocCCTNode> ch = new ArrayList<PresoObjAllocCCTNode>();
            if (this.children != null) {
                ch.addAll(Arrays.asList(this.children));
            }
            for (PresoObjAllocCCTNode child : PresoObjAllocCCTNode.resolveChildren(_node)) {
                int idx = ch.indexOf(child);
                if (idx == -1) {
                    ch.add(child);
                    continue;
                }
                ((CCTNode)ch.get(idx)).merge(child);
            }
            this.children = ch.toArray(new PresoObjAllocCCTNode[ch.size()]);
        }
    }

    protected static Collection<PresoObjAllocCCTNode> resolveChildren(PresoObjAllocCCTNode node) {
        PresoObjAllocCCTNode[] chldrn = (PresoObjAllocCCTNode[])node.getChildren();
        return chldrn == null ? Collections.EMPTY_LIST : Arrays.asList(chldrn);
    }

    public static void getNamesForMethodIdsFromVM(ProfilerClient profilerClient, RuntimeMemoryCCTNode[] allStackRoots) throws ClientUtils.TargetAppOrVMTerminated {
        if (allStackRoots == null) {
            return;
        }
        for (int i = 0; i < allStackRoots.length; ++i) {
            if (allStackRoots[i] == null) continue;
            PresoObjAllocCCTNode.checkMethodIdForNodeFromVM(allStackRoots[i]);
        }
        JMethodIdTable.getDefault().getNamesForMethodIds(profilerClient);
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromSnapshot(MemoryResultsSnapshot snapshot, RuntimeMemoryCCTNode rootRuntimeNode, String classTypeName) {
        PresoObjAllocCCTNode rootNode = PresoObjAllocCCTNode.generateMirrorNode(rootRuntimeNode);
        PresoObjAllocCCTNode.assignNamesToNodesFromSnapshot(snapshot, rootNode, classTypeName);
        return rootNode;
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromVM(ProfilerClient profilerClient, RuntimeMemoryCCTNode rootRuntimeNode, String classTypeName) throws ClientUtils.TargetAppOrVMTerminated {
        PresoObjAllocCCTNode rootNode = PresoObjAllocCCTNode.generateMirrorNode(rootRuntimeNode);
        PresoObjAllocCCTNode.assignNamesToNodesFromVM(profilerClient, rootNode, classTypeName);
        return rootNode;
    }

    @Override
    public CCTNode getChild(int index) {
        if (index < this.children.length) {
            return this.children[index];
        }
        return null;
    }

    @Override
    public CCTNode[] getChildren() {
        return this.children;
    }

    @Override
    public int getIndexOfChild(Object child) {
        for (int i = 0; i < this.children.length; ++i) {
            if ((PresoObjAllocCCTNode)child != this.children[i]) continue;
            return i;
        }
        return -1;
    }

    public String[] getMethodClassNameAndSig() {
        return new String[]{this.getClassName(), this.getMethodName(), this.getMethodSig()};
    }

    @Override
    public int getNChildren() {
        if (this.children != null) {
            return this.children.length;
        }
        return 0;
    }

    public String getNodeName() {
        if (this.nodeName == null) {
            this.nodeName = this.isFiltered() ? FilterSortSupport.FILTERED_OUT_LBL : (this.methodId != 0 ? (VM_ALLOC_CLASS.equals(this.getClassName()) && VM_ALLOC_METHOD.equals(this.getMethodName()) ? VM_ALLOC_TEXT : MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(this.getClassName(), this.getMethodName(), this.getMethodSig()).toFormatted()) : (this.getClassName() != null ? this.getClassName() : UKNOWN_NODENAME));
        }
        return this.nodeName;
    }

    @Override
    public CCTNode getParent() {
        return this.parent;
    }

    public void sortChildren(int sortBy, boolean sortOrder) {
    }

    public String toString() {
        return this.getNodeName();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PresoObjAllocCCTNode)) {
            return false;
        }
        PresoObjAllocCCTNode other = (PresoObjAllocCCTNode)o;
        if (this.isFiltered()) {
            return other.isFiltered();
        }
        if (other.isFiltered()) {
            return false;
        }
        if (this.methodId == 0) {
            return this.getNodeName().equals(other.getNodeName());
        }
        if (other.methodId == 0) {
            return false;
        }
        return this.entry.className.equals(other.entry.className) && this.entry.methodName.equals(other.entry.methodName) && this.entry.methodSig.equals(other.entry.methodSig);
    }

    public int hashCode() {
        if (this.methodId == 0 || this.isFiltered()) {
            return this.getNodeName().hashCode();
        }
        return this.entry.className.hashCode() ^ this.entry.methodName.hashCode() ^ this.entry.methodSig.hashCode();
    }

    protected static void assignNamesToNodesFromSnapshot(MemoryResultsSnapshot snapshot, PresoObjAllocCCTNode rootNode, String classTypeName) {
        rootNode.className = StringUtils.userFormClassName(classTypeName);
        rootNode.setFullClassAndMethodInfo(snapshot.getJMethodIdTable());
    }

    protected static void assignNamesToNodesFromVM(ProfilerClient profilerClient, PresoObjAllocCCTNode rootNode, String classTypeName) throws ClientUtils.TargetAppOrVMTerminated {
        JMethodIdTable.getDefault().getNamesForMethodIds(profilerClient);
        rootNode.className = StringUtils.userFormClassName(classTypeName);
        rootNode.setFullClassAndMethodInfo(JMethodIdTable.getDefault());
    }

    protected static PresoObjAllocCCTNode generateMirrorNode(RuntimeMemoryCCTNode rtNode) {
        PresoObjAllocCCTNode thisNode = new PresoObjAllocCCTNode(rtNode);
        Object nodeChildren = rtNode.children;
        if (nodeChildren != null) {
            if (nodeChildren instanceof RuntimeMemoryCCTNode) {
                PresoObjAllocCCTNode child;
                thisNode.children = new PresoObjAllocCCTNode[1];
                thisNode.children[0] = child = PresoObjAllocCCTNode.generateMirrorNode((RuntimeMemoryCCTNode)nodeChildren);
                child.parent = thisNode;
                thisNode.nCalls += child.nCalls;
                thisNode.totalObjSize += child.totalObjSize;
            } else {
                RuntimeMemoryCCTNode[] ar = (RuntimeMemoryCCTNode[])nodeChildren;
                int nChildren = ar.length;
                if (nChildren > 0) {
                    thisNode.children = new PresoObjAllocCCTNode[nChildren];
                    for (int i = 0; i < nChildren; ++i) {
                        PresoObjAllocCCTNode child;
                        thisNode.children[i] = child = PresoObjAllocCCTNode.generateMirrorNode(ar[i]);
                        child.parent = thisNode;
                        thisNode.nCalls += child.nCalls;
                        thisNode.totalObjSize += child.totalObjSize;
                    }
                }
            }
        }
        return thisNode;
    }

    protected boolean setFullClassAndMethodInfo(JMethodIdTable methodIdTable) {
        if (this.methodId != 0) {
            this.entry = methodIdTable.getEntry(this.methodId);
        }
        boolean thisNodeOk = this.entry != null && !"org/netbeans/lib/profiler/server/ProfilerServer".equals(this.entry.className);
        boolean childrenOk = true;
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i].setFullClassAndMethodInfo(methodIdTable)) continue;
                childrenOk = false;
                this.children[i] = null;
            }
        }
        if (!childrenOk) {
            boolean hasNonNullChildren;
            int newLen = 0;
            for (int i = 0; i < this.children.length; ++i) {
                newLen += this.children[i] != null ? 1 : 0;
            }
            boolean bl = hasNonNullChildren = newLen > 0;
            if (!hasNonNullChildren) {
                this.children = null;
            } else {
                PresoObjAllocCCTNode[] newChildren = new PresoObjAllocCCTNode[newLen];
                int idx = 0;
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null) continue;
                    newChildren[idx++] = this.children[i];
                }
                this.children = newChildren;
            }
            if (this.getMethodName() == null || this.getMethodName().equals("main") && this.getMethodSig().equals("([Ljava/lang/String;)V")) {
                return true;
            }
            return hasNonNullChildren;
        }
        return thisNodeOk;
    }

    protected static void checkMethodIdForNodeFromVM(RuntimeMemoryCCTNode rtNode) {
        Object nodeChildren;
        if (rtNode.methodId != 0) {
            JMethodIdTable.getDefault().checkMethodId(rtNode.methodId);
        }
        if ((nodeChildren = rtNode.children) != null) {
            if (nodeChildren instanceof RuntimeMemoryCCTNode) {
                PresoObjAllocCCTNode.checkMethodIdForNodeFromVM((RuntimeMemoryCCTNode)nodeChildren);
            } else {
                RuntimeMemoryCCTNode[] ar = (RuntimeMemoryCCTNode[])nodeChildren;
                for (int i = 0; i < ar.length; ++i) {
                    PresoObjAllocCCTNode.checkMethodIdForNodeFromVM(ar[i]);
                }
            }
        }
    }

    public void exportXMLData(ExportDataDumper eDD, String indent) {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer(indent + "<Node>" + newline);
        result.append(indent).append(" <Name>").append(this.replaceHTMLCharacters(this.getNodeName())).append("<Name>").append(newline);
        result.append(indent).append(" <Parent>").append(this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName())).append("<Parent>").append(newline);
        result.append(indent).append(" <Bytes_Allocated>").append(this.totalObjSize).append("</Bytes_Allocated>").append(newline);
        result.append(indent).append(" <Objects_Allocated>").append(this.nCalls).append("</Objects_Allocated>").append(newline);
        eDD.dumpData(result);
        if (this.children != null) {
            for (int i = 0; i < this.getNChildren(); ++i) {
                this.children[i].exportXMLData(eDD, indent + " ");
            }
        }
        result = new StringBuffer(indent + "</Node>");
        eDD.dumpData(result);
    }

    public void exportHTMLData(ExportDataDumper eDD, int depth) {
        int i;
        StringBuffer result = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">");
        for (i = 0; i < depth; ++i) {
            result.append(".");
        }
        result.append(this.replaceHTMLCharacters(this.getNodeName())).append("</pre></td><td class=\"right\">").append(this.totalObjSize).append("</td><td class=\"right\">").append(this.nCalls).append("</td><td class=\"parent\"><pre class=\"parent\">").append(this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName())).append("</pre></td></tr>");
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.children.length; ++i) {
                this.children[i].exportHTMLData(eDD, depth + 1);
            }
        }
    }

    private String replaceHTMLCharacters(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public void exportCSVData(String separator, int depth, ExportDataDumper eDD) {
        int i;
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        String indent = " ";
        result.append(quote);
        for (i = 0; i < depth; ++i) {
            result.append(indent);
        }
        result.append(this.getNodeName()).append(quote).append(separator);
        result.append(quote).append(this.totalObjSize).append(quote).append(separator);
        result.append(quote).append(this.nCalls).append(quote).append(separator);
        result.append(quote).append(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName()).append(newLine);
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.children.length; ++i) {
                this.children[i].exportCSVData(separator, depth + 1, eDD);
            }
        }
    }

    String getClassName() {
        if (this.className == null && this.entry != null) {
            this.className = this.entry.className.replace('/', '.');
        }
        return this.className;
    }

    String getMethodName() {
        if (this.methodName == null && this.entry != null) {
            this.methodName = this.entry.methodName;
            if (this.entry.isNative) {
                this.methodName = this.methodName.concat(JMethodIdTable.NATIVE_SUFFIX);
            }
        }
        return this.methodName;
    }

    String getMethodSig() {
        if (this.entry != null) {
            return this.entry.methodSig;
        }
        return null;
    }

    static class Handle {
        final PresoObjAllocCCTNode node;

        Handle(PresoObjAllocCCTNode n) {
            this.node = n;
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return this.node.equals(((Handle)obj).node);
        }
    }
}

