/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class LegalCombinationOfAnnotations {
    private static Collection<IllegalCombination> illegalClassAnnotationCombinations = Arrays.asList(new IllegalCombination(Collections.singleton("javax.persistence.Entity"), Arrays.asList("javax.persistence.Embeddable", "javax.persistence.MappedSuperclass")), new IllegalCombination(Collections.singleton("javax.persistence.Table"), Collections.singleton("javax.persistence.MappedSuperclass")));
    private static Collection<IllegalCombination> illegalAttrAnnotationCombinations = Arrays.asList(new Object[0]);

    public static Collection<ErrorDescription> apply(HintContext hc) {
        if (hc.isCanceled() || hc.getPath().getLeaf().getKind() != Tree.Kind.IDENTIFIER || hc.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) {
            return null;
        }
        JPAProblemContext ctx = ModelUtils.getOrCreateCachedContext(hc);
        if (ctx == null || hc.isCanceled()) {
            return null;
        }
        TypeElement subject = ctx.getJavaClass();
        ArrayList<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();
        Collection<String> annotationsOnClass = ModelUtils.extractAnnotationNames(subject);
        for (IllegalCombination illegalCombination : illegalClassAnnotationCombinations) {
            illegalCombination.check(ctx, hc, subject, problemsFound, annotationsOnClass);
        }
        for (Element element : subject.getEnclosedElements()) {
            Collection<String> annotationsOnElement = ModelUtils.extractAnnotationNames(element);
            for (IllegalCombination ic : illegalAttrAnnotationCombinations) {
                ic.check(ctx, hc, element, problemsFound, annotationsOnElement);
            }
        }
        return problemsFound;
    }

    private static class IllegalCombination {
        private Collection<String> set1;
        private Collection<String> set2;

        IllegalCombination(Collection<String> set1, Collection<String> set2) {
            this.set1 = set1;
            this.set2 = set2;
        }

        void check(ProblemContext ctx, HintContext hc, Element elem, Collection<ErrorDescription> errorList, Collection<String> annotations) {
            for (String ann : annotations) {
                if (!this.set1.contains(ann)) continue;
                for (String forbiddenAnn : this.set2) {
                    if (!annotations.contains(forbiddenAnn)) continue;
                    Tree elementTree = ctx.getCompilationInfo().getTrees().getTree(elem);
                    Utilities.TextSpan underlineSpan = Utilities.getUnderlineSpan(ctx.getCompilationInfo(), elementTree);
                    ErrorDescription error = ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(LegalCombinationOfAnnotations.class, (String)"MSG_IllegalAnnotationCombination", (Object)ModelUtils.shortAnnotationName(ann), (Object)ModelUtils.shortAnnotationName(forbiddenAnn)), (Fix[])new Fix[0]);
                    errorList.add(error);
                }
            }
        }
    }
}

