/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;

public abstract class StdTuple
implements NativeCloneable<std.tuple>,
Native.NativeComparable<std.tuple>,
Native.assignable<std.tuple> {
    private boolean isDataPointerLike;
    private Object[] elements;

    public StdTuple(Object ... elements) {
        this(false, elements);
    }

    public StdTuple(boolean isDataPointerLike, Object ... elements) {
        this.isDataPointerLike = isDataPointerLike;
        this.elements = elements;
    }

    @Override
    public std.tuple clone() {
        return new std.tuple(this.elements);
    }

    @Override
    public std.tuple $assign(std.tuple value) {
        if (this == value) {
            return value;
        }
        if (this.elements.length == value.elements.length) {
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i] = Native.$tryAssign(this.elements[i], value.elements[i], this.isDataPointerLike);
            }
        }
        throw new AssertionError((Object)"Tuples of different sizes (and types) are not assignable!");
    }

    @Override
    public boolean $noteq(std.tuple other) {
        return !this.$eq(other);
    }

    @Override
    public boolean $eq(std.tuple other) {
        if (this.elements.length == other.elements.length) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (Native.$eq(this.elements[i], other.elements[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

