/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clank.support.aliases.char$ptr;

public final class ByteUtils {
    private static final Class<? extends ByteBuffer> SUN_DIRECT_BUFFER = ByteUtils.lookupClassQuietly("sun.nio.ch.DirectBuffer");
    private static final Method SUN_BUFFER_CLEANER;
    private static final Method SUN_CLEANER_CLEAN;

    private ByteUtils() {
    }

    public static byte[] intToBytes(int x) {
        new Exception().printStackTrace();
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(0, x);
        return buffer.array();
    }

    public static long bytesToUInt(byte[] bytes) {
        long Value = 0L;
        for (int idx = bytes.length - 1; idx >= 0; --idx) {
            Value |= (long)bytes[idx];
            Value <<= 8;
        }
        return Value;
    }

    public static int bytesToInt(byte[] bytes) {
        int Value = 0;
        for (int idx = bytes.length - 1; idx >= 0; --idx) {
            Value |= bytes[idx];
            Value <<= 8;
        }
        return Value;
    }

    public static byte[] longToBytes(long x) {
        new Exception().printStackTrace();
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(0, x);
        return buffer.array();
    }

    public static long bytesToLong(byte[] bytes) {
        long Value = 0L;
        for (int idx = bytes.length - 1; idx >= 0; --idx) {
            Value |= (long)bytes[idx];
            Value <<= 8;
        }
        return Value;
    }

    public static long bytesToLong(char$ptr bytes, int startIdx, int Len) {
        long Value = 0L;
        for (int idx = startIdx + Len - 1; idx >= startIdx; --idx) {
            Value |= (long)bytes.$at(idx);
            Value <<= 8;
        }
        return Value;
    }

    public static int bytesToUInt(char$ptr bytes, int startIdx, int Len) {
        int Value = 0;
        for (int idx = startIdx + Len - 1; idx >= startIdx; --idx) {
            Value |= bytes.$at(idx);
            Value <<= 8;
        }
        return Value;
    }

    public static void releaseDirectByteBuffer(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        if (SUN_DIRECT_BUFFER != null && SUN_DIRECT_BUFFER.isAssignableFrom(buffer.getClass())) {
            try {
                Object cleaner = SUN_BUFFER_CLEANER.invoke((Object)buffer, (Object[])null);
                if (cleaner == null) {
                    Logger.getLogger(ByteUtils.class.getName()).log(Level.INFO, "No Sun Cleaner to clean up Sun specific DirectByteBuffer.", buffer);
                } else {
                    SUN_CLEANER_CLEAN.invoke(cleaner, (Object[])null);
                }
            }
            catch (Throwable t) {
                Logger.getLogger(ByteUtils.class.getName()).log(Level.INFO, "Exception occurred attempting to clean up Sun specific DirectByteBuffer.", t);
            }
        }
    }

    private static Class<?> lookupClassQuietly(String name) {
        try {
            return ByteUtils.class.getClassLoader().loadClass(name);
        }
        catch (Throwable t) {
            Logger.getLogger(ByteUtils.class.getName()).log(Level.FINE, "Did not find requested class: " + name, t);
            return null;
        }
    }

    static {
        Method bufferCleaner = null;
        Method cleanerClean = null;
        try {
            if (SUN_DIRECT_BUFFER != null) {
                bufferCleaner = SUN_DIRECT_BUFFER.getMethod("cleaner", null);
                Class<?> cleanClazz = ByteUtils.lookupClassQuietly("sun.misc.Cleaner");
                cleanerClean = cleanClazz.getMethod("clean", null);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        SUN_BUFFER_CLEANER = bufferCleaner;
        SUN_CLEANER_CLEAN = cleanerClean;
    }
}

