/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import java.lang.reflect.Field;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.aliases.char$ptr;
import org.clank.support.void$ptr;
import sun.misc.Unsafe;

public class NativeMemory {
    private static final int NATIVE_PAGE_SIZE;
    private static final int FALLBACK_PAGE_SIZE = 4096;

    static MemoryPoint unfoldMemoryPoint(MemoryPoint data) {
        MemoryPoint result = new MemoryPoint(data.memory, data.byteIndex);
        while (result.memory instanceof memproj) {
            result.memory = ((memproj)result.memory).getOrigMemory();
            result.byteIndex += (long)((memproj)result.memory).getByteShift();
        }
        return result;
    }

    static boolean areMemoryPointsComparable(MemoryPoint p1, MemoryPoint p2) {
        if (p1.memory != p2.memory) {
            p1 = NativeMemory.unfoldMemoryPoint(p1);
            p2 = NativeMemory.unfoldMemoryPoint(p2);
        }
        return p1.memory == p2.memory;
    }

    static int compareMemoryPoints(MemoryPoint p1, MemoryPoint p2) {
        if (p1.memory != p2.memory) {
            p1 = NativeMemory.unfoldMemoryPoint(p1);
            p2 = NativeMemory.unfoldMemoryPoint(p2);
        }
        if (p1.memory == p2.memory) {
            return (int)(p1.byteIndex - p2.byteIndex);
        }
        throw new UnsupportedOperationException("Incomparable memory points!");
    }

    static long calcMemoryPointHashCode(MemoryPoint mp) {
        mp = NativeMemory.unfoldMemoryPoint(mp);
        return (long)System.identityHashCode(mp.memory) ^ mp.byteIndex;
    }

    static int getMemoryPointsDistance(MemoryPoint p1, MemoryPoint p2) {
        int distBytes = NativeMemory.compareMemoryPoints(p1, p2);
        return distBytes / NativeType.sizeof(p1);
    }

    static boolean areEqualMemoryPoints(MemoryPoint p1, MemoryPoint p2) {
        if (p1.memory != p2.memory) {
            p1 = NativeMemory.unfoldMemoryPoint(p1);
            p2 = NativeMemory.unfoldMemoryPoint(p2);
        }
        if (p1.memory != p2.memory) {
            return false;
        }
        return NativeMemory.compareMemoryPoints(p1, p2) == 0;
    }

    private NativeMemory() {
        throw new AssertionError();
    }

    static /* synthetic */ int access$000() {
        return NATIVE_PAGE_SIZE;
    }

    static {
        int pageSize;
        block3: {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                Unsafe unsafe = (Unsafe)f.get(null);
                pageSize = unsafe.pageSize();
                if (NativeTrace.VERBOSE_MODE) {
                    System.err.printf("Native Page Size is %d%n", pageSize);
                }
            }
            catch (Throwable ex) {
                pageSize = 4096;
                if (!NativeTrace.VERBOSE_MODE) break block3;
                System.err.printf("No Unsafe, Use Native Page Size as %d%n", pageSize);
            }
        }
        NATIVE_PAGE_SIZE = pageSize;
    }

    static final class MemoryPoint {
        public memory memory;
        public long byteIndex;

        public MemoryPoint() {
        }

        public MemoryPoint(memory first, long second) {
            this.memory = first;
            this.byteIndex = second;
        }
    }

    public static interface memproj<M extends memory>
    extends memory {
        public M getOrigMemory();

        public int getByteShift();
    }

    public static interface memory {
        public int sizeof();

        public int size();

        public long toByteIndex(long var1);

        public long fromByteIndex(long var1);
    }

    public static interface BumpAllocator
    extends Allocator {
        public int AllocateAndGetIndex(int var1, int var2);

        public int AllocateAndGetIndex(int var1);

        public byte[] GetLastAllocationStorage();
    }

    public static interface Allocator {
        public static final int MaxPageSize = Integer.getInteger("clank.max.page.size", 65536);
        public static final int PageSize = Integer.getInteger("clank.page.size", Math.min(MaxPageSize, NativeMemory.access$000()));

        public void Reset();

        public char$ptr Allocate(int var1, int var2);

        public char$ptr Allocate(int var1);

        public char$ptr AllocateSlab(int var1);

        public <T> void$ptr Allocate(Class<T> var1, int var2);

        public void Deallocate(Object var1);

        public void DeallocateSlab(char$ptr var1, int var2);

        public void PrintStats();
    }
}

