/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import java.math.BigInteger;

public final class Unsigned {
    static final int INT_HIGH_BIT = Integer.MIN_VALUE;
    static final long INT_SIGN_BIT_IN_LONG = 0x80000000L;
    static final long LONG_HIGH_BIT = Long.MIN_VALUE;
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public static int long2uint(long longVal) {
        assert ((longVal & 0xFFFFFFFF00000000L) == 0L) : "incorrect long value " + longVal + ":" + Long.toHexString(longVal);
        int out = (int)longVal;
        return out;
    }

    public static long uint2long(int intVal) {
        long out = 0xFFFFFFFFL & (long)intVal;
        assert (out >= 0L);
        return out;
    }

    private Unsigned() {
    }

    public static int compare(int u1, int u2) {
        if ((u1 & Integer.MAX_VALUE) == u1 == ((u2 & Integer.MAX_VALUE) == u2)) {
            return u1 - u2;
        }
        if (u1 < 0) {
            return 1;
        }
        return -1;
    }

    public static long compare(long u1, long u2) {
        if ((u1 & Long.MAX_VALUE) == u1 == ((u2 & Long.MAX_VALUE) == u2)) {
            return u1 - u2;
        }
        if (u1 < 0L) {
            return 1L;
        }
        return -1L;
    }

    public static String toUnsignedString(long i, int radix) {
        return Unsigned.toUnsignedStringImplFromJDK8(i, radix);
    }

    private static String toUnsignedStringImplFromJDK8(long i, int radix) {
        if (i >= 0L) {
            return Long.toString(i, radix);
        }
        switch (radix) {
            case 2: {
                return Long.toBinaryString(i);
            }
            case 4: {
                return Unsigned.toUnsignedString0(i, 2);
            }
            case 8: {
                return Long.toOctalString(i);
            }
            case 10: {
                long quot = (i >>> 1) / 5L;
                long rem = i - quot * 10L;
                return Long.toString(quot) + rem;
            }
            case 16: {
                return Long.toHexString(i);
            }
            case 32: {
                return Unsigned.toUnsignedString0(i, 5);
            }
        }
        return Unsigned.toUnsignedBigInteger(i).toString(radix);
    }

    private static BigInteger toUnsignedBigInteger(long i) {
        if (i >= 0L) {
            return BigInteger.valueOf(i);
        }
        int upper = (int)(i >>> 32);
        int lower = (int)i;
        return BigInteger.valueOf(Unsigned.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Unsigned.toUnsignedLong(lower)));
    }

    private static long toUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    static String toUnsignedString0(long val, int shift) {
        int mag = 64 - Long.numberOfLeadingZeros(val);
        int chars = Math.max((mag + (shift - 1)) / shift, 1);
        char[] buf = new char[chars];
        Unsigned.formatUnsignedLong(val, shift, buf, 0, chars);
        return new String(buf);
    }

    static int formatUnsignedLong(long val, int shift, char[] buf, int offset, int len) {
        int charPos = len;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[offset + --charPos] = digits[(int)val & mask];
        } while ((val >>>= shift) != 0L && charPos > 0);
        return charPos;
    }

    public static long divideUnsigned(long dividend, long divisor) {
        if (divisor < 0L) {
            return Unsigned.compare(dividend, divisor) < 0L ? 0L : 1L;
        }
        if (dividend > 0L) {
            return dividend / divisor;
        }
        return Unsigned.toUnsignedBigInteger(dividend).divide(Unsigned.toUnsignedBigInteger(divisor)).longValue();
    }

    public static long remainderUnsigned(long dividend, long divisor) {
        if (dividend > 0L && divisor > 0L) {
            return dividend % divisor;
        }
        if (Unsigned.compare(dividend, divisor) < 0L) {
            return dividend;
        }
        return Unsigned.toUnsignedBigInteger(dividend).remainder(Unsigned.toUnsignedBigInteger(divisor)).longValue();
    }
}

