/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2.mi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITListItem;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;

public class MITList
extends MIValue
implements Iterable<MITListItem> {
    private final ArrayList<MITListItem> list = new ArrayList();
    private final boolean isList;
    private final boolean topLevel;
    private boolean sawResults;
    private boolean sawValues;
    private static final Logger LOG = Logger.getLogger(MITList.class.toString());

    MITList(boolean isList, boolean topLevel) {
        this.isList = isList;
        this.topLevel = topLevel;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        if (!this.topLevel) {
            s.append(this.isList() ? (char)'[' : '{');
        }
        for (int vx = 0; vx < this.list.size(); ++vx) {
            MITListItem item = this.list.get(vx);
            s.append(item.toString());
            if (vx + 1 >= this.list.size()) continue;
            s.append(',');
        }
        if (!this.topLevel) {
            s.append(this.isList() ? (char)']' : '}');
        }
        return s.toString();
    }

    public boolean isList() {
        return this.isList;
    }

    @Override
    public boolean isTList() {
        return true;
    }

    @Override
    public Iterator<MITListItem> iterator() {
        return this.list.iterator();
    }

    @Override
    public MITList asTList() {
        return this;
    }

    @Override
    public MITList asTuple() {
        return this;
    }

    @Override
    public MITList asList() {
        return this;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }

    public boolean isValueList() {
        return this.sawValues;
    }

    public boolean isResultList() {
        return this.sawResults;
    }

    public MITListItem get(int x) {
        return this.list.get(x);
    }

    void add(MIResult result) {
        assert (!this.sawValues) : "Adding results to a value list";
        this.sawResults = true;
        this.list.add(result);
    }

    void add(MIValue value) {
        assert (!this.sawResults) : "Adding values to a result list";
        this.sawValues = true;
        this.list.add(value);
    }

    public <Type> Iterable<Type> getOnly(final Class<Type> cls) {
        final Iterator<MITListItem> iterator = this.iterator();
        return new Iterable<Type>(){

            @Override
            public Iterator<Type> iterator() {
                return new Iterator<Type>(){
                    private Type item = this.nextImpl();

                    private Type nextImpl() {
                        while (iterator.hasNext()) {
                            MITListItem next = (MITListItem)iterator.next();
                            if (!cls.isInstance(next)) continue;
                            return cls.cast(next);
                        }
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.item != null;
                    }

                    @Override
                    public Type next() {
                        if (this.item == null) {
                            throw new NoSuchElementException();
                        }
                        Object res = this.item;
                        this.item = this.nextImpl();
                        return res;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported.");
                    }
                };
            }
        };
    }

    public MIValue valueOf(String variable) {
        for (MITListItem item : this.list) {
            if (item instanceof MIResult) {
                MIResult result = (MIResult)item;
                if (!result.matches(variable)) continue;
                return result.value();
            }
            LOG.log(Level.WARNING, "Trying to get value from a result list :{0}", this);
        }
        return null;
    }

    public String getConstValue(String variable) {
        return this.getConstValue(variable, "");
    }

    public String getConstValue(String variable, String defaultValue) {
        MIValue val = this.valueOf(variable);
        if (val != null) {
            return val.asConst().value();
        }
        return defaultValue;
    }
}

