/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fileoperations.spi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteExceptions;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemTransport;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.spi.RemoteServerListProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class RemoteVcsSupportUtil {
    private static final boolean USE_CACHE;
    public static final boolean USE_FS;

    private RemoteVcsSupportUtil() {
    }

    public static boolean isSymbolicLink(FileSystem fileSystem, String path) {
        if (fileSystem instanceof RemoteFileSystem) {
            Boolean res;
            RemoteFileSystem rfs = (RemoteFileSystem)fileSystem;
            if (USE_CACHE && (res = rfs.vcsSafeIsSymbolicLink(path)) != null) {
                return res;
            }
            ExecutionEnvironment env = rfs.getExecutionEnvironment();
            if (!ConnectionManager.getInstance().isConnectedTo(env)) {
                return false;
            }
            try {
                DirEntry entry = RemoteFileSystemTransport.lstat(env, path);
                return entry.isLink();
            }
            catch (ConnectException ex) {
                RemoteLogger.finest(ex);
            }
            catch (IOException | InterruptedException ex) {
                RemoteLogger.finest(ex);
            }
            catch (ExecutionException ex) {
                if (RemoteFileSystemUtils.isFileNotFoundException(ex)) {
                    return false;
                }
                ex.printStackTrace(System.err);
            }
            return false;
        }
        return false;
    }

    @SuppressWarnings(value={"NP"})
    public static Boolean isDirectoryFast(FileSystem fs, String path) throws IOException {
        if (fs instanceof RemoteFileSystem) {
            return ((RemoteFileSystem)fs).vcsSafeIsDirectory(path);
        }
        return null;
    }

    public static String readSymbolicLinkPath(FileSystem fileSystem, String path) throws IOException {
        FileObject fo;
        if (fileSystem instanceof RemoteFileSystem && (fo = fileSystem.findResource(path)) != null) {
            return fo.readSymbolicLinkPath();
        }
        return null;
    }

    public static String getCanonicalPath(FileSystem fileSystem, String path) throws IOException {
        if (fileSystem instanceof RemoteFileSystem) {
            return RemoteVcsSupportUtil.getCanonicalPathImpl((RemoteFileSystem)fileSystem, path);
        }
        return null;
    }

    private static String getCanonicalPathImpl(RemoteFileSystem fs, String path) throws IOException {
        Boolean isLink = fs.vcsSafeCanonicalPathDiffers(path);
        if (isLink != null && !isLink.booleanValue()) {
            return null;
        }
        ExecutionEnvironment env = fs.getExecutionEnvironment();
        if (!ConnectionManager.getInstance().isConnectedTo(env)) {
            throw RemoteExceptions.createConnectException(RemoteFileSystemUtils.getConnectExceptionMessage(env));
        }
        try {
            DirEntry entry = RemoteFileSystemTransport.lstat(env, path);
            if (entry.isLink()) {
                String nextTarget;
                String target = entry.getLinkTarget();
                if (!target.startsWith("/")) {
                    target = PathUtilities.normalizeUnixPath((String)(path + "/" + target));
                }
                return (nextTarget = RemoteVcsSupportUtil.getCanonicalPathImpl(fs, target)) == null ? target : nextTarget;
            }
            return null;
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException();
        }
        catch (ExecutionException ex) {
            if (RemoteFileSystemUtils.isFileNotFoundException(ex)) {
                FileNotFoundException fnfe = new FileNotFoundException();
                fnfe.initCause(ex);
                throw fnfe;
            }
            throw new IOException(ex);
        }
    }

    public static boolean canReadImpl(RemoteFileSystem fileSystem, String path) {
        try {
            ExecutionEnvironment env = fileSystem.getExecutionEnvironment();
            DirEntry entry = RemoteFileSystemTransport.stat(env, path);
            return entry.canRead();
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex);
        }
        catch (IOException | InterruptedException | ExecutionException ex) {
            RemoteLogger.finest(ex);
        }
        return false;
    }

    public static boolean canRead(FileSystem fileSystem, String path) {
        if (fileSystem instanceof RemoteFileSystem) {
            return RemoteVcsSupportUtil.canReadImpl((RemoteFileSystem)fileSystem, path);
        }
        return false;
    }

    public static long getSizeImpl(RemoteFileSystem fileSystem, String path) {
        try {
            ExecutionEnvironment env = fileSystem.getExecutionEnvironment();
            DirEntry entry = RemoteFileSystemTransport.stat(env, path);
            return entry.getSize();
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex);
            return 0L;
        }
        catch (IOException | InterruptedException | ExecutionException ex) {
            RemoteLogger.finest(ex);
            return 0L;
        }
    }

    public static long getSize(FileSystem fileSystem, String path) {
        if (fileSystem instanceof RemoteFileSystem) {
            return RemoteVcsSupportUtil.getSizeImpl((RemoteFileSystem)fileSystem, path);
        }
        return 0L;
    }

    public static OutputStream getOutputStream(FileSystem fileSystem, String path) throws IOException {
        FileObject fo = RemoteVcsSupportUtil.getOrCreateFileObject(fileSystem, path);
        return fo.getOutputStream();
    }

    private static FileObject getOrCreateFileObject(FileSystem fileSystem, String path) throws IOException {
        FileObject fo = RemoteVcsSupportUtil.getFileObject(fileSystem, path);
        if (fo == null) {
            fo = FileUtil.createData((FileObject)fileSystem.getRoot(), (String)path);
        }
        return fo;
    }

    private static FileObject getFileObject(FileSystem fileSystem, String path) throws IOException {
        return RemoteVcsSupportUtil.getFileObject(fileSystem, path, null);
    }

    private static FileObject getFileObject(FileSystem fileSystem, String path, AtomicBoolean refreshed) throws IOException {
        RemoteFileObjectBase cachedFileObject;
        if (fileSystem instanceof RemoteFileSystem && (cachedFileObject = ((RemoteFileSystem)fileSystem).getFactory().getCachedFileObject(path)) != null && cachedFileObject.isValid()) {
            return cachedFileObject.getOwnerFileObject();
        }
        FileObject fo = fileSystem.findResource(path);
        if (fo == null) {
            FileObject parentFO;
            String parentPath = PathUtilities.getDirName((String)path);
            FileObject fileObject = parentFO = parentPath == null ? fileSystem.getRoot() : fileSystem.findResource(parentPath);
            while (parentFO == null) {
                parentFO = (parentPath = PathUtilities.getDirName((String)parentPath)) == null ? fileSystem.getRoot() : fileSystem.findResource(parentPath);
            }
            parentFO.refresh();
            if (refreshed != null) {
                refreshed.set(true);
            }
            fo = fileSystem.findResource(path);
        }
        return fo;
    }

    private static void deleteExternally(ExecutionEnvironment env, String path) {
        ProcessUtils.ExitStatus res = ProcessUtils.execute((ExecutionEnvironment)env, (String)"rm", (String[])new String[]{"-rf", path});
        if (!res.isOK()) {
            RemoteLogger.info("Error deleting {0}:{1} rc={2} {3}", env, path, res.exitCode, res.error);
        }
    }

    public static void delete(FileSystem fs, String path) {
        RemoteLogger.assertTrue(fs instanceof RemoteFileSystem, "" + fs + " not an instance of RemoteFileSystem", new Object[0]);
        if (fs instanceof RemoteFileSystem) {
            RemoteFileSystem rfs = (RemoteFileSystem)fs;
            ExecutionEnvironment env = rfs.getExecutionEnvironment();
            if (rfs.isInsideVCS()) {
                RemoteVcsSupportUtil.deleteExternally(env, path);
            } else {
                try {
                    FileObject fo = RemoteVcsSupportUtil.getFileObject(fs, path);
                    if (fo != null) {
                        fo.delete();
                    } else {
                        RemoteLogger.info("Can not delete inexistent file {0}:{1}", env, path);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }

    public static void deleteExternally(FileSystem fs, String path) {
        RemoteLogger.assertTrue(fs instanceof RemoteFileSystem, "" + fs + " not an instance of RemoteFileSystem", new Object[0]);
        if (fs instanceof RemoteFileSystem) {
            RemoteVcsSupportUtil.deleteExternally(((RemoteFileSystem)fs).getExecutionEnvironment(), path);
            String parentPath = PathUtilities.getDirName((String)path);
            try {
                RemoteVcsSupportUtil.refreshFor(fs, parentPath == null ? "/" : parentPath);
            }
            catch (IOException ex) {
                RemoteLogger.fine(ex);
            }
        }
    }

    public static void setLastModified(FileSystem fs, String path, String referenceFile) {
        RemoteLogger.assertTrue(fs instanceof RemoteFileSystem, "" + fs + " not an instance of RemoteFileSystem", new Object[0]);
        RemoteLogger.assertTrue(path.startsWith("/"));
        RemoteLogger.assertTrue(referenceFile.startsWith("/"));
        if (fs instanceof RemoteFileSystem) {
            RemoteFileSystem rfs = (RemoteFileSystem)fs;
            ExecutionEnvironment env = rfs.getExecutionEnvironment();
            ProcessUtils.ExitStatus res = ProcessUtils.execute((ExecutionEnvironment)env, (String)"touch", (String[])new String[]{"-r", path, referenceFile});
            if (res.isOK()) {
                try {
                    FileObject baseFO2;
                    String base1 = PathUtilities.getDirName((String)path);
                    String base2 = PathUtilities.getDirName((String)referenceFile);
                    FileObject baseFO1 = base1 == null ? fs.getRoot() : RemoteVcsSupportUtil.getFileObject(fs, base1);
                    FileObject fileObject = baseFO2 = base2 == null ? fs.getRoot() : RemoteVcsSupportUtil.getFileObject(fs, base2);
                    if (baseFO1 instanceof RemoteFileObject) {
                        ((RemoteFileObject)baseFO1).nonRecursiveRefresh();
                    }
                    if (baseFO2 instanceof RemoteFileObject && !baseFO2.equals(baseFO1)) {
                        ((RemoteFileObject)baseFO2).nonRecursiveRefresh();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            } else {
                RemoteLogger.info("Error setting timestamp for {0}:{1} from {2} rc={3} {4}", env, path, env, referenceFile, res.exitCode, res.error);
            }
        }
    }

    public static FileSystem[] getConnectedFileSystems() {
        ArrayList<RemoteFileSystem> connected = new ArrayList<RemoteFileSystem>();
        RemoteServerListProvider provider = (RemoteServerListProvider)Lookup.getDefault().lookup(RemoteServerListProvider.class);
        if (provider == null) {
            for (RemoteFileSystem fs : RemoteFileSystemManager.getInstance().getAllFileSystems()) {
                if (!ConnectionManager.getInstance().isConnectedTo(fs.getExecutionEnvironment())) continue;
                connected.add(fs);
            }
        } else {
            for (ExecutionEnvironment env : provider.getRemoteServers()) {
                if (!ConnectionManager.getInstance().isConnectedTo(env)) continue;
                RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(env);
                connected.add(fs);
            }
        }
        return connected.toArray(new FileSystem[connected.size()]);
    }

    public static void refreshFor(FileSystem fs, String ... paths) throws ConnectException, IOException {
        RemoteLogger.assertTrue(fs instanceof RemoteFileSystem, "" + fs + " not an instance of RemoteFileSystem", new Object[0]);
        for (String p : paths) {
            RemoteLogger.assertTrue(p != null, "Path should not be null", new Object[0]);
            RemoteLogger.assertTrue(p.isEmpty() || p.startsWith("/"), "Path should be absolute: {0}", paths);
        }
        RemoteFileSystem rfs = (RemoteFileSystem)fs;
        AtomicBoolean refreshed = new AtomicBoolean(false);
        HashSet<RemoteDirectory> refreshSet = new HashSet<RemoteDirectory>();
        for (String p : paths) {
            FileObject fo;
            if (p.isEmpty()) {
                p = "/";
            }
            if ((fo = RemoteVcsSupportUtil.getFileObject(rfs, p, refreshed)) == null || refreshed.get()) continue;
            RemoteFileObjectBase impl = ((RemoteFileObject)fo).getImplementor();
            if (impl.isFolder()) {
                if ((impl = RemoteFileSystemUtils.getCanonicalFileObject(impl)) instanceof RemoteDirectory) {
                    refreshSet.add((RemoteDirectory)impl);
                    continue;
                }
                RemoteLogger.info("Unexpected file object instance, expected RemoteDirectory: {0}", impl);
                impl.refresh();
                continue;
            }
            refreshSet.add(RemoteFileSystemUtils.getCanonicalParent(impl));
        }
        if (RemoteFileSystemTransport.canRefreshFast(rfs.getExecutionEnvironment())) {
            for (RemoteDirectory impl : refreshSet) {
                try {
                    RemoteFileSystemTransport.refreshFast(impl, false);
                }
                catch (InterruptedException | CancellationException ex) {
                    InterruptedIOException ie = new InterruptedIOException(ex.getMessage());
                    ie.initCause(ex);
                    throw ie;
                }
                catch (ExecutionException ex) {
                    throw new IOException(ex.getMessage(), ex);
                }
            }
        } else {
            for (RemoteDirectory fo : refreshSet) {
                fo.refresh();
            }
        }
    }

    static {
        String text = System.getProperty("rfs.vcs.cache");
        USE_CACHE = text == null ? true : Boolean.parseBoolean(text);
        USE_FS = RemoteFileSystemUtils.getBoolean("rfs.vcs.use.fs", true);
    }
}

