/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.FormatException;
import org.openide.util.Exceptions;

public class DirEntryImpl
extends DirEntry {
    private final String name;
    private final long size;
    private final String linkTarget;
    private final long lastModified;
    private final byte flags;
    private final char fileTypeChar;
    private final long device;
    private final long inode;
    private static final byte MASK_CAN_READ = 1;
    private static final byte MASK_CAN_WRITE = 2;
    private static final byte MASK_CAN_EXECUTE = 4;

    public static DirEntryImpl create(FileInfoProvider.StatInfo statInfo, ExecutionEnvironment env) {
        return DirEntryImpl.create(statInfo, statInfo.getName(), env);
    }

    public static DirEntryImpl create(FileInfoProvider.StatInfo statInfo, String cache, ExecutionEnvironment env) {
        return new DirEntryImpl(cache, statInfo.getName(), statInfo.getSize(), statInfo.getLastModified().getTime(), DirEntryImpl.makeFlags(statInfo.canRead(env), statInfo.canWrite(env), statInfo.canExecute(env)), statInfo.getFileType().toChar(), 0L, 0L, statInfo.getLinkTarget());
    }

    public static DirEntryImpl create(String name, long size, long lastModified, boolean canRead, boolean canWrite, boolean canExec, char fileTypeChar, long device, long inode, String linkTarget) {
        return new DirEntryImpl(name, name, size, lastModified, DirEntryImpl.makeFlags(canRead, canWrite, canExec), fileTypeChar, device, inode, linkTarget);
    }

    private static byte makeFlags(boolean canRead, boolean canWrite, boolean canExec) {
        byte flags = 0;
        if (canRead) {
            flags = (byte)(flags | 1);
        }
        if (canWrite) {
            flags = (byte)(flags | 2);
        }
        if (canExec) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    private DirEntryImpl(String cache, String name, long size, long lastModified, byte flags, char fileTypeChar, long device, long inode, String linkTarget) {
        super(cache);
        this.name = name;
        this.size = size;
        this.linkTarget = linkTarget;
        this.lastModified = lastModified;
        this.flags = flags;
        this.fileTypeChar = fileTypeChar;
        this.device = device;
        this.inode = inode;
    }

    private boolean getFlag(byte mask) {
        return (this.flags & mask) == mask;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean canRead() {
        return this.getFlag((byte)1);
    }

    @Override
    public boolean canExecute() {
        return this.getFlag((byte)4);
    }

    @Override
    public boolean canWrite() {
        return this.getFlag((byte)2);
    }

    @Override
    public long getDevice() {
        return this.device;
    }

    @Override
    public long getINode() {
        return this.inode;
    }

    @Override
    public Date getLastModified() {
        return new Date(this.lastModified);
    }

    @Override
    public boolean isLink() {
        return this.fileTypeChar == FileInfoProvider.StatInfo.FileType.SymbolicLink.toChar();
    }

    @Override
    public boolean isDirectory() {
        return this.fileTypeChar == FileInfoProvider.StatInfo.FileType.Directory.toChar();
    }

    @Override
    public boolean isPlainFile() {
        return this.fileTypeChar == FileInfoProvider.StatInfo.FileType.Regular.toChar();
    }

    @Override
    public FileInfoProvider.StatInfo.FileType getFileType() {
        return FileInfoProvider.StatInfo.FileType.fromChar((char)this.fileTypeChar);
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    @Override
    public String toExternalForm() {
        StringBuilder sb = new StringBuilder();
        sb.append(DirEntryImpl.escape(this.name)).append(' ');
        sb.append(DirEntryImpl.escape(this.getCache())).append(' ');
        sb.append(this.getFileType().toChar()).append(' ');
        sb.append(this.size).append(' ');
        sb.append(this.lastModified).append(' ');
        sb.append(this.accessAsString()).append(' ');
        sb.append(this.device).append(' ');
        sb.append(this.inode).append(' ');
        if (this.linkTarget != null) {
            sb.append(DirEntryImpl.escape(this.linkTarget)).append(' ');
        }
        return sb.toString();
    }

    public static DirEntryImpl fromExternalForm(String externalForm) throws FormatException {
        String[] parts = externalForm.split(" +");
        if (parts.length != 8 && parts.length != 9) {
            throw new FormatException("Wrong format: " + externalForm, false);
        }
        String name = DirEntryImpl.unescape(parts[0]);
        String cache = DirEntryImpl.unescape(parts[1]);
        if (parts[2].length() != 1) {
            throw new FormatException("Wrong file type format: " + externalForm, false);
        }
        FileInfoProvider.StatInfo.FileType type = FileInfoProvider.StatInfo.FileType.fromChar((char)parts[2].charAt(0));
        long size = Long.parseLong(parts[3]);
        long lastModified = Long.parseLong(parts[4]);
        String access = parts[5];
        if (access.length() != 3 || access.charAt(0) != 'r' && access.charAt(0) != '-' || access.charAt(1) != 'w' && access.charAt(1) != '-' || access.charAt(2) != 'x' && access.charAt(2) != '-') {
            throw new FormatException("Wrong file access format: " + externalForm, false);
        }
        byte flags = 0;
        if (access.charAt(0) == 'r') {
            flags = (byte)(flags | 1);
        }
        if (access.charAt(1) == 'w') {
            flags = (byte)(flags | 2);
        }
        if (access.charAt(2) == 'x') {
            flags = (byte)(flags | 4);
        }
        long device = Long.parseLong(parts[6]);
        long inode = Long.parseLong(parts[7]);
        String linkTarget = parts.length > 8 ? DirEntryImpl.unescape(parts[8]) : null;
        return new DirEntryImpl(cache, name, size, lastModified, flags, type.toChar(), device, inode, linkTarget);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private static String escape(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return text.replace(" ", "\\ ");
        }
    }

    private static String unescape(String text) {
        try {
            return URLDecoder.decode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return text.replace("\\ ", " ");
        }
    }

    public String toString() {
        return this.name + ' ' + this.accessAsString() + ' ' + this.isDirectory() + ' ' + this.lastModified + ' ' + (this.isLink() ? " -> " + this.linkTarget : Long.valueOf(this.size)) + " (" + this.getCache() + ')' + (this.isValid() ? "[valid]" : "[invalid]");
    }

    private String accessAsString() {
        return "" + (this.canRead() ? (char)'r' : '-') + (this.canWrite() ? (char)'w' : '-') + (this.canExecute() ? (char)'x' : '-');
    }
}

