/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.RemoteStatistics;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class MagicCache {
    static final int BUF_LENGTH = 4000;
    private static final String cacheName = ".rfs_magic";
    private final RemoteDirectory dir;
    private Map<String, byte[]> cache;
    private static final RequestProcessor RP = new RequestProcessor("ErrorReader");

    public MagicCache(RemoteDirectory dir) {
        this.dir = dir;
    }

    public synchronized byte[] get(String fileName) {
        if (this.cache == null) {
            this.cache = new HashMap<String, byte[]>();
            if (!this.readCache()) {
                this.cache = null;
                return null;
            }
        }
        return this.cache.get(fileName);
    }

    public synchronized void clean(String fileName) {
        File od = new File(this.dir.getCache(), cacheName);
        if (od.exists()) {
            od.delete();
            if (this.cache != null) {
                if (fileName == null) {
                    this.cache.clear();
                } else {
                    this.cache.remove(fileName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readCache() {
        File od = new File(this.dir.getCache(), cacheName);
        if (!od.exists()) {
            try {
                if (!ConnectionManager.getInstance().isConnectedTo(this.dir.getExecutionEnvironment())) {
                    return false;
                }
                this.updateCache();
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (UnsupportedEncodingException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InterruptedIOException ex) {
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (od.exists()) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(od));
                String line = null;
                String file = null;
                byte[] res = null;
                int pos = 0;
                block22: while ((line = in.readLine()) != null) {
                    String[] split;
                    if (line.startsWith("./")) {
                        this.createEntry(file, res, pos);
                        file = line.substring(2);
                        res = new byte[4000];
                        pos = 0;
                        continue;
                    }
                    if (!line.startsWith("000") || (split = line.split(" +")).length <= 1) continue;
                    for (int i = 1; i < split.length; ++i) {
                        String s = split[i];
                        try {
                            if (s.length() == 2) {
                                if (pos >= res.length) continue;
                                int L = Integer.parseInt(s, 16);
                                res[pos++] = (byte)(L & 0xFF);
                                continue;
                            }
                            long L = Long.parseLong(s, 16);
                            if (pos < res.length) {
                                res[pos++] = (byte)(L & 0xFFL);
                            }
                            if (pos < res.length) {
                                res[pos++] = (byte)(L >> 8 & 0xFFL);
                            }
                            if (pos < res.length) {
                                res[pos++] = (byte)(L >> 16 & 0xFFL);
                            }
                            if (pos >= res.length) continue;
                            res[pos++] = (byte)(L >> 24 & 0xFFL);
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            continue block22;
                        }
                    }
                }
                this.createEntry(file, res, pos);
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return true;
    }

    private void createEntry(String file, byte[] res, int pos) {
        if (file != null) {
            if (pos < res.length) {
                byte[] ares = new byte[pos];
                System.arraycopy(res, 0, ares, 0, pos);
                res = ares;
            }
            this.cache.put(file, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache() throws FileNotFoundException, UnsupportedEncodingException, IOException {
        String command = "/usr/bin/find . ! -name . -prune -type f -print -exec od -t x1 -N 4000 {} \\;";
        String path = this.dir.getPath();
        if (path.isEmpty()) {
            path = "/";
        }
        File od = new File(this.dir.getCache(), cacheName);
        FileOutputStream os = null;
        InputStream is = null;
        RemoteStatistics.ActivityID activityID = RemoteStatistics.startChannelActivity((CharSequence)"reading MIME", (CharSequence[])new CharSequence[]{path});
        try {
            os = new FileOutputStream(od);
            NativeProcessBuilder processBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.dir.getExecutionEnvironment());
            processBuilder.setExecutable("/bin/sh");
            processBuilder.setArguments(new String[]{"-c", command});
            processBuilder.setWorkingDirectory(path);
            NativeProcess process = processBuilder.call();
            RP.post(new Runnable((Process)process){
                final /* synthetic */ Process val$process;
                {
                    this.val$process = process;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BufferedReader reader = ProcessUtils.getReader((InputStream)this.val$process.getErrorStream(), (boolean)true);
                    try {
                        while (reader.readLine() != null) {
                        }
                    }
                    catch (IOException ex) {
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            });
            is = process.getInputStream();
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
            RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)od.length());
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }
}

