/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.DirEntryList;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteExceptions;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemTransport;
import org.netbeans.modules.remote.impl.fs.RemoteLinkBase;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RemoteFileSystemUtils {
    private static final int MAXSYMLINKS;
    private static final boolean TRUE_CASE_SENSITIVE_SYSTEM;
    private static boolean isWindows;
    private static final char[][] windowsReservedChars;
    private static final char windowsReservedNameChar = 'R';

    public static boolean isSystemCaseSensitive() {
        return TRUE_CASE_SENSITIVE_SYSTEM;
    }

    private RemoteFileSystemUtils() {
    }

    public static ExecutionEnvironment getExecutionEnvironment(String hostName, int port) {
        ExecutionEnvironment result = null;
        for (ExecutionEnvironment env : ConnectionManager.getInstance().getRecentConnections()) {
            if (!hostName.equals(env.getHost()) || port != 0 && port != env.getSSHPort()) continue;
            result = env;
            if (!ConnectionManager.getInstance().isConnectedTo(env)) continue;
            break;
        }
        return result;
    }

    public static String escapeFileName(String name) {
        char c;
        if (name.startsWith(".rfs_")) {
            name = "._rfs_" + name.substring(".rfs_".length());
        }
        if (!isWindows) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        if ((name.startsWith("CON") || name.startsWith("PRN") || name.startsWith("AUX") || name.startsWith("NUL")) && (name.length() == 3 || name.charAt(3) == '.')) {
            sb.append('_').append('R').append(name);
            return sb.toString();
        }
        if ((name.startsWith("COM") || name.startsWith("LPT")) && name.length() > 3 && '1' <= (c = name.charAt(3)) && c <= '9' && (name.length() == 4 || name.charAt(4) == '.')) {
            sb.append('_').append('R').append(name);
            return sb.toString();
        }
        if (!RemoteFileSystemUtils.containsReservedCharacters(name) && name.indexOf(95) < 0) {
            return name;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c2 = name.charAt(i);
            if (c2 == '_') {
                sb.append("__");
                continue;
            }
            boolean added = false;
            for (int j = 0; j < windowsReservedChars.length; ++j) {
                if (c2 != windowsReservedChars[j][0]) continue;
                sb.append('_').append(windowsReservedChars[j][1]);
                added = true;
            }
            if (added) continue;
            sb.append(c2);
        }
        return sb.toString();
    }

    private char unescapeChar(char c) {
        for (int j = 0; j < windowsReservedChars.length; ++j) {
            if (c != windowsReservedChars[j][1]) continue;
            return windowsReservedChars[j][0];
        }
        return '\u0000';
    }

    public static String unescapeFileName(String name) {
        if (!isWindows) {
            return name;
        }
        if (name.length() < 2 || name.indexOf(95) < 0) {
            return name;
        }
        if (name.charAt(0) == '_' && name.charAt(1) == 'R') {
            return name.substring(2);
        }
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (escape) {
                escape = false;
                if (c == '_') {
                    sb.append('_');
                    continue;
                }
                boolean added = false;
                for (int j = 0; j < windowsReservedChars.length; ++j) {
                    if (c != windowsReservedChars[j][1]) continue;
                    sb.append(windowsReservedChars[j][0]);
                    added = true;
                    break;
                }
                if (added) continue;
                RemoteLogger.getInstance().log(Level.SEVERE, "Incorrect name to unescape: ''{0}''", name);
                continue;
            }
            if (c == '_') {
                escape = true;
                if (i + 1 != name.length()) continue;
                RemoteLogger.getInstance().log(Level.SEVERE, "Incorrect name to unescape: ''{0}''", name);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean containsReservedCharacters(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            for (int j = 0; j < windowsReservedChars.length; ++j) {
                if (c != windowsReservedChars[j][0]) continue;
                return true;
            }
        }
        return false;
    }

    static void testSetWindows(boolean isWin) {
        isWindows = isWin;
    }

    public static String normalize(String absPath) {
        return absPath;
    }

    public static FileObject getCanonicalFileObject(FileObject fo) throws IOException {
        if (fo instanceof RemoteFileObject) {
            return RemoteFileSystemUtils.getCanonicalFileObject(((RemoteFileObject)fo).getImplementor()).getOwnerFileObject();
        }
        return fo;
    }

    public static RemoteFileObjectBase getCanonicalFileObject(RemoteFileObjectBase fileObject) throws IOException {
        RemoteFileObjectBase candidate = fileObject;
        for (int i = 0; i < MAXSYMLINKS; ++i) {
            RemoteFileObjectBase delegate;
            if (candidate instanceof RemoteLinkBase) {
                delegate = ((RemoteLinkBase)candidate).getDelegateImpl();
                if (delegate == null) {
                    throw new FileNotFoundException("Null delegate for remote link " + candidate);
                }
                if (!(delegate instanceof RemoteLinkBase)) {
                    return delegate;
                }
            } else {
                return candidate;
            }
            candidate = delegate;
        }
        throw RemoteExceptions.createFileNotFoundException(NbBundle.getMessage(RemoteFileSystemUtils.class, (String)"EXC_DeepSymLinks", (Object)fileObject.getDisplayName(), (Object)MAXSYMLINKS));
    }

    public static RemoteDirectory getCanonicalParent(RemoteFileObjectBase fo) throws IOException {
        RemoteFileObjectBase parent = fo.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof RemoteDirectory) {
            return (RemoteDirectory)parent;
        }
        RemoteLogger.assertTrueInConsole(parent instanceof RemoteLinkBase, "Unexpected parent class, should be RemoteLinkBase: " + parent.getClass().getName(), new Object[0]);
        RemoteFileObjectBase canonical = RemoteFileSystemUtils.getCanonicalFileObject(parent);
        if (canonical instanceof RemoteDirectory) {
            return (RemoteDirectory)canonical;
        }
        return null;
    }

    public static InputStream createDummyInputStream() {
        return new DummyInputStream();
    }

    public static boolean isFileNotFoundException(Throwable ex) {
        while (ex != null) {
            if (ex instanceof FileNotFoundException) {
                return true;
            }
            if (ex instanceof FileInfoProvider.SftpIOException) {
                switch (((FileInfoProvider.SftpIOException)ex).getId()) {
                    case 2: 
                    case 3: {
                        return true;
                    }
                }
            }
            ex = ex.getCause();
        }
        return false;
    }

    public static boolean getBoolean(String name, boolean result) {
        String text = System.getProperty(name);
        if (text != null) {
            result = Boolean.parseBoolean(text);
        }
        return result;
    }

    public static String getConnectExceptionMessage(ExecutionEnvironment env) {
        return NbBundle.getMessage(RemoteFileSystemUtils.class, (String)"NotConnectedExceptionMessage", (Object)env.getDisplayName());
    }

    public static boolean isUnitTestMode() {
        return Boolean.getBoolean("cnd.mode.unittest");
    }

    @SuppressWarnings(value={"NP"})
    public static Boolean isLinux(ExecutionEnvironment env) {
        if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
            try {
                HostInfo hi = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                return hi.getOSFamily() == HostInfo.OSFamily.LINUX;
            }
            catch (IOException | ConnectionManager.CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public static void deleteRecursively(File file) {
        if (file != null) {
            file.delete();
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    RemoteFileSystemUtils.deleteRecursively(child);
                }
            }
        }
    }

    public static FileObject copy(FileObject source, FileObject target, String name, String ext) throws IOException {
        ExecutionEnvironment env;
        if (source.isFolder() && FileUtil.isParentOf((FileObject)source, (FileObject)target)) {
            throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteFileSystemUtils.class, (String)"EXC_OperateChild", (Object)source.getPath(), (Object)target.getPath()));
        }
        String from = source.getPath();
        String newNameExt = RemoteFileObjectBase.composeName(name, ext);
        String newPath = target.getPath() + '/' + newNameExt;
        if (target instanceof RemoteFileObject && source instanceof RemoteFileObject && (env = ((RemoteFileObject)source).getExecutionEnvironment()).equals((Object)((RemoteFileObject)target).getExecutionEnvironment()) && RemoteFileSystemTransport.canCopy(env, from, newPath)) {
            try {
                ArrayList<IOException> subdirectoryExceptions = new ArrayList<IOException>();
                DirEntryList entries = RemoteFileSystemTransport.copy(env, from, newPath, subdirectoryExceptions);
                ((RemoteFileObject)target).getImplementor().postDeleteOrCreateChild(null, entries);
                FileObject fo = target.getFileObject(newNameExt);
                if (fo == null) {
                    throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteFileSystemUtils.class, (String)"EXC_NullFoAfterCopy", (Object)RemoteFileObjectBase.getDisplayName(env, newPath)));
                }
                FileUtil.copyAttributes((FileObject)source, (FileObject)fo);
                if (!subdirectoryExceptions.isEmpty()) {
                    throw (IOException)subdirectoryExceptions.get(0);
                }
                return fo;
            }
            catch (InterruptedException | CancellationException ex) {
                throw RemoteExceptions.createInterruptedIOException(ex.getLocalizedMessage(), ex);
            }
            catch (ExecutionException ex) {
                if (RemoteFileSystemUtils.isFileNotFoundException(ex)) {
                    throw RemoteExceptions.createFileNotFoundException(NbBundle.getMessage(RemoteFileSystemUtils.class, (String)"EXC_CantCopyFromTo", (Object)from, (Object)newPath, (Object)ex.getLocalizedMessage()), ex);
                }
                throw RemoteExceptions.createIOException(ex.getLocalizedMessage(), ex);
            }
        }
        if (source.isFolder()) {
            FileObject peer = target.createFolder(name);
            FileUtil.copyAttributes((FileObject)source, (FileObject)peer);
            for (FileObject fo : source.getChildren()) {
                fo.copy(peer, fo.getName(), fo.getExt());
            }
            return peer;
        }
        FileObject dest = RemoteFileSystemUtils.copyFileImpl(source, target, name, ext);
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileObject copyFileImpl(FileObject source, FileObject destFolder, String newName, String newExt) throws IOException {
        FileObject dest = destFolder.createData(newName, newExt);
        FileLock lock = null;
        InputStream bufIn = null;
        OutputStream bufOut = null;
        try {
            lock = dest.lock();
            bufIn = source.getInputStream();
            bufOut = dest.getOutputStream(lock);
            FileUtil.copy((InputStream)bufIn, (OutputStream)bufOut);
            FileUtil.copyAttributes((FileObject)source, (FileObject)dest);
        }
        finally {
            if (bufIn != null) {
                bufIn.close();
            }
            if (bufOut != null) {
                bufOut.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
        return dest;
    }

    static {
        boolean caseSenstive;
        MAXSYMLINKS = Integer.getInteger("remote.max.sym.links", 20);
        isWindows = Utilities.isWindows();
        windowsReservedChars = new char[][]{{'<', 'L'}, {'>', 'M'}, {':', 'C'}, {'\"', 'D'}, {'/', 'F'}, {'\\', 'B'}, {'|', 'P'}, {'?', 'Q'}, {'*', 'A'}};
        try {
            File tmpFile = File.createTempFile("CaseSensitiveFile", ".check");
            String absPath = tmpFile.getAbsolutePath();
            absPath = absPath.toUpperCase();
            caseSenstive = !new File(absPath).exists();
            tmpFile.delete();
        }
        catch (IOException ex) {
            caseSenstive = Utilities.isUnix() && !Utilities.isMac();
        }
        TRUE_CASE_SENSITIVE_SYSTEM = caseSenstive;
    }

    private static class DummyInputStream
    extends InputStream {
        private DummyInputStream() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }
}

