/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.refactoring.PositionBoundsResolver;
import org.netbeans.modules.web.refactoring.WebRefactoring;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public abstract class TldRefactoring
implements WebRefactoring {
    private static final Logger LOGGER = Logger.getLogger(TldRefactoring.class.getName());

    @Override
    public Problem preCheck() {
        return null;
    }

    protected List<TaglibHandle> getTaglibs(WebModule wm) {
        FileObject webInf = wm.getWebInf();
        if (webInf == null) {
            return Collections.emptyList();
        }
        ArrayList<TaglibHandle> result = new ArrayList<TaglibHandle>();
        Enumeration children = webInf.getChildren(true);
        while (children.hasMoreElements()) {
            FileObject child = (FileObject)children.nextElement();
            if (!this.isTld(child)) continue;
            Taglib taglib = null;
            try {
                taglib = this.getTaglib(child);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINE, "Failed to create Taglib graph for " + child, ioe);
            }
            result.add(new TaglibHandle(taglib, child));
        }
        return result;
    }

    private boolean isTld(FileObject fo) {
        return "tld".equalsIgnoreCase(fo.getExt());
    }

    private Taglib getTaglib(FileObject tld) throws IOException {
        DataObject tldData = null;
        try {
            tldData = DataObject.find((FileObject)tld);
        }
        catch (DataObjectNotFoundException dne) {
            Exceptions.printStackTrace((Throwable)dne);
        }
        Taglib result = null;
        if (tldData instanceof TLDDataObject) {
            result = ((TLDDataObject)tldData).getTaglib();
        }
        return result;
    }

    protected static abstract class TldRefactoringElement
    extends SimpleRefactoringElementImplementation {
        protected final Taglib taglib;
        protected final FileObject tldFile;
        protected final String clazz;

        public TldRefactoringElement(String clazz, Taglib taglib, FileObject tldFile) {
            this.clazz = clazz;
            this.taglib = taglib;
            this.tldFile = tldFile;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.tldFile;
        }

        public PositionBounds getPosition() {
            try {
                return new PositionBoundsResolver(DataObject.find((FileObject)this.tldFile), this.clazz).getPositionBounds();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        protected void write() {
            try {
                TLDDataObject tdo = (TLDDataObject)DataObject.find((FileObject)this.tldFile);
                if (tdo != null) {
                    tdo.write(this.taglib);
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    protected static class TaglibHandle {
        private final Taglib taglib;
        private final FileObject tldFile;
        private final boolean valid;

        private TaglibHandle(Taglib taglib, FileObject tldFile) {
            this.taglib = taglib;
            this.tldFile = tldFile;
            this.valid = taglib != null;
        }

        public Taglib getTaglib() {
            return this.taglib;
        }

        public FileObject getTldFile() {
            return this.tldFile;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

