/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring.safedelete;

import java.util.List;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.refactoring.RefactoringUtil;
import org.netbeans.modules.web.refactoring.TldRefactoring;
import org.netbeans.modules.web.taglib.model.TagType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class TldSafeDelete
extends TldRefactoring {
    private final List<String> classes;
    private final WebModule webModule;
    private final SafeDeleteRefactoring safeDelete;

    public TldSafeDelete(SafeDeleteRefactoring safeDelete, WebModule webModule) {
        this.safeDelete = safeDelete;
        this.webModule = webModule;
        this.classes = RefactoringUtil.getRefactoredClasses((AbstractRefactoring)safeDelete);
    }

    @Override
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        for (String clazz : this.classes) {
            for (TldRefactoring.TaglibHandle taglibHandle : this.getTaglibs(this.webModule)) {
                if (!taglibHandle.isValid()) {
                    problem = RefactoringUtil.addToEnd(new Problem(false, NbBundle.getMessage(TldSafeDelete.class, (String)"TXT_TldInvalidProblem", (Object)taglibHandle.getTldFile())), problem);
                    continue;
                }
                Taglib taglib = taglibHandle.getTaglib();
                for (TagType tagType : taglib.getTag()) {
                    if (!clazz.equals(tagType.getTagClass())) continue;
                    refactoringElements.add((AbstractRefactoring)this.safeDelete, (RefactoringElementImplementation)new TagClassSafeDeleteElement(clazz, taglib, taglibHandle.getTldFile(), tagType));
                }
            }
        }
        return problem;
    }

    private static class TagClassSafeDeleteElement
    extends TldRefactoring.TldRefactoringElement {
        private final TagType tagType;

        public TagClassSafeDeleteElement(String clazz, Taglib taglib, FileObject tldFile, TagType tagType) {
            super(clazz, taglib, tldFile);
            this.tagType = tagType;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(TldSafeDelete.class, (String)"TXT_TaglibTagClassSafeDelete", (Object)this.tagType.getName());
        }

        public void undoChange() {
            this.taglib.addTag(this.tagType);
            this.write();
        }

        public void performChange() {
            this.taglib.removeTag(this.tagType);
            this.write();
        }
    }
}

