/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProviderFactory;
import org.netbeans.modules.cnd.discovery.buildsupport.BuildProjectActionHandler;
import org.netbeans.modules.cnd.discovery.services.DiscoveryManagerImpl;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class BuildActionsProviderImpl
extends BuildActionsProvider {
    public List<BuildActionsProvider.BuildAction> getActions(String ioTabName, ProjectActionEvent[] events) {
        ArrayList<BuildActionsProvider.BuildAction> res = new ArrayList<BuildActionsProvider.BuildAction>();
        if (events != null && events.length == 2 && events[0].getType() == ProjectActionEvent.PredefinedType.CLEAN && events[1].getType() == ProjectActionEvent.PredefinedType.BUILD && events[1].getConfiguration() != null && events[1].getConfiguration().getConfigurationType().getValue() == 0) {
            res.add(new ConfigureAction(ioTabName, events));
        }
        return res;
    }

    public static final class ConfigureAction
    extends AbstractAction
    implements BuildActionsProvider.BuildAction,
    BuildActionsProvider.OutputStreamHandler {
        private final String ioTabName;
        private final ProjectActionEvent[] events;
        private int step = -1;
        private BufferedWriter bw;
        private BuildProjectActionHandler.ExecLogWrapper execLog;

        public ConfigureAction(String ioTabName, ProjectActionEvent[] events) {
            this.ioTabName = ioTabName;
            this.events = events;
        }

        @Override
        public Object getValue(String key) {
            if (key.equals("SmallIcon")) {
                return new ImageIcon(BuildActionsProviderImpl.class.getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/configure.png"));
            }
            if (key.equals("ShortDescription")) {
                return NbBundle.getMessage(BuildActionsProviderImpl.class, (String)"OUTPUT_LOG_ACTION_TEXT");
            }
            return super.getValue(key);
        }

        public void executionStarted(int pid) {
            this.setEnabled(false);
            if (this.step == 1) {
                try {
                    File file = File.createTempFile("build", ".log");
                    file.deleteOnExit();
                    if (this.execLog == null) {
                        this.execLog = new BuildProjectActionHandler.ExecLogWrapper(null, null);
                    }
                    this.execLog.setBuildLog(file.getAbsolutePath());
                    this.bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                }
                catch (IOException ex) {
                    this.execLog.setBuildLog(null);
                    this.bw = null;
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else if (this.step == 0) {
                this.execLog = null;
            }
        }

        public void executionFinished(int rc) {
            if (this.step == 1 && rc == 0 && this.execLog != null && this.execLog.getBuildLog() != null) {
                this.setEnabled(true);
            }
        }

        public void setStep(int step) {
            this.step = step;
        }

        public void setExecLog(BuildProjectActionHandler.ExecLogWrapper execLog) {
            this.execLog = execLog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            if (this.step >= 0 && this.step < this.events.length) {
                Project project = this.events[this.step].getProject();
                if (this.execLog.getBuildLog() != null) {
                    this.invokeWizard(project);
                    this.execLog = null;
                }
            }
        }

        public void handleLine(String line) {
            if (this.bw != null) {
                try {
                    this.bw.write(line);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void flush() {
            if (this.bw != null) {
                try {
                    this.bw.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void close() {
            if (this.bw != null) {
                try {
                    this.bw.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void invokeWizard(Project project) {
            DiscoveryProvider provider = null;
            if (this.execLog.getExecLog() != null) {
                provider = DiscoveryProviderFactory.findProvider("exec-log");
            }
            if (provider == null) {
                provider = DiscoveryProviderFactory.findProvider("make-log");
            }
            if (provider == null) {
                return;
            }
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)this.getString("OUTPUT_LOG_DILOG_COMTENT_TEXT"), this.getString("OUTPUT_LOG_DILOG_TITLE_TEXT"), 0)) != NotifyDescriptor.YES_OPTION) {
                return;
            }
            HashMap<String, Object> artifacts = new HashMap<String, Object>();
            artifacts.put("exec-log", this.execLog.getExecLog());
            artifacts.put("build-log", this.execLog.getBuildLog());
            DiscoveryManagerImpl.projectBuilt(project, artifacts, false);
        }

        private String getString(String key) {
            return NbBundle.getMessage(BuildActionsProviderImpl.class, (String)key);
        }
    }
}

