/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.makeproject.api.wizards.WizardConstants;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public class DiscoveryWizardDescriptor
extends WizardDescriptor
implements DiscoveryDescriptor {
    public static final WizardConstants.WizardConstant<String> ROOT_FOLDER = WizardConstants.DISCOVERY_ROOT_FOLDER;
    public static final WizardConstants.WizardConstant<String> BUILD_RESULT = WizardConstants.DISCOVERY_BUILD_RESULT;
    public static final WizardConstants.WizardConstant<FileSystem> FILE_SYSTEM = WizardConstants.DISCOVERY_BINARY_FILESYSTEM;
    public static final WizardConstants.WizardConstant<String> ADDITIONAL_LIBRARIES = WizardConstants.DISCOVERY_LIBRARIES;
    public static final WizardConstants.WizardConstant<String> COMPILER_NAME = WizardConstants.DISCOVERY_COMPILER;
    public static final WizardConstants.WizardConstant<List<String>> DEPENDENCIES = WizardConstants.DISCOVERY_BINARY_DEPENDENCIES;
    public static final WizardConstants.WizardConstant<List<String>> SEARCH_PATHS = WizardConstants.DISCOVERY_BINARY_SEARCH_PATH;
    public static final WizardConstants.WizardConstant<List<String>> ERRORS = WizardConstants.DISCOVERY_ERRORS;
    public static final WizardConstants.WizardConstant<Boolean> RESOLVE_SYMBOLIC_LINKS = WizardConstants.DISCOVERY_RESOLVE_LINKS;
    public static final WizardConstants.WizardConstant<Project> PROJECT = new WizardConstants.WizardConstant("DW:project");
    public static final WizardConstants.WizardConstant<DiscoveryProvider> PROVIDER = new WizardConstants.WizardConstant("DW:provider");
    public static final WizardConstants.WizardConstant<String> BUILD_FOLDER = new WizardConstants.WizardConstant("DW:buildFolder");
    public static final WizardConstants.WizardConstant<String> LOG_FILE = new WizardConstants.WizardConstant("DW:logFile");
    public static final WizardConstants.WizardConstant<String> EXEC_LOG_FILE = new WizardConstants.WizardConstant("DW:execLogFile");
    public static final WizardConstants.WizardConstant<List<ProjectConfiguration>> CONFIGURATIONS = new WizardConstants.WizardConstant("DW:configurations");
    public static final WizardConstants.WizardConstant<List<String>> INCLUDED = new WizardConstants.WizardConstant("DW:included");
    public static final WizardConstants.WizardConstant<Boolean> INVOKE_PROVIDER = new WizardConstants.WizardConstant("DW:invokeProvider");
    public static final WizardConstants.WizardConstant<List<String>> BUILD_ARTIFACTS = new WizardConstants.WizardConstant("DW:buildArtifacts");
    public static final WizardConstants.WizardConstant<Boolean> INCREMENTAL = new WizardConstants.WizardConstant("DW:incremental");
    private boolean stateChanged = true;
    private boolean cutResult = false;

    public DiscoveryWizardDescriptor(WizardDescriptor.Iterator panels) {
        super(panels);
    }

    public static DiscoveryDescriptor adaptee(Object wizard) {
        if (wizard instanceof DiscoveryDescriptor) {
            return (DiscoveryDescriptor)wizard;
        }
        if (wizard instanceof WizardDescriptor) {
            return new DiscoveryWizardDescriptorAdapter((WizardDescriptor)wizard);
        }
        if (wizard instanceof Map) {
            return new DiscoveryWizardClone((Map)wizard);
        }
        return null;
    }

    @Override
    public Project getProject() {
        return (Project)this.getProperty(PROJECT.key());
    }

    @Override
    public void setProject(Project project) {
        this.putProperty(PROJECT.key(), project);
    }

    @Override
    public String getRootFolder() {
        return (String)this.getProperty(ROOT_FOLDER.key());
    }

    @Override
    public void setRootFolder(String root) {
        this.stateChanged = true;
        if (root != null && Utilities.isWindows()) {
            root = root.replace('\\', '/');
        }
        this.putProperty(ROOT_FOLDER.key(), root);
    }

    @Override
    public List<String> getErrors() {
        return (List)this.getProperty(ERRORS.key());
    }

    @Override
    public void setErrors(List<String> errors) {
        this.stateChanged = true;
        this.putProperty(ERRORS.key(), errors);
    }

    @Override
    public String getBuildResult() {
        return (String)this.getProperty(BUILD_RESULT.key());
    }

    @Override
    public void setBuildResult(String binaryPath) {
        this.putProperty(BUILD_RESULT.key(), binaryPath);
    }

    @Override
    public String getBuildFolder() {
        return (String)this.getProperty(BUILD_FOLDER.key());
    }

    @Override
    public void setBuildFolder(String buildPath) {
        this.putProperty(BUILD_FOLDER.key(), buildPath);
    }

    @Override
    public FileSystem getFileSystem() {
        return (FileSystem)this.getProperty(FILE_SYSTEM.key());
    }

    @Override
    public void setFileSystem(FileSystem fs) {
        this.putProperty(FILE_SYSTEM.key(), fs);
    }

    @Override
    public String getAditionalLibraries() {
        return (String)this.getProperty(ADDITIONAL_LIBRARIES.key());
    }

    @Override
    public void setAditionalLibraries(String binaryPath) {
        this.putProperty(ADDITIONAL_LIBRARIES.key(), binaryPath);
    }

    @Override
    public String getBuildLog() {
        return (String)this.getProperty(LOG_FILE.key());
    }

    @Override
    public void setBuildLog(String logFile) {
        this.putProperty(LOG_FILE.key(), logFile);
    }

    @Override
    public String getExecLog() {
        return (String)this.getProperty(EXEC_LOG_FILE.key());
    }

    @Override
    public void setExecLog(String logFile) {
        this.putProperty(EXEC_LOG_FILE.key(), logFile);
    }

    @Override
    public DiscoveryProvider getProvider() {
        return (DiscoveryProvider)this.getProperty(PROVIDER.key());
    }

    @Override
    public String getProviderID() {
        DiscoveryProvider provider = (DiscoveryProvider)this.getProperty(PROVIDER.key());
        if (provider != null) {
            return provider.getID();
        }
        return null;
    }

    @Override
    public void setProvider(DiscoveryProvider provider) {
        this.stateChanged = true;
        this.putProperty(PROVIDER.key(), provider);
    }

    @Override
    public List<ProjectConfiguration> getConfigurations() {
        return (List)this.getProperty(CONFIGURATIONS.key());
    }

    @Override
    public void setConfigurations(List<ProjectConfiguration> configuration) {
        this.putProperty(CONFIGURATIONS.key(), configuration);
    }

    @Override
    public List<String> getIncludedFiles() {
        return (List)this.getProperty(INCLUDED.key());
    }

    @Override
    public void setIncludedFiles(List<String> includedFiles) {
        this.putProperty(INCLUDED.key(), includedFiles);
    }

    @Override
    public boolean isInvokeProvider() {
        return this.stateChanged;
    }

    @Override
    public void setInvokeProvider(boolean invoke) {
        this.stateChanged = invoke;
    }

    @Override
    public void setMessage(String message) {
        this.putProperty("WizardPanel_errorMessage", message);
    }

    @Override
    public void clean() {
        this.setProject(null);
        this.setProvider(null);
        this.setRootFolder(null);
        this.setBuildResult(null);
        this.setAditionalLibraries(null);
        this.setConfigurations(null);
        this.setIncludedFiles(null);
    }

    public boolean isCutResult() {
        return this.cutResult;
    }

    public void setCutResult(boolean cutResult) {
        this.cutResult = cutResult;
    }

    @Override
    public String getCompilerName() {
        return (String)this.getProperty(COMPILER_NAME.key());
    }

    @Override
    public void setCompilerName(String compiler) {
        this.putProperty(COMPILER_NAME.key(), compiler);
    }

    @Override
    public List<String> getDependencies() {
        return (List)this.getProperty(DEPENDENCIES.key());
    }

    @Override
    public void setDependencies(List<String> dependencies) {
        this.putProperty(DEPENDENCIES.key(), dependencies);
    }

    @Override
    public List<String> getBuildArtifacts() {
        return (List)this.getProperty(BUILD_ARTIFACTS.key());
    }

    @Override
    public void setBuildArtifacts(List<String> buildArtifacts) {
        this.putProperty(BUILD_ARTIFACTS.key(), buildArtifacts);
    }

    @Override
    public List<String> getSearchPaths() {
        return (List)this.getProperty(SEARCH_PATHS.key());
    }

    @Override
    public void setSearchPaths(List<String> searchPaths) {
        this.putProperty(SEARCH_PATHS.key(), searchPaths);
    }

    @Override
    public boolean isIncrementalMode() {
        return Boolean.TRUE.equals(this.getProperty(INCREMENTAL.key()));
    }

    @Override
    public void setIncrementalMode(boolean incremental) {
        this.putProperty(INCREMENTAL.key(), incremental);
    }

    @Override
    public boolean isResolveSymbolicLinks() {
        return Boolean.TRUE.equals(this.getProperty(RESOLVE_SYMBOLIC_LINKS.key()));
    }

    @Override
    public void setResolveSymbolicLinks(boolean resolveSymbolicLinks) {
        this.putProperty(RESOLVE_SYMBOLIC_LINKS.key(), resolveSymbolicLinks);
    }

    private static class DiscoveryWizardClone
    implements DiscoveryDescriptor {
        private final Map<String, Object> map;

        public DiscoveryWizardClone(Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public Project getProject() {
            return (Project)PROJECT.fromMap(this.map);
        }

        @Override
        public void setProject(Project project) {
            PROJECT.toMap(this.map, (Object)project);
        }

        @Override
        public String getRootFolder() {
            String root = (String)ROOT_FOLDER.fromMap(this.map);
            if (root == null && (root = (String)WizardConstants.PROPERTY_WORKING_DIR.fromMap(this.map)) != null && Utilities.isWindows()) {
                root = root.replace('\\', '/');
            }
            return root;
        }

        @Override
        public void setRootFolder(String root) {
            INVOKE_PROVIDER.toMap(this.map, (Object)Boolean.TRUE);
            if (root != null && Utilities.isWindows()) {
                root = root.replace('\\', '/');
            }
            ROOT_FOLDER.toMap(this.map, (Object)root);
        }

        @Override
        public List<String> getErrors() {
            return (List)ERRORS.fromMap(this.map);
        }

        @Override
        public void setErrors(List<String> errors) {
            ERRORS.toMap(this.map, errors);
        }

        @Override
        public String getBuildResult() {
            return (String)BUILD_RESULT.fromMap(this.map);
        }

        @Override
        public void setBuildResult(String binaryPath) {
            BUILD_RESULT.toMap(this.map, (Object)binaryPath);
        }

        @Override
        public String getBuildFolder() {
            return (String)BUILD_FOLDER.fromMap(this.map);
        }

        @Override
        public void setBuildFolder(String buildPath) {
            BUILD_FOLDER.toMap(this.map, (Object)buildPath);
        }

        @Override
        public FileSystem getFileSystem() {
            return (FileSystem)FILE_SYSTEM.fromMap(this.map);
        }

        @Override
        public void setFileSystem(FileSystem fs) {
            FILE_SYSTEM.toMap(this.map, (Object)fs);
        }

        @Override
        public String getAditionalLibraries() {
            return (String)ADDITIONAL_LIBRARIES.fromMap(this.map);
        }

        @Override
        public void setAditionalLibraries(String binaryPath) {
            ADDITIONAL_LIBRARIES.toMap(this.map, (Object)binaryPath);
        }

        @Override
        public String getBuildLog() {
            return (String)LOG_FILE.fromMap(this.map);
        }

        @Override
        public void setBuildLog(String logFile) {
            LOG_FILE.toMap(this.map, (Object)logFile);
        }

        @Override
        public String getExecLog() {
            return (String)EXEC_LOG_FILE.fromMap(this.map);
        }

        @Override
        public void setExecLog(String logFile) {
            EXEC_LOG_FILE.toMap(this.map, (Object)logFile);
        }

        @Override
        public DiscoveryProvider getProvider() {
            return (DiscoveryProvider)PROVIDER.fromMap(this.map);
        }

        @Override
        public String getProviderID() {
            DiscoveryProvider provider = (DiscoveryProvider)PROVIDER.fromMap(this.map);
            if (provider != null) {
                return provider.getID();
            }
            return null;
        }

        @Override
        public void setProvider(DiscoveryProvider provider) {
            INVOKE_PROVIDER.toMap(this.map, (Object)Boolean.TRUE);
            PROVIDER.toMap(this.map, (Object)provider);
        }

        @Override
        public List<ProjectConfiguration> getConfigurations() {
            return (List)CONFIGURATIONS.fromMap(this.map);
        }

        @Override
        public void setConfigurations(List<ProjectConfiguration> configuration) {
            CONFIGURATIONS.toMap(this.map, configuration);
        }

        @Override
        public List<String> getIncludedFiles() {
            return (List)INCLUDED.fromMap(this.map);
        }

        @Override
        public void setIncludedFiles(List<String> includedFiles) {
            INCLUDED.toMap(this.map, includedFiles);
        }

        @Override
        public boolean isInvokeProvider() {
            Boolean res = (Boolean)INVOKE_PROVIDER.fromMap(this.map);
            if (res == null) {
                return true;
            }
            return res;
        }

        @Override
        public void setInvokeProvider(boolean invoke) {
            INVOKE_PROVIDER.toMap(this.map, (Object)invoke);
        }

        public boolean isCutResult() {
            return false;
        }

        public void setCutResult(boolean cutResult) {
        }

        @Override
        public void setMessage(String message) {
            this.map.put("WizardPanel_errorMessage", message);
        }

        @Override
        public void clean() {
            this.setProject(null);
            this.setProvider(null);
            this.setRootFolder(null);
            this.setBuildResult(null);
            this.setAditionalLibraries(null);
            this.setBuildLog(null);
            this.setConfigurations(null);
            this.setIncludedFiles(null);
        }

        @Override
        public String getCompilerName() {
            return (String)COMPILER_NAME.fromMap(this.map);
        }

        @Override
        public void setCompilerName(String compiler) {
            COMPILER_NAME.toMap(this.map, (Object)compiler);
        }

        @Override
        public List<String> getDependencies() {
            return (List)DEPENDENCIES.fromMap(this.map);
        }

        @Override
        public void setDependencies(List<String> dependencies) {
            DEPENDENCIES.toMap(this.map, dependencies);
        }

        @Override
        public List<String> getBuildArtifacts() {
            return (List)BUILD_ARTIFACTS.fromMap(this.map);
        }

        @Override
        public void setBuildArtifacts(List<String> buildArtifacts) {
            BUILD_ARTIFACTS.toMap(this.map, buildArtifacts);
        }

        @Override
        public List<String> getSearchPaths() {
            return (List)SEARCH_PATHS.fromMap(this.map);
        }

        @Override
        public void setSearchPaths(List<String> searchPaths) {
            SEARCH_PATHS.toMap(this.map, searchPaths);
        }

        @Override
        public boolean isIncrementalMode() {
            return Boolean.TRUE.equals(INCREMENTAL.fromMap(this.map));
        }

        @Override
        public void setIncrementalMode(boolean incremental) {
            INCREMENTAL.toMap(this.map, (Object)incremental);
        }

        @Override
        public boolean isResolveSymbolicLinks() {
            return Boolean.TRUE.equals(RESOLVE_SYMBOLIC_LINKS.fromMap(this.map));
        }

        @Override
        public void setResolveSymbolicLinks(boolean resolveSymbolicLinks) {
            RESOLVE_SYMBOLIC_LINKS.toMap(this.map, (Object)resolveSymbolicLinks);
        }
    }

    private static class DiscoveryWizardDescriptorAdapter
    implements DiscoveryDescriptor {
        private final WizardDescriptor wizard;

        public DiscoveryWizardDescriptorAdapter(WizardDescriptor wizard) {
            this.wizard = wizard;
        }

        @Override
        public Project getProject() {
            return (Project)PROJECT.get(this.wizard);
        }

        @Override
        public void setProject(Project project) {
            PROJECT.put(this.wizard, (Object)project);
        }

        @Override
        public String getRootFolder() {
            String root = (String)ROOT_FOLDER.get(this.wizard);
            if (root == null && (root = (String)WizardConstants.PROPERTY_WORKING_DIR.get(this.wizard)) != null && Utilities.isWindows()) {
                root = root.replace('\\', '/');
            }
            return root;
        }

        @Override
        public void setRootFolder(String root) {
            this.wizard.putProperty(INVOKE_PROVIDER.key(), (Object)Boolean.TRUE);
            if (root != null && Utilities.isWindows()) {
                root = root.replace('\\', '/');
            }
            ROOT_FOLDER.put(this.wizard, (Object)root);
        }

        @Override
        public List<String> getErrors() {
            return (List)ERRORS.get(this.wizard);
        }

        @Override
        public void setErrors(List<String> errors) {
            ERRORS.put(this.wizard, errors);
        }

        @Override
        public String getBuildResult() {
            return (String)BUILD_RESULT.get(this.wizard);
        }

        @Override
        public void setBuildResult(String binaryPath) {
            BUILD_RESULT.put(this.wizard, (Object)binaryPath);
        }

        @Override
        public String getBuildFolder() {
            return (String)BUILD_FOLDER.get(this.wizard);
        }

        @Override
        public void setBuildFolder(String buildPath) {
            BUILD_FOLDER.put(this.wizard, (Object)buildPath);
        }

        @Override
        public FileSystem getFileSystem() {
            return (FileSystem)FILE_SYSTEM.get(this.wizard);
        }

        @Override
        public void setFileSystem(FileSystem fs) {
            FILE_SYSTEM.put(this.wizard, (Object)fs);
        }

        @Override
        public String getAditionalLibraries() {
            return (String)ADDITIONAL_LIBRARIES.get(this.wizard);
        }

        @Override
        public void setAditionalLibraries(String binaryPath) {
            ADDITIONAL_LIBRARIES.put(this.wizard, (Object)binaryPath);
        }

        @Override
        public String getBuildLog() {
            return (String)LOG_FILE.get(this.wizard);
        }

        @Override
        public void setBuildLog(String logFile) {
            LOG_FILE.put(this.wizard, (Object)logFile);
        }

        @Override
        public String getExecLog() {
            return (String)EXEC_LOG_FILE.get(this.wizard);
        }

        @Override
        public void setExecLog(String logFile) {
            EXEC_LOG_FILE.put(this.wizard, (Object)logFile);
        }

        @Override
        public DiscoveryProvider getProvider() {
            return (DiscoveryProvider)PROVIDER.get(this.wizard);
        }

        @Override
        public String getProviderID() {
            DiscoveryProvider provider = (DiscoveryProvider)PROVIDER.get(this.wizard);
            if (provider != null) {
                return provider.getID();
            }
            return null;
        }

        @Override
        public void setProvider(DiscoveryProvider provider) {
            INVOKE_PROVIDER.put(this.wizard, (Object)Boolean.TRUE);
            PROVIDER.put(this.wizard, (Object)provider);
        }

        @Override
        public List<ProjectConfiguration> getConfigurations() {
            return (List)CONFIGURATIONS.get(this.wizard);
        }

        @Override
        public void setConfigurations(List<ProjectConfiguration> configuration) {
            CONFIGURATIONS.put(this.wizard, configuration);
        }

        @Override
        public List<String> getIncludedFiles() {
            return (List)INCLUDED.get(this.wizard);
        }

        @Override
        public void setIncludedFiles(List<String> includedFiles) {
            INCLUDED.put(this.wizard, includedFiles);
        }

        @Override
        public boolean isInvokeProvider() {
            Boolean res = (Boolean)INVOKE_PROVIDER.get(this.wizard);
            if (res == null) {
                return true;
            }
            return res;
        }

        @Override
        public void setInvokeProvider(boolean invoke) {
            INVOKE_PROVIDER.put(this.wizard, (Object)invoke);
        }

        public boolean isCutResult() {
            return false;
        }

        public void setCutResult(boolean cutResult) {
        }

        @Override
        public void setMessage(String message) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)message);
        }

        @Override
        public void clean() {
            this.setProject(null);
            this.setProvider(null);
            this.setRootFolder(null);
            this.setBuildResult(null);
            this.setAditionalLibraries(null);
            this.setBuildLog(null);
            this.setConfigurations(null);
            this.setIncludedFiles(null);
        }

        @Override
        public String getCompilerName() {
            return (String)COMPILER_NAME.get(this.wizard);
        }

        @Override
        public void setCompilerName(String compiler) {
            COMPILER_NAME.put(this.wizard, (Object)compiler);
        }

        @Override
        public List<String> getDependencies() {
            return (List)DEPENDENCIES.get(this.wizard);
        }

        @Override
        public void setDependencies(List<String> dependencies) {
            DEPENDENCIES.put(this.wizard, dependencies);
        }

        @Override
        public List<String> getBuildArtifacts() {
            return (List)BUILD_ARTIFACTS.get(this.wizard);
        }

        @Override
        public void setBuildArtifacts(List<String> buildArtifacts) {
            BUILD_ARTIFACTS.put(this.wizard, buildArtifacts);
        }

        @Override
        public List<String> getSearchPaths() {
            return (List)SEARCH_PATHS.get(this.wizard);
        }

        @Override
        public void setSearchPaths(List<String> searchPaths) {
            SEARCH_PATHS.put(this.wizard, searchPaths);
        }

        @Override
        public boolean isIncrementalMode() {
            return Boolean.TRUE.equals(INCREMENTAL.get(this.wizard));
        }

        @Override
        public void setIncrementalMode(boolean incremental) {
            INCREMENTAL.put(this.wizard, (Object)incremental);
        }

        @Override
        public boolean isResolveSymbolicLinks() {
            return Boolean.TRUE.equals(RESOLVE_SYMBOLIC_LINKS.get(this.wizard));
        }

        @Override
        public void setResolveSymbolicLinks(boolean resolveSymbolicLinks) {
            RESOLVE_SYMBOLIC_LINKS.put(this.wizard, (Object)resolveSymbolicLinks);
        }
    }
}

