/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProviderFactory;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.ProviderPropertyType;
import org.netbeans.modules.cnd.discovery.wizard.SelectProviderWizard;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.ui.EditableComboBox;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class SelectProviderPanel
extends JPanel
implements CsmProgressListener {
    private static final boolean SHOW_RESTRICT = Boolean.getBoolean("cnd.discovery.wizard.restrictSources");
    private final SelectProviderWizard wizard;
    public static final boolean USE_PROJECT_PROPERTIES = true;
    private static final String ROOT_PROPERTY_KEY = "rootFolder";
    private JPanel alertPanel;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JLabel jLabel1;
    private JLabel labelForProviders;
    private JLabel labelForRoot;
    private JComboBox prividersComboBox;
    private JCheckBox restrictCompile;
    private JCheckBox restrictSources;
    private JComboBox rootFolder;
    private JButton rootFolderButton;

    public SelectProviderPanel(SelectProviderWizard wizard) {
        this.wizard = wizard;
        this.initComponents();
        if (!SHOW_RESTRICT) {
            this.restrictSources.setVisible(false);
            this.restrictCompile.setVisible(false);
        }
        this.addListeners();
    }

    private void addListeners() {
        ((EditableComboBox)this.rootFolder).addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectProviderPanel.this.update();
            }
        });
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this);
    }

    private void initComponents() {
        this.labelForRoot = new JLabel();
        this.rootFolder = new EditableComboBox();
        this.rootFolderButton = new JButton();
        this.labelForProviders = new JLabel();
        this.prividersComboBox = new JComboBox();
        this.restrictSources = new JCheckBox();
        this.restrictCompile = new JCheckBox();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.alertPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new GridBagLayout());
        this.labelForRoot.setLabelFor(this.rootFolder);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.labelForRoot, (String)bundle.getString("ProjectRootFolder"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.labelForRoot, gridBagConstraints);
        this.rootFolder.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.rootFolder, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.rootFolderButton, (String)bundle.getString("ROOT_DIR_BROWSE_BUTTON_TXT"));
        this.rootFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectProviderPanel.this.rootFolderButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.rootFolderButton, gridBagConstraints);
        this.labelForProviders.setLabelFor(this.prividersComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelForProviders, (String)bundle.getString("SelectDiscoveryProviderText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.labelForProviders, gridBagConstraints);
        this.prividersComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SelectProviderPanel.this.providersComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.prividersComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.restrictSources, (String)NbBundle.getMessage(SelectProviderPanel.class, (String)"RestrictSourcesText"));
        this.restrictSources.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.restrictSources, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.restrictCompile, (String)NbBundle.getMessage(SelectProviderPanel.class, (String)"RESTRICT_COMPILE_PATH"));
        this.restrictCompile.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.restrictCompile, gridBagConstraints);
        this.instructionPanel.setEnabled(false);
        this.instructionPanel.setFocusable(false);
        this.instructionPanel.setRequestFocusEnabled(false);
        this.instructionPanel.setVerifyInputWhenFocusTarget(false);
        this.instructionPanel.setLayout(new BorderLayout());
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        this.instructionsTextArea.setOpaque(false);
        this.instructionPanel.add((Component)this.instructionsTextArea, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.alertPanel.setLayout(new BorderLayout());
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/info.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SelectProviderPanel.class, (String)"selectedAdvancedLabel"));
        this.alertPanel.add((Component)this.jLabel1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.alertPanel, gridBagConstraints);
    }

    private void providersComboBoxItemStateChanged(ItemEvent evt) {
        Object item = evt.getItem();
        if (item instanceof ProviderItem) {
            ProviderItem provider = (ProviderItem)item;
            this.instructionsTextArea.setText(provider.getDescription());
            this.wizard.stateChanged(null);
            if ("make-log".equals(provider.getID())) {
                this.restrictCompile.setSelected(true);
            } else {
                this.restrictCompile.setSelected(false);
            }
        }
    }

    private void update() {
        this.wizard.stateChanged(null);
    }

    private void rootFolderButtonActionPerformed(ActionEvent evt) {
        FileObject projectDirectory = this.wizard.getWizardDescriptor().getProject().getProjectDirectory();
        ExecutionEnvironment execEnv = FileSystemProvider.getExecutionEnvironment((FileObject)projectDirectory);
        JFileChooser fileChooser = RemoteFileUtil.createFileChooser((ExecutionEnvironment)execEnv, (String)this.getString("ROOT_DIR_CHOOSER_TITLE_TXT", new String[0]), (String)this.getString("ROOT_DIR_BUTTON_TXT", new String[0]), (int)1, null, (String)this.getRootText(), (boolean)false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        this.rootFolder.setSelectedItem(path);
    }

    void read(final DiscoveryDescriptor wizardDescriptor) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.prividersComboBox.getModel();
        model.removeAllElements();
        ProjectProxy proxy = new ProjectProxy(){

            @Override
            public boolean createSubProjects() {
                return false;
            }

            @Override
            public Project getProject() {
                return wizardDescriptor.getProject();
            }

            @Override
            public String getMakefile() {
                return null;
            }

            @Override
            public String getSourceRoot() {
                return wizardDescriptor.getRootFolder();
            }

            @Override
            public String getExecutable() {
                return wizardDescriptor.getBuildResult();
            }

            @Override
            public String getWorkingFolder() {
                return null;
            }

            @Override
            public boolean mergeProjectProperties() {
                return false;
            }

            @Override
            public boolean resolveSymbolicLinks() {
                return wizardDescriptor.isResolveSymbolicLinks();
            }
        };
        DiscoveryProvider defProvider = (DiscoveryProvider)((WizardDescriptor)wizardDescriptor).getProperty("PreferedProvider");
        ProviderItem def = null;
        ArrayList<ProviderItem> list = new ArrayList<ProviderItem>();
        for (DiscoveryProvider provider : DiscoveryProviderFactory.findAllProviders()) {
            if (!provider.isApplicable(proxy)) continue;
            ProviderItem providerItem = new ProviderItem(provider);
            if (defProvider != null && defProvider.getID().equals(provider.getID())) {
                def = providerItem;
            }
            list.add(providerItem);
        }
        Collections.sort(list);
        for (ProviderItem item : list) {
            model.addElement(item);
        }
        if (def != null) {
            this.prividersComboBox.setSelectedItem(def);
        }
        String path = wizardDescriptor.getRootFolder();
        try {
            FileSystem fileSystem = this.wizard.getWizardDescriptor().getProject().getProjectDirectory().getFileSystem();
            if (CndFileUtils.isLocalFileSystem((FileSystem)fileSystem) && Utilities.isWindows()) {
                path = path.replace('/', CndFileUtils.getFileSeparatorChar((FileSystem)fileSystem));
            }
        }
        catch (FileStateInvalidException ex) {
            // empty catch block
        }
        Preferences preferences = ProjectUtils.getPreferences((Project)wizardDescriptor.getProject(), SelectProviderPanel.class, (boolean)false);
        ((EditableComboBox)this.rootFolder).setStorage(ROOT_PROPERTY_KEY, preferences);
        ((EditableComboBox)this.rootFolder).read(path);
    }

    private String getRootText() {
        Component component;
        ComboBoxEditor editor = this.rootFolder.getEditor();
        if (editor != null && (component = editor.getEditorComponent()) instanceof JTextField) {
            return ((JTextField)component).getText();
        }
        if (this.rootFolder.getSelectedItem() != null) {
            return this.rootFolder.getSelectedItem().toString();
        }
        return null;
    }

    void store(DiscoveryDescriptor wizardDescriptor) {
        ProviderItem provider = (ProviderItem)this.prividersComboBox.getSelectedItem();
        wizardDescriptor.setProvider(provider.getProvider());
        wizardDescriptor.setRootFolder(this.getRootText());
        Preferences preferences = ProjectUtils.getPreferences((Project)wizardDescriptor.getProject(), SelectProviderPanel.class, (boolean)false);
        ((EditableComboBox)this.rootFolder).setStorage(ROOT_PROPERTY_KEY, preferences);
        ((EditableComboBox)this.rootFolder).store();
        ProviderProperty p = provider.getProvider().getProperty(ProviderPropertyType.RestrictSourceRootPropertyType.key());
        if (p != null) {
            if (this.restrictSources.isSelected()) {
                ProviderPropertyType.RestrictSourceRootPropertyType.setProperty(provider.getProvider(), this.getRootText());
            } else {
                ProviderPropertyType.RestrictSourceRootPropertyType.setProperty(provider.getProvider(), "");
            }
        }
        if ((p = provider.getProvider().getProperty(ProviderPropertyType.RestrictCompileRootPropertyType.key())) != null) {
            if (this.restrictCompile.isSelected()) {
                ProviderPropertyType.RestrictCompileRootPropertyType.setProperty(provider.getProvider(), this.getRootText());
            } else {
                ProviderPropertyType.RestrictCompileRootPropertyType.setProperty(provider.getProvider(), "");
            }
        }
    }

    boolean valid(DiscoveryDescriptor wizardDescriptor) {
        FSPath file;
        wizardDescriptor.setMessage(null);
        String path = this.getRootText();
        if (path == null) {
            wizardDescriptor.setMessage(this.getString("SelectModeRootFolderError", path));
            return false;
        }
        try {
            file = new FSPath(this.wizard.getWizardDescriptor().getProject().getProjectDirectory().getFileSystem(), path);
        }
        catch (FileStateInvalidException ex) {
            wizardDescriptor.setMessage(this.getString("SelectModeRootFolderError", path));
            return false;
        }
        FileObject fo = file.getFileObject();
        if (fo == null || !fo.isValid() || !fo.isFolder()) {
            wizardDescriptor.setMessage(this.getString("SelectModeRootFolderError", path));
            return false;
        }
        ProviderItem provider = (ProviderItem)this.prividersComboBox.getSelectedItem();
        if ("model-folder".equals(provider.getID())) {
            CsmProject langProject;
            Project project = wizardDescriptor.getProject();
            if (project != null && (langProject = CsmModelAccessor.getModel().getProject((Object)project)) != null && langProject.isStable(null)) {
                return true;
            }
            wizardDescriptor.setMessage(this.getString("ModelNotFinishParsing", new String[0]));
            return false;
        }
        return true;
    }

    void showAlert(DiscoveryDescriptor wizardDescriptor) {
        Object o = ((WizardDescriptor)wizardDescriptor).getProperty("ShowAlert");
        this.alertPanel.setVisible(Boolean.TRUE.equals(o));
    }

    private String getString(String key, String ... params) {
        return NbBundle.getMessage(SelectProviderPanel.class, (String)key, (Object[])params);
    }

    public void projectParsingStarted(CsmProject project) {
    }

    public void projectFilesCounted(CsmProject project, int filesCount) {
    }

    public void projectParsingFinished(CsmProject project) {
        this.wizard.stateChanged(null);
    }

    public void projectLoaded(CsmProject project) {
        this.wizard.stateChanged(null);
    }

    public void projectParsingCancelled(CsmProject project) {
    }

    public void fileInvalidated(CsmFile file) {
    }

    public void fileAddedToParse(CsmFile file) {
    }

    public void fileParsingStarted(CsmFile file) {
    }

    public void fileParsingFinished(CsmFile file) {
    }

    public void parserIdle() {
    }

    public void fileRemoved(CsmFile file) {
    }

    static class ProviderItem
    implements Comparable<ProviderItem> {
        private final DiscoveryProvider provider;

        ProviderItem(DiscoveryProvider provider) {
            this.provider = provider;
        }

        public String toString() {
            return this.provider.getName();
        }

        public String getID() {
            return this.provider.getID();
        }

        public String getDescription() {
            return this.provider.getDescription();
        }

        public DiscoveryProvider getProvider() {
            return this.provider;
        }

        @Override
        public int compareTo(ProviderItem o) {
            return this.toString().compareTo(o.toString());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ProviderItem)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

