/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.support.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.buildsupport.CompileSupport;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.FileConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.discovery.wizard.checkedtree.AbstractRoot;
import org.netbeans.modules.cnd.discovery.wizard.checkedtree.UnusedFactory;
import org.netbeans.modules.cnd.discovery.wizard.support.impl.MacroMap;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DiscoveryProjectGeneratorImpl {
    private static final boolean DEBUG = Boolean.getBoolean("cnd.discovery.trace.project_update");
    private static final boolean TRUNCATE_BEGINNING_PATH = true;
    private final ProjectBridge projectBridge;
    private final DiscoveryDescriptor wizard;
    private final String baseFolder;

    public DiscoveryProjectGeneratorImpl(DiscoveryDescriptor wizard) throws IOException {
        this.wizard = wizard;
        this.baseFolder = wizard.getRootFolder();
        Project project = wizard.getProject();
        this.projectBridge = project != null ? new ProjectBridge(project) : new ProjectBridge(this.baseFolder);
    }

    private void storeCompileLines(List<ProjectConfiguration> projectConfigurations) {
        MakeConfiguration activeConfiguration;
        MakeConfigurationDescriptor makeConfigurationDescriptor;
        ConfigurationDescriptorProvider pdp;
        Project project = this.wizard.getProject();
        if (project != null && (pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class)) != null && (makeConfigurationDescriptor = pdp.getConfigurationDescriptor()) != null && (activeConfiguration = makeConfigurationDescriptor.getActiveConfiguration()) != null) {
            ArrayList<FileConfiguration> confs = new ArrayList<FileConfiguration>();
            for (ProjectConfiguration config : projectConfigurations) {
                confs.addAll(config.getFiles());
            }
            final Iterator iterator = confs.iterator();
            CompileSupport support = new CompileSupport();
            Iterator<String> it = new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public String next() {
                    FileConfiguration next = (FileConfiguration)iterator.next();
                    if (next.getCompileLine() != null) {
                        return next.getFilePath() + "=" + next.getCompilePath() + "#" + next.getCompileLine();
                    }
                    return "";
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            support.putOptions(makeConfigurationDescriptor, activeConfiguration, it);
        }
    }

    public void process() {
        List<ProjectConfiguration> projectConfigurations = this.wizard.getConfigurations();
        Folder sourceRoot = this.projectBridge.getRoot();
        this.createFolderStructure(projectConfigurations, sourceRoot);
        HashSet<Item> used = new HashSet<Item>();
        for (ProjectConfiguration config : projectConfigurations) {
            this.setupCompilerConfiguration(config);
            this.addConfiguration(sourceRoot, config, used);
        }
        this.addAdditional(sourceRoot, this.baseFolder, used);
        this.packRoot(sourceRoot);
        this.upConfiguration(sourceRoot, ItemProperties.LanguageKind.CPP);
        this.upConfiguration(sourceRoot, ItemProperties.LanguageKind.C);
        this.downConfiguration(sourceRoot, ItemProperties.LanguageKind.CPP);
        this.downConfiguration(sourceRoot, ItemProperties.LanguageKind.C);
        this.projectBridge.printStaticstic(sourceRoot, ImportProject.logger);
        this.storeCompileLines(projectConfigurations);
        this.projectBridge.save();
        this.projectBridge.dispose();
    }

    private void packRoot(Folder root) {
        for (Object item : root.getElements()) {
            if (item instanceof Folder) continue;
            return;
        }
        HashMap<Folder, Folder> res = new HashMap<Folder, Folder>();
        for (Folder folder : root.getFolders()) {
            if (folder.getKind() == Folder.Kind.IMPORTANT_FILES_FOLDER) {
                res.put(folder, folder);
                continue;
            }
            if (folder.isDiskFolder()) {
                res.put(folder, folder);
                continue;
            }
            Folder packFolder = this.packFolder(folder);
            res.put(folder, packFolder);
        }
        boolean isFullNames = false;
        for (int i = 0; i < 3; ++i) {
            isFullNames = false;
            HashMap names = new HashMap();
            for (Map.Entry entry : res.entrySet()) {
                String folderName = ((Folder)entry.getValue()).getName();
                ArrayList list = (ArrayList)names.get(folderName);
                if (list == null) {
                    list = new ArrayList();
                    names.put(folderName, list);
                }
                list.add(entry);
                if (list.size() <= 1) continue;
                isFullNames = true;
            }
            if (!isFullNames) break;
            for (Map.Entry entry : names.entrySet()) {
                if (((List)entry.getValue()).size() <= 1) continue;
                for (Map.Entry e : (List)entry.getValue()) {
                    Folder beg = (Folder)e.getKey();
                    Folder end = (Folder)e.getValue();
                    Folder up = end.getParent();
                    if (up != null && up != beg) {
                        res.put(beg, up);
                        continue;
                    }
                    return;
                }
            }
        }
        if (isFullNames) {
            return;
        }
        List elements = root.getElements();
        if (res.size() == elements.size()) {
            boolean equals = true;
            for (Map.Entry entry : res.entrySet()) {
                if (elements.indexOf(entry.getValue()) >= 0) continue;
                equals = false;
            }
            if (equals) {
                for (Map.Entry entry : res.entrySet()) {
                    FileObject folderFile;
                    if (((Folder)entry.getKey()).getKind() == Folder.Kind.IMPORTANT_FILES_FOLDER || ((Folder)entry.getValue()).isDiskFolder() || ((Folder)entry.getValue()).getRoot() != null || (folderFile = this.getFolderFile((Folder)entry.getValue())) == null) continue;
                    ((Folder)entry.getValue()).setRoot(this.projectBridge.getRelativepath(folderFile.getPath()));
                }
                return;
            }
        }
        root.reset();
        for (Map.Entry entry : res.entrySet()) {
            FileObject folderFile;
            if (((Folder)entry.getKey()).getKind() == Folder.Kind.IMPORTANT_FILES_FOLDER) {
                root.addFolder((Folder)entry.getValue(), true);
                continue;
            }
            if (((Folder)entry.getValue()).isDiskFolder()) {
                root.addFolder((Folder)entry.getValue(), true);
                continue;
            }
            if (((Folder)entry.getValue()).getRoot() == null && (folderFile = this.getFolderFile((Folder)entry.getValue())) != null) {
                ((Folder)entry.getValue()).setRoot(this.projectBridge.getRelativepath(folderFile.getPath()));
            }
            root.addFolder((Folder)entry.getValue(), true);
        }
    }

    private FileObject getFolderFile(Folder folder) {
        for (Item item : folder.getItemsAsArray()) {
            FileObject parent;
            FileObject fo = item.getFileObject();
            if (fo == null || (parent = fo.getParent()) == null) continue;
            return parent;
        }
        for (Folder f : folder.getFolders()) {
            FileObject parent;
            FileObject folderObject = this.getFolderFile(f);
            if (folderObject == null || (parent = folderObject.getParent()) == null) continue;
            return parent;
        }
        return null;
    }

    private Folder packFolder(Folder folder) {
        while (folder.getElements().size() <= 1) {
            List folders = folder.getFolders();
            if (folders.isEmpty()) {
                return folder;
            }
            folder = (Folder)folders.get(0);
        }
        return folder;
    }

    private void downConfiguration(Folder folder, ItemProperties.LanguageKind lang) {
        CCCCompilerConfiguration cccc = this.projectBridge.getFolderConfiguration(lang, folder);
        if (cccc != null) {
            List commonFoldersIncludes = cccc.getIncludeDirectories().getValue();
            List commonFoldersFiles = cccc.getIncludeFiles().getValue();
            List commonFoldersMacros = cccc.getPreprocessorConfiguration().getValue();
            List commonFoldersUndefs = cccc.getUndefinedPreprocessorConfiguration().getValue();
            this.projectBridge.setupProject(commonFoldersIncludes, commonFoldersFiles, commonFoldersMacros, commonFoldersUndefs, lang);
            this.projectBridge.setupFolder(Collections.emptyList(), true, Collections.emptyList(), true, Collections.emptyList(), true, Collections.emptyList(), true, lang, folder);
            this.downConfiguration(folder, lang, commonFoldersIncludes, commonFoldersFiles, commonFoldersMacros, commonFoldersUndefs);
        }
    }

    private void downConfiguration(Folder folder, ItemProperties.LanguageKind lang, List<String> commonFoldersIncludes, List<String> commonFoldersFiles, List<String> commonFoldersMacros, List<String> commonFoldersUndefs) {
        for (Folder subFolder : folder.getFoldersAsArray()) {
            CCCCompilerConfiguration cccc = this.projectBridge.getFolderConfiguration(lang, subFolder);
            if (cccc == null) continue;
            ArrayList<String> aCommonFoldersIncludes = new ArrayList<String>(commonFoldersIncludes);
            ArrayList<String> aCommonFoldersFiles = new ArrayList<String>(commonFoldersFiles);
            ArrayList<String> aCommonFoldersMacros = new ArrayList<String>(commonFoldersMacros);
            ArrayList<String> aCommonFoldersUndefs = new ArrayList<String>(commonFoldersUndefs);
            ArrayList<String> foldersIncludes = new ArrayList<String>();
            ArrayList<String> foldersFiles = new ArrayList<String>();
            ArrayList<String> foldersMacros = new ArrayList<String>();
            ArrayList<String> foldersUndefs = new ArrayList<String>();
            for (String s : cccc.getIncludeDirectories().getValue()) {
                if (aCommonFoldersIncludes.contains(s)) continue;
                foldersIncludes.add(s);
                aCommonFoldersIncludes.add(s);
            }
            for (String s : cccc.getIncludeFiles().getValue()) {
                if (aCommonFoldersFiles.contains(s)) continue;
                foldersFiles.add(s);
                aCommonFoldersFiles.add(s);
            }
            for (String s : cccc.getPreprocessorConfiguration().getValue()) {
                if (aCommonFoldersMacros.contains(s)) continue;
                foldersMacros.add(s);
                aCommonFoldersMacros.add(s);
            }
            for (String s : cccc.getUndefinedPreprocessorConfiguration().getValue()) {
                if (aCommonFoldersUndefs.contains(s)) continue;
                foldersUndefs.add(s);
                aCommonFoldersUndefs.add(s);
            }
            this.projectBridge.setupFolder(foldersIncludes, true, foldersFiles, true, foldersMacros, true, foldersUndefs, true, lang, subFolder);
            this.downConfiguration(subFolder, lang, aCommonFoldersIncludes, aCommonFoldersFiles, aCommonFoldersMacros, aCommonFoldersUndefs);
        }
    }

    private Folder getOrCreateFolder(Folder folder, String name, AbstractRoot used) {
        Folder[] folders;
        Folder added = null;
        for (Folder folder1 : folders = folder.getFoldersAsArray()) {
            String root = folder1.getAbsolutePath();
            String orphan = used.getFolder();
            if (root != null && orphan != null && orphan.startsWith(root)) {
                String[] splitRoot = root.split("\\/");
                String[] splitOrphan = orphan.split("\\/");
                int lastEquals = -1;
                int j = 0;
                while (j < splitRoot.length && j < splitOrphan.length && splitRoot[j].equals(splitOrphan[j])) {
                    lastEquals = j++;
                }
                if (lastEquals == splitRoot.length - 1) {
                    added = folder1;
                    for (j = lastEquals + 1; j < splitOrphan.length; ++j) {
                        Folder found = null;
                        for (Folder current : added.getFoldersAsArray()) {
                            if (!current.getName().equals(splitOrphan[j])) continue;
                            found = current;
                            break;
                        }
                        if (found == null) {
                            found = this.projectBridge.createFolder(added, splitOrphan[j]);
                            added.addFolder(found, true);
                        }
                        added = found;
                    }
                    break;
                }
            }
            if (name == null || !name.equals(folder1.getName())) continue;
            added = folder1;
            break;
        }
        if (added == null) {
            added = this.projectBridge.createFolder(folder, name);
            folder.addFolder(added, true);
        } else if (added.isDiskFolder()) {
            String additionalPath = used.getFolder();
            String folderPath = CndPathUtilities.toAbsolutePath((FileObject)folder.getConfigurationDescriptor().getBaseDirFileObject(), (String)added.getRootPath());
            Folder logicalCandidate = null;
            if (!additionalPath.equals(folderPath)) {
                for (Folder candidate : folder.getFolders()) {
                    if (candidate.isDiskFolder()) {
                        folderPath = CndPathUtilities.toAbsolutePath((FileObject)folder.getConfigurationDescriptor().getBaseDirFileObject(), (String)candidate.getRootPath());
                        if (!additionalPath.equals(folderPath)) continue;
                        added = candidate;
                        break;
                    }
                    if (logicalCandidate != null || !candidate.getName().equals(name)) continue;
                    logicalCandidate = candidate;
                }
            }
            if (!additionalPath.equals(folderPath)) {
                if (logicalCandidate == null) {
                    added = this.projectBridge.createFolder(folder, name);
                    folder.addFolder(added, true);
                } else {
                    added = logicalCandidate;
                }
            }
        }
        return added;
    }

    private boolean upConfiguration(Folder folder, ItemProperties.LanguageKind lang) {
        CCCCompilerConfiguration cccc;
        CCCCompilerConfiguration cccc2;
        LinkedHashSet commonFoldersIncludes = new LinkedHashSet();
        LinkedHashSet commonFoldersFiles = new LinkedHashSet();
        MacroMap commonFolderMacroMap = new MacroMap();
        HashSet commonFoldersUndefs = new HashSet();
        boolean haveSubFolders = false;
        for (Folder subFolder : folder.getFolders()) {
            String next2;
            String next1;
            int i;
            int last;
            Iterator it2;
            Iterator it1;
            int min;
            List itemPaths;
            CCCCompilerConfiguration cccc3;
            if (!this.upConfiguration(subFolder, lang)) continue;
            if (!haveSubFolders) {
                cccc3 = this.projectBridge.getFolderConfiguration(lang, subFolder);
                if (cccc3 == null) continue;
                commonFoldersIncludes.addAll(cccc3.getIncludeDirectories().getValue());
                commonFoldersFiles.addAll(cccc3.getIncludeFiles().getValue());
                commonFolderMacroMap.addAll(cccc3.getPreprocessorConfiguration().getValue());
                commonFoldersUndefs.addAll(cccc3.getUndefinedPreprocessorConfiguration().getValue());
                haveSubFolders = true;
                continue;
            }
            if (commonFoldersIncludes.size() > 0 && (cccc3 = this.projectBridge.getFolderConfiguration(lang, subFolder)) != null) {
                itemPaths = cccc3.getIncludeDirectories().getValue();
                min = Math.min(commonFoldersIncludes.size(), itemPaths.size());
                it1 = commonFoldersIncludes.iterator();
                it2 = itemPaths.iterator();
                last = min;
                for (i = 0; i < min; ++i) {
                    next1 = (String)it1.next();
                    if (next1.equals(next2 = (String)it2.next())) continue;
                    last = i;
                    break;
                }
                commonFoldersIncludes = new LinkedHashSet();
                if (last > 0) {
                    for (i = 0; i < last; ++i) {
                        commonFoldersIncludes.add(itemPaths.get(i));
                    }
                }
            }
            if (commonFoldersFiles.size() > 0 && (cccc3 = this.projectBridge.getFolderConfiguration(lang, subFolder)) != null) {
                itemPaths = cccc3.getIncludeFiles().getValue();
                min = Math.min(commonFoldersFiles.size(), itemPaths.size());
                it1 = commonFoldersFiles.iterator();
                it2 = itemPaths.iterator();
                last = min;
                for (i = 0; i < min; ++i) {
                    next1 = (String)it1.next();
                    if (next1.equals(next2 = (String)it2.next())) continue;
                    last = i;
                    break;
                }
                commonFoldersFiles = new LinkedHashSet();
                if (last > 0) {
                    for (i = 0; i < last; ++i) {
                        commonFoldersFiles.add(itemPaths.get(i));
                    }
                }
            }
            if (commonFolderMacroMap.size() > 0 && (cccc3 = this.projectBridge.getFolderConfiguration(lang, subFolder)) != null) {
                commonFolderMacroMap.retainAll(cccc3.getPreprocessorConfiguration().getValue());
            }
            if (commonFoldersUndefs.size() <= 0 || (cccc3 = this.projectBridge.getFolderConfiguration(lang, subFolder)) == null) continue;
            commonFoldersUndefs.retainAll(cccc3.getUndefinedPreprocessorConfiguration().getValue());
        }
        LinkedHashSet commonFilesIncludes = new LinkedHashSet();
        HashSet commonFilesFiles = new HashSet();
        MacroMap commonFilesMacroMap = new MacroMap();
        HashSet commonFilesUndefs = new HashSet();
        boolean first = true;
        if (haveSubFolders) {
            commonFilesIncludes = new LinkedHashSet(commonFoldersIncludes);
            commonFilesFiles = new HashSet(commonFoldersFiles);
            commonFilesMacroMap = new MacroMap(commonFolderMacroMap);
            commonFilesUndefs = new HashSet(commonFoldersUndefs);
            first = false;
        }
        for (Item item : folder.getItemsAsArray()) {
            String next2;
            String next1;
            int i;
            int last;
            Iterator it2;
            Iterator it1;
            int min;
            List itemPaths;
            if (ProjectBridge.getExclude(item)) continue;
            cccc2 = this.projectBridge.getItemConfiguration(item);
            if (lang != ItemProperties.LanguageKind.CPP ? lang != ItemProperties.LanguageKind.C || !(cccc2 instanceof CCompilerConfiguration) : !(cccc2 instanceof CCCompilerConfiguration)) continue;
            if (first) {
                commonFilesIncludes.addAll(cccc2.getIncludeDirectories().getValue());
                commonFilesFiles.addAll(cccc2.getIncludeFiles().getValue());
                commonFilesMacroMap.addAll(cccc2.getPreprocessorConfiguration().getValue());
                commonFilesUndefs.addAll(cccc2.getUndefinedPreprocessorConfiguration().getValue());
                first = false;
                continue;
            }
            if (commonFilesIncludes.size() > 0) {
                itemPaths = cccc2.getIncludeDirectories().getValue();
                min = Math.min(commonFilesIncludes.size(), itemPaths.size());
                it1 = commonFilesIncludes.iterator();
                it2 = itemPaths.iterator();
                last = min;
                for (i = 0; i < min; ++i) {
                    next1 = (String)it1.next();
                    if (next1.equals(next2 = (String)it2.next())) continue;
                    last = i;
                    break;
                }
                commonFilesIncludes = new LinkedHashSet();
                if (last > 0) {
                    for (i = 0; i < last; ++i) {
                        commonFilesIncludes.add(itemPaths.get(i));
                    }
                }
            }
            if (commonFilesFiles.size() > 0) {
                itemPaths = cccc2.getIncludeFiles().getValue();
                min = Math.min(commonFilesFiles.size(), itemPaths.size());
                it1 = commonFilesFiles.iterator();
                it2 = itemPaths.iterator();
                last = min;
                for (i = 0; i < min; ++i) {
                    next1 = (String)it1.next();
                    if (next1.equals(next2 = (String)it2.next())) continue;
                    last = i;
                    break;
                }
                commonFilesFiles = new LinkedHashSet();
                if (last > 0) {
                    for (i = 0; i < last; ++i) {
                        commonFilesFiles.add(itemPaths.get(i));
                    }
                }
            }
            if (commonFilesMacroMap.size() > 0) {
                commonFilesMacroMap.retainAll(cccc2.getPreprocessorConfiguration().getValue());
            }
            if (commonFilesUndefs.size() <= 0) continue;
            commonFilesUndefs.retainAll(cccc2.getUndefinedPreprocessorConfiguration().getValue());
        }
        if (commonFilesIncludes.size() > 0 || commonFilesFiles.size() > 0 || commonFilesMacroMap.size() > 0 || commonFilesUndefs.size() > 0) {
            for (Item item : folder.getItemsAsArray()) {
                List<String> list;
                cccc2 = this.projectBridge.getItemConfiguration(item);
                if (lang != ItemProperties.LanguageKind.CPP ? lang != ItemProperties.LanguageKind.C || !(cccc2 instanceof CCompilerConfiguration) : !(cccc2 instanceof CCCompilerConfiguration)) continue;
                if (commonFilesIncludes.size() > 0) {
                    list = new ArrayList<String>(cccc2.getIncludeDirectories().getValue());
                    list.removeAll(commonFilesIncludes);
                    cccc2.getIncludeDirectories().setValue(list);
                }
                if (commonFilesFiles.size() > 0) {
                    list = new ArrayList(cccc2.getIncludeFiles().getValue());
                    list.removeAll(commonFilesFiles);
                    cccc2.getIncludeFiles().setValue(list);
                }
                if (commonFilesMacroMap.size() > 0) {
                    list = new ArrayList(cccc2.getPreprocessorConfiguration().getValue());
                    list = commonFilesMacroMap.removeCommon(list);
                    cccc2.getPreprocessorConfiguration().setValue(list);
                }
                if (commonFilesUndefs.size() <= 0) continue;
                list = new ArrayList(cccc2.getUndefinedPreprocessorConfiguration().getValue());
                list.removeAll(commonFilesUndefs);
                cccc2.getUndefinedPreprocessorConfiguration().setValue(list);
            }
        }
        if ((cccc = this.projectBridge.getFolderConfiguration(lang, folder)) != null) {
            if (commonFilesIncludes.size() > 0) {
                cccc.getIncludeDirectories().setValue(new ArrayList(commonFilesIncludes));
            }
            if (commonFilesFiles.size() > 0) {
                cccc.getIncludeFiles().setValue(new ArrayList(commonFilesFiles));
            }
            if (commonFilesMacroMap.size() > 0) {
                cccc.getPreprocessorConfiguration().setValue(commonFilesMacroMap.convertToList());
            }
            if (commonFilesUndefs.size() > 0) {
                cccc.getUndefinedPreprocessorConfiguration().setValue(new ArrayList(commonFilesUndefs));
            }
        }
        return !first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Project> makeProject() {
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DiscoveryProjectGeneratorImpl.class, (String)"UpdateCodeAssistance"));
        handle.start();
        try {
            if (this.projectBridge.isValid() && this.wizard.getConfigurations() != null && this.wizard.getConfigurations().size() > 0) {
                this.projectBridge.startModifications();
                this.process();
                Set<Project> set = this.projectBridge.getResult();
                return set;
            }
            Set<Project> set = Collections.emptySet();
            return set;
        }
        finally {
            handle.finish();
        }
    }

    private Set<String> getSourceFolders() {
        HashSet<String> used = new HashSet<String>();
        List<ProjectConfiguration> projectConfigurations = this.wizard.getConfigurations();
        for (ProjectConfiguration conf : projectConfigurations) {
            for (FileConfiguration file : conf.getFiles()) {
                int i;
                String path = file.getFilePath();
                if (Utilities.isWindows()) {
                    path = path.replace('\\', '/');
                }
                if ((i = path.lastIndexOf(47)) > 0) {
                    path = path.substring(0, i + 1);
                }
                used.add(path);
            }
        }
        used.addAll(this.compureRoots(used));
        return used;
    }

    private Set<String> compureRoots(Set<String> roots) {
        HashSet<String> res = new HashSet<String>();
        ArrayList<String> root = null;
        block0: for (String s : roots) {
            if (root == null) {
                root = new ArrayList<String>();
                root.addAll(Arrays.asList(s.split("/")));
                continue;
            }
            int i = 0;
            for (String segment : s.split("/")) {
                if (i >= root.size()) continue block0;
                if (!segment.equals(root.get(i))) {
                    while (root.size() > i) {
                        root.remove(root.size() - 1);
                    }
                }
                ++i;
            }
        }
        if (root != null && root.size() > 1) {
            StringBuilder buf = new StringBuilder();
            for (String s : root) {
                buf.append(s);
                buf.append('/');
            }
            res.add(buf.toString());
        }
        return res;
    }

    private void addAdditional(Folder folder, String base, Set<Item> usedItems) {
        Set<String> folders = this.getSourceFolders();
        HashSet<String> used = new HashSet<String>();
        HashSet<String> needAdd = new HashSet<String>();
        HashSet<String> needCheck = new HashSet<String>();
        List<String> list = this.wizard.getIncludedFiles();
        Map<String, Folder> preffered = this.projectBridge.prefferedFolders();
        for (String name : list) {
            used.add(name);
            String path = this.projectBridge.getRelativepath(name);
            Item item = this.projectBridge.getProjectItem(path);
            if (item == null) {
                String folderPath;
                Folder prefferedFolder;
                int i;
                path = name;
                if (Utilities.isWindows()) {
                    path = path.replace('\\', '/');
                }
                boolean bl = false;
                if (path.startsWith(base)) {
                    bl = true;
                } else {
                    for (String dir : folders) {
                        if (!path.startsWith(dir)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl && (i = path.lastIndexOf(47)) >= 0 && (prefferedFolder = preffered.get(folderPath = path.substring(0, i))) != null) {
                    item = this.projectBridge.createItem(name);
                    item = prefferedFolder.addItem(item);
                    ProjectBridge.setHeaderTool(item);
                    if (!MIMENames.isCppOrCOrFortran((String)item.getMIMEType())) {
                        needCheck.add(path);
                    } else if (DEBUG) {
                        System.err.println("Source is header:" + item.getAbsPath());
                    }
                    ProjectBridge.setExclude(item, true);
                    ProjectBridge.excludeItemFromOtherConfigurations(item);
                    bl = false;
                }
                if (!bl) continue;
                needCheck.add(path);
                needAdd.add(name);
                continue;
            }
            if (!usedItems.contains(item)) {
                ProjectBridge.setExclude(item, true);
                ProjectBridge.setHeaderTool(item);
                continue;
            }
            if (MIMENames.isCppOrCOrFortran((String)item.getMIMEType())) continue;
            needCheck.add(path);
        }
        if (needAdd.size() > 0) {
            AbstractRoot additional = UnusedFactory.createRoot(needAdd, this.projectBridge.getBaseFolderFileSystem());
            if (additional.getName().isEmpty()) {
                for (AbstractRoot aRoot : additional.getChildren()) {
                    this.addAdditionalPreferedFolder(folder, aRoot);
                }
            } else {
                this.addAdditionalPreferedFolder(folder, additional);
            }
        }
        List<ProjectConfiguration> projectConfigurations = this.wizard.getConfigurations();
        for (ProjectConfiguration conf : projectConfigurations) {
            for (FileConfiguration fileConfiguration : conf.getFiles()) {
                used.add(fileConfiguration.getFilePath());
            }
        }
        HashSet<String> relatives = new HashSet<String>();
        for (String name : used) {
            relatives.add(this.projectBridge.getRelativepath(name));
        }
        TreeMap<String, Item> sorted = new TreeMap<String, Item>();
        for (Item item : this.projectBridge.getAllSources()) {
            if (usedItems.contains(item)) continue;
            sorted.put(item.getPath(), item);
        }
        for (Map.Entry entry : sorted.entrySet()) {
            Item item;
            String path = (String)entry.getKey();
            item = (Item)entry.getValue();
            String canonicalPath = item.getNormalizedPath();
            if (relatives.contains(path) || used.contains(path) || relatives.contains(canonicalPath) || used.contains(canonicalPath)) continue;
            if (DEBUG) {
                System.out.println("Exclude Item " + path);
            }
            ProjectBridge.setExclude(item, true);
        }
        if (needCheck.size() > 0) {
            this.projectBridge.checkForNewExtensions(needCheck);
        }
    }

    private void addAdditionalPreferedFolder(Folder folder, AbstractRoot additional) {
        int i;
        Folder rootCandidate = null;
        String root = additional.getFolder();
        if (Utilities.isWindows()) {
            root = root.replace('\\', '/');
        }
        if ((i = root.lastIndexOf(47)) > 0) {
            Map<String, Folder> prefferedFolders = this.projectBridge.prefferedFolders();
            root = root.substring(0, i);
            rootCandidate = prefferedFolders.get(root);
        }
        if (rootCandidate == null) {
            rootCandidate = folder;
        }
        this.addAdditionalFolder(rootCandidate, additional);
    }

    private void addAdditionalFolder(Folder folder, AbstractRoot used) {
        String name = used.getName();
        Folder added = this.getOrCreateFolder(folder, name, used);
        if (added == null) {
            added = this.projectBridge.createFolder(folder, name);
            folder.addFolder(added, true);
        }
        for (AbstractRoot sub : used.getChildren()) {
            this.addAdditionalFolder(added, sub);
        }
        List<String> files = used.getFiles();
        if (files != null) {
            for (String file : files) {
                String path = this.projectBridge.getRelativepath(file);
                Item item = this.projectBridge.getProjectItem(path);
                if (item != null) {
                    if (item.getFolder() != added) {
                        Object old = this.projectBridge.getAuxObject(item);
                        item.getFolder().removeItem(item);
                        item = added.addItem(item);
                        if (old != null) {
                            this.projectBridge.setAuxObject(item, old);
                        }
                    }
                } else {
                    item = this.projectBridge.createItem(file);
                    item = added.addItem(item);
                    ProjectBridge.excludeItemFromOtherConfigurations(item);
                }
                ProjectBridge.setExclude(item, true);
                ProjectBridge.setHeaderTool(item);
            }
        }
    }

    private void setupCompilerConfiguration(ProjectConfiguration config) {
        this.projectBridge.setupProject(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), config.getLanguageKind());
    }

    private List<String> buildMacrosString(Map<String, String> map) {
        ArrayList<String> vector = new ArrayList<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() != null) {
                vector.add(entry.getKey() + "=" + entry.getValue());
                continue;
            }
            vector.add(entry.getKey());
        }
        return vector;
    }

    private void setupFile(FileConfiguration config, Item item, ItemProperties.LanguageKind lang) {
        ProjectBridge.setSourceTool(item, lang, config.getLanguageStandard(), this.wizard.isIncrementalMode());
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        LinkedHashSet<String> fileSet = new LinkedHashSet<String>();
        HashMap<String, String> macros = new HashMap<String, String>();
        this.reConsolidatePaths(set, config);
        this.reConsolidateFiles(fileSet, config, set);
        macros.putAll(config.getUserMacros());
        this.projectBridge.setupFile(config.getCompilePath(), new ArrayList<String>(set), !config.overrideIncludes(), new ArrayList<String>(fileSet), !config.overrideFiles(), this.buildMacrosString(macros), !config.overrideMacros(), new ArrayList<String>(config.getUndefinedMacros()), !config.overrideUndefinedMacros(), item, config.getImportantFlags());
    }

    private void reConsolidatePaths(Set<String> set, FileConfiguration file) {
        this.projectBridge.convertIncludePaths(set, file.getUserInludePaths(), file.getCompilePath(), file.getFilePath());
    }

    private void reConsolidateFiles(Set<String> set, FileConfiguration file, Set<String> paths) {
        this.projectBridge.convertIncludeFiles(set, file.getUserInludeFiles(), file.getCompilePath(), paths);
    }

    private void createFolderStructure(List<ProjectConfiguration> projectConfigurations, Folder sourceRoot) {
        HashMap<String, Set<Pair>> configurationStructure = new HashMap<String, Set<Pair>>();
        for (ProjectConfiguration config : projectConfigurations) {
            this.analyzeConfigurationStructure(config.getFiles(), config.getLanguageKind(), configurationStructure);
        }
        List<Pair> orphan = this.detectOrphan(configurationStructure, null);
        if (orphan.size() > 0) {
            this.createOrphan(sourceRoot, orphan, null);
        }
    }

    private void addConfiguration(Folder sourceRoot, ProjectConfiguration conf, Set<Item> used) {
        ItemProperties.LanguageKind lang = conf.getLanguageKind();
        HashMap<String, Set<Pair>> configurationStructure = new HashMap<String, Set<Pair>>();
        this.analyzeConfigurationStructure(conf.getFiles(), lang, configurationStructure);
        List<Pair> orphan = this.detectOrphan(configurationStructure, lang);
        if (orphan.size() > 0) {
            this.createOrphan(sourceRoot, orphan, lang);
        }
        HashSet<Folder> folders = new HashSet<Folder>();
        for (Map.Entry entry : configurationStructure.entrySet()) {
            Set files = (Set)entry.getValue();
            for (Pair pair : files) {
                if (pair.item == null) continue;
                Folder folder = pair.item.getFolder();
                folders.add(folder);
            }
        }
        for (Folder folder : folders) {
            this.projectBridge.setupFolder(Collections.emptyList(), true, Collections.emptyList(), true, Collections.emptyList(), true, Collections.emptyList(), true, conf.getLanguageKind(), folder);
        }
        for (Set set : configurationStructure.values()) {
            for (Pair pair : set) {
                if (pair.item == null) continue;
                used.add(pair.item);
            }
        }
    }

    private void createOrphan(Folder sourceRoot, List<Pair> orphan, ItemProperties.LanguageKind lang) {
        HashMap<String, Pair> folders = new HashMap<String, Pair>();
        for (Pair pair : orphan) {
            String path = pair.fileConfiguration.getFilePath();
            folders.put(path, pair);
        }
        AbstractRoot additional = UnusedFactory.createRoot(folders.keySet(), this.projectBridge.getBaseFolderFileSystem());
        if (additional.getName().isEmpty()) {
            for (AbstractRoot aRoot : additional.getChildren()) {
                this.addFolder(sourceRoot, aRoot, folders, lang);
            }
        } else {
            this.addFolder(sourceRoot, additional, folders, lang);
        }
    }

    private void addFolder(Folder folder, AbstractRoot additional, Map<String, Pair> folders, ItemProperties.LanguageKind lang) {
        String name = additional.getName();
        Folder added = this.getOrCreateFolder(folder, name, additional);
        for (AbstractRoot sub : additional.getChildren()) {
            this.addFolder(added, sub, folders, lang);
        }
        for (String file : additional.getFiles()) {
            Pair pair = folders.get(file);
            if (pair != null) {
                String path = this.projectBridge.getRelativepath(file);
                Item item = this.projectBridge.getProjectItem(path);
                if (item == null) {
                    item = this.projectBridge.createItem(file);
                    if ((item = added.addItem(item)) != null) {
                        ProjectBridge.excludeItemFromOtherConfigurations(item);
                    }
                } else if (DEBUG) {
                    System.err.println("Orphan pair found by path " + file);
                }
                pair.item = item;
                if (lang == null) continue;
                this.setupFile(pair.fileConfiguration, pair.item, lang);
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("Cannot find pair by path " + file);
        }
    }

    private List<Pair> detectOrphan(Map<String, Set<Pair>> configurationStructure, ItemProperties.LanguageKind lang) {
        Map<String, Folder> preffered = this.projectBridge.prefferedFolders();
        ArrayList<Pair> orphan = new ArrayList<Pair>();
        for (Map.Entry<String, Set<Pair>> entry : configurationStructure.entrySet()) {
            Set<Pair> files = entry.getValue();
            Folder folder = null;
            ArrayList<Pair> list = new ArrayList<Pair>();
            for (Pair pair : files) {
                int i;
                Item item = pair.item;
                if (item != null) {
                    if (folder == null) continue;
                    folder = item.getFolder();
                    continue;
                }
                String prefferedFolder = pair.fileConfiguration.getFilePath();
                if (Utilities.isWindows()) {
                    prefferedFolder = prefferedFolder.replace('\\', '/');
                }
                if ((i = prefferedFolder.lastIndexOf(47)) >= 0) {
                    prefferedFolder = prefferedFolder.substring(0, i);
                    folder = preffered.get(prefferedFolder);
                }
                list.add(pair);
            }
            if (folder != null) {
                for (Pair pair : list) {
                    String relPath = this.projectBridge.getRelativepath(pair.fileConfiguration.getFilePath());
                    Item item = this.projectBridge.getProjectItem(relPath);
                    if (item == null) {
                        item = this.projectBridge.createItem(pair.fileConfiguration.getFilePath());
                        pair.item = item;
                        item = folder.addItem(item);
                        if (item != null) {
                            ProjectBridge.excludeItemFromOtherConfigurations(item);
                        }
                    }
                    if (lang == null) continue;
                    this.setupFile(pair.fileConfiguration, item, lang);
                }
                continue;
            }
            for (Pair pair : list) {
                orphan.add(pair);
            }
        }
        return orphan;
    }

    private void analyzeConfigurationStructure(List<FileConfiguration> files, ItemProperties.LanguageKind lang, Map<String, Set<Pair>> folders) {
        for (FileConfiguration file : files) {
            this.analyzeConfigurationStructure(file.getFilePath(), folders, file, lang);
        }
    }

    private void analyzeConfigurationStructure(String aPath, Map<String, Set<Pair>> folders, FileConfiguration file, ItemProperties.LanguageKind lang) {
        String path = Utilities.isWindows() ? aPath.replace('\\', '/') : aPath;
        int i = path.lastIndexOf(47);
        if (i >= 0) {
            String relPath;
            Item item;
            String folder = path.substring(0, i);
            Set<Pair> set = folders.get(folder);
            if (set == null) {
                set = new HashSet<Pair>();
                folders.put(folder, set);
            }
            if ((item = this.projectBridge.getProjectItem(relPath = this.projectBridge.getRelativepath(path))) != null && lang != null) {
                this.setupFile(file, item, lang);
            }
            set.add(new Pair(file, item));
        }
    }

    private static class Pair {
        private FileConfiguration fileConfiguration;
        private Item item;

        private Pair(FileConfiguration fileConfiguration, Item item) {
            this.fileConfiguration = fileConfiguration;
            this.item = item;
        }
    }
}

