/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.symbol;

import java.awt.Dialog;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.jumpto.common.AbstractModelFilter;
import org.netbeans.modules.jumpto.common.CurrentSearch;
import org.netbeans.modules.jumpto.common.Factory;
import org.netbeans.modules.jumpto.common.ItemRenderer;
import org.netbeans.modules.jumpto.common.Models;
import org.netbeans.modules.jumpto.common.Utils;
import org.netbeans.modules.jumpto.symbol.DialogFactory;
import org.netbeans.modules.jumpto.symbol.GoToPanel;
import org.netbeans.modules.jumpto.symbol.GoToPanelImpl;
import org.netbeans.modules.jumpto.symbol.GoToSymbolAction;
import org.netbeans.modules.jumpto.symbol.SymbolComparator;
import org.netbeans.modules.jumpto.symbol.SymbolProviderAccessor;
import org.netbeans.spi.jumpto.support.AsyncDescriptor;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.netbeans.spi.jumpto.symbol.SymbolProvider;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

final class ContentProviderImpl
implements GoToPanelImpl.ContentProvider {
    private static final Logger LOG = Logger.getLogger(ContentProviderImpl.class.getName());
    private static final RequestProcessor rp = new RequestProcessor(ContentProviderImpl.class);
    private final JButton okButton;
    private final AtomicReference<Collection<? extends SymbolProvider>> typeProviders = new AtomicReference();
    private final CurrentSearch<SymbolDescriptor> currentSearch = new CurrentSearch<SymbolDescriptor>(new Callable<AbstractModelFilter<SymbolDescriptor>>(){

        @Override
        @NonNull
        public AbstractModelFilter<SymbolDescriptor> call() throws Exception {
            class Filter
            extends AbstractModelFilter<SymbolDescriptor>
            implements ChangeListener {
                Filter() {
                    this.addChangeListener(this);
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    SymbolDescriptorAttrCopier copier = ContentProviderImpl.this.currentSearch.getAttribute(SymbolDescriptorAttrCopier.class);
                    if (copier != null) {
                        copier.clearWrongCase();
                    }
                }

                @Override
                @NonNull
                protected String getItemValue(@NonNull SymbolDescriptor item) {
                    String name = item.getSimpleName();
                    if (name == null) {
                        name = item.getSymbolName();
                        String[] nameParts = name.split("\\s+|\\(");
                        name = nameParts[0];
                    }
                    return name;
                }

                @Override
                protected void update(@NonNull SymbolDescriptor item) {
                    String searchText = this.getSearchText();
                    if (searchText == null) {
                        searchText = "";
                    }
                    SymbolProviderAccessor.DEFAULT.setHighlightText(item, searchText);
                    SymbolDescriptorAttrCopier copier = ContentProviderImpl.this.currentSearch.getAttribute(SymbolDescriptorAttrCopier.class);
                    if (copier != null && item instanceof AsyncDescriptor && !((AsyncDescriptor)((Object)item)).hasCorrectCase()) {
                        copier.reportWrongCase((AsyncDescriptor)((Object)item));
                    }
                }
            }
            return new Filter();
        }
    });
    private RequestProcessor.Task task;
    private Worker running;
    private Dialog dialog;

    public ContentProviderImpl(JButton okButton) {
        this.okButton = okButton;
    }

    void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public ListCellRenderer getListCellRenderer(@NonNull JList list, @NonNull ButtonModel caseSensitive) {
        Parameters.notNull((CharSequence)"list", (Object)list);
        Parameters.notNull((CharSequence)"caseSensitive", (Object)caseSensitive);
        return ItemRenderer.Builder.create(list, caseSensitive, new SymbolDescriptorCovertor()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setListModel(GoToPanel panel, String text) {
        RequestProcessor.Task taskToCancel;
        Worker workToCancel;
        this.enableOK(false);
        ContentProviderImpl contentProviderImpl = this;
        synchronized (contentProviderImpl) {
            workToCancel = this.running;
            taskToCancel = this.task;
            this.running = null;
            this.task = null;
        }
        if (workToCancel != null) {
            workToCancel.cancel();
        }
        if (taskToCancel != null) {
            taskToCancel.cancel();
        }
        if (text == null) {
            this.currentSearch.resetFilter();
            panel.setModel(new DefaultListModel());
            return false;
        }
        boolean exact = text.endsWith(" ");
        boolean isCaseSensitive = panel.isCaseSensitive();
        if ((text = text.trim()).length() == 0 || !Utils.isValidInput(text)) {
            this.currentSearch.resetFilter();
            panel.setModel(new DefaultListModel());
            return false;
        }
        SearchType searchType = Utils.getSearchType(text, exact, isCaseSensitive, null, null);
        if (searchType == SearchType.REGEXP || searchType == SearchType.CASE_INSENSITIVE_REGEXP) {
            text = Utils.removeNonNeededWildCards(text);
        }
        Pair<String, String> nameAndScope = Utils.splitNameAndScope(text.trim());
        String name = (String)nameAndScope.first();
        String scope = (String)nameAndScope.second();
        if (name.length() == 0) {
            this.currentSearch.resetFilter();
            panel.setModel(new DefaultListModel());
            return false;
        }
        ContentProviderImpl contentProviderImpl2 = this;
        synchronized (contentProviderImpl2) {
            boolean correctCase;
            SymbolDescriptorAttrCopier acp = this.currentSearch.getAttribute(SymbolDescriptorAttrCopier.class);
            boolean bl = correctCase = acp == null || acp.hasCorrectCase();
            if (this.currentSearch.isNarrowing(searchType, name, scope, correctCase)) {
                this.currentSearch.filter(searchType, name, null);
                this.enableOK(panel.revalidateModel());
                return false;
            }
            this.running = new Worker(text, searchType, panel);
            this.task = rp.post((Runnable)this.running, 220);
            if (panel.getStartTime() != -1L) {
                LOG.log(Level.FINE, "Worker posted after {0} ms.", System.currentTimeMillis() - panel.getStartTime());
            }
            return true;
        }
    }

    @Override
    public void closeDialog() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            DialogFactory.storeDialogDimensions(new Dimension(this.dialog.getWidth(), this.dialog.getHeight()));
            this.dialog.dispose();
            this.dialog = null;
            this.cleanUp();
        }
    }

    @Override
    public boolean hasValidContent() {
        return this.okButton != null && this.okButton.isEnabled();
    }

    @NonNull
    Runnable createWorker(@NonNull String text, @NonNull SearchType searchType, @NonNull GoToPanel panel) {
        return new Worker(text, searchType, panel);
    }

    private void enableOK(boolean enabled) {
        if (this.okButton != null) {
            this.okButton.setEnabled(enabled);
        }
    }

    private void cleanUp() {
        for (SymbolProvider symbolProvider : this.getTypeProviders()) {
            symbolProvider.cleanup();
        }
        SymbolDescriptorAttrCopier attrCopier = this.currentSearch.setAttribute(SymbolDescriptorAttrCopier.class, null);
        if (attrCopier != null) {
            attrCopier.clearWrongCase();
        }
    }

    private Collection<? extends SymbolProvider> getTypeProviders() {
        Collection<? extends SymbolProvider> res = this.typeProviders.get();
        if (res == null && !this.typeProviders.compareAndSet(null, res = Arrays.asList(Lookup.getDefault().lookupAll(SymbolProvider.class).toArray(new SymbolProvider[0])))) {
            res = this.typeProviders.get();
        }
        return res;
    }

    private static final class Result {
        final Collection<SymbolDescriptor> symbols;
        final int retry;
        final Collection<SymbolProvider> nonFinishedProviders;

        Result(@NonNull Collection<SymbolDescriptor> symbols, @NonNull Collection<SymbolProvider> providers, int retry) {
            assert (symbols != null);
            assert (providers != null);
            this.symbols = symbols;
            this.nonFinishedProviders = providers;
            this.retry = retry;
            assert (this.retry <= 0 ? this.nonFinishedProviders.isEmpty() : !this.nonFinishedProviders.isEmpty());
        }
    }

    private static final class SymbolDescriptorAttrCopier
    implements Factory<SymbolDescriptor, Pair<? extends SymbolDescriptor, ? extends SymbolDescriptor>> {
        private final Set<AsyncDescriptor<SymbolDescriptor>> hasWrongCase = Collections.synchronizedSet(new HashSet());
        private final Set<SymbolDescriptor> resolved = Collections.synchronizedSet(new HashSet());

        SymbolDescriptorAttrCopier() {
        }

        void checkWrongCase(@NonNull Collection<? extends SymbolDescriptor> remove, @NonNull Collection<? extends SymbolDescriptor> add) {
            this.hasWrongCase.removeAll(remove);
            for (SymbolDescriptor symbolDescriptor : add) {
                if (!(symbolDescriptor instanceof AsyncDescriptor) || ((AsyncDescriptor)((Object)symbolDescriptor)).hasCorrectCase()) continue;
                this.reportWrongCase((AsyncDescriptor)((Object)symbolDescriptor));
            }
        }

        void clearWrongCase() {
            this.hasWrongCase.clear();
        }

        void reportWrongCase(@NonNull AsyncDescriptor<SymbolDescriptor> d) {
            this.hasWrongCase.add(d);
        }

        boolean hasCorrectCase() {
            return this.hasWrongCase.isEmpty();
        }

        void searchCompleted() {
            this.resolved.clear();
        }

        boolean isResolved(@NonNull SymbolDescriptor desc) {
            return this.resolved.contains(desc);
        }

        @Override
        @NonNull
        public SymbolDescriptor create(@NonNull Pair<? extends SymbolDescriptor, ? extends SymbolDescriptor> p) {
            SymbolDescriptor source = (SymbolDescriptor)p.first();
            SymbolDescriptor target = (SymbolDescriptor)p.second();
            this.resolved.add(source);
            if (source instanceof AsyncDescriptor && !((AsyncDescriptor)((Object)source)).hasCorrectCase()) {
                this.hasWrongCase.remove(source);
            }
            SymbolProviderAccessor.DEFAULT.setHighlightText(target, SymbolProviderAccessor.DEFAULT.getHighlightText(source));
            SymbolProviderAccessor.DEFAULT.setSymbolProvider(target, SymbolProviderAccessor.DEFAULT.getSymbolProvider(source));
            return target;
        }
    }

    private class Worker
    implements Runnable {
        private final String text;
        private final SearchType searchType;
        private final long createTime;
        private final GoToPanel panel;
        private volatile boolean isCanceled = false;
        private volatile SymbolProvider current;

        Worker(@NonNull String text, @NonNull SearchType searchType, GoToPanel panel) {
            this.text = text;
            this.searchType = searchType;
            this.panel = panel;
            this.createTime = System.currentTimeMillis();
            LOG.log(Level.FINE, "Worker for {0} - created after {1} ms.", new Object[]{text, System.currentTimeMillis() - panel.getStartTime()});
        }

        @Override
        public void run() {
            LOG.log(Level.FINE, "Worker for {0} - started {1} ms.", new Object[]{this.text, System.currentTimeMillis() - this.createTime});
            ArrayList<SymbolDescriptor> transientItems = new ArrayList<SymbolDescriptor>(512);
            Collection<SymbolProvider> providers = ContentProviderImpl.this.getTypeProviders();
            int lastSize = -1;
            int lastProvCount = providers.size();
            int[] newSize = new int[1];
            final SymbolDescriptorAttrCopier attrCopier = new SymbolDescriptorAttrCopier();
            final Models.MutableListModel<? extends SymbolDescriptor> model = Models.mutable(new SymbolComparator(), ContentProviderImpl.this.currentSearch.resetFilter(), attrCopier);
            try {
                while (true) {
                    boolean resultChanged;
                    Result res = this.getSymbolNames(this.text, (Collection<? extends SymbolProvider>)providers);
                    if (this.isCanceled) {
                        LOG.log(Level.FINE, "Worker for {0} exited after cancel {1} ms.", new Object[]{this.text, System.currentTimeMillis() - this.createTime});
                        return;
                    }
                    ArrayList toRemove = new ArrayList(transientItems);
                    Collection<? extends SymbolDescriptor> toAdd = this.mergeSymbols(transientItems, res.symbols, (Collection<? extends SymbolProvider>)providers, res.nonFinishedProviders, attrCopier, newSize);
                    final boolean done = res.retry <= 0;
                    int newProvCount = res.nonFinishedProviders.size();
                    boolean bl = resultChanged = lastSize != newSize[0] || lastProvCount != newProvCount;
                    if (done || resultChanged) {
                        lastSize = newSize[0];
                        lastProvCount = newProvCount;
                        model.remove(toRemove);
                        model.add(toAdd);
                        attrCopier.checkWrongCase(toRemove, toAdd);
                        if (this.isCanceled) {
                            LOG.log(Level.FINE, "Worker for {0} exited after cancel {1} ms.", new Object[]{this.text, System.currentTimeMillis() - this.createTime});
                            return;
                        }
                        LOG.log(Level.FINE, "Worker for text {0} finished after {1} ms.", new Object[]{this.text, System.currentTimeMillis() - this.createTime});
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (done) {
                                    Pair<String, String> nameAndScope = Utils.splitNameAndScope(Worker.this.text);
                                    SymbolDescriptorAttrCopier oldAttrCopier = ContentProviderImpl.this.currentSearch.setAttribute(SymbolDescriptorAttrCopier.class, attrCopier);
                                    if (oldAttrCopier != null) {
                                        oldAttrCopier.clearWrongCase();
                                    }
                                    ContentProviderImpl.this.currentSearch.searchCompleted(Worker.this.searchType, (String)nameAndScope.first(), (String)nameAndScope.second());
                                }
                                if (!Worker.this.isCanceled) {
                                    ContentProviderImpl.this.enableOK(Worker.this.panel.setModel(model));
                                }
                            }
                        });
                    }
                    if (done) {
                        return;
                    }
                    providers = res.nonFinishedProviders;
                    try {
                        Thread.sleep(res.retry);
                    }
                    catch (InterruptedException ex) {}
                }
            }
            finally {
                attrCopier.searchCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            SymbolProvider _provider;
            if (this.panel.getStartTime() != -1L) {
                LOG.log(Level.FINE, "Worker for text {0} canceled after {1} ms.", new Object[]{this.text, System.currentTimeMillis() - this.createTime});
            }
            Worker worker = this;
            synchronized (worker) {
                this.isCanceled = true;
                _provider = this.current;
            }
            if (_provider != null) {
                _provider.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        private Result getSymbolNames(String text, Collection<? extends SymbolProvider> providers) {
            HashSet<SymbolDescriptor> items = new HashSet<SymbolDescriptor>(128);
            String[] message = new String[1];
            int retry = 0;
            Set<SymbolProvider> nonFinishedProviders = Collections.newSetFromMap(new IdentityHashMap());
            Iterator<? extends SymbolProvider> i$ = providers.iterator();
            while (i$.hasNext()) {
                SymbolProvider provider;
                this.current = provider = i$.next();
                try {
                    if (this.isCanceled) {
                        Result result = null;
                        return result;
                    }
                    LOG.log(Level.FINE, "Calling SymbolProvider: {0}", provider);
                    SymbolProvider.Context context = SymbolProviderAccessor.DEFAULT.createContext(null, text, this.searchType);
                    SymbolProvider.Result result = SymbolProviderAccessor.DEFAULT.createResult(items, message, context, provider);
                    provider.computeSymbolNames(context, result);
                    int providerRetry = SymbolProviderAccessor.DEFAULT.getRetry(result);
                    if (providerRetry > 0) {
                        nonFinishedProviders.add(provider);
                    }
                    retry = this.mergeRetryTimeOut(retry, providerRetry);
                }
                finally {
                    this.current = null;
                }
            }
            if (!this.isCanceled) {
                this.panel.setWarning(message[0]);
                return new Result(items, nonFinishedProviders, retry);
            }
            return null;
        }

        private int mergeRetryTimeOut(int t1, int t2) {
            if (t1 == 0) {
                return t2;
            }
            if (t2 == 0) {
                return t1;
            }
            return Math.min(t1, t2);
        }

        @NonNull
        private Collection<? extends SymbolDescriptor> mergeSymbols(@NonNull Collection<SymbolDescriptor> transientSymbols, @NonNull Collection<? extends SymbolDescriptor> newSymbols, @NonNull Collection<? extends SymbolProvider> usedProviders, @NonNull Collection<? extends SymbolProvider> nonFinishedProviders, @NonNull SymbolDescriptorAttrCopier attrCopier, @NonNull int[] newSize) {
            transientSymbols.clear();
            newSize[0] = 0;
            Iterator<? extends SymbolDescriptor> it = newSymbols.iterator();
            while (it.hasNext()) {
                SymbolDescriptor newSymbol = it.next();
                if (nonFinishedProviders.contains(SymbolProviderAccessor.DEFAULT.getSymbolProvider(newSymbol))) {
                    newSize[0] = newSize[0] + 1;
                    transientSymbols.add(newSymbol);
                }
                if (!attrCopier.isResolved(newSymbol)) continue;
                it.remove();
            }
            return newSymbols;
        }
    }

    private static final class SymbolDescriptorCovertor
    implements ItemRenderer.Convertor<SymbolDescriptor> {
        private SymbolDescriptorCovertor() {
        }

        @Override
        public String getName(@NonNull SymbolDescriptor item) {
            return item.getSymbolName();
        }

        @Override
        public String getHighlightText(@NonNull SymbolDescriptor item) {
            return SymbolProviderAccessor.DEFAULT.getHighlightText(item);
        }

        @Override
        public String getOwnerName(@NonNull SymbolDescriptor item) {
            return NbBundle.getMessage(GoToSymbolAction.class, (String)"MSG_DeclaredIn", (Object)item.getOwnerName());
        }

        @Override
        public String getProjectName(@NonNull SymbolDescriptor item) {
            return item.getProjectName();
        }

        @Override
        public String getFilePath(@NonNull SymbolDescriptor item) {
            return item.getFileDisplayPath();
        }

        @Override
        public Icon getItemIcon(@NonNull SymbolDescriptor item) {
            return item.getIcon();
        }

        @Override
        public Icon getProjectIcon(@NonNull SymbolDescriptor item) {
            return item.getProjectIcon();
        }

        @Override
        public boolean isFromCurrentProject(@NonNull SymbolDescriptor item) {
            return false;
        }
    }
}

