/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.TemplateChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class TemplateChooserPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private TemplateChooserPanelGUI gui;
    @NullAllowed
    private Project project;
    private WizardDescriptor wizard;
    private final boolean includeTemplatesWithProjects;

    TemplateChooserPanel(@NullAllowed Project p, boolean includeTemplatesWithProjects) {
        this.project = p;
        this.includeTemplatesWithProjects = includeTemplatesWithProjects;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new TemplateChooserPanelGUI(this.includeTemplatesWithProjects);
            this.gui.addChangeListener(this);
            this.gui.setDefaultActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (null != TemplateChooserPanel.this.wizard) {
                        TemplateChooserPanel.this.wizard.doNextClick();
                    }
                }
            });
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return this.gui != null && this.gui.getTemplate() != null;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void readSettings(WizardDescriptor settings) {
        this.wizard = settings;
        TemplateChooserPanelGUI panel = (TemplateChooserPanelGUI)this.getComponent();
        FileObject currentTemplate = Templates.getTemplate((WizardDescriptor)settings);
        FileObject templates = FileUtil.getConfigFile((String)"Templates");
        String currentCategoryName = null;
        String currentTemplateName = null;
        if (templates != null && currentTemplate != null && currentTemplate.getParent() != null && templates.equals(currentTemplate.getParent().getParent())) {
            try {
                DataObject dobj = DataObject.find((FileObject)currentTemplate);
                DataObject owner = DataObject.find((FileObject)currentTemplate.getParent());
                currentTemplateName = dobj.getName();
                currentCategoryName = owner.getName();
            }
            catch (DataObjectNotFoundException e) {
                // empty catch block
            }
        }
        panel.readValues(this.project, currentCategoryName, currentTemplateName);
        settings.putProperty("WizardPanel_contentSelectedIndex", (Object)0);
        settings.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getBundle(TemplateChooserPanel.class).getString("LBL_TemplatesPanel_Name"), NbBundle.getBundle(TemplateChooserPanel.class).getString("LBL_TemplatesPanel_Dots")});
        settings.putProperty("NewFileWizard_Title", null);
    }

    public void storeSettings(WizardDescriptor wd) {
        Object value = wd.getValue();
        if (NotifyDescriptor.CANCEL_OPTION != value && NotifyDescriptor.CLOSED_OPTION != value) {
            try {
                Project newProject;
                this.project = newProject = this.gui.getProject();
                wd.putProperty("project", (Object)newProject);
                if (this.gui.getTemplate() == null) {
                    return;
                }
                if (wd instanceof TemplateWizard) {
                    ((TemplateWizard)wd).setTemplate(DataObject.find((FileObject)this.gui.getTemplate()));
                } else {
                    wd.putProperty("targetTemplate", (Object)this.gui.getTemplate());
                }
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }
}

